/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.contextpropagation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.metadata.extended.MetaDataIdentifierService;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.microprofile.context.ApplicationContextProvider;
import com.ibm.ws.microprofile.context.CDIContextProviderHolder;
import com.ibm.ws.microprofile.context.SecurityContextProvider;
import com.ibm.ws.microprofile.context.ThreadIdentityContextProvider;
import com.ibm.ws.microprofile.context.TransactionContextProvider;
import com.ibm.ws.microprofile.context.WLMContextProvider;
import com.ibm.ws.microprofile.contextpropagation.ContextManagerImpl;
import com.ibm.ws.microprofile.contextpropagation.MPConfigAccessor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.PolicyExecutorProvider;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.context.spi.ContextManager;
import org.eclipse.microprofile.context.spi.ContextManagerProvider;
import org.eclipse.microprofile.context.spi.ContextManagerProviderRegistration;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true)
public class ContextManagerProviderImpl
implements ApplicationStateListener,
ContextManagerProvider {
    private static final TraceComponent tc = Tr.register(ContextManagerProviderImpl.class, (String)"concurrent", (String)"com.ibm.ws.microprofile.context.resources.CWWKCMessages");
    final ApplicationContextProvider applicationContextProvider = new ApplicationContextProvider();
    final CDIContextProviderHolder cdiContextProvider = new CDIContextProviderHolder();
    final SecurityContextProvider securityContextProvider = new SecurityContextProvider();
    final TransactionContextProvider transactionContextProvider = new TransactionContextProvider();
    final WLMContextProvider wlmContextProvider = new WLMContextProvider();
    final ThreadIdentityContextProvider threadIdendityContextProvider = new ThreadIdentityContextProvider();
    private static final String NO_CONTEXT_CLASSLOADER = "NO_CONTEXT_CLASSLOADER";
    @Reference
    protected MetaDataIdentifierService metadataIdentifierService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected volatile MPConfigAccessor mpConfigAccessor;
    @Reference
    protected PolicyExecutorProvider policyExecutorProvider;
    private final ConcurrentHashMap<Object, ContextManagerImpl> providersPerClassLoader = new ConcurrentHashMap();
    private ContextManagerProviderRegistration registration;
    static final long serialVersionUID = 8948946543403597431L;

    @Activate
    protected void activate(ComponentContext osgiComponentContext) {
        this.applicationContextProvider.classloaderContextProviderRef.activate(osgiComponentContext);
        this.applicationContextProvider.jeeMetadataContextProviderRef.activate(osgiComponentContext);
        this.cdiContextProvider.cdiContextProviderRef.activate(osgiComponentContext);
        this.securityContextProvider.securityContextProviderRef.activate(osgiComponentContext);
        this.threadIdendityContextProvider.threadIdentityContextProviderRef.activate(osgiComponentContext);
        this.transactionContextProvider.transactionContextProviderRef.activate(osgiComponentContext);
        this.wlmContextProvider.wlmContextProviderRef.activate(osgiComponentContext);
        this.registration = ContextManagerProvider.register((ContextManagerProvider)this);
    }

    @Trivial
    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
    }

    @Trivial
    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        String appName = appInfo.getName();
        Iterator<Map.Entry<Object, ContextManagerImpl>> it = this.providersPerClassLoader.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, ContextManagerImpl> entry = it.next();
            Object cl = entry.getKey();
            ContextManagerImpl cm = entry.getValue();
            if (NO_CONTEXT_CLASSLOADER.equals(cl) || !appName.equals(cm.appName)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"remove", (Object[])new Object[]{cl, cm});
            }
            it.remove();
        }
    }

    public void applicationStopping(ApplicationInfo appInfo) {
        this.policyExecutorProvider.shutdownNow(appInfo.getName());
    }

    @Deactivate
    protected void deactivate(ComponentContext osgiComponentContext) {
        this.registration.unregister();
        this.wlmContextProvider.wlmContextProviderRef.deactivate(osgiComponentContext);
        this.transactionContextProvider.transactionContextProviderRef.deactivate(osgiComponentContext);
        this.threadIdendityContextProvider.threadIdentityContextProviderRef.deactivate(osgiComponentContext);
        this.securityContextProvider.securityContextProviderRef.deactivate(osgiComponentContext);
        this.cdiContextProvider.cdiContextProviderRef.deactivate(osgiComponentContext);
        this.applicationContextProvider.jeeMetadataContextProviderRef.deactivate(osgiComponentContext);
        this.applicationContextProvider.classloaderContextProviderRef.deactivate(osgiComponentContext);
    }

    public ContextManager getContextManager(ClassLoader classLoader) {
        ContextManagerImpl cmgrNew;
        Object key = classLoader == null ? NO_CONTEXT_CLASSLOADER : classLoader;
        ContextManagerImpl cmgr = this.providersPerClassLoader.get(key);
        if (cmgr == null && (cmgr = this.providersPerClassLoader.putIfAbsent(key, cmgrNew = new ContextManagerImpl(this, classLoader))) == null) {
            cmgr = cmgrNew;
        }
        return cmgr;
    }

    @Reference(service=ThreadContextProvider.class, target="(component.name=com.ibm.ws.cdi.context.provider)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setCDIContextProvider(ServiceReference<ThreadContextProvider> ref) {
        this.cdiContextProvider.cdiContextProviderRef.setReference(ref);
    }

    @Reference(service=com.ibm.wsspi.threadcontext.ThreadContextProvider.class, target="(component.name=com.ibm.ws.classloader.context.provider)")
    protected void setClassloaderContextProvider(ServiceReference<com.ibm.wsspi.threadcontext.ThreadContextProvider> ref) {
        this.applicationContextProvider.classloaderContextProviderRef.setReference(ref);
    }

    @Reference(service=com.ibm.wsspi.threadcontext.ThreadContextProvider.class, target="(component.name=com.ibm.ws.javaee.metadata.context.provider)")
    protected void setJeeMetadataContextProvider(ServiceReference<com.ibm.wsspi.threadcontext.ThreadContextProvider> ref) {
        this.applicationContextProvider.jeeMetadataContextProviderRef.setReference(ref);
    }

    @Reference(service=com.ibm.wsspi.threadcontext.ThreadContextProvider.class, target="(component.name=com.ibm.ws.security.context.provider)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setSecurityContextProvider(ServiceReference<com.ibm.wsspi.threadcontext.ThreadContextProvider> ref) {
        this.securityContextProvider.securityContextProviderRef.setReference(ref);
    }

    @Reference(service=com.ibm.wsspi.threadcontext.ThreadContextProvider.class, target="(component.name=com.ibm.ws.security.thread.zos.context.provider)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setThreadIdentityContextProvider(ServiceReference<com.ibm.wsspi.threadcontext.ThreadContextProvider> ref) {
        this.threadIdendityContextProvider.threadIdentityContextProviderRef.setReference(ref);
    }

    @Reference(service=com.ibm.wsspi.threadcontext.ThreadContextProvider.class, target="(component.name=com.ibm.ws.transaction.context.provider)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setTransactionContextProvider(ServiceReference<com.ibm.wsspi.threadcontext.ThreadContextProvider> ref) {
        this.transactionContextProvider.transactionContextProviderRef.setReference(ref);
    }

    @Reference(service=com.ibm.wsspi.threadcontext.ThreadContextProvider.class, target="(component.name=com.ibm.ws.zos.wlm.context.provider)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setWLMContextProvider(ServiceReference<com.ibm.wsspi.threadcontext.ThreadContextProvider> ref) {
        this.wlmContextProvider.wlmContextProviderRef.setReference(ref);
    }

    protected void unsetCDIContextProvider(ServiceReference<ThreadContextProvider> ref) {
        this.cdiContextProvider.cdiContextProviderRef.unsetReference(ref);
    }

    protected void unsetClassloaderContextProvider(ServiceReference<com.ibm.wsspi.threadcontext.ThreadContextProvider> ref) {
        this.applicationContextProvider.classloaderContextProviderRef.unsetReference(ref);
    }

    protected void unsetJeeMetadataContextProvider(ServiceReference<com.ibm.wsspi.threadcontext.ThreadContextProvider> ref) {
        this.applicationContextProvider.jeeMetadataContextProviderRef.unsetReference(ref);
    }

    protected void unsetSecurityContextProvider(ServiceReference<com.ibm.wsspi.threadcontext.ThreadContextProvider> ref) {
        this.securityContextProvider.securityContextProviderRef.unsetReference(ref);
    }

    protected void unsetThreadIdentityContextProvider(ServiceReference<com.ibm.wsspi.threadcontext.ThreadContextProvider> ref) {
        this.threadIdendityContextProvider.threadIdentityContextProviderRef.unsetReference(ref);
    }

    protected void unsetTransactionContextProvider(ServiceReference<com.ibm.wsspi.threadcontext.ThreadContextProvider> ref) {
        this.transactionContextProvider.transactionContextProviderRef.unsetReference(ref);
    }

    protected void unsetWLMContextProvider(ServiceReference<com.ibm.wsspi.threadcontext.ThreadContextProvider> ref) {
        this.wlmContextProvider.wlmContextProviderRef.unsetReference(ref);
    }
}

