/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.collector;

import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.ws.logging.collector.CollectorJsonHelpers;
import com.ibm.ws.logging.data.AccessLogData;
import com.ibm.ws.logging.data.AuditData;
import com.ibm.ws.logging.data.FFDCData;
import com.ibm.ws.logging.data.GCData;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.KeyValuePair;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.data.LogTraceData;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;

public class CollectorJsonUtils_JSON {
    public static final int MAX_USER_AGENT_LENGTH = 2048;

    public static String getEventType(String source, String location) {
        return CollectorJsonHelpers.getEventType(source, location);
    }

    public static String jsonifyEvent(Object event, String eventType, String serverName, String wlpUserDir, String serverHostName, String[] tags, int maxFieldLength) {
        if (eventType.equals("liberty_gc")) {
            if (event instanceof GCData) {
                return CollectorJsonUtils_JSON.jsonifyGCEvent(wlpUserDir, serverName, serverHostName, event, tags);
            }
            return CollectorJsonUtils_JSON.jsonifyGCEvent(-1, wlpUserDir, serverName, serverHostName, "liberty_gc", event, tags);
        }
        if (eventType.equals("liberty_message")) {
            return CollectorJsonUtils_JSON.jsonifyTraceAndMessage(maxFieldLength, wlpUserDir, serverName, serverHostName, "liberty_message", event, tags);
        }
        if (eventType.equals("liberty_trace")) {
            return CollectorJsonUtils_JSON.jsonifyTraceAndMessage(maxFieldLength, wlpUserDir, serverName, serverHostName, "liberty_trace", event, tags);
        }
        if (eventType.equals("liberty_ffdc")) {
            return CollectorJsonUtils_JSON.jsonifyFFDC(maxFieldLength, wlpUserDir, serverName, serverHostName, event, tags);
        }
        if (eventType.equals("liberty_accesslog")) {
            return CollectorJsonUtils_JSON.jsonifyAccess(wlpUserDir, serverName, serverHostName, event, tags);
        }
        if (eventType.equals("liberty_audit")) {
            return CollectorJsonUtils_JSON.jsonifyAudit(wlpUserDir, serverName, serverHostName, event, tags);
        }
        return "";
    }

    private static String jsonifyGCEvent(int maxFieldLength, String wlpUserDir, String serverName, String hostName, String eventType, Object event, String[] tags) {
        GenericData genData = (GenericData)event;
        KeyValuePair[] pairs = genData.getPairs();
        KeyValuePair kvp = null;
        String key = null;
        StringBuilder sb = CollectorJsonHelpers.startGCJson1_1(hostName, wlpUserDir, serverName);
        for (KeyValuePair p : pairs) {
            if (p == null || p.isList()) continue;
            kvp = p;
            key = kvp.getKey();
            if (key.equals("ibm_duration")) {
                long duration = kvp.getLongValue() * 1000L;
                CollectorJsonHelpers.addToJSON(sb, key, Long.toString(duration), false, false, true, false, false, true);
                continue;
            }
            if (key.equals("ibm_datetime")) {
                String datetime = CollectorJsonHelpers.dateFormatTL.get().format(kvp.getLongValue());
                CollectorJsonHelpers.addToJSON(sb, key, datetime, false, false, true, false, false, false);
                continue;
            }
            String value = null;
            value = kvp.isInteger() ? Integer.toString(kvp.getIntValue()) : (kvp.isLong() ? Long.toString(kvp.getLongValue()) : kvp.getStringValue());
            CollectorJsonHelpers.addToJSON(sb, key, value, false, false, true, false, false, !kvp.isString());
        }
        if (tags != null) {
            CollectorJsonUtils_JSON.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String jsonifyGCEvent(String wlpUserDir, String serverName, String hostName, Object event, String[] tags) {
        GCData gcData = (GCData)event;
        StringBuilder sb = CollectorJsonHelpers.startGCJson1_1(hostName, wlpUserDir, serverName);
        CollectorJsonHelpers.addToJSON(sb, gcData.getHeapKey1_1(), Long.toString(gcData.getHeap()), false, false, false, false, false, true);
        CollectorJsonHelpers.addToJSON(sb, gcData.getUsedHeapKey1_1(), Long.toString(gcData.getUsedHeap()), false, false, false, false, false, true);
        CollectorJsonHelpers.addToJSON(sb, gcData.getMaxHeapKey1_1(), Long.toString(gcData.getMaxHeap()), false, false, false, false, false, true);
        long duration = gcData.getDuration() * 1000L;
        CollectorJsonHelpers.addToJSON(sb, gcData.getDurationKey1_1(), Long.toString(duration), false, false, false, false, false, true);
        CollectorJsonHelpers.addToJSON(sb, gcData.getGcTypeKey1_1(), gcData.getGcType(), false, false, false, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, gcData.getReasonKey1_1(), gcData.getReason(), false, false, false, false, false, false);
        String datetime = CollectorJsonHelpers.dateFormatTL.get().format(gcData.getDatetime());
        CollectorJsonHelpers.addToJSON(sb, gcData.getDatetimeKey1_1(), datetime, false, false, false, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, gcData.getSequenceKey1_1(), gcData.getSequence(), false, false, false, false, false, false);
        if (tags != null) {
            CollectorJsonUtils_JSON.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String jsonifyFFDC(int maxFieldLength, String wlpUserDir, String serverName, String hostName, Object event, String[] tags) {
        FFDCData ffdcData = (FFDCData)event;
        StringBuilder sb = CollectorJsonHelpers.startFFDCJsonFields(hostName, wlpUserDir, serverName);
        String datetime = CollectorJsonHelpers.dateFormatTL.get().format(ffdcData.getDatetime());
        CollectorJsonHelpers.addToJSON(sb, FFDCData.getDatetimeKeyJSON(), datetime, FFDCData.getDatetimeOmitBoolJSON(), false, true, false, sb.length() <= 1, false);
        CollectorJsonHelpers.addToJSON(sb, FFDCData.getMessageKeyJSON(), ffdcData.getMessage(), FFDCData.getMessageOmitBoolJSON(), false, true, false, sb.length() <= 1, false);
        CollectorJsonHelpers.addToJSON(sb, FFDCData.getClassNameKeyJSON(), ffdcData.getClassName(), FFDCData.getClassNameOmitBoolJSON(), false, true, false, sb.length() <= 1, false);
        CollectorJsonHelpers.addToJSON(sb, FFDCData.getExceptionNameKeyJSON(), ffdcData.getExceptionName(), FFDCData.getExceptionNameOmitBoolJSON(), false, true, false, sb.length() <= 1, false);
        CollectorJsonHelpers.addToJSON(sb, FFDCData.getProbeIdKeyJSON(), ffdcData.getProbeId(), FFDCData.getProbeIdOmitBoolJSON(), false, true, false, sb.length() <= 1, false);
        CollectorJsonHelpers.addToJSON(sb, FFDCData.getThreadIdKeyJSON(), DataFormatHelper.padHexString((int)ffdcData.getThreadId(), 8), FFDCData.getThreadIdOmitBoolJSON(), false, true, false, sb.length() <= 1, false);
        String formattedValue = CollectorJsonHelpers.formatMessage(ffdcData.getStacktrace(), maxFieldLength);
        CollectorJsonHelpers.addToJSON(sb, FFDCData.getStacktraceKeyJSON(), formattedValue, FFDCData.getStacktraceOmitBoolJSON(), false, true, false, sb.length() <= 1, false);
        CollectorJsonHelpers.addToJSON(sb, FFDCData.getObjectDetailsKeyJSON(), ffdcData.getObjectDetails(), FFDCData.getObjectDetailsOmitBoolJSON(), false, true, sb.length() <= 1, false, false);
        CollectorJsonHelpers.addToJSON(sb, FFDCData.getSequenceKeyJSON(), ffdcData.getSequence(), FFDCData.getSequenceOmitBoolJSON(), false, true, false, sb.length() <= 1, false);
        if (tags != null) {
            CollectorJsonUtils_JSON.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    public static String jsonifyAccess(String wlpUserDir, String serverName, String hostName, Object event, String[] tags) {
        AccessLogData accessLogData = (AccessLogData)event;
        StringBuilder sb = CollectorJsonHelpers.startAccessLogJsonFields(hostName, wlpUserDir, serverName);
        CollectorJsonHelpers.addToJSON(sb, AccessLogData.getUriPathKeyJSON(), accessLogData.getUriPath(), AccessLogData.getUriPathOmitBoolJSON(), false, true, false, sb.length() <= 1, false);
        CollectorJsonHelpers.addToJSON(sb, AccessLogData.getRequestMethodKeyJSON(), accessLogData.getRequestMethod(), AccessLogData.getRequestHostOmitBoolJSON(), false, true, false, sb.length() <= 1, false);
        String jsonQueryString = accessLogData.getQueryString();
        if (jsonQueryString != null) {
            try {
                jsonQueryString = URLDecoder.decode(jsonQueryString, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        CollectorJsonHelpers.addToJSON(sb, AccessLogData.getQueryStringKeyJSON(), jsonQueryString, AccessLogData.getQueryStringOmitBoolJSON(), false, true, false, sb.length() <= 1, false);
        CollectorJsonHelpers.addToJSON(sb, AccessLogData.getRequestHostKeyJSON(), accessLogData.getRequestHost(), AccessLogData.getRequestHostOmitBoolJSON(), false, true, false, sb.length() <= 1, false);
        CollectorJsonHelpers.addToJSON(sb, AccessLogData.getRequestPortKeyJSON(), accessLogData.getRequestPort(), AccessLogData.getRequestPortOmitBoolJSON(), false, true, false, sb.length() <= 1, false);
        CollectorJsonHelpers.addToJSON(sb, AccessLogData.getRemoteHostKeyJSON(), accessLogData.getRemoteHost(), AccessLogData.getRemoteHostOmitBoolJSON(), false, true, false, sb.length() <= 1, false);
        String userAgent = accessLogData.getUserAgent();
        if (userAgent != null && userAgent.length() > 2048) {
            userAgent = userAgent.substring(0, 2048);
        }
        CollectorJsonHelpers.addToJSON(sb, AccessLogData.getUserAgentKeyJSON(), userAgent, AccessLogData.getUserAgentOmitBoolJSON(), false, false, false, sb.length() <= 1, false);
        CollectorJsonHelpers.addToJSON(sb, AccessLogData.getRequestProtocolKeyJSON(), accessLogData.getRequestProtocol(), AccessLogData.getRequestProtocolOmitBoolJSON(), false, true, false, sb.length() <= 1, false);
        CollectorJsonHelpers.addToJSON(sb, AccessLogData.getBytesReceivedKeyJSON(), Long.toString(accessLogData.getBytesReceived()), AccessLogData.getBytesReceivedOmitBoolJSON(), false, true, false, sb.length() <= 1, true);
        CollectorJsonHelpers.addToJSON(sb, AccessLogData.getResponseCodeKeyJSON(), Integer.toString(accessLogData.getResponseCode()), AccessLogData.getResponseCodeOmitBoolJSON(), false, true, false, sb.length() <= 1, true);
        CollectorJsonHelpers.addToJSON(sb, AccessLogData.getElapsedTimeKeyJSON(), Long.toString(accessLogData.getElapsedTime()), AccessLogData.getElapsedTimeOmitBoolJSON(), false, true, false, sb.length() <= 1, true);
        String datetime = CollectorJsonHelpers.dateFormatTL.get().format(accessLogData.getDatetime());
        CollectorJsonHelpers.addToJSON(sb, AccessLogData.getDatetimeKeyJSON(), datetime, AccessLogData.getDatetimeOmitBoolJSON(), false, true, false, sb.length() <= 1, false);
        CollectorJsonHelpers.addToJSON(sb, AccessLogData.getSequenceKeyJSON(), accessLogData.getSequence(), AccessLogData.getSequenceOmitBoolJSON(), false, true, false, sb.length() <= 1, false);
        if (tags != null) {
            CollectorJsonUtils_JSON.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String jsonifyTraceAndMessage(int maxFieldLength, String wlpUserDir, String serverName, String hostName, String eventType, Object event, String[] tags) {
        LogTraceData logData = (LogTraceData)event;
        StringBuilder sb = null;
        boolean isMessageEvent = eventType.equals("liberty_message");
        ArrayList<KeyValuePair> extensions = null;
        KeyValuePairList kvpl = null;
        if (isMessageEvent) {
            sb = CollectorJsonHelpers.startMessageJsonFields(hostName, wlpUserDir, serverName);
        }
        if (!isMessageEvent) {
            sb = CollectorJsonHelpers.startTraceJsonFields(hostName, wlpUserDir, serverName);
        }
        String message = logData.getMessage();
        String loglevel = logData.getLoglevel();
        if (loglevel != null && (loglevel.equals("ENTRY") || loglevel.equals("EXIT"))) {
            message = CollectorJsonHelpers.jsonRemoveSpace(message);
        }
        StringBuilder formattedValue = new StringBuilder(CollectorJsonHelpers.formatMessage(message, maxFieldLength));
        String throwable = logData.getThrowable();
        if (throwable != null) {
            formattedValue.append(CollectorJsonHelpers.LINE_SEPARATOR).append(throwable);
        }
        CollectorJsonHelpers.addToJSON(sb, LogTraceData.getMessageKeyJSON(isMessageEvent), formattedValue.toString(), LogTraceData.getMessageOmitBoolJSON(isMessageEvent), false, true, false, sb.length() <= 1);
        CollectorJsonHelpers.addToJSON(sb, LogTraceData.getThreadIdKeyJSON(isMessageEvent), DataFormatHelper.padHexString(logData.getThreadId(), 8), LogTraceData.getThreadIdOmitBoolJSON(isMessageEvent), false, true, false, sb.length() <= 1);
        String datetime = CollectorJsonHelpers.dateFormatTL.get().format(logData.getDatetime());
        CollectorJsonHelpers.addToJSON(sb, LogTraceData.getDatetimeKeyJSON(isMessageEvent), datetime, LogTraceData.getDatetimeOmitBoolJSON(isMessageEvent), false, true, false, sb.length() <= 1);
        CollectorJsonHelpers.addToJSON(sb, LogTraceData.getMessageIdKeyJSON(isMessageEvent), logData.getMessageId(), LogTraceData.getMessageIdOmitBoolJSON(isMessageEvent), false, true, false, sb.length() <= 1);
        CollectorJsonHelpers.addToJSON(sb, LogTraceData.getModuleKeyJSON(isMessageEvent), logData.getModule(), LogTraceData.getModuleOmitBoolJSON(isMessageEvent), false, true, false, sb.length() <= 1);
        CollectorJsonHelpers.addToJSON(sb, LogTraceData.getLoglevelKeyJSON(isMessageEvent), logData.getLoglevel(), LogTraceData.getLoglevelOmitBoolJSON(isMessageEvent), false, true, false, sb.length() <= 1);
        CollectorJsonHelpers.addToJSON(sb, LogTraceData.getMethodNameKeyJSON(isMessageEvent), logData.getMethodName(), LogTraceData.getMethodNameOmitBoolJSON(isMessageEvent), false, true, false, sb.length() <= 1);
        CollectorJsonHelpers.addToJSON(sb, LogTraceData.getClassNameKeyJSON(isMessageEvent), logData.getClassName(), LogTraceData.getClassNameOmitBoolJSON(isMessageEvent), false, true, false, sb.length() <= 1);
        CollectorJsonHelpers.addToJSON(sb, LogTraceData.getSequenceKeyJSON(isMessageEvent), logData.getSequence(), LogTraceData.getSequenceOmitBoolJSON(isMessageEvent), false, true, false, sb.length() <= 1);
        kvpl = logData.getExtensions();
        if (kvpl != null && kvpl.getKey().equals("extensions")) {
            extensions = kvpl.getList();
            for (KeyValuePair k : extensions) {
                String extKey = k.getKey();
                if (extKey.endsWith("_int")) {
                    CollectorJsonHelpers.addToJSON(sb, LogTraceData.getExtensionNameKeyJSON(isMessageEvent, extKey), Integer.toString(k.getIntValue()), LogTraceData.getExtensionNameOmitBool(isMessageEvent, extKey), false, true, false, sb.length() <= 1, true);
                    continue;
                }
                if (extKey.endsWith("_float")) {
                    CollectorJsonHelpers.addToJSON(sb, LogTraceData.getExtensionNameKeyJSON(isMessageEvent, extKey), Float.toString(k.getFloatValue()), LogTraceData.getExtensionNameOmitBool(isMessageEvent, extKey), false, true, false, sb.length() <= 1, true);
                    continue;
                }
                if (extKey.endsWith("_long")) {
                    CollectorJsonHelpers.addToJSON(sb, LogTraceData.getExtensionNameKeyJSON(isMessageEvent, extKey), Long.toString(k.getLongValue()), LogTraceData.getExtensionNameOmitBool(isMessageEvent, extKey), false, true, false, sb.length() <= 1, true);
                    continue;
                }
                if (extKey.endsWith("_bool")) {
                    CollectorJsonHelpers.addToJSON(sb, LogTraceData.getExtensionNameKeyJSON(isMessageEvent, extKey), Boolean.toString(k.getBooleanValue()), LogTraceData.getExtensionNameOmitBool(isMessageEvent, extKey), false, true, false, sb.length() <= 1, true);
                    continue;
                }
                CollectorJsonHelpers.addToJSON(sb, LogTraceData.getExtensionNameKeyJSON(isMessageEvent, extKey), k.getStringValue(), LogTraceData.getExtensionNameOmitBool(isMessageEvent, extKey), false, true, false, sb.length() <= 1, false);
            }
        }
        if (tags != null) {
            CollectorJsonUtils_JSON.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    public static String jsonifyAudit(String wlpUserDir, String serverName, String hostName, Object event, String[] tags) {
        GenericData genData = (GenericData)event;
        KeyValuePair[] pairs = genData.getPairs();
        String key = null;
        StringBuilder sb = CollectorJsonHelpers.startAuditJsonFields(hostName, wlpUserDir, serverName);
        for (KeyValuePair kvp : pairs) {
            if (kvp == null || kvp.isList()) continue;
            key = kvp.getKey();
            if (key.equals("ibm_datetime") || key.equals("loggingEventTime") || AuditData.getDatetimeKeyJSON().equals(key)) {
                String datetime = CollectorJsonHelpers.dateFormatTL.get().format(kvp.getLongValue());
                CollectorJsonHelpers.addToJSON(sb, AuditData.getDatetimeKeyJSON(), datetime, AuditData.getDatetimeOmitBoolJSON(), false, true, false, sb.length() <= 1, false);
                continue;
            }
            if (key.equals("ibm_sequence") || key.equals("loggingSequenceNumber") || AuditData.getSequenceKeyJSON().equals(key)) {
                CollectorJsonHelpers.addToJSON(sb, AuditData.getSequenceKeyJSON(), kvp.getStringValue(), AuditData.getSequenceOmitBoolJSON(), false, false, sb.length() <= 1, false, !kvp.isString());
                continue;
            }
            if (key.equals("ibm_threadId") || AuditData.getThreadIDKeyJSON().equals(key)) {
                CollectorJsonHelpers.addToJSON(sb, AuditData.getThreadIDKeyJSON(), DataFormatHelper.padHexString(kvp.getIntValue(), 8), AuditData.getThreadIDOmitBoolJSON(), false, true, false, sb.length() <= 1, false);
                continue;
            }
            CollectorJsonHelpers.addToJSON(sb, "ibm_audit_" + key, kvp.getStringValue(), false, false, false, false, sb.length() <= 1, !kvp.isString());
        }
        sb.append("}");
        return sb.toString();
    }

    private static StringBuilder addTagNameForVersion(StringBuilder sb) {
        sb.append(",\"ibm_tags\":");
        return sb;
    }
}

