/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.logging.internal.impl.LoggingConfigUtils;
import com.ibm.ws.logging.internal.impl.LoggingConstants;
import com.ibm.wsspi.logging.TextFileOutputStreamFactory;
import com.ibm.wsspi.logprovider.FFDCFilterService;
import com.ibm.wsspi.logprovider.LogProviderConfig;
import com.ibm.wsspi.logprovider.TrService;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;

public class LogProviderConfigImpl
implements LogProviderConfig {
    private static final TraceComponent tc = Tr.register(LogProviderConfigImpl.class, "logging", "com.ibm.ws.logging.internal.resources.LoggingMessages");
    protected final TrService trDelegate;
    protected final FFDCFilterService ffdcDelegate;
    protected final TextFileOutputStreamFactory fileStreamFactory;
    protected final boolean loggerUsesTr;
    protected final LoggingConstants.FFDCSummaryPolicy ffdcSummaryPolicy;
    protected volatile File logDirectory;
    protected volatile LoggingConstants.TraceFormat traceFormat = LoggingConstants.TraceFormat.ENHANCED;
    protected volatile boolean isoDateFormat = false;
    protected volatile int maxFileSize = 0;
    protected volatile long maxFileSizeBytes = 0L;
    protected volatile int maxFiles = 0;
    protected volatile String traceFileName = "trace.log";
    protected volatile String messageFileName = "messages.log";
    protected volatile Collection<String> hideMessageIds = new ArrayList<String>();
    protected volatile Level consoleLogLevel = WsLevel.AUDIT;
    protected volatile boolean copySystemStreams = true;
    protected volatile String traceSpec = "*=info";
    protected volatile Collection<String> messageSource = Arrays.asList("message");
    protected volatile String messageFormat = "basic";
    protected volatile String jsonFields = "";
    protected volatile Boolean omitJsonFields = false;
    protected volatile Collection<String> consoleSource = Arrays.asList("message");
    protected volatile String consoleFormat = "basic";
    protected volatile boolean newLogsOnStart = true;
    private final String logHeader;
    private final boolean javaLangInstrument;
    private final String serverName;
    private final String wlpUsrDir;

    public LogProviderConfigImpl(Map<String, String> config, File logLocation, TextFileOutputStreamFactory factory) {
        if (config == null) {
            config = Collections.emptyMap();
        }
        this.logDirectory = logLocation;
        this.fileStreamFactory = factory;
        this.ffdcSummaryPolicy = LoggingConfigUtils.getFFDCSummaryPolicy(config.get("com.ibm.ws.logging.ffdc.summary.policy"), LoggingConstants.FFDCSummaryPolicy.DEFAULT);
        this.messageSource = LoggingConfigUtils.parseStringCollection("messageSource", LoggingConfigUtils.getEnvValue("WLP_LOGGING_MESSAGE_SOURCE"), this.messageSource);
        this.messageFormat = LoggingConfigUtils.getStringValue(LoggingConfigUtils.getEnvValue("WLP_LOGGING_MESSAGE_FORMAT"), this.messageFormat);
        this.jsonFields = LoggingConfigUtils.getStringValue(LoggingConfigUtils.getEnvValue("WLP_LOGGING_JSON_FIELD_MAPPINGS"), this.jsonFields);
        this.omitJsonFields = LoggingConfigUtils.getBooleanValue(LoggingConfigUtils.getEnvValue("WLP_LOGGING_OMIT_JSON_FIELD_MAPPINGS"), this.omitJsonFields);
        this.consoleSource = LoggingConfigUtils.parseStringCollection("consoleSource", LoggingConfigUtils.getEnvValue("WLP_LOGGING_CONSOLE_SOURCE"), this.consoleSource);
        this.consoleFormat = LoggingConfigUtils.getStringValue(LoggingConfigUtils.getEnvValue("WLP_LOGGING_CONSOLE_FORMAT"), this.consoleFormat);
        this.consoleLogLevel = LoggingConfigUtils.getLogLevel(LoggingConfigUtils.getEnvValue("WLP_LOGGING_CONSOLE_LOGLEVEL"), this.consoleLogLevel);
        this.doCommonInit(config, true);
        this.loggerUsesTr = !this.traceFileName.equals("java.util.logging");
        String defaultDelegate = this.loggerUsesTr ? "com.ibm.ws.logging.internal.impl.BaseTraceService" : "com.ibm.ws.logging.internal.impl.Jsr47TraceService";
        this.trDelegate = LoggingConfigUtils.getDelegate(TrService.class, config.get("com.ibm.ws.logging.trace.delegate"), defaultDelegate);
        this.ffdcDelegate = LoggingConfigUtils.getDelegate(FFDCFilterService.class, config.get("com.ibm.ws.logging.ffdc.delegate"), "com.ibm.ws.logging.internal.impl.BaseFFDCService");
        this.logHeader = LogProviderConfigImpl.getLogHeader(config);
        this.javaLangInstrument = Boolean.parseBoolean(config.get("java.lang.instrument"));
        this.serverName = config.get("wlp.server.name");
        this.wlpUsrDir = config.get("wlp.user.dir");
    }

    @Override
    public synchronized void update(Map<String, Object> config) {
        this.doCommonInit(config, false);
    }

    protected void doCommonInit(Map config, boolean isInit) {
        Map c = config;
        this.maxFiles = InitConfgAttribute.MAX_NUM_FILES.getIntValue(c, this.maxFiles, isInit);
        this.maxFileSize = InitConfgAttribute.FILE_MAX_SIZE.getIntValue(c, this.maxFileSize, isInit);
        this.maxFileSizeBytes = (long)this.maxFileSize * 1024L * 1024L;
        this.traceSpec = InitConfgAttribute.TRACE_SPEC.getStringValue(c, this.traceSpec, isInit);
        this.traceFormat = InitConfgAttribute.TRACE_FORMAT.getTraceFormatValue(c, this.traceFormat, isInit);
        this.isoDateFormat = InitConfgAttribute.ISO_DATE_FORMAT.getBooleanValue(c, this.isoDateFormat, isInit);
        this.consoleLogLevel = InitConfgAttribute.CONSOLE_LOG_LEVEL.getLogLevelValue(c, this.consoleLogLevel, isInit);
        this.copySystemStreams = InitConfgAttribute.COPY_SYSTEM_STREAMS.getBooleanValue(c, this.copySystemStreams, isInit);
        this.traceFileName = InitConfgAttribute.TRACE_FILE_NAME.getStringValue(c, this.traceFileName, isInit);
        this.messageFileName = InitConfgAttribute.MSG_FILE_NAME.getStringValue(c, this.messageFileName, isInit);
        this.logDirectory = InitConfgAttribute.LOG_LOCATION.getLogDirectory(c, this.logDirectory, isInit);
        this.hideMessageIds = InitConfgAttribute.HIDE_MESSAGES.getStringCollectionValue("hideMessage", c, this.hideMessageIds, isInit);
        this.messageSource = InitConfgAttribute.MESSAGE_SOURCE.getStringCollectionValueAndSaveInit("messageSource", c, this.messageSource, isInit);
        this.messageFormat = InitConfgAttribute.MESSAGE_FORMAT.getStringValueAndSaveInit(c, this.messageFormat, isInit);
        this.consoleSource = InitConfgAttribute.CONSOLE_SOURCE.getStringCollectionValueAndSaveInit("consoleSource", c, this.consoleSource, isInit);
        this.consoleFormat = InitConfgAttribute.CONSOLE_FORMAT.getStringValueAndSaveInit(c, this.consoleFormat, isInit);
        this.jsonFields = InitConfgAttribute.JSON_FIELD_MAPPINGS.getStringValueAndSaveInit(c, this.jsonFields, isInit);
        this.newLogsOnStart = InitConfgAttribute.NEW_LOGS_ON_START.getBooleanValue(c, this.newLogsOnStart, isInit);
    }

    static String getLogHeader(Map<String, String> config) {
        String serverOutputDir;
        String serverConfigDir;
        String installDir;
        StringBuilder builder = new StringBuilder(512);
        String productInfo = config.get("websphere.product.info");
        if (productInfo != null) {
            builder.append("product = ").append(productInfo).append(LoggingConstants.nl);
        }
        if ((installDir = config.get("wlp.install.dir")) != null) {
            builder.append("wlp.install.dir = ").append(installDir).append(LoggingConstants.nl);
        }
        if ((serverConfigDir = config.get("server.config.dir")) != null && !"true".equals(config.get("wlp.user.dir.isDefault"))) {
            builder.append("server.config.dir = ").append(serverConfigDir).append(LoggingConstants.nl);
        }
        if ((serverOutputDir = config.get("server.output.dir")) != null && !serverOutputDir.equals(serverConfigDir)) {
            builder.append("server.output.dir = ").append(serverOutputDir).append(LoggingConstants.nl);
        }
        builder.append("java.home = ").append(System.getProperty("java.home")).append(LoggingConstants.nl);
        builder.append("java.version = ").append(System.getProperty("java.version")).append(LoggingConstants.nl);
        builder.append("java.runtime = ").append(System.getProperty("java.runtime.name")).append(" (").append(System.getProperty("java.runtime.version")).append(')').append(LoggingConstants.nl);
        builder.append("os = ").append(System.getProperty("os.name")).append(" (").append(System.getProperty("os.version")).append("; ").append(System.getProperty("os.arch")).append(") (").append(Locale.getDefault()).append(")").append(LoggingConstants.nl);
        builder.append("process = ");
        String pid = System.getProperty("sun.java.launcher.pid");
        if (pid != null) {
            try {
                String ip = InetAddress.getLocalHost().getHostAddress();
                builder.append(pid).append('@').append(ip);
            }
            catch (Exception e) {
                pid = null;
            }
        }
        if (pid == null) {
            builder.append(ManagementFactory.getRuntimeMXBean().getName());
        }
        builder.append(LoggingConstants.nl);
        return builder.toString();
    }

    public String getLogHeader() {
        return this.logHeader;
    }

    public boolean hasJavaLangInstrument() {
        return this.javaLangInstrument;
    }

    @Override
    public File getLogDirectory() {
        return this.logDirectory;
    }

    public LoggingConstants.TraceFormat getTraceFormat() {
        return this.traceFormat;
    }

    public boolean getIsoDateFormat() {
        return this.isoDateFormat;
    }

    public long getMaxFileBytes() {
        return this.maxFileSizeBytes;
    }

    @Override
    public int getMaxFiles() {
        return this.maxFiles;
    }

    @Override
    public TextFileOutputStreamFactory getTextFileOutputStreamFactory() {
        return this.fileStreamFactory;
    }

    public String getTraceFileName() {
        return this.traceFileName;
    }

    @Override
    public String getTraceString() {
        return this.traceSpec;
    }

    public String getMessageFileName() {
        return this.messageFileName;
    }

    public Collection<String> getMessagesToHide() {
        return this.hideMessageIds;
    }

    public Level getConsoleLogLevel() {
        return this.consoleLogLevel;
    }

    public boolean copySystemStreams() {
        return this.copySystemStreams;
    }

    @Override
    public TrService getTrDelegate() {
        return this.trDelegate;
    }

    @Override
    public FFDCFilterService getFfdcDelegate() {
        return this.ffdcDelegate;
    }

    public LoggingConstants.FFDCSummaryPolicy getFfdcSummaryPolicy() {
        return this.ffdcSummaryPolicy;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getWlpUsrDir() {
        return this.wlpUsrDir;
    }

    public Collection<String> getMessageSource() {
        return this.messageSource;
    }

    public String getMessageFormat() {
        return this.messageFormat;
    }

    public String getjsonFields() {
        return this.jsonFields;
    }

    public Boolean getOmitJsonFields() {
        return this.omitJsonFields;
    }

    public Collection<String> getConsoleSource() {
        return this.consoleSource;
    }

    public String getConsoleFormat() {
        return this.consoleFormat;
    }

    public boolean getNewLogsOnStart() {
        return this.newLogsOnStart;
    }

    public boolean loggerUsesTr() {
        return this.loggerUsesTr;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[maxFileSize=").append(this.maxFileSize);
        sb.append(",maxFiles=").append(this.maxFiles);
        sb.append(",logDirectory=").append(this.logDirectory);
        sb.append(",consoleLogLevel=").append(this.consoleLogLevel.getName());
        sb.append(",copySystemStreams=").append(this.copySystemStreams);
        sb.append(",messageFileName=").append(this.messageFileName);
        sb.append(",traceFormat=").append((Object)this.traceFormat);
        sb.append(",isoDateFormat=").append(this.isoDateFormat);
        sb.append(",traceFileName=").append(this.traceFileName);
        sb.append(",newLogsOnStart=").append(this.newLogsOnStart);
        sb.append("]");
        return sb.toString();
    }

    private static enum InitConfgAttribute {
        FILE_MAX_SIZE("maxFileSize", "com.ibm.ws.logging.max.file.size"),
        MAX_NUM_FILES("maxFiles", "com.ibm.ws.logging.max.files"),
        CONSOLE_LOG_LEVEL("consoleLogLevel", "com.ibm.ws.logging.console.log.level"),
        COPY_SYSTEM_STREAMS("copySystemStreams", "com.ibm.ws.logging.copy.system.streams"),
        LOG_LOCATION("logDirectory", "com.ibm.ws.logging.log.directory"),
        MSG_FILE_NAME("messageFileName", "com.ibm.ws.logging.message.file.name"),
        TRACE_FILE_NAME("traceFileName", "com.ibm.ws.logging.trace.file.name"),
        TRACE_SPEC("traceSpecification", "com.ibm.ws.logging.trace.specification"),
        TRACE_FORMAT("traceFormat", "com.ibm.ws.logging.trace.format"),
        ISO_DATE_FORMAT("isoDateFormat", "com.ibm.ws.logging.isoDateFormat"),
        HIDE_MESSAGES("hideMessage", "com.ibm.ws.logging.hideMessage"),
        MESSAGE_SOURCE("messageSource", "com.ibm.ws.logging.message.source"),
        MESSAGE_FORMAT("messageFormat", "com.ibm.ws.logging.message.format"),
        CONSOLE_SOURCE("consoleSource", "com.ibm.ws.logging.console.source"),
        CONSOLE_FORMAT("consoleFormat", "com.ibm.ws.logging.console.format"),
        JSON_FIELD_MAPPINGS("jsonFieldMappings", "com.ibm.ws.logging.json.field.mappings"),
        NEW_LOGS_ON_START("newLogsOnStart", "com.ibm.ws.logging.newLogsOnStart");

        final String configKey;
        final String propertyKey;

        private InitConfgAttribute(String cfgKey, String propKey) {
            this.configKey = cfgKey;
            this.propertyKey = propKey;
        }

        boolean getBooleanValue(Map<String, Object> config, boolean defaultValue, boolean isInit) {
            Object value = config.get(isInit ? this.propertyKey : this.configKey);
            return LoggingConfigUtils.getBooleanValue(value, defaultValue);
        }

        int getIntValue(Map<String, Object> config, int defaultValue, boolean isInit) {
            Object value = config.get(isInit ? this.propertyKey : this.configKey);
            return LoggingConfigUtils.getIntValue(value, defaultValue);
        }

        String getStringValue(Map<String, Object> config, String defaultValue, boolean isInit) {
            Object value = config.get(isInit ? this.propertyKey : this.configKey);
            return LoggingConfigUtils.getStringValue(value, defaultValue);
        }

        LoggingConstants.TraceFormat getTraceFormatValue(Map<String, Object> config, LoggingConstants.TraceFormat defaultValue, boolean isInit) {
            Object value = config.get(isInit ? this.propertyKey : this.configKey);
            LoggingConstants.TraceFormat newValue = LoggingConfigUtils.getFormatValue(value, defaultValue);
            if (isInit && newValue != defaultValue) {
                config.put(this.propertyKey, newValue.name());
            }
            return newValue;
        }

        String getStringValueAndSaveInit(Map<String, Object> config, String defaultValue, boolean isInit) {
            Object value = config.get(isInit ? this.propertyKey : this.configKey);
            String newValue = LoggingConfigUtils.getStringValue(value, defaultValue);
            if (isInit && value == null) {
                config.put(this.propertyKey, newValue);
            }
            return newValue;
        }

        Collection<String> getStringCollectionValueAndSaveInit(String key, Map<String, Object> config, Collection<String> defaultValue, boolean isInit) {
            Object value = config.get(isInit ? this.propertyKey : this.configKey);
            Collection<String> collection = LoggingConfigUtils.parseStringCollection(key, value, defaultValue);
            if (isInit && value == null) {
                config.put(this.propertyKey, LoggingConfigUtils.getStringFromCollection(defaultValue));
            }
            return collection;
        }

        Level getLogLevelValue(Map<String, Object> config, Level defaultValue, boolean isInit) {
            Object value = config.get(isInit ? this.propertyKey : this.configKey);
            Level newLevel = LoggingConfigUtils.getLogLevel(value, defaultValue);
            if (isInit && value == null) {
                config.put(this.propertyKey, newLevel.toString());
            }
            return newLevel;
        }

        File getLogDirectory(Map<String, Object> config, File defaultValue, boolean isInit) {
            Object value = config.get(isInit ? this.propertyKey : this.configKey);
            File newValue = LoggingConfigUtils.getLogDirectory(value, defaultValue);
            if (isInit && value == null) {
                config.put(this.propertyKey, newValue.getAbsolutePath());
            }
            return newValue;
        }

        Collection<String> getStringCollectionValue(String key, Map<String, Object> config, Collection<String> defaultValue, boolean isInit) {
            Object value = config.get(isInit ? this.propertyKey : this.configKey);
            Collection<String> collection = LoggingConfigUtils.parseStringCollection(key, value, defaultValue);
            return collection;
        }
    }
}

