/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.cache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.zip.cache.ZipCachingProperties;
import com.ibm.ws.artifact.zip.cache.internal.ZipFileData;
import com.ibm.ws.artifact.zip.cache.internal.ZipFileDataStore;
import com.ibm.ws.artifact.zip.internal.SystemUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ZipFileReaper {
    static final TraceComponent tc = Tr.register(ZipFileReaper.class, (String)"archive.artifact", null);
    private static final DeferredLogEmitter logEmitter = new DeferredLogEmitter();
    private static final Thread logThread = new Thread((Runnable)logEmitter, "reaper logger");
    protected static final ErrorConsumer<String> NULL_ERROR_HANDLER;
    public static final boolean DO_DEBUG_STATE = true;
    public static final boolean DO_NOT_DEBUG_STATE = false;
    private final String reaperName;
    private final boolean debugState;
    private final int maxCache;
    private final long quickPendMin;
    private final long quickPendMax;
    private final long slowPendMin;
    private final long slowPendMax;
    private boolean isActive;
    private final long initialAt;
    private long finalAt;
    private final Map<String, ZipFileData> storage;
    private final ZipFileDataStore pendingQuickStorage;
    private final ZipFileDataStore pendingSlowStorage;
    private final ZipFileDataStore completedStorage;
    private final ReaperShutdownRunnable reaperShutdown;
    private final Thread reaperShutdownThread;
    private final ReaperRunnable reaperRunnable;
    private final Thread reaperThread;
    private final ErrorConsumer<String> errorHandler;
    public static final int NUM_REASONS = 10;
    private Reasons waitReasons;
    private final ReaperLock reaperLock;
    private static final boolean IS_NOT_SHUTDOWN_REAP = false;
    private static final boolean IS_SHUTDOWN_REAP = true;
    private static final long REAP_DELAY_INDEFINITE = -1L;
    static final long serialVersionUID = 7999140256782834907L;

    @Trivial
    private static String toCount(int count) {
        return ZipCachingProperties.toCount(count);
    }

    @Trivial
    private static String toRelSec(long baseNS, long actualNS) {
        return ZipCachingProperties.toRelSec(baseNS, actualNS);
    }

    @Trivial
    private static String toAbsSec(long durationNS) {
        return ZipCachingProperties.toAbsSec(durationNS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    public void validate() {
        ReaperLock reaperLock = this.reaperLock;
        synchronized (reaperLock) {
            this.pendingQuickStorage.validate();
            this.pendingSlowStorage.validate();
            if (!this.debugState) {
                this.completedStorage.validate();
            }
        }
    }

    protected static void asyncWarning(String msgKey, Object ... msgArgs) {
        logEmitter.post(msgKey, msgArgs);
    }

    @Trivial
    public ZipFileReaper(String reaperName) {
        this(reaperName, SystemUtils.getNanoTime());
    }

    @Trivial
    public ZipFileReaper(String reaperName, long initialAt) {
        this(reaperName, ZipCachingProperties.ZIP_REAPER_DEBUG_STATE, ZipCachingProperties.ZIP_CACHE_REAPER_MAX_PENDING, ZipCachingProperties.ZIP_CACHE_REAPER_QUICK_PEND_MIN, ZipCachingProperties.ZIP_CACHE_REAPER_QUICK_PEND_MIN, ZipCachingProperties.ZIP_CACHE_REAPER_SLOW_PEND_MAX, ZipCachingProperties.ZIP_CACHE_REAPER_SLOW_PEND_MAX, NULL_ERROR_HANDLER);
    }

    @Trivial
    public ZipFileReaper(String reaperName, boolean debugState, int maxCache, long quickPendMin, long quickPendMax, long slowPendMin, long slowPendMax, ErrorConsumer<String> errorHandler) {
        this(reaperName, debugState, maxCache, quickPendMin, quickPendMax, slowPendMin, slowPendMax, errorHandler, SystemUtils.getNanoTime());
    }

    @Trivial
    public ZipFileReaper(String reaperName, boolean debugState, int maxCache, long quickPendMin, long quickPendMax, long slowPendMin, long slowPendMax) {
        this(reaperName, debugState, maxCache, quickPendMin, quickPendMax, slowPendMin, slowPendMax, NULL_ERROR_HANDLER);
    }

    private static void validate(int maxCache, long quickPendMin, long quickPendMax, long slowPendMin, long slowPendMax) throws IllegalArgumentException {
        if (maxCache == 0) {
            throw new IllegalArgumentException("Max cache cannot be zero.");
        }
        if (quickPendMin == 0L || quickPendMax == 0L) {
            if (quickPendMin != 0L || quickPendMax != 0L) {
                throw new IllegalArgumentException("If one quick pend duration is zero, the other must be zero.");
            }
        } else {
            if (quickPendMin < 0L) {
                throw new IllegalArgumentException("Minimum quick pend duration [ " + quickPendMin + " ] must be positive or zero");
            }
            if (quickPendMax < 0L) {
                throw new IllegalArgumentException("Maximum quick pend duration[ " + quickPendMax + " ] must be positive or zero");
            }
            if (quickPendMin >= quickPendMax) {
                throw new IllegalArgumentException("Both quick durations must be zero, or, the minimum quick pend duration [ " + quickPendMin + " ] must be less than maximum quick pend duration [ " + quickPendMax + " ]");
            }
        }
        if (slowPendMin <= 0L) {
            throw new IllegalArgumentException("Minimum slow pend duration [ " + slowPendMin + " ] must be positive");
        }
        if (slowPendMax <= 0L) {
            throw new IllegalArgumentException("Maximum slow pend duration [ " + slowPendMax + " ] must be positive");
        }
        if (slowPendMin >= slowPendMax) {
            throw new IllegalArgumentException("Minimum slow pend duration [ " + slowPendMin + " ] must be less than maximum slow pend duration [ " + slowPendMax + " ]");
        }
        if (slowPendMin <= quickPendMax) {
            throw new IllegalArgumentException("Minimum slow pend duration [ " + slowPendMin + " ] must be greater than maximum quick pend duration [ " + quickPendMax + " ]");
        }
    }

    public ZipFileReaper(String reaperName, boolean debugState, int maxCache, long quickPendMin, long quickPendMax, long slowPendMin, long slowPendMax, ErrorConsumer<String> errorHandler, long initialAt) {
        ZipFileReaper.validate(maxCache, quickPendMin, quickPendMax, slowPendMin, slowPendMax);
        this.reaperName = reaperName;
        this.debugState = debugState;
        this.maxCache = maxCache;
        this.quickPendMin = quickPendMin;
        this.quickPendMax = quickPendMax;
        this.slowPendMin = slowPendMin;
        this.slowPendMax = slowPendMax;
        this.storage = new HashMap<String, ZipFileData>();
        this.pendingQuickStorage = new ZipFileDataStore("pendingQuick");
        this.pendingSlowStorage = new ZipFileDataStore("pendingSlow");
        this.completedStorage = !debugState ? new ZipFileDataStore("completed") : null;
        this.reaperLock = new ReaperLock();
        this.reaperRunnable = new ReaperRunnable(this);
        this.reaperThread = new Thread((Runnable)this.reaperRunnable, "zip file reaper");
        this.reaperThread.setDaemon(true);
        if (this.debugState) {
            this.reaperShutdown = new ReaperShutdownRunnable(this.reaperThread);
            this.reaperShutdownThread = new Thread(this.reaperShutdown);
        } else {
            this.reaperShutdown = null;
            this.reaperShutdownThread = null;
        }
        this.initialAt = initialAt;
        this.finalAt = 0L;
        this.isActive = true;
        this.waitReasons = new Reasons("Reaper Waits");
        this.errorHandler = errorHandler;
        this.reaperThread.start();
        if (this.debugState) {
            SystemUtils.addShutdownHook(this.reaperShutdownThread);
        }
        try {
            this.reaperRunnable.waitForStartup();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void shutDown() {
        this.reaperThread.interrupt();
    }

    @Trivial
    public String getReaperName() {
        return this.reaperName;
    }

    @Trivial
    public boolean getDebugState() {
        return this.debugState;
    }

    @Trivial
    public int getMaxCache() {
        return this.maxCache;
    }

    @Trivial
    public long getQuickPendMin() {
        return this.quickPendMin;
    }

    @Trivial
    public long getQuickPendMax() {
        return this.quickPendMax;
    }

    @Trivial
    public long getSlowPendMin() {
        return this.slowPendMin;
    }

    @Trivial
    public long getSlowPendMax() {
        return this.slowPendMax;
    }

    @Trivial
    public boolean getIsActive() {
        return this.isActive;
    }

    @Trivial
    private void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Trivial
    public long getInitialAt() {
        return this.initialAt;
    }

    @Trivial
    public long getFinalAt() {
        return this.finalAt;
    }

    @Trivial
    private void setFinalAt(long finalAt) {
        this.finalAt = finalAt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFileData.ZipFileState getState(String path) {
        ReaperLock reaperLock = this.reaperLock;
        synchronized (reaperLock) {
            ZipFileData data = this.storage.get(path);
            if (data == null && !this.debugState) {
                data = this.completedStorage.get(path);
            }
            return data == null ? null : data.zipFileState;
        }
    }

    protected ZipFileData getRipest() {
        ZipFileData ripest;
        if (this.pendingQuickStorage.isEmpty()) {
            ripest = this.pendingSlowStorage.getFirst();
        } else if (this.pendingSlowStorage.isEmpty()) {
            ripest = this.pendingQuickStorage.getFirst();
        } else {
            ZipFileData ripestQuick = this.pendingQuickStorage.getFirst();
            long expireAtQuick = ripestQuick.lastPendAt + this.quickPendMin;
            ZipFileData ripestSlow = this.pendingSlowStorage.getFirst();
            long expireAtSlow = ripestSlow.lastPendAt + this.slowPendMin;
            ripest = expireAtQuick <= expireAtSlow ? ripestQuick : ripestSlow;
        }
        return ripest;
    }

    protected void fullyClose(ZipFileData data, long fullCloseAt, boolean isShutdown) {
        String methodName = "fullyClose";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + data.path + " ] at [ " + ZipFileReaper.toRelSec(this.initialAt, fullCloseAt) + " (s) ]"), (Object[])new Object[0]);
        }
        data.closeZipFile();
        data.enactFullClose(fullCloseAt);
        if (!isShutdown && !this.debugState) {
            ZipFileData fullyClosedData = this.storage.remove(data.path);
            ZipFileData oldestCompletedClose = this.completedStorage.addLast(data, this.getMaxCache());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && oldestCompletedClose != null) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Discard completed close [ " + oldestCompletedClose.path + " ]"), (Object[])new Object[0]);
            }
        }
    }

    @Trivial
    private ReaperShutdownRunnable getReaperShutdown() {
        return this.reaperShutdown;
    }

    @Trivial
    private Thread getReaperShutdownThread() {
        return this.reaperShutdownThread;
    }

    @Trivial
    private ReaperRunnable getReaper() {
        return this.reaperRunnable;
    }

    @Trivial
    private Thread getReaperThread() {
        return this.reaperThread;
    }

    protected void introspectReaperThread(PrintWriter output) {
        output.println();
        output.println("  Reaper [ " + this.reaperThread + " ]");
        output.println("    Id          [ " + this.reaperThread.getId() + " ]");
        output.println("    Name        [ " + this.reaperThread.getName() + " ]");
        output.println("    Daemon      [ " + this.reaperThread.isDaemon() + " ]");
        output.println("    Priority    [ " + this.reaperThread.getPriority() + " ]");
        output.println("    Group       [ " + this.reaperThread.getThreadGroup() + " ]");
        output.println();
        output.println("    State       [ " + (Object)((Object)this.reaperThread.getState()) + " ]");
        output.println("    Alive       [ " + this.reaperThread.isAlive() + " ]");
        output.println("    Interrupted [ " + this.reaperThread.isInterrupted() + " ]");
        output.println();
        this.reaperLock.introspect(output);
        output.println();
        this.waitReasons.introspect(output);
        output.println();
        this.reaperRunnable.introspect(output);
    }

    private void handleError(String errorMessage) {
        Tr.error((TraceComponent)tc, (String)errorMessage, (Object[])new Object[0]);
        if (this.errorHandler != null) {
            this.errorHandler.accept(errorMessage);
        }
        PrintWriter writer = new PrintWriter(System.out);
        this.introspect(writer, System.nanoTime());
        writer.flush();
    }

    protected void addWaitReason(String reason) {
        this.waitReasons.add(reason);
    }

    private long reap(long reapAt, boolean isShutdownReap) {
        long nextReapDelay;
        boolean useQuick;
        String methodName = "reap";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " At [ " + ZipFileReaper.toRelSec(this.initialAt, reapAt) + " (s) ] Force [ " + isShutdownReap + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(methodName + " All [ " + this.storage.size() + " ] Pending Quick [ " + this.pendingQuickStorage.size() + " ] Pending Slow [ " + this.pendingSlowStorage.size() + " ]"), (Object[])new Object[0]);
        }
        long nextQuickReapDelay = -1L;
        Iterator<ZipFileData> pendingQuick = this.pendingQuickStorage.values();
        while (nextQuickReapDelay == -1L && pendingQuick.hasNext()) {
            ZipFileData nextPending = pendingQuick.next();
            long nextLastPendAt = nextPending.lastPendAt;
            long nextPendDuration = reapAt - nextLastPendAt;
            if (isShutdownReap) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + nextPending.path + " ] Waiting [ " + ZipFileReaper.toAbsSec(nextPendDuration) + " (s) ] (Quick): Forced"), (Object[])new Object[0]);
                }
                pendingQuick.remove();
                this.fullyClose(nextPending, reapAt, true);
                continue;
            }
            if (nextPendDuration > this.quickPendMin) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + nextPending.path + " ] Waiting [ " + ZipFileReaper.toAbsSec(nextPendDuration) + " (s) ] (Quick): Expired"), (Object[])new Object[0]);
                }
                pendingQuick.remove();
                this.fullyClose(nextPending, reapAt, false);
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + nextPending.path + " ] Waiting [ " + ZipFileReaper.toAbsSec(nextPendDuration) + " (s) ]: Still Waiting"), (Object[])new Object[0]);
            }
            if (nextPendDuration < 0L) {
                nextPendDuration = 0L;
            }
            nextQuickReapDelay = this.quickPendMax - nextPendDuration;
        }
        long nextSlowReapDelay = -1L;
        Iterator<ZipFileData> pendingSlow = this.pendingSlowStorage.values();
        while (nextSlowReapDelay == -1L && pendingSlow.hasNext()) {
            ZipFileData nextPending = pendingSlow.next();
            long nextLastPendAt = nextPending.lastPendAt;
            long nextPendDuration = reapAt - nextLastPendAt;
            if (isShutdownReap) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + nextPending.path + " ] Waiting [ " + ZipFileReaper.toAbsSec(nextPendDuration) + " (s) ] (Slow): Forced"), (Object[])new Object[0]);
                }
                pendingSlow.remove();
                this.fullyClose(nextPending, reapAt, true);
                continue;
            }
            if (nextPendDuration > this.slowPendMin) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + nextPending.path + " ] Waiting [ " + ZipFileReaper.toAbsSec(nextPendDuration) + " (s) ] (Slow): Expired"), (Object[])new Object[0]);
                }
                pendingSlow.remove();
                this.fullyClose(nextPending, reapAt, false);
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + nextPending.path + " ] Waiting [ " + ZipFileReaper.toAbsSec(nextPendDuration) + " (s) ]: Still Waiting"), (Object[])new Object[0]);
            }
            if (nextPendDuration < 0L) {
                nextPendDuration = 0L;
            }
            nextSlowReapDelay = this.slowPendMax - nextPendDuration;
        }
        if (isShutdownReap) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " De-activating reaper"), (Object[])new Object[0]);
            }
            this.setIsActive(false);
            this.setFinalAt(reapAt);
            for (ZipFileData mustBeOpenOrClosed : this.storage.values()) {
                String path = mustBeOpenOrClosed.path;
                if (mustBeOpenOrClosed.isFullyClosed()) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Closed [ " + path + " ]: No shutdown action"), (Object[])new Object[0]);
                    continue;
                }
                if (mustBeOpenOrClosed.isPending()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Unexpected Pending [ " + path + " ]: Shutdown close"), (Object[])new Object[0]);
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Open [ " + path + " ] [ " + mustBeOpenOrClosed.getActiveOpens() + " ]: Shutdown pend and close"), (Object[])new Object[0]);
                    }
                    mustBeOpenOrClosed.enactClose(reapAt, true);
                }
                this.fullyClose(mustBeOpenOrClosed, reapAt, true);
            }
            for (ZipFileData mustBeClosed : this.storage.values()) {
                mustBeClosed.setFinal(reapAt);
                mustBeClosed.debugState();
            }
        }
        if (nextQuickReapDelay < 0L && nextSlowReapDelay < 0L) {
            useQuick = true;
            nextReapDelay = -1L;
        } else if (nextQuickReapDelay < 0L) {
            useQuick = false;
            nextReapDelay = nextSlowReapDelay;
        } else if (nextSlowReapDelay < 0L) {
            useQuick = true;
            nextReapDelay = nextQuickReapDelay;
        } else if (nextQuickReapDelay < nextSlowReapDelay) {
            useQuick = true;
            nextReapDelay = nextQuickReapDelay;
        } else {
            useQuick = false;
            nextReapDelay = nextSlowReapDelay;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String delayText = nextReapDelay == -1L ? "Indefinite" : ZipFileReaper.toAbsSec(nextReapDelay);
            String speedText = useQuick ? "Quick" : "Slow";
            Tr.debug((TraceComponent)tc, (String)(methodName + " Next reap [ " + delayText + " (s) ] (" + speedText + ")"), (Object[])new Object[0]);
        }
        return nextReapDelay;
    }

    @Trivial
    public ZipFile open(String path) throws IOException, ZipException {
        return this.open(path, SystemUtils.getNanoTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    public ZipFile open(String path, long openAt) throws IOException, ZipException {
        String methodName = "open";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + path + " ] at [ " + ZipFileReaper.toRelSec(this.initialAt, openAt) + " (s) ]"), (Object[])new Object[0]);
        }
        ReaperLock reaperLock = this.reaperLock;
        synchronized (reaperLock) {
            ZipFile zipFile;
            if (!this.getIsActive()) {
                ZipFileReaper.asyncWarning("reaper.inactive", path, this.reaperName);
                throw new IOException("Cannot open [ " + path + " ]: ZipFile cache is inactive");
            }
            ZipFileData data = this.storage.get(path);
            if (data == null) {
                if (!this.debugState) {
                    data = this.completedStorage.remove(path);
                }
                if (data == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " New [ " + path + " ]"), (Object[])new Object[0]);
                    }
                    data = new ZipFileData(path, this.getInitialAt());
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Recovered [ " + path + " ]"), (Object[])new Object[0]);
                }
                this.storage.put(path, data);
            }
            if (data.isFullyClosed()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Open [ " + path + " ]"), (Object[])new Object[0]);
                }
                zipFile = data.openZipFile();
            } else if (data.isPending()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Unpend [ " + path + " ]"), (Object[])new Object[0]);
                }
                ZipFileData zipFileData = data.expireQuickly ? this.pendingQuickStorage.remove(path) : this.pendingSlowStorage.remove(path);
                try {
                    zipFile = data.reacquireZipFile();
                }
                catch (Exception e) {
                    data.enactFullClose(openAt);
                    throw e;
                }
            } else if (data.isOpen()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Already open [ " + path + " ]"), (Object[])new Object[0]);
                }
                try {
                    zipFile = data.reacquireZipFile();
                }
                catch (Exception e) {
                    data.enactClose(openAt, true);
                    data.enactFullClose(openAt);
                    throw e;
                }
            } else {
                throw data.unknownState();
            }
            data.enactOpen(openAt);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + path + " ] [ " + zipFile + " ]"), (Object[])new Object[0]);
            }
            return zipFile;
        }
    }

    public ZipFileData.ZipFileState close(String path) {
        return this.close(path, SystemUtils.getNanoTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFileData.ZipFileState close(String path, long closeAt) {
        String methodName = "close";
        ReaperLock reaperLock = this.reaperLock;
        synchronized (reaperLock) {
            if (!this.getIsActive()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + path + " ]: Ignore: Inactive"), (Object[])new Object[0]);
                }
                return null;
            }
            ZipFileData data = this.storage.get(path);
            if (data == null) {
                ZipFileReaper.asyncWarning("reaper.unregistered.path", path);
            } else if (data.isFullyClosed()) {
                ZipFileReaper.asyncWarning("reaper.closed.path", path);
            } else if (data.isPending()) {
                ZipFileReaper.asyncWarning("reaper.pending.path", path);
            } else if (data.isOpen()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Active opens [ " + path + " ] [ " + data.getActiveOpens() + " ]"), (Object[])new Object[0]);
                }
                if (data.enactClose(closeAt, false)) {
                    boolean expireQuickly = data.setExpireQuickly(this.slowPendMin);
                    if (expireQuickly && this.quickPendMin == 0L) {
                        this.fullyClose(data, closeAt, false);
                    } else {
                        String skipWakeReason;
                        String wakeReason;
                        boolean wasQuickEmpty = this.pendingQuickStorage.isEmpty();
                        boolean wasSlowEmpty = this.pendingSlowStorage.isEmpty();
                        ZipFileData ripestPending = expireQuickly ? this.pendingQuickStorage.addLast(data, this.getMaxCache()) : this.pendingSlowStorage.addLast(data, this.getMaxCache());
                        if (ripestPending != null) {
                            this.fullyClose(ripestPending, closeAt, false);
                        }
                        if (wasQuickEmpty && wasSlowEmpty) {
                            wakeReason = "Added first pending";
                            skipWakeReason = null;
                        } else if (expireQuickly) {
                            if (!wasQuickEmpty) {
                                wakeReason = null;
                                skipWakeReason = "Quick added with other quick";
                            } else {
                                wakeReason = "Added first quick while slow are present";
                                skipWakeReason = null;
                            }
                        } else {
                            wakeReason = null;
                            skipWakeReason = "slow added with quick or slow";
                        }
                        if (wakeReason != null) {
                            this.reaperLock.notify(methodName, wakeReason);
                        } else {
                            this.reaperLock.skipNotify(methodName, skipWakeReason);
                        }
                    }
                }
            } else {
                throw data.unknownState();
            }
            return data == null ? null : data.zipFileState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void introspect(PrintWriter output, long introspectAt) {
        ReaperLock reaperLock = this.reaperLock;
        synchronized (reaperLock) {
            output.println();
            output.println("  IsActive [ " + Boolean.valueOf(this.isActive) + " ]");
            output.println("  Initial  [ " + ZipFileReaper.toAbsSec(this.initialAt) + " (s) ]");
            output.println("  Final    [ " + ZipFileReaper.toAbsSec(this.finalAt) + " (s) ]");
            output.println("  Current  [ " + ZipFileReaper.toAbsSec(introspectAt) + " (s) ]");
            this.introspectReaperThread(output);
            output.println();
            output.println("Active and Pending Data:");
            if (this.storage.isEmpty()) {
                output.println("  ** NONE **");
            } else {
                for (Map.Entry<String, ZipFileData> reaperEntry : this.storage.entrySet()) {
                    output.println();
                    reaperEntry.getValue().introspect(output, introspectAt);
                }
            }
            this.pendingQuickStorage.introspect(output, false, introspectAt);
            this.pendingSlowStorage.introspect(output, false, introspectAt);
            if (this.completedStorage == null) {
                output.println();
                output.println("Completed zip file data is not being tracked");
            } else {
                this.completedStorage.introspect(output, true, introspectAt);
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        logThread.setDaemon(true);
        logThread.start();
        NULL_ERROR_HANDLER = null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ReaperLock {
        Reasons lockReasons = new Reasons("Reaper Lock Activity");
        static final long serialVersionUID = 1195618659810513498L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public void addReason(String reason) {
            this.lockReasons.add(reason);
        }

        public void introspect(PrintWriter printWriter) {
            this.lockReasons.introspect(printWriter);
        }

        public void skipNotify(String methodName, String text) {
            this.addReason(text);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " " + text), (Object[])new Object[0]);
            }
        }

        public void notify(String methodName, String text) {
            this.addReason(text);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " " + text), (Object[])new Object[0]);
            }
            this.notify();
        }

        public void wait(String methodName, String text) throws InterruptedException {
            this.addReason(text);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Waiting for [ " + text + " ]"), (Object[])new Object[0]);
            }
            this.wait();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Waited for [ " + text + " ]"), (Object[])new Object[0]);
            }
        }

        public void waitNS(long waitNs, String methodName, String text) throws InterruptedException {
            this.addReason(text);
            long waitMs = waitNs / 1000000L;
            int fracWaitNs = (int)(waitNs - waitMs * 1000000L);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Waiting [ " + Long.toString(waitMs) + " (ms) " + Integer.toString(fracWaitNs) + " (ns) ] for [ " + text + " ]"), (Object[])new Object[0]);
            }
            if (waitMs == 0L && fracWaitNs == 0) {
                throw new IllegalArgumentException(methodName + ": Invalid zero wait request for [ " + text + " ]");
            }
            this.wait(waitMs, fracWaitNs);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Waited [ " + Long.toString(waitMs) + " (ms) " + Integer.toString(fracWaitNs) + " (ns) ] for [ " + text + " ]"), (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$ReaperLock", ReaperLock.class, (String)"archive.artifact", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class Reasons {
        private final String description;
        private int nextReason;
        public final String[] reasons;
        static final long serialVersionUID = 3825694454729853907L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Reasons(String description) {
            this.description = description;
            this.reasons = new String[10];
            this.nextReason = 0;
        }

        public void add(String reason) {
            this.reasons[this.nextReason] = reason;
            this.nextReason = this.nextReason == 9 ? 0 : ++this.nextReason;
        }

        public void introspect(PrintWriter printWriter) {
            int lastReason;
            printWriter.println(this.description + ": ");
            int n = lastReason = this.nextReason == 0 ? 9 : this.nextReason - 1;
            if (this.reasons[lastReason] == null) {
                printWriter.println("  *** NONE ***");
            } else {
                for (int reasonNo = 0; reasonNo > -10; --reasonNo) {
                    String reason;
                    int actualReasonNo = this.nextReason + reasonNo - 1;
                    if (actualReasonNo < 0) {
                        actualReasonNo += 10;
                    }
                    if ((reason = this.reasons[actualReasonNo]) == null) break;
                    printWriter.println("  [ " + reasonNo + " ] [ " + this.reasons[actualReasonNo] + " ]");
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$Reasons", Reasons.class, (String)"archive.artifact", null);
        }
    }

    public static interface ErrorConsumer<T> {
        public void accept(T var1);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ReaperShutdownRunnable
    implements Runnable {
        private final Thread reaperThread;
        static final long serialVersionUID = -4710337470754673672L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public ReaperShutdownRunnable(Thread reaperThread) {
            this.reaperThread = reaperThread;
        }

        @Trivial
        private Thread getReaperThread() {
            return this.reaperThread;
        }

        @Override
        public void run() {
            Thread useReaperThread = this.getReaperThread();
            useReaperThread.interrupt();
            try {
                useReaperThread.join();
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$ReaperShutdownRunnable", (String)"773", (Object)this, (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$ReaperShutdownRunnable", ReaperShutdownRunnable.class, (String)"archive.artifact", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ReaperRunnable
    implements Runnable {
        private long initialAt;
        private boolean isFinal;
        private long finalAt;
        private boolean didShutdownReap;
        private long shutdownReapAt;
        private long nextReapAt;
        private long lastReapAt;
        private long nextReapDelay;
        private String nextReapReason;
        private final CountDownLatch startupLatch;
        private final ZipFileReaper reaper;
        public static final long STALL_LIMIT = 10000000000L;
        static final long serialVersionUID = 325038746527180445L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public ReaperRunnable(ZipFileReaper reaper) {
            this.reaper = reaper;
            this.initialAt = -1L;
            this.isFinal = false;
            this.finalAt = -1L;
            this.didShutdownReap = false;
            this.shutdownReapAt = -1L;
            this.nextReapAt = -1L;
            this.lastReapAt = -1L;
            this.nextReapDelay = -1L;
            this.startupLatch = new CountDownLatch(1);
        }

        protected void waitForStartup() throws InterruptedException {
            this.startupLatch.await();
        }

        protected void signalStartup() {
            this.startupLatch.countDown();
        }

        protected void introspect(PrintWriter output) {
            output.println();
            output.println("  Runner [ " + this + " ]");
            long reaperInitialAt = this.getReaper().getInitialAt();
            output.println("    Initial       [ " + ZipFileReaper.toRelSec(reaperInitialAt, this.initialAt) + " (s) ]");
            if (this.isFinal) {
                output.println("    Final         [ " + ZipFileReaper.toRelSec(reaperInitialAt, this.initialAt) + " (s) ]");
            }
            if (this.didShutdownReap) {
                output.println("    Shutdown Reap [ " + ZipFileReaper.toRelSec(reaperInitialAt, this.shutdownReapAt) + " (s) ]");
            }
            output.println("    Last Reap     [ " + ZipFileReaper.toRelSec(reaperInitialAt, this.lastReapAt) + " (s) ]");
            output.println("    Next Reap     [ " + ZipFileReaper.toRelSec(reaperInitialAt, this.nextReapAt) + " (s) ]");
            String delayText = this.nextReapDelay < 0L ? "INDEFINITE" : ZipFileReaper.toAbsSec(this.nextReapDelay);
            output.println("    Next Delay    [ " + delayText + " (s) ] (" + this.nextReapReason + ")");
            output.println();
            output.println("  Logger [ " + logThread + " ]");
        }

        @Trivial
        public ZipFileReaper getReaper() {
            return this.reaper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            String methodName = "run";
            boolean doDebug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
            long startAt = SystemUtils.getNanoTime();
            if (doDebug) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Start [ " + ZipFileReaper.toRelSec(startAt, startAt) + " (s) ]"), (Object[])new Object[0]);
            }
            ReaperLock reaperLock = this.reaper.reaperLock;
            synchronized (reaperLock) {
                this.signalStartup();
                this.nextReapDelay = -1L;
                this.reaper.addWaitReason("indefinite (initial)");
                this.nextReapAt = this.initialAt;
                this.nextReapReason = "indefinite (initial)";
                while (true) {
                    long pendMax;
                    ZipFileData ripestPending;
                    String errorMessage;
                    long lastReapAt = this.nextReapAt;
                    ZipFileData testPending = this.reaper.getRipest();
                    if (this.nextReapDelay < 0L) {
                        if (testPending != null) {
                            errorMessage = "Indefinite wait with pending [ " + testPending + " ]";
                            this.nextReapReason = "specific (corrected from indefinite) [ " + this.nextReapDelay + " ]";
                            this.nextReapDelay = this.reaper.getQuickPendMin();
                            this.reaper.addWaitReason("specific (corrected from indefinite)");
                        } else {
                            errorMessage = null;
                            this.nextReapReason = "indefinite (no pending)";
                        }
                    } else if (this.nextReapDelay == 0L) {
                        errorMessage = "Incorrect explicit indefinited wait [ " + testPending + " ]";
                        if (testPending == null) {
                            this.nextReapDelay = -1L;
                            this.nextReapReason = "indefinite (corrected from zero)";
                            this.reaper.addWaitReason("indefinite (corrected from zero)");
                        } else {
                            this.nextReapDelay = this.reaper.getQuickPendMin();
                            this.nextReapReason = "specific (corrected from zero)";
                            this.reaper.addWaitReason("specific (corrected from zero)");
                        }
                    } else {
                        errorMessage = null;
                        this.nextReapReason = testPending == null ? "specific (no pending)" : "specific [ " + this.nextReapDelay + " ]";
                    }
                    if (errorMessage != null) {
                        this.reaper.handleError(errorMessage);
                    }
                    try {
                        if (this.nextReapDelay < 0L) {
                            this.reaper.reaperLock.wait(methodName, "new pending close");
                        } else {
                            this.reaper.reaperLock.waitNS(this.nextReapDelay, methodName, "active pending close");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$ReaperRunnable", (String)"450", (Object)this, (Object[])new Object[0]);
                        if (!doDebug) break;
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Interrupted!"), (Object[])new Object[0]);
                        break;
                    }
                    this.nextReapAt = SystemUtils.getNanoTime();
                    if (doDebug) {
                        long overage;
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Reap [ " + ZipFileReaper.toRelSec(startAt, this.nextReapAt) + " (s) ]"), (Object[])new Object[0]);
                        long actualReapDelay = this.nextReapAt - lastReapAt;
                        String message = this.nextReapDelay > 0L ? ((overage = actualReapDelay - this.nextReapDelay) > 10000000000L ? " Excessive reap cycle time:" : " Reap cycle time:") : " Reap cycle time:";
                        Tr.debug((TraceComponent)tc, (String)(methodName + message + " Actual delay [ " + ZipFileReaper.toAbsSec(actualReapDelay) + " (s) ]; Requested delay [ " + ZipFileReaper.toAbsSec(this.nextReapDelay) + " (s) ]"), (Object[])new Object[0]);
                    }
                    if ((ripestPending = this.reaper.getRipest()) == null) {
                        if (doDebug) {
                            Tr.debug((TraceComponent)tc, (String)(methodName + " No pending!"), (Object[])new Object[0]);
                        }
                        this.nextReapDelay = -1L;
                        this.reaper.addWaitReason("indefinite (no pending)");
                        continue;
                    }
                    long lastPendAt = ripestPending.lastPendAt;
                    long consumedPend = this.nextReapAt - lastPendAt;
                    long l = pendMax = ripestPending.expireQuickly ? this.reaper.getQuickPendMin() : this.reaper.getSlowPendMax();
                    if (consumedPend < pendMax) {
                        this.nextReapDelay = pendMax - consumedPend;
                        this.reaper.addWaitReason("specific (incomplete pend)");
                        if (!doDebug) continue;
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Ripest [ " + ripestPending.path + " ] waited [ " + ZipFileReaper.toAbsSec(consumedPend) + " (s) ] remaining [ " + ZipFileReaper.toAbsSec(this.nextReapDelay) + " (s) ]"), (Object[])new Object[0]);
                        continue;
                    }
                    if (doDebug) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Ripest [ " + ripestPending.path + " ] waited [ " + ZipFileReaper.toAbsSec(consumedPend) + " (s) ]"), (Object[])new Object[0]);
                    }
                    this.nextReapDelay = this.reaper.reap(this.nextReapAt, false);
                    this.reaper.addWaitReason("specific (reap)");
                }
            }
            long shutdownAt = SystemUtils.getNanoTime();
            if (doDebug) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Shutting down [ " + ZipFileReaper.toRelSec(startAt, shutdownAt) + " (s) ]"), (Object[])new Object[0]);
            }
            this.reaper.reap(shutdownAt, true);
            long stopAt = SystemUtils.getNanoTime();
            if (doDebug) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Stop [ " + ZipFileReaper.toRelSec(startAt, stopAt) + " (s) ]"), (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$ReaperRunnable", ReaperRunnable.class, (String)"archive.artifact", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class DeferredLogEmitter
    implements Runnable {
        protected final BlockingQueue<DeferredLogRecord> deferredLogQueue = new LinkedBlockingQueue<DeferredLogRecord>();
        static final long serialVersionUID = -2165541111510212266L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public void run() {
            try {
                while (true) {
                    this.take().emit();
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$DeferredLogEmitter", (String)"221", (Object)this, (Object[])new Object[0]);
                return;
            }
        }

        public void post(String msgKey, Object ... msgArgs) {
            try {
                this.deferredLogQueue.put(new DeferredLogRecord(msgKey, msgArgs));
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$DeferredLogEmitter", (String)"236", (Object)this, (Object[])new Object[]{msgKey, msgArgs});
            }
        }

        public DeferredLogRecord take() throws InterruptedException {
            return this.deferredLogQueue.take();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$DeferredLogEmitter", DeferredLogEmitter.class, (String)"archive.artifact", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class DeferredLogRecord {
        private final String msgKey;
        private final Object[] msgArgs;
        static final long serialVersionUID = -3088694982418321168L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public DeferredLogRecord(String msgKey, Object ... msgArgs) {
            this.msgKey = msgKey;
            this.msgArgs = msgArgs;
        }

        public void emit() {
            Tr.warning((TraceComponent)tc, (String)this.msgKey, (Object[])this.msgArgs);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$DeferredLogRecord", DeferredLogRecord.class, (String)"archive.artifact", null);
        }
    }
}

