/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.validation;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.beanvalidation.component.BeanValidationService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.Configuration;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;
import javax.validation.spi.ValidationProvider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.validation.ResponseConstraintViolationException;
import org.apache.cxf.validation.ValidationConfiguration;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class BeanValidationProvider {
    private static final Logger LOG = LogUtils.getL7dLogger(BeanValidationProvider.class);
    private final ValidatorFactory factory;
    static final long serialVersionUID = 2495820649088565622L;

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BeanValidationProvider() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.validation.BeanValidationProvider", "<init>", new Object[0]);
        }
        try {
            this.factory = BeanValidationService.instance().getDefaultValidatorFactory();
        }
        catch (ValidationException validationException) {
            void ex;
            FFDCFilter.processException((Throwable)validationException, (String)"org.apache.cxf.validation.BeanValidationProvider", (String)"48", (Object)this, (Object[])new Object[0]);
            LOG.severe("Bean Validation provider can not be found, no validation will be performed");
            throw ex;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.validation.BeanValidationProvider", "<init>", this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BeanValidationProvider(ValidationConfiguration cfg) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.validation.BeanValidationProvider", "<init>", new Object[]{cfg});
        }
        try {
            Configuration factoryCfg = Validation.byDefaultProvider().configure();
            BeanValidationProvider.initFactoryConfig(factoryCfg, cfg);
            this.factory = factoryCfg.buildValidatorFactory();
        }
        catch (ValidationException factoryCfg) {
            void ex;
            FFDCFilter.processException((Throwable)factoryCfg, (String)"org.apache.cxf.validation.BeanValidationProvider", (String)"59", (Object)this, (Object[])new Object[]{cfg});
            LOG.severe("Bean Validation provider can not be found, no validation will be performed");
            throw ex;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.validation.BeanValidationProvider", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BeanValidationProvider(ValidatorFactory factory) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.validation.BeanValidationProvider", "<init>", new Object[]{factory});
        }
        if (factory == null) {
            throw new NullPointerException("Factory is null");
        }
        this.factory = factory;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.validation.BeanValidationProvider", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BeanValidationProvider(ValidationProviderResolver resolver) {
        this(resolver, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.validation.BeanValidationProvider", "<init>", new Object[]{resolver});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.validation.BeanValidationProvider", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T extends Configuration<T>> BeanValidationProvider(ValidationProviderResolver resolver, Class<ValidationProvider<T>> providerType) {
        this(resolver, providerType, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.validation.BeanValidationProvider", "<init>", new Object[]{resolver, providerType});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.validation.BeanValidationProvider", "<init>", this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T extends Configuration<T>> BeanValidationProvider(ValidationProviderResolver resolver, Class<ValidationProvider<T>> providerType, ValidationConfiguration cfg) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.validation.BeanValidationProvider", "<init>", new Object[]{resolver, providerType, cfg});
        }
        try {
            Configuration factoryCfg = providerType != null ? Validation.byProvider(providerType).providerResolver(resolver).configure() : Validation.byDefaultProvider().providerResolver(resolver).configure();
            BeanValidationProvider.initFactoryConfig(factoryCfg, cfg);
            this.factory = factoryCfg.buildValidatorFactory();
        }
        catch (ValidationException factoryCfg) {
            void ex;
            FFDCFilter.processException((Throwable)factoryCfg, (String)"org.apache.cxf.validation.BeanValidationProvider", (String)"92", (Object)this, (Object[])new Object[]{resolver, providerType, cfg});
            LOG.severe("Bean Validation provider can not be found, no validation will be performed");
            throw ex;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.validation.BeanValidationProvider", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void initFactoryConfig(Configuration<?> factoryCfg, ValidationConfiguration cfg) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.validation.BeanValidationProvider", "initFactoryConfig", new Object[]{factoryCfg, cfg});
        }
        if (cfg != null) {
            factoryCfg.parameterNameProvider(cfg.getParameterNameProvider());
            factoryCfg.messageInterpolator(cfg.getMessageInterpolator());
            factoryCfg.traversableResolver(cfg.getTraversableResolver());
            factoryCfg.constraintValidatorFactory(cfg.getConstraintValidatorFactory());
            for (Map.Entry<String, String> entry : cfg.getProperties().entrySet()) {
                factoryCfg.addProperty(entry.getKey(), entry.getValue());
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.validation.BeanValidationProvider", "initFactoryConfig");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> void validateParameters(T instance, Method method, Object[] arguments) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.validation.BeanValidationProvider", "validateParameters", new Object[]{instance, method, arguments});
        }
        ExecutableValidator methodValidator = this.getExecutableValidator();
        Set violations = methodValidator.validateParameters(instance, method, arguments, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.validation.BeanValidationProvider", "validateParameters");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> void validateReturnValue(T instance, Method method, Object returnValue) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.validation.BeanValidationProvider", "validateReturnValue", new Object[]{instance, method, returnValue});
        }
        ExecutableValidator methodValidator = this.getExecutableValidator();
        Set violations = methodValidator.validateReturnValue(instance, method, returnValue, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ResponseConstraintViolationException(violations);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.validation.BeanValidationProvider", "validateReturnValue");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> void validateReturnValue(T bean) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.validation.BeanValidationProvider", "validateReturnValue", new Object[]{bean});
        }
        Set<ConstraintViolation<T>> violations = this.doValidateBean(bean);
        if (!violations.isEmpty()) {
            throw new ResponseConstraintViolationException(violations);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.validation.BeanValidationProvider", "validateReturnValue");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> void validateBean(T bean) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.validation.BeanValidationProvider", "validateBean", new Object[]{bean});
        }
        Set<ConstraintViolation<T>> violations = this.doValidateBean(bean);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.validation.BeanValidationProvider", "validateBean");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private <T> Set<ConstraintViolation<T>> doValidateBean(T bean) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.validation.BeanValidationProvider", "doValidateBean", new Object[]{bean});
        }
        Set set = this.factory.getValidator().validate(bean, new Class[0]);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.validation.BeanValidationProvider", "doValidateBean", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ExecutableValidator getExecutableValidator() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.validation.BeanValidationProvider", "getExecutableValidator", new Object[0]);
        }
        ExecutableValidator executableValidator = this.factory.getValidator().forExecutables();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            executableValidator = executableValidator;
            LOG.exiting("org.apache.cxf.validation.BeanValidationProvider", "getExecutableValidator", executableValidator);
        }
        return executableValidator;
    }
}

