/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwtsso.token;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.principals.WSPrincipal;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.common.crypto.HashUtils;
import com.ibm.ws.security.jwtsso.config.JwtSsoBuilderConfig;
import com.ibm.ws.security.jwtsso.config.JwtSsoConfig;
import com.ibm.ws.security.jwtsso.token.proxy.JwtSSOTokenProxy;
import com.ibm.ws.security.jwtsso.utils.JwtSsoTokenUtils;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={JwtSSOTokenProxy.class}, name="JwtSSOTokenProxy", immediate=true, property={"service.vendor=IBM"})
public class JwtSSOTokenImpl
implements JwtSSOTokenProxy {
    private static final TraceComponent tc = Tr.register(JwtSSOTokenImpl.class, (String)"JWTSSOTOKEN", (String)"com.ibm.ws.security.jwtsso.token.resources.JWTSSOTOKENMessages");
    public static final String JSON_WEB_TOKEN_SSO_CONFIG = "jwtSsoConfig";
    public static final String JSON_WEB_TOKEN_SSO_BUILDER_CONFIG = "jwtSsoBuilderConfig";
    public static final String MP_JSON_WEB_TOKEN_TAI = "microProfileJwtTAI";
    public static final String UNAUTHENTICATED = "UNAUTHENTICATED";
    protected static final AtomicServiceReference<JwtSsoConfig> jwtSSOConfigRef = new AtomicServiceReference("jwtSsoConfig");
    protected static final AtomicServiceReference<JwtSsoBuilderConfig> jwtSSOBuilderConfigRef = new AtomicServiceReference("jwtSsoBuilderConfig");
    protected static final AtomicServiceReference<TrustAssociationInterceptor> mpJwtTaiServiceRef = new AtomicServiceReference("microProfileJwtTAI");
    private final SubjectHelper subjectHelper = new SubjectHelper();
    private static final String[] hashtableProperties = new String[]{"com.ibm.wsspi.security.cred.cacheKey"};
    static final long serialVersionUID = -2805714517291641964L;

    @Reference(service=TrustAssociationInterceptor.class, name="microProfileJwtTAI", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setTrustAssociationInterceptor(ServiceReference<TrustAssociationInterceptor> ref) {
        mpJwtTaiServiceRef.setReference(ref);
    }

    protected void unsetTrustAssociationInterceptor(ServiceReference<TrustAssociationInterceptor> ref) {
        mpJwtTaiServiceRef.unsetReference(ref);
    }

    @Reference(service=JwtSsoBuilderConfig.class, name="jwtSsoBuilderConfig", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setJwtSsoBuilderConfig(ServiceReference<JwtSsoBuilderConfig> ref) {
        jwtSSOBuilderConfigRef.setReference(ref);
    }

    protected void unsetJwtSsoBuilderConfig(ServiceReference<JwtSsoBuilderConfig> ref) {
        jwtSSOBuilderConfigRef.unsetReference(ref);
    }

    @Reference(service=JwtSsoConfig.class, name="jwtSsoConfig", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setJwtSsoConfig(ServiceReference<JwtSsoConfig> ref) {
        jwtSSOConfigRef.setReference(ref);
    }

    protected void unsetJwtSsoConfig(ServiceReference<JwtSsoConfig> ref) {
        jwtSSOConfigRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        jwtSSOConfigRef.activate(cc);
        jwtSSOBuilderConfigRef.activate(cc);
        mpJwtTaiServiceRef.activate(cc);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Jwt SSO config consumer service is activated", (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)"Jwt SSO config builder service is activated", (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)"MicroProfile Jwt TAI service is activated", (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)"Jwt SSO token (impl) service is being activated!!", (Object[])new Object[0]);
        }
    }

    @Modified
    protected void modified(Map<String, Object> props) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        jwtSSOConfigRef.deactivate(cc);
        jwtSSOBuilderConfigRef.deactivate(cc);
        mpJwtTaiServiceRef.deactivate(cc);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Jwt SSO config consumer service is deactivated", (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)"Jwt SSO config builder service is deactivated", (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)"MicroProfile Jwt TAI service is deactivated", (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)"Jwt SSO token (impl) service is being deactivated!!", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createJwtSSOToken(Subject subject) throws WSLoginFailedException {
        if (subject != null) {
            if (this.isSubjectUnauthenticated(subject) || this.subjectHasJwtPrincipal(subject)) {
                return;
            }
            JwtSsoTokenUtils tokenUtil = this.getJwtSsoTokenBuilderUtils();
            if (tokenUtil != null) {
                JsonWebToken ssotoken = null;
                try {
                    ssotoken = tokenUtil.buildTokenFromSecuritySubject(subject);
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwtsso.token.JwtSSOTokenImpl", (String)"143", (Object)this, (Object[])new Object[]{subject});
                    throw new WSLoginFailedException(e.getLocalizedMessage());
                }
                this.updateSubject(subject, ssotoken);
            } else {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWTSSO_CONFIG_INVALID", (Object[])new Object[0]);
                throw new WSLoginFailedException(msg);
            }
        }
    }

    protected JwtSsoTokenUtils getJwtSsoTokenBuilderUtils() {
        JwtSsoBuilderConfig jwtssobuilderConfig = this.getJwtSSOBuilderConfig();
        String builder = null;
        if (jwtssobuilderConfig != null) {
            builder = this.getJwtBuilder(jwtssobuilderConfig);
        }
        if (builder != null) {
            return new JwtSsoTokenUtils(builder);
        }
        return null;
    }

    private void updateSubject(Subject subject, JsonWebToken ssotoken) {
        if (subject != null && ssotoken != null) {
            this.addJwtSSOTokenToSubject(subject, ssotoken);
        }
    }

    private boolean subjectHasJwtPrincipal(Subject subject) {
        return !this.getJwtPrincipals(subject).isEmpty();
    }

    private boolean isSubjectUnauthenticated(Subject subject) {
        Set<WSPrincipal> principals = this.getWSPrincipals(subject);
        return principals == null || principals.isEmpty() || UNAUTHENTICATED.equals(principals.iterator().next().getName());
    }

    private void addJwtSSOTokenToSubject(Subject subject, JsonWebToken ssotoken) {
        if (subject != null && ssotoken != null) {
            subject.getPrincipals().add((Principal)ssotoken);
        }
    }

    protected JwtSsoTokenUtils getJwtSsoTokenConsumerUtils() {
        JwtSsoConfig jwtssoconsumerConfig = this.getJwtSSOConsumerConfig();
        String consumer = null;
        if (jwtssoconsumerConfig != null) {
            consumer = this.getJwtConsumer(jwtssoconsumerConfig);
        }
        if (consumer != null) {
            JwtSsoTokenUtils result = new JwtSsoTokenUtils(consumer, mpJwtTaiServiceRef);
            return result.isValid() ? result : null;
        }
        return null;
    }

    private JwtSsoTokenUtils getSimpleJwtSsoTokenUtils() {
        return new JwtSsoTokenUtils();
    }

    private String getJwtConsumer(JwtSsoConfig jwtssoconfig) {
        return jwtssoconfig.getJwtConsumerRef();
    }

    private String getJwtBuilder(JwtSsoBuilderConfig jwtssobuilderconfig) {
        return jwtssobuilderconfig.getJwtBuilderRef();
    }

    protected JwtSsoConfig getJwtSSOConsumerConfig() {
        if (jwtSSOConfigRef.getService() != null) {
            return (JwtSsoConfig)jwtSSOConfigRef.getService();
        }
        return null;
    }

    protected JwtSsoBuilderConfig getJwtSSOBuilderConfig() {
        if (jwtSSOBuilderConfigRef.getService() != null) {
            return (JwtSsoBuilderConfig)jwtSSOBuilderConfigRef.getService();
        }
        return null;
    }

    public String getJwtSSOToken(Subject subject) {
        String encodedjwtprincipal = null;
        Set<JsonWebToken> jsonWebTokenPrincipalSet = this.getJwtPrincipals(subject);
        if (jsonWebTokenPrincipalSet != null && !jsonWebTokenPrincipalSet.isEmpty() && !this.hasMultiplePrincipals(jsonWebTokenPrincipalSet)) {
            encodedjwtprincipal = this.convertToEncoded(jsonWebTokenPrincipalSet.iterator().next());
        }
        return encodedjwtprincipal;
    }

    private String convertToEncoded(JsonWebToken jwtprincipal) {
        return this.getRawJwtToken(jwtprincipal);
    }

    private String getRawJwtToken(JsonWebToken jwtprincipal) {
        if (jwtprincipal != null) {
            return jwtprincipal.getRawToken();
        }
        return null;
    }

    private boolean hasMultiplePrincipals(Set<JsonWebToken> jsonWebTokenPrincipalSet) {
        return false;
    }

    private Set<JsonWebToken> getJwtPrincipals(Subject subject) {
        return subject != null ? subject.getPrincipals(JsonWebToken.class) : null;
    }

    private Set<WSPrincipal> getWSPrincipals(Subject subject) {
        return subject != null ? subject.getPrincipals(WSPrincipal.class) : null;
    }

    /*
     * WARNING - void declaration
     */
    public Subject handleJwtSSOTokenValidation(Subject subject, String encodedjwt) throws WSLoginFailedException {
        String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWTSSO_CONFIG_INVALID_OR_TOKEN_INVALID", (Object[])new Object[0]);
        Subject resultSub = null;
        JwtSsoTokenUtils tokenUtil = this.getJwtSsoTokenConsumerUtils();
        if (tokenUtil != null && encodedjwt != null) {
            if (subject != null) {
                try {
                    resultSub = tokenUtil.handleJwtSsoTokenValidationWithSubject(subject, encodedjwt);
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwtsso.token.JwtSSOTokenImpl", (String)"368", (Object)this, (Object[])new Object[]{subject, encodedjwt});
                    throw new WSLoginFailedException(e.getLocalizedMessage());
                }
            } else {
                try {
                    resultSub = tokenUtil.handleJwtSsoTokenValidation(encodedjwt);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.jwtsso.token.JwtSSOTokenImpl", (String)"374", (Object)this, (Object[])new Object[]{subject, encodedjwt});
                    throw new WSLoginFailedException(e.getLocalizedMessage());
                }
            }
        } else {
            throw new WSLoginFailedException(msg);
        }
        if (resultSub == null) {
            throw new WSLoginFailedException(msg);
        }
        return resultSub;
    }

    public String getCustomCacheKeyFromJwtSSOToken(String encodedjwt) {
        JwtSsoTokenUtils tokenUtil = this.getSimpleJwtSsoTokenUtils();
        if (encodedjwt != null) {
            return tokenUtil.getCustomCacheKeyFromToken(encodedjwt);
        }
        return null;
    }

    public String getCacheKeyForJwtSSOToken(Subject subject, String encodedjwt) {
        String jwtssotoken;
        if (encodedjwt != null) {
            return HashUtils.digest((String)encodedjwt);
        }
        if (subject != null && (jwtssotoken = this.getJwtSSOToken(subject)) != null) {
            return HashUtils.digest((String)jwtssotoken);
        }
        return null;
    }

    public void addAttributesToJwtSSOToken(Subject subject) throws WSLoginFailedException {
        Set<JsonWebToken> jsonWebTokenPrincipals = this.getJwtPrincipals(subject);
        if (jsonWebTokenPrincipals != null && !jsonWebTokenPrincipals.isEmpty()) {
            subject.getPrincipals().removeAll(jsonWebTokenPrincipals);
        }
        this.createJwtSSOToken(subject);
    }

    public boolean isSubjectValid(Subject subject) {
        String encodedjwt = this.getJwtSSOToken(subject);
        JwtSsoTokenUtils tokenUtil = this.getJwtSsoTokenConsumerUtils();
        if (tokenUtil != null && encodedjwt != null) {
            return tokenUtil.isJwtValid(encodedjwt);
        }
        return false;
    }

    public String getJwtCookieName() {
        JwtSsoBuilderConfig jwtssobuilderConfig = this.getJwtSSOBuilderConfig();
        if (jwtssobuilderConfig != null) {
            return jwtssobuilderConfig.getCookieName();
        }
        return null;
    }

    public boolean isCookieSecured() {
        JwtSsoBuilderConfig jwtssobuilderConfig = this.getJwtSSOBuilderConfig();
        if (jwtssobuilderConfig != null) {
            return jwtssobuilderConfig.isCookieSecured();
        }
        return true;
    }

    public long getValidTimeInMinutes() {
        JwtSsoBuilderConfig jwtssobuilderConfig = this.getJwtSSOBuilderConfig();
        if (jwtssobuilderConfig != null) {
            return jwtssobuilderConfig.getValidTime() * 60L;
        }
        return 0L;
    }

    public boolean shouldSetJwtCookiePathToWebAppContext() {
        JwtSsoBuilderConfig jwtssobuilderConfig = this.getJwtSSOBuilderConfig();
        if (jwtssobuilderConfig != null) {
            return jwtssobuilderConfig.isSetCookiePathToWebAppContextPath();
        }
        return false;
    }

    public boolean shouldAlsoIncludeLtpaCookie() {
        JwtSsoBuilderConfig jwtssobuilderConfig = this.getJwtSSOBuilderConfig();
        if (jwtssobuilderConfig != null) {
            return jwtssobuilderConfig.isIncludeLtpaCookie();
        }
        return true;
    }

    public boolean shouldUseLtpaIfJwtAbsent() {
        JwtSsoBuilderConfig jwtssobuilderConfig = this.getJwtSSOBuilderConfig();
        if (jwtssobuilderConfig != null) {
            return jwtssobuilderConfig.isUseLtpaIfJwtAbsent();
        }
        return true;
    }
}

