/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jaas.config.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jaas.common.internal.JAASLoginModuleConfigImpl;
import com.ibm.ws.security.jaas.config.JAASLoginConfig;
import com.ibm.ws.security.jaas.config.internal.ConfigFile;
import com.ibm.ws.security.jaas.config.internal.Parser;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.library.Library;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={JAASLoginConfig.class}, name="JAASLoginConfig", configurationPid={"com.ibm.ws.security.jaas.config.JAASLoginConfig"}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class JAASLoginConfigImpl
extends Parser
implements JAASLoginConfig {
    private static TraceComponent tc = Tr.register(JAASLoginConfigImpl.class, (String)"security", (String)"com.ibm.ws.security.jaas.common.internal.resources.JAASCommonMessages");
    private final String KEY_LOCATION_ADMIN = "locationAdmin";
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    private static final String AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    public static final List<String> defaultJaasLoginContextEntries = Collections.unmodifiableList(Arrays.asList("system.UNAUTHENTICATED", "system.WEB_INBOUND", "system.DEFAULT", "system.DESERIALIZE_CONTEXT", "system.RMI_INBOUND", "DefaultPrincipalMapping", "WSLogin", "ClientContainer"));
    private String fileName;
    private volatile Library sharedLibrary = null;
    private ConfigFile configFile = null;
    private ClassLoadingService classLoadingService;
    static final long serialVersionUID = 8590702513374981072L;

    @Reference(service=WsLocationAdmin.class, name="locationAdmin")
    protected void setLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.setReference(ref);
    }

    protected void unsetLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.unsetReference(ref);
    }

    @Reference
    protected void setClassLoadingSvc(ClassLoadingService classLoadingService) {
        this.classLoadingService = classLoadingService;
    }

    @Reference(service=Library.class, name="sharedLibrary", target="(id=jaasDefaultSharedLib)", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setSharedLib(Library svc) {
        this.sharedLibrary = svc;
    }

    protected void unsetSharedLib(Library svc) {
        this.sharedLibrary = svc;
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) {
        this.locationAdminRef.activate(cc);
        this.modified(props);
    }

    @Modified
    protected void modified(Map<String, Object> props) {
        String fn = this.getSystemProperty(AUTH_LOGIN_CONFIG);
        if (fn != null) {
            this.fileName = this.resolveVariblePath(fn);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.fileName == null ? "There is no JAAS login configuration file" : "JAAS login configuration file: " + this.fileName), (Object[])new Object[0]);
        }
        if (this.fileName != null) {
            this.configFile = new ConfigFile(this.fileName);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.locationAdminRef.deactivate(cc);
    }

    public String getSystemProperty(final String propName) {
        String value = (String)AccessController.doPrivileged(new PrivilegedAction(){
            static final long serialVersionUID = 3658551511379460254L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Object run() {
                return System.getProperty(propName);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jaas.config.internal.JAASLoginConfigImpl$1", 1.class, (String)"security", (String)"com.ibm.ws.security.jaas.common.internal.resources.JAASCommonMessages");
            }
        });
        return value;
    }

    private String resolveVariblePath(String fn) {
        WsLocationAdmin locationAdmin = (WsLocationAdmin)this.locationAdminRef.getService();
        if (locationAdmin != null) {
            return locationAdmin.resolveString(fn);
        }
        Tr.error((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"WsLocationAdmin"});
        return fn;
    }

    @Override
    public Map<String, List<AppConfigurationEntry>> getEntries() {
        if (this.configFile != null) {
            return this.updateDelegateOptions(this.configFile.getFileMap());
        }
        return null;
    }

    private Map<String, List<AppConfigurationEntry>> updateDelegateOptions(Map<String, List<AppConfigurationEntry>> jaasConfigurationEntries) {
        HashMap<String, List<AppConfigurationEntry>> result = new HashMap<String, List<AppConfigurationEntry>>();
        ArrayList<String> skipDefaultJaasLoginContextEntries = new ArrayList<String>();
        for (Map.Entry<String, List<AppConfigurationEntry>> entry : jaasConfigurationEntries.entrySet()) {
            String jaasLoginContextEnrty = entry.getKey();
            if (!defaultJaasLoginContextEntries.contains(jaasLoginContextEnrty)) {
                List<AppConfigurationEntry> updateAppConfiguationEntries = this.updateAppConfiguration(entry);
                result.put(jaasLoginContextEnrty, updateAppConfiguationEntries);
                continue;
            }
            skipDefaultJaasLoginContextEntries.add(jaasLoginContextEnrty);
        }
        if (!skipDefaultJaasLoginContextEntries.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"DEFAULT_JAAS_LOGIN_CONTEXT_ENTRY_SKIP", (Object[])new Object[]{((Object)skipDefaultJaasLoginContextEntries).toString(), this.fileName});
        }
        return result;
    }

    private List<AppConfigurationEntry> updateAppConfiguration(Map.Entry<String, List<AppConfigurationEntry>> entry) {
        ArrayList<AppConfigurationEntry> updateAppConfiguationEntries = new ArrayList<AppConfigurationEntry>();
        List<AppConfigurationEntry> appConfigurationEntries = entry.getValue();
        for (AppConfigurationEntry appConfigurationEntry : appConfigurationEntries) {
            Map<String, Object> options = appConfigurationEntry.getOptions();
            options = JAASLoginModuleConfigImpl.processDelegateOptions(options, appConfigurationEntry.getLoginModuleName(), null, this.classLoadingService, this.sharedLibrary, true);
            AppConfigurationEntry.LoginModuleControlFlag controlFlag = appConfigurationEntry.getControlFlag();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("loginModuleClassName: com.ibm.ws.kernel.boot.security.LoginModuleProxy options: " + options.toString() + " controlFlag: " + controlFlag.toString()), (Object[])new Object[0]);
            }
            updateAppConfiguationEntries.add(new AppConfigurationEntry("com.ibm.ws.kernel.boot.security.LoginModuleProxy", controlFlag, options));
        }
        return updateAppConfiguationEntries;
    }
}

