/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.Messaging.MaxHopsPolicy_impl;
import org.apache.yoko.orb.Messaging.QueueOrderPolicy_impl;
import org.apache.yoko.orb.Messaging.RebindPolicy_impl;
import org.apache.yoko.orb.Messaging.ReplyEndTimePolicy_impl;
import org.apache.yoko.orb.Messaging.ReplyPriorityPolicy_impl;
import org.apache.yoko.orb.Messaging.ReplyStartTimePolicy_impl;
import org.apache.yoko.orb.Messaging.RequestEndTimePolicy_impl;
import org.apache.yoko.orb.Messaging.RequestPriorityPolicy_impl;
import org.apache.yoko.orb.Messaging.RequestStartTimePolicy_impl;
import org.apache.yoko.orb.Messaging.RoutingPolicy_impl;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.RefCountPolicyList;
import org.apache.yoko.orb.OB.TimeHelper;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.IOP.TaggedComponent;
import org.omg.MessageRouting.PersistentRequestRouter;
import org.omg.MessageRouting.PersistentRequestRouterHelper;
import org.omg.MessageRouting.Router;
import org.omg.MessageRouting.RouterHelper;
import org.omg.MessageRouting.RouterListHelper;
import org.omg.MessageRouting.RouterListHolder;
import org.omg.Messaging.MaxHopsPolicyHelper;
import org.omg.Messaging.OrderingHelper;
import org.omg.Messaging.PolicyValue;
import org.omg.Messaging.PolicyValueSeqHolder;
import org.omg.Messaging.PriorityRange;
import org.omg.Messaging.PriorityRangeHelper;
import org.omg.Messaging.QueueOrderPolicyHelper;
import org.omg.Messaging.RebindModeHelper;
import org.omg.Messaging.RebindPolicyHelper;
import org.omg.Messaging.RelativeRequestTimeoutPolicyHelper;
import org.omg.Messaging.RelativeRoundtripTimeoutPolicyHelper;
import org.omg.Messaging.ReplyPriorityPolicyHelper;
import org.omg.Messaging.ReplyStartTimePolicyHelper;
import org.omg.Messaging.RequestEndTimePolicyHelper;
import org.omg.Messaging.RequestPriorityPolicyHelper;
import org.omg.Messaging.RequestStartTimePolicyHelper;
import org.omg.Messaging.RoutingPolicyHelper;
import org.omg.Messaging.RoutingTypeRange;
import org.omg.Messaging.RoutingTypeRangeHelper;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.TimeBase.UtcT;
import org.omg.TimeBase.UtcTHelper;

public final class MessageRoutingUtil {
    public static void getRouterListFromConfig(ORBInstance orbInstance, RouterListHolder routerList) {
        Properties properties = orbInstance.getProperties();
        ArrayList<String> amiPropKeys = new ArrayList<String>();
        for (java.lang.Object obj : properties.keySet()) {
            String key = (String)obj;
            if (!key.startsWith("yoko.ami.router.")) continue;
            amiPropKeys.add(key);
        }
        java.lang.Object[] routerKeys = amiPropKeys.toArray(new String[0]);
        Arrays.sort(routerKeys);
        for (java.lang.Object routerKey : routerKeys) {
            Object obj;
            String value = properties.getProperty((String)routerKey);
            if (value.startsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            ORB orb = orbInstance.getORB();
            try {
                if (value.startsWith("corbaloc:") || value.startsWith("corbaname:") || value.startsWith("IOR:") || value.startsWith("relfile:") || value.startsWith("file:")) {
                    obj = orb.string_to_object(value);
                } else {
                    String address = "corbaloc::" + value + "/AMIRouter";
                    obj = orb.string_to_object(address);
                }
            }
            catch (BAD_PARAM ex) {
                continue;
            }
            Router router = RouterHelper.unchecked_narrow((Object)obj);
            int oldLen = routerList.value.length + 1;
            routerList.value = Arrays.copyOf(routerList.value, oldLen);
            routerList.value[oldLen] = router;
        }
    }

    public static PersistentRequestRouter getPersistentRouterFromConfig(ORBInstance orbInstance) throws SystemException {
        PersistentRequestRouter router;
        Object obj;
        String key;
        Properties properties = orbInstance.getProperties();
        String value = properties.getProperty(key = "yoko.ami.persistent_router");
        if (value.startsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        ORB orb = orbInstance.getORB();
        if (value.startsWith("corbaloc:") || value.startsWith("corbaname:") || value.startsWith("IOR:") || value.startsWith("relfile:") || value.startsWith("file:")) {
            obj = orb.string_to_object(value);
        } else {
            String address = "corbaloc::" + value + "/AMIPersistentRouter";
            obj = orb.string_to_object(address);
        }
        try {
            router = PersistentRequestRouterHelper.narrow((Object)obj);
        }
        catch (SystemException ex) {
            throw (TRANSIENT)new TRANSIENT("PersistentRequestRouter not available").initCause((Throwable)ex);
        }
        return router;
    }

    public static void getRouterListFromComponents(ORBInstance orbInstance, ProfileInfo info, RouterListHolder routerList) {
        if (info.major == 1 && info.minor == 0) {
            return;
        }
        for (TaggedComponent component : info.components) {
            if (component.tag != 30) continue;
            InputStream in = new InputStream(component.component_data);
            in._OB_readEndian();
            in._OB_ORBInstance(orbInstance);
            Router[] routers = RouterListHelper.read((org.omg.CORBA.portable.InputStream)in);
            int routerLen = routers.length;
            int currentLen = routerList.value.length;
            Router[] newList = new Router[routerLen + currentLen];
            System.arraycopy(routerList.value, 0, newList, 0, currentLen);
            System.arraycopy(routers, 0, newList, currentLen, routerLen);
            routerList.value = newList;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static PolicyValue createMessagingPolicyValue(Policy policy) {
        value = new PolicyValue();
        switch (policy.policy_type()) {
            case 23: {
                p = RebindPolicyHelper.narrow((Object)policy);
                mode = p.rebind_mode();
                value.ptype = 23;
                out = new OutputStream();
                var5_36 = null;
                out._OB_writeEndian();
                RebindModeHelper.write((org.omg.CORBA.portable.OutputStream)out, (short)mode);
                value.pvalue = out.copyWrittenBytes();
                if (out == null) break;
                if (var5_36 == null) ** GOTO lbl21
                try {
                    out.close();
                }
                catch (Throwable var6_48) {
                    var5_36.addSuppressed(var6_48);
                }
                break;
lbl21:
                // 1 sources

                out.close();
                break;
                catch (Throwable var6_49) {
                    try {
                        var5_36 = var6_49;
                        throw var6_49;
                    }
                    catch (Throwable var7_70) {
                        if (out != null) {
                            if (var5_36 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable var8_73) {
                                    var5_36.addSuppressed(var8_73);
                                }
                            } else {
                                out.close();
                            }
                        }
                        throw var7_70;
                    }
                }
            }
            case 25: {
                p = RequestPriorityPolicyHelper.narrow((Object)policy);
                range = p.priority_range();
                value.ptype = 25;
                out = new OutputStream();
                var5_37 = null;
                out._OB_writeEndian();
                PriorityRangeHelper.write((org.omg.CORBA.portable.OutputStream)out, (PriorityRange)range);
                value.pvalue = out.copyWrittenBytes();
                if (out == null) break;
                if (var5_37 == null) ** GOTO lbl56
                try {
                    out.close();
                }
                catch (Throwable var6_50) {
                    var5_37.addSuppressed(var6_50);
                }
                break;
lbl56:
                // 1 sources

                out.close();
                break;
                catch (Throwable var6_51) {
                    try {
                        var5_37 = var6_51;
                        throw var6_51;
                    }
                    catch (Throwable var9_78) {
                        if (out != null) {
                            if (var5_37 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable var10_79) {
                                    var5_37.addSuppressed(var10_79);
                                }
                            } else {
                                out.close();
                            }
                        }
                        throw var9_78;
                    }
                }
            }
            case 26: {
                p = ReplyPriorityPolicyHelper.narrow((Object)policy);
                range = p.priority_range();
                value.ptype = 26;
                out = new OutputStream();
                var5_38 = null;
                out._OB_writeEndian();
                PriorityRangeHelper.write((org.omg.CORBA.portable.OutputStream)out, (PriorityRange)range);
                value.pvalue = out.copyWrittenBytes();
                if (out == null) break;
                if (var5_38 == null) ** GOTO lbl91
                try {
                    out.close();
                }
                catch (Throwable var6_52) {
                    var5_38.addSuppressed(var6_52);
                }
                break;
lbl91:
                // 1 sources

                out.close();
                break;
                catch (Throwable var6_53) {
                    try {
                        var5_38 = var6_53;
                        throw var6_53;
                    }
                    catch (Throwable var11_80) {
                        if (out != null) {
                            if (var5_38 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable var12_81) {
                                    var5_38.addSuppressed(var12_81);
                                }
                            } else {
                                out.close();
                            }
                        }
                        throw var11_80;
                    }
                }
            }
            case 27: {
                p = RequestStartTimePolicyHelper.narrow((Object)policy);
                time = p.start_time();
                value.ptype = 27;
                out = new OutputStream();
                var5_39 = null;
                out._OB_writeEndian();
                UtcTHelper.write((org.omg.CORBA.portable.OutputStream)out, (UtcT)time);
                value.pvalue = out.copyWrittenBytes();
                if (out == null) break;
                if (var5_39 == null) ** GOTO lbl126
                try {
                    out.close();
                }
                catch (Throwable var6_54) {
                    var5_39.addSuppressed(var6_54);
                }
                break;
lbl126:
                // 1 sources

                out.close();
                break;
                catch (Throwable var6_55) {
                    try {
                        var5_39 = var6_55;
                        throw var6_55;
                    }
                    catch (Throwable var13_82) {
                        if (out != null) {
                            if (var5_39 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable var14_83) {
                                    var5_39.addSuppressed(var14_83);
                                }
                            } else {
                                out.close();
                            }
                        }
                        throw var13_82;
                    }
                }
            }
            case 28: {
                p = RequestEndTimePolicyHelper.narrow((Object)policy);
                time = p.end_time();
                value.ptype = 28;
                out = new OutputStream();
                var5_40 = null;
                out._OB_writeEndian();
                UtcTHelper.write((org.omg.CORBA.portable.OutputStream)out, (UtcT)time);
                value.pvalue = out.copyWrittenBytes();
                if (out == null) break;
                if (var5_40 == null) ** GOTO lbl161
                try {
                    out.close();
                }
                catch (Throwable var6_56) {
                    var5_40.addSuppressed(var6_56);
                }
                break;
lbl161:
                // 1 sources

                out.close();
                break;
                catch (Throwable var6_57) {
                    try {
                        var5_40 = var6_57;
                        throw var6_57;
                    }
                    catch (Throwable var15_84) {
                        if (out != null) {
                            if (var5_40 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable var16_85) {
                                    var5_40.addSuppressed(var16_85);
                                }
                            } else {
                                out.close();
                            }
                        }
                        throw var15_84;
                    }
                }
            }
            case 29: {
                p = ReplyStartTimePolicyHelper.narrow((Object)policy);
                time = p.start_time();
                value.ptype = 29;
                out = new OutputStream();
                var5_41 = null;
                out._OB_writeEndian();
                UtcTHelper.write((org.omg.CORBA.portable.OutputStream)out, (UtcT)time);
                value.pvalue = out.copyWrittenBytes();
                if (out == null) break;
                if (var5_41 == null) ** GOTO lbl196
                try {
                    out.close();
                }
                catch (Throwable var6_58) {
                    var5_41.addSuppressed(var6_58);
                }
                break;
lbl196:
                // 1 sources

                out.close();
                break;
                catch (Throwable var6_59) {
                    try {
                        var5_41 = var6_59;
                        throw var6_59;
                    }
                    catch (Throwable var17_86) {
                        if (out != null) {
                            if (var5_41 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable var18_87) {
                                    var5_41.addSuppressed(var18_87);
                                }
                            } else {
                                out.close();
                            }
                        }
                        throw var17_86;
                    }
                }
            }
            case 30: {
                p = RequestEndTimePolicyHelper.narrow((Object)policy);
                time = p.end_time();
                value.ptype = 30;
                out = new OutputStream();
                var5_42 = null;
                out._OB_writeEndian();
                UtcTHelper.write((org.omg.CORBA.portable.OutputStream)out, (UtcT)time);
                value.pvalue = out.copyWrittenBytes();
                if (out == null) break;
                if (var5_42 == null) ** GOTO lbl231
                try {
                    out.close();
                }
                catch (Throwable var6_60) {
                    var5_42.addSuppressed(var6_60);
                }
                break;
lbl231:
                // 1 sources

                out.close();
                break;
                catch (Throwable var6_61) {
                    try {
                        var5_42 = var6_61;
                        throw var6_61;
                    }
                    catch (Throwable var19_88) {
                        if (out != null) {
                            if (var5_42 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable var20_89) {
                                    var5_42.addSuppressed(var20_89);
                                }
                            } else {
                                out.close();
                            }
                        }
                        throw var19_88;
                    }
                }
            }
            case 31: {
                p = RelativeRequestTimeoutPolicyHelper.narrow((Object)policy);
                time = p.relative_expiry();
                timeout = TimeHelper.add(TimeHelper.utcNow(0L), time);
                value.ptype = 28;
                out = new OutputStream();
                var7_71 = null;
                out._OB_writeEndian();
                UtcTHelper.write((org.omg.CORBA.portable.OutputStream)out, (UtcT)timeout);
                value.pvalue = out.copyWrittenBytes();
                if (out == null) break;
                if (var7_71 == null) ** GOTO lbl267
                try {
                    out.close();
                }
                catch (Throwable var8_74) {
                    var7_71.addSuppressed(var8_74);
                }
                break;
lbl267:
                // 1 sources

                out.close();
                break;
                catch (Throwable var8_75) {
                    try {
                        var7_71 = var8_75;
                        throw var8_75;
                    }
                    catch (Throwable var21_90) {
                        if (out != null) {
                            if (var7_71 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable var22_91) {
                                    var7_71.addSuppressed(var22_91);
                                }
                            } else {
                                out.close();
                            }
                        }
                        throw var21_90;
                    }
                }
            }
            case 32: {
                p = RelativeRoundtripTimeoutPolicyHelper.narrow((Object)policy);
                time = p.relative_expiry();
                timeout = TimeHelper.add(TimeHelper.utcNow(0L), time);
                value.ptype = 30;
                out = new OutputStream();
                var7_72 = null;
                out._OB_writeEndian();
                UtcTHelper.write((org.omg.CORBA.portable.OutputStream)out, (UtcT)timeout);
                value.pvalue = out.copyWrittenBytes();
                if (out == null) break;
                if (var7_72 == null) ** GOTO lbl303
                try {
                    out.close();
                }
                catch (Throwable var8_76) {
                    var7_72.addSuppressed(var8_76);
                }
                break;
lbl303:
                // 1 sources

                out.close();
                break;
                catch (Throwable var8_77) {
                    try {
                        var7_72 = var8_77;
                        throw var8_77;
                    }
                    catch (Throwable var23_92) {
                        if (out != null) {
                            if (var7_72 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable var24_93) {
                                    var7_72.addSuppressed(var24_93);
                                }
                            } else {
                                out.close();
                            }
                        }
                        throw var23_92;
                    }
                }
            }
            case 33: {
                p = RoutingPolicyHelper.narrow((Object)policy);
                range = p.routing_range();
                value.ptype = 33;
                out = new OutputStream();
                var5_45 = null;
                out._OB_writeEndian();
                RoutingTypeRangeHelper.write((org.omg.CORBA.portable.OutputStream)out, (RoutingTypeRange)range);
                value.pvalue = out.copyWrittenBytes();
                if (out == null) break;
                if (var5_45 == null) ** GOTO lbl338
                try {
                    out.close();
                }
                catch (Throwable var6_64) {
                    var5_45.addSuppressed(var6_64);
                }
                break;
lbl338:
                // 1 sources

                out.close();
                break;
                catch (Throwable var6_65) {
                    try {
                        var5_45 = var6_65;
                        throw var6_65;
                    }
                    catch (Throwable var25_94) {
                        if (out != null) {
                            if (var5_45 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable var26_95) {
                                    var5_45.addSuppressed(var26_95);
                                }
                            } else {
                                out.close();
                            }
                        }
                        throw var25_94;
                    }
                }
            }
            case 34: {
                p = MaxHopsPolicyHelper.narrow((Object)policy);
                hops = p.max_hops();
                value.ptype = 34;
                out = new OutputStream();
                var5_46 = null;
                out._OB_writeEndian();
                out.write_ushort(hops);
                value.pvalue = out.copyWrittenBytes();
                if (out == null) break;
                if (var5_46 == null) ** GOTO lbl373
                try {
                    out.close();
                }
                catch (Throwable var6_66) {
                    var5_46.addSuppressed(var6_66);
                }
                break;
lbl373:
                // 1 sources

                out.close();
                break;
                catch (Throwable var6_67) {
                    try {
                        var5_46 = var6_67;
                        throw var6_67;
                    }
                    catch (Throwable var27_96) {
                        if (out != null) {
                            if (var5_46 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable var28_97) {
                                    var5_46.addSuppressed(var28_97);
                                }
                            } else {
                                out.close();
                            }
                        }
                        throw var27_96;
                    }
                }
            }
            case 35: {
                p = QueueOrderPolicyHelper.narrow((Object)policy);
                order = p.allowed_orders();
                value.ptype = 35;
                out = new OutputStream();
                var5_47 = null;
                out._OB_writeEndian();
                OrderingHelper.write((org.omg.CORBA.portable.OutputStream)out, (short)order);
                value.pvalue = out.copyWrittenBytes();
                if (out == null) break;
                if (var5_47 == null) ** GOTO lbl408
                try {
                    out.close();
                }
                catch (Throwable var6_68) {
                    var5_47.addSuppressed(var6_68);
                }
                break;
lbl408:
                // 1 sources

                out.close();
                break;
                catch (Throwable var6_69) {
                    try {
                        var5_47 = var6_69;
                        throw var6_69;
                    }
                    catch (Throwable var29_98) {
                        if (out != null) {
                            if (var5_47 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable var30_99) {
                                    var5_47.addSuppressed(var30_99);
                                }
                            } else {
                                out.close();
                            }
                        }
                        throw var29_98;
                    }
                }
            }
            default: {
                throw new INV_POLICY();
            }
        }
        return value;
    }

    public static void getComponentPolicyValues(IORInfo info, PolicyValueSeqHolder policies) {
        PolicyValue[] newSeq;
        int len;
        PolicyValue value;
        Policy p2;
        try {
            p2 = info.get_effective_policy(25);
            value = MessageRoutingUtil.createMessagingPolicyValue(p2);
            len = policies.value.length;
            newSeq = new PolicyValue[len + 1];
            System.arraycopy(policies.value, 0, newSeq, 0, len);
            newSeq[len] = value;
            policies.value = newSeq;
        }
        catch (INV_POLICY p2) {
            // empty catch block
        }
        try {
            p2 = info.get_effective_policy(26);
            value = MessageRoutingUtil.createMessagingPolicyValue(p2);
            len = policies.value.length;
            newSeq = new PolicyValue[len + 1];
            System.arraycopy(policies.value, 0, newSeq, 0, len);
            newSeq[len] = value;
            policies.value = newSeq;
        }
        catch (INV_POLICY p3) {
            // empty catch block
        }
        try {
            p2 = info.get_effective_policy(34);
            value = MessageRoutingUtil.createMessagingPolicyValue(p2);
            len = policies.value.length;
            newSeq = new PolicyValue[len + 1];
            System.arraycopy(policies.value, 0, newSeq, 0, len);
            newSeq[len] = value;
            policies.value = newSeq;
        }
        catch (INV_POLICY p4) {
            // empty catch block
        }
        try {
            p2 = info.get_effective_policy(35);
            value = MessageRoutingUtil.createMessagingPolicyValue(p2);
            len = policies.value.length;
            newSeq = new PolicyValue[len + 1];
            System.arraycopy(policies.value, 0, newSeq, 0, len);
            newSeq[len] = value;
            policies.value = newSeq;
        }
        catch (INV_POLICY iNV_POLICY) {
            // empty catch block
        }
    }

    public static void getInvocationPolicyValues(RefCountPolicyList policyList, PolicyValueSeqHolder policies) {
        PolicyValue val;
        UtcT timeout;
        boolean rebind = false;
        boolean queueOrder = false;
        boolean useRelativeRequest = false;
        boolean useRelativeRoundtrip = false;
        if (policyList.relativeRequestTimeout != 0L) {
            useRelativeRequest = true;
            if (TimeHelper.notEqual(policyList.requestEndTime, TimeHelper.utcMin()) && TimeHelper.greaterThan(timeout = TimeHelper.utcMin(), policyList.requestEndTime)) {
                useRelativeRequest = false;
            }
        }
        if (policyList.relativeRoundTripTimeout != 0L) {
            useRelativeRoundtrip = true;
            if (TimeHelper.notEqual(policyList.replyEndTime, TimeHelper.utcMin()) && TimeHelper.greaterThan(timeout = TimeHelper.utcMin(), policyList.replyEndTime)) {
                useRelativeRequest = false;
            }
        }
        for (UtcT policy : policyList.value) {
            try {
                int type = policy.policy_type();
                if (type == 31 && !useRelativeRequest || type == 28 && useRelativeRequest || type == 32 && !useRelativeRoundtrip || type == 30 && useRelativeRoundtrip) continue;
                PolicyValue val2 = MessageRoutingUtil.createMessagingPolicyValue((Policy)policy);
                if (val2.ptype == 23) {
                    rebind = true;
                }
                if (val2.ptype == 35) {
                    queueOrder = true;
                }
                int oldLen = policies.value.length;
                policies.value = Arrays.copyOf(policies.value, oldLen + 1);
            }
            catch (INV_POLICY iNV_POLICY) {
                // empty catch block
            }
        }
        if (!rebind) {
            val = new PolicyValue();
            val.ptype = 23;
            try (OutputStream out = new OutputStream();){
                out._OB_writeEndian();
                RebindModeHelper.write((org.omg.CORBA.portable.OutputStream)out, (short)policyList.rebindMode);
                val.pvalue = out.copyWrittenBytes();
            }
            int len = policies.value.length;
            PolicyValue[] newSeq = new PolicyValue[len + 1];
            System.arraycopy(policies.value, 0, newSeq, 0, len);
            newSeq[len] = val;
            policies.value = newSeq;
        }
        if (!queueOrder) {
            val = new PolicyValue();
            val.ptype = 35;
            PolicyValue[] newSeq = null;
            try (OutputStream out = new OutputStream();){
                out._OB_writeEndian();
                OrderingHelper.write((org.omg.CORBA.portable.OutputStream)out, (short)policyList.queueOrder);
                val.pvalue = out.copyWrittenBytes();
            }
            catch (Throwable object) {
                newSeq = object;
                throw object;
            }
            int len = policies.value.length;
            newSeq = new PolicyValue[len + 1];
            System.arraycopy(policies.value, 0, newSeq, 0, len);
            newSeq[len] = val;
            policies.value = newSeq;
        }
    }

    public static Policy[] getPolicyListFromPolicyValues(PolicyValue[] policies) {
        ArrayList<Policy> list = new ArrayList<Policy>();
        for (PolicyValue policyValue : policies) {
            try {
                list.add(MessageRoutingUtil.getPolicyFromPolicyValue(policyValue));
            }
            catch (INV_POLICY iNV_POLICY) {
                // empty catch block
            }
        }
        return list.toArray(new Policy[0]);
    }

    private static Policy getPolicyFromPolicyValue(PolicyValue policyValue) {
        switch (policyValue.ptype) {
            case 23: {
                InputStream in = new InputStream(policyValue.pvalue);
                in._OB_readEndian();
                short mode = RebindModeHelper.read((org.omg.CORBA.portable.InputStream)in);
                return new RebindPolicy_impl(mode);
            }
            case 25: {
                InputStream in = new InputStream(policyValue.pvalue);
                in._OB_readEndian();
                PriorityRange range = PriorityRangeHelper.read((org.omg.CORBA.portable.InputStream)in);
                return new RequestPriorityPolicy_impl(range);
            }
            case 26: {
                InputStream in = new InputStream(policyValue.pvalue);
                in._OB_readEndian();
                PriorityRange range = PriorityRangeHelper.read((org.omg.CORBA.portable.InputStream)in);
                return new ReplyPriorityPolicy_impl(range);
            }
            case 27: {
                InputStream in = new InputStream(policyValue.pvalue);
                in._OB_readEndian();
                UtcT time = UtcTHelper.read((org.omg.CORBA.portable.InputStream)in);
                return new RequestStartTimePolicy_impl(time);
            }
            case 28: {
                InputStream in = new InputStream(policyValue.pvalue);
                in._OB_readEndian();
                UtcT time = UtcTHelper.read((org.omg.CORBA.portable.InputStream)in);
                return new RequestEndTimePolicy_impl(time);
            }
            case 29: {
                InputStream in = new InputStream(policyValue.pvalue);
                in._OB_readEndian();
                UtcT time = UtcTHelper.read((org.omg.CORBA.portable.InputStream)in);
                return new ReplyStartTimePolicy_impl(time);
            }
            case 30: {
                InputStream in = new InputStream(policyValue.pvalue);
                in._OB_readEndian();
                UtcT time = UtcTHelper.read((org.omg.CORBA.portable.InputStream)in);
                return new ReplyEndTimePolicy_impl(time);
            }
            case 33: {
                InputStream in = new InputStream(policyValue.pvalue);
                in._OB_readEndian();
                RoutingTypeRange range = RoutingTypeRangeHelper.read((org.omg.CORBA.portable.InputStream)in);
                return new RoutingPolicy_impl(range);
            }
            case 34: {
                InputStream in = new InputStream(policyValue.pvalue);
                in._OB_readEndian();
                short hops = in.read_ushort();
                return new MaxHopsPolicy_impl(hops);
            }
            case 35: {
                InputStream in = new InputStream(policyValue.pvalue);
                in._OB_readEndian();
                short order = OrderingHelper.read((org.omg.CORBA.portable.InputStream)in);
                return new QueueOrderPolicy_impl(order);
            }
        }
        throw new INV_POLICY();
    }
}

