/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.opentracing.rest.client.listener;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.opentracing.rest.client.listener.OpentracingRestClientFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import org.eclipse.microprofile.opentracing.Traced;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.spi.RestClientListener;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpentracingRestClientListener
implements RestClientListener {
    private static final TraceComponent tc = Tr.register(OpentracingRestClientListener.class, null, null);
    static final long serialVersionUID = -739936327710919101L;

    public void onNewClient(Class<?> serviceInterface, RestClientBuilder builder) {
        Traced traced = serviceInterface.getAnnotation(Traced.class);
        if (traced != null && !traced.value()) {
            Tr.debug((TraceComponent)tc, (String)"@Traced(false) specified on service interface", (Object[])new Object[0]);
            return;
        }
        builder.register(OpentracingRestClientFilter.class);
    }
}

