/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.util.concurrent;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.yoko.util.Reference;
import org.apache.yoko.util.Sequential;

class CountedEntry<K, V> {
    private static final int CLEANED = Integer.MIN_VALUE;
    private static final int NOT_READY = -1;
    private static final int IDLE = -2;
    private final AtomicInteger refCount = new AtomicInteger(-1);
    private final Sequential<CountedEntry<K, V>> idleEntries;
    private Sequential.Place<?> idlePlace;
    private V value;
    final K key;

    CountedEntry(K key, Sequential<CountedEntry<K, V>> idleEntries) {
        this.key = key;
        this.idleEntries = idleEntries;
    }

    ValueReference setValue(V value) {
        this.value = Objects.requireNonNull(value);
        this.notifyReady(1);
        return new ValueReference();
    }

    void abort() {
        assert (this.value == null);
        this.notifyReady(Integer.MIN_VALUE);
    }

    private synchronized void notifyReady(int newCount) {
        boolean success = this.refCount.compareAndSet(-1, newCount);
        assert (success);
        this.notifyAll();
    }

    private synchronized void blockWhileNotReady() {
        while (this.refCount.get() == -1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean acquire() {
        block5: while (true) {
            int oldCount = this.refCount.get();
            switch (oldCount) {
                case -2147483648: {
                    return false;
                }
                case -1: {
                    this.blockWhileNotReady();
                    continue block5;
                }
                case -2: {
                    if (!this.refCount.compareAndSet(-2, -1)) continue block5;
                    Object self = this.idlePlace.relinquish();
                    assert (this == self);
                    this.idlePlace = null;
                    this.notifyReady(1);
                    return true;
                }
            }
            if (this.refCount.compareAndSet(oldCount, oldCount + 1)) break;
        }
        return true;
    }

    private boolean release() {
        int newCount = this.refCount.decrementAndGet();
        if (newCount != 0) {
            return true;
        }
        if (!this.refCount.compareAndSet(0, -1)) {
            return true;
        }
        this.idlePlace = this.idleEntries.put(this);
        this.notifyReady(-2);
        return true;
    }

    V clear() {
        if (!this.refCount.compareAndSet(-2, Integer.MIN_VALUE)) {
            return null;
        }
        try {
            Object self = this.idlePlace.relinquish();
            assert (self == this);
            V v = this.value;
            return v;
        }
        finally {
            this.value = null;
            this.idlePlace = null;
        }
    }

    ValueReference obtain() {
        return this.acquire() ? new ValueReference() : null;
    }

    private CountedEntry<K, V> purge() {
        int oldCount;
        do {
            if ((oldCount = this.refCount.get()) == Integer.MIN_VALUE) {
                return null;
            }
            if (oldCount >= 1) continue;
            throw new IllegalStateException();
        } while (!this.refCount.compareAndSet(oldCount, Integer.MIN_VALUE));
        return this;
    }

    final class ReferenceCloserTask
    implements Runnable {
        boolean closed;

        ReferenceCloserTask() {
        }

        @Override
        public synchronized void run() {
            this.closed = this.closed || CountedEntry.this.release();
        }

        synchronized CountedEntry<K, V> purge() {
            if (this.closed) {
                throw new IllegalStateException();
            }
            this.closed = true;
            return CountedEntry.this.purge();
        }
    }

    final class ValueReference
    implements Reference<V> {
        private final ReferenceCloserTask closer;

        ValueReference() {
            this.closer = new ReferenceCloserTask();
        }

        @Override
        public V get() {
            return CountedEntry.this.value;
        }

        @Override
        public void close() {
            this.closer.run();
        }

        CountedEntry<K, V> invalidateAndGetEntry() {
            return this.closer.purge();
        }

        Runnable getCloserTask() {
            return this.closer;
        }
    }
}

