/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.dynamic;

import java.lang.reflect.Modifier;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.EclipseLinkClassWriter;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.internal.dynamic.DynamicPropertiesManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;

public class DynamicClassWriter
implements EclipseLinkClassWriter {
    protected static final String DYNAMIC_PROPERTIES_MANAGER_CLASSNAME_SLASHES = DynamicPropertiesManager.class.getName().replace('.', '/');
    protected static final String INIT = "<init>";
    protected static final String CLINIT = "<clinit>";
    protected Class<?> parentClass;
    protected String parentClassName;
    public static int[] ICONST = new int[]{3, 4, 5, 6, 7, 8};

    public DynamicClassWriter() {
        this(DynamicEntityImpl.class);
    }

    public DynamicClassWriter(Class<?> parentClass) {
        this.parentClass = parentClass;
    }

    public DynamicClassWriter(String parentClassName) {
        if (parentClassName == null || parentClassName.length() == 0) {
            throw DynamicException.illegalParentClassName(parentClassName);
        }
        this.parentClassName = parentClassName;
    }

    @Override
    public Class<?> getParentClass() {
        return this.parentClass;
    }

    @Override
    public String getParentClassName() {
        return this.parentClassName;
    }

    private Class<?> getParentClass(ClassLoader loader) throws ClassNotFoundException {
        if (this.parentClass == null && this.parentClassName != null) {
            this.parentClass = loader.loadClass(this.parentClassName);
        }
        return this.parentClass;
    }

    @Override
    public byte[] writeClass(DynamicClassLoader loader, String className) throws ClassNotFoundException {
        DynamicClassLoader.EnumInfo enumInfo = loader.enumInfoRegistry.get(className);
        if (enumInfo != null) {
            return this.createEnum(enumInfo);
        }
        Class<?> parent = this.getParentClass(loader);
        this.parentClassName = parent.getName();
        if (parent.isPrimitive() || parent.isArray() || parent.isEnum() || parent.isInterface() || Modifier.isFinal(parent.getModifiers())) {
            throw new IllegalArgumentException("Invalid parent class: " + parent);
        }
        String classNameAsSlashes = className.replace('.', '/');
        String parentClassNameAsSlashes = this.parentClassName.replace('.', '/');
        ClassWriter cw = new ClassWriter(2);
        cw.visit(52, 33, classNameAsSlashes, null, parentClassNameAsSlashes, null);
        cw.visitField(9, "DPM", "L" + DYNAMIC_PROPERTIES_MANAGER_CLASSNAME_SLASHES + ";", null, null);
        MethodVisitor mv = cw.visitMethod(8, CLINIT, "()V", null, null);
        mv.visitTypeInsn(187, DYNAMIC_PROPERTIES_MANAGER_CLASSNAME_SLASHES);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, DYNAMIC_PROPERTIES_MANAGER_CLASSNAME_SLASHES, INIT, "()V", false);
        mv.visitFieldInsn(179, classNameAsSlashes, "DPM", "L" + DYNAMIC_PROPERTIES_MANAGER_CLASSNAME_SLASHES + ";");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv = cw.visitMethod(1, INIT, "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, parentClassNameAsSlashes, INIT, "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv = cw.visitMethod(1, "fetchPropertiesManager", "()L" + DYNAMIC_PROPERTIES_MANAGER_CLASSNAME_SLASHES + ";", null, null);
        mv.visitFieldInsn(178, classNameAsSlashes, "DPM", "L" + DYNAMIC_PROPERTIES_MANAGER_CLASSNAME_SLASHES + ";");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        this.addFields(cw, parentClassNameAsSlashes);
        this.addMethods(cw, parentClassNameAsSlashes);
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected void addFields(ClassWriter cw, String parentClassType) {
    }

    protected void addMethods(ClassWriter cw, String parentClassType) {
    }

    protected byte[] createEnum(DynamicClassLoader.EnumInfo enumInfo) {
        String enumValue;
        String[] enumValues = enumInfo.getLiteralLabels();
        String className = enumInfo.getClassName();
        String internalClassName = className.replace('.', '/');
        ClassWriter cw = new ClassWriter(2);
        cw.visit(52, 16433, internalClassName, null, "java/lang/Enum", null);
        String[] stringArray = enumValues;
        int n = enumValues.length;
        int n2 = 0;
        while (n2 < n) {
            String enumValue2 = stringArray[n2];
            cw.visitField(16409, enumValue2, "L" + internalClassName + ";", null, null);
            ++n2;
        }
        cw.visitField(4122, "$VALUES", "[L" + internalClassName + ";", null, null);
        MethodVisitor mv = cw.visitMethod(9, "values", "()[L" + internalClassName + ";", null, null);
        mv.visitFieldInsn(178, internalClassName, "$VALUES", "[L" + internalClassName + ";");
        mv.visitMethodInsn(182, "[L" + internalClassName + ";", "clone", "()Ljava/lang/Object;", false);
        mv.visitTypeInsn(192, "[L" + internalClassName + ";");
        mv.visitInsn(176);
        mv.visitMaxs(1, 0);
        mv = cw.visitMethod(9, "valueOf", "(Ljava/lang/String;)L" + internalClassName + ";", null, null);
        mv.visitLdcInsn(Type.getType("L" + internalClassName + ";"));
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/Enum", "valueOf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;", false);
        mv.visitTypeInsn(192, internalClassName);
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv = cw.visitMethod(2, INIT, "(Ljava/lang/String;I)V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(183, "java/lang/Enum", INIT, "(Ljava/lang/String;I)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv = cw.visitMethod(8, CLINIT, "()V", null, null);
        int lastCount = 0;
        int i = 0;
        while (i < enumValues.length) {
            enumValue = enumValues[i];
            mv.visitTypeInsn(187, internalClassName);
            mv.visitInsn(89);
            mv.visitLdcInsn(enumValue);
            if (i <= 5) {
                mv.visitInsn(ICONST[i]);
            } else if (i <= 127) {
                mv.visitIntInsn(16, i);
            } else {
                mv.visitIntInsn(17, i);
            }
            mv.visitMethodInsn(183, internalClassName, INIT, "(Ljava/lang/String;I)V", false);
            mv.visitFieldInsn(179, internalClassName, enumValue, "L" + internalClassName + ";");
            lastCount = i++;
        }
        if (lastCount < 5) {
            mv.visitInsn(ICONST[lastCount + 1]);
        } else if (lastCount < 127) {
            mv.visitIntInsn(16, lastCount + 1);
        } else {
            mv.visitIntInsn(17, lastCount + 1);
        }
        mv.visitTypeInsn(189, internalClassName);
        i = 0;
        while (i < enumValues.length) {
            enumValue = enumValues[i];
            mv.visitInsn(89);
            if (i <= 5) {
                mv.visitInsn(ICONST[i]);
            } else if (i <= 127) {
                mv.visitIntInsn(16, i);
            } else {
                mv.visitIntInsn(17, i);
            }
            mv.visitFieldInsn(178, internalClassName, enumValue, "L" + internalClassName + ";");
            mv.visitInsn(83);
            ++i;
        }
        mv.visitFieldInsn(179, internalClassName, "$VALUES", "[L" + internalClassName + ";");
        mv.visitInsn(177);
        mv.visitMaxs(4, 0);
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected boolean verify(Class<?> dynamicClass, ClassLoader loader) throws ClassNotFoundException {
        Class<?> parent = this.getParentClass(loader);
        return dynamicClass != null && parent.isAssignableFrom(dynamicClass);
    }

    protected String[] getInterfaces() {
        return null;
    }

    protected DynamicClassWriter createCopy(Class<?> parentClass) {
        return new DynamicClassWriter(parentClass);
    }

    @Override
    public boolean isCompatible(EclipseLinkClassWriter writer) {
        if (writer == null) {
            return false;
        }
        if (this.getClass() != writer.getClass()) {
            return false;
        }
        if (this.getParentClass() == null) {
            return this.getParentClassName() != null && this.getParentClassName().equals(writer.getParentClassName());
        }
        return this.getParentClass() == writer.getParentClass();
    }

    public String toString() {
        String parentName = this.getParentClass() == null ? this.getParentClassName() : this.getParentClass().getName();
        return String.valueOf(Helper.getShortClassName(this.getClass())) + "(" + parentName + ")";
    }
}

