/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.webcontainer.osgi.interceptor.RequestInterceptor;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="com.ibm.ws.webcontainer.osgi.interceptor.RegisterRequestInterceptor", property={"service.vendor=IBM"})
public class RegisterRequestInterceptor {
    private static final TraceComponent tc = Tr.register(RegisterRequestInterceptor.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    protected static final String CLASS_NAME = "com.ibm.ws.webcontainer.osgi.interceptor.RegisterRequestInterceptor";
    private static final ConcurrentServiceReferenceSet<RequestInterceptor> _FileNotFoundInterceptors = new ConcurrentServiceReferenceSet("RequestInterceptor");
    private static final ConcurrentServiceReferenceSet<RequestInterceptor> _AfterFilterInterceptors = new ConcurrentServiceReferenceSet("RequestInterceptor");

    @Activate
    protected void activate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("RegisterRequestInterceptor activated. context:" + context), (Object[])new Object[0]);
        }
        _FileNotFoundInterceptors.activate(context);
        _AfterFilterInterceptors.activate(context);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"RegisterRequestInterceptor de-activated.", (Object[])new Object[0]);
        }
        _FileNotFoundInterceptors.deactivate(context);
        _AfterFilterInterceptors.deactivate(context);
    }

    @Reference(service=RequestInterceptor.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void setRequestInterceptor(ServiceReference<RequestInterceptor> reference) {
        String IPKey;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("RegisterRequestInterceptor.setRequestInterceptor(), reference : " + reference + ", InterceptPoints: " + (String)reference.getProperty("InterceptPoint")), (Object[])new Object[0]);
        }
        if ((IPKey = (String)reference.getProperty("InterceptPoint")) != null) {
            List<String> IPs = Arrays.asList(IPKey.split("\\s*, \\s*"));
            for (String IP : IPs) {
                if (IP.equals("AfterFilters")) {
                    _AfterFilterInterceptors.addReference(reference);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"RegisterRequestInterceptor.setRequestInterceptor(), register for after-filter intercept point.", (Object[])new Object[0]);
                    continue;
                }
                if (IP.equals("OnFileNotFound")) {
                    _FileNotFoundInterceptors.addReference(reference);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"RegisterRequestInterceptor.setRequestInterceptor(), register for on-filenotfound intercept point.", (Object[])new Object[0]);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("RegisterRequestInterceptor.setRequestInterceptor(), InterceptPoint not recognized : " + IP), (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"RegisterRequestInterceptor.setRequestInterceptor(), reference ignored because no InterecptPoints defined", (Object[])new Object[0]);
        }
    }

    protected void unsetRequestInterceptor(ServiceReference<RequestInterceptor> reference) {
        String IPKey;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("RegisterRequestInterceptor.unsetRequestInterceptor(), reference:" + reference + ", InterceptPoints: " + (String)reference.getProperty("InterceptPoint")), (Object[])new Object[0]);
        }
        if ((IPKey = (String)reference.getProperty("InterceptPoint")) != null) {
            List<String> IPs = Arrays.asList(IPKey.split("\\s*, \\s*"));
            for (String IP : IPs) {
                if (IP.equals("AfterFilters")) {
                    _AfterFilterInterceptors.removeReference(reference);
                    continue;
                }
                if (IP.equals("OnFileNotFound")) {
                    _FileNotFoundInterceptors.removeReference(reference);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("RegisterRequestInterceptor.unsetRequestInterceptor(), InterceptPoint not recognized : " + IP), (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"RegisterRequestInterceptor.unsetRequestInterceptor(), reference ignored because no InterecptPoints defined", (Object[])new Object[0]);
        }
    }

    public static boolean notifyRequestInterceptors(String interceptPoint, HttpServletRequest req, HttpServletResponse resp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("RegisterRequestInterceptor.notifyRequestInterceptors() : InterceptPoint = " + interceptPoint), (Object[])new Object[0]);
        }
        boolean result = false;
        if (interceptPoint.equals("AfterFilters")) {
            if (!_AfterFilterInterceptors.isEmpty()) {
                Iterator afps = _AfterFilterInterceptors.getServices();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("RegisterRequestInterceptor.notifyRequestInterceptors() afps.hasNext() : " + afps.hasNext()), (Object[])new Object[0]);
                }
                ArrayList<RequestInterceptor> reverseAfps = new ArrayList<RequestInterceptor>();
                while (afps.hasNext()) {
                    reverseAfps.add(0, (RequestInterceptor)afps.next());
                }
                afps = reverseAfps.iterator();
                while (afps.hasNext() && !result) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"RegisterRequestInterceptor.notifyRequestInterceptors() notify after filter interceptor.", (Object[])new Object[0]);
                    }
                    result = ((RequestInterceptor)afps.next()).handleRequest(req, resp);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"RegisterRequestInterceptor.notifyRequestInterceptors() no after filter interceptors.", (Object[])new Object[0]);
            }
        } else if (interceptPoint.equals("OnFileNotFound")) {
            if (!_FileNotFoundInterceptors.isEmpty()) {
                Iterator fnfps = _FileNotFoundInterceptors.getServices();
                while (fnfps.hasNext() && !result) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"RegisterRequestInterceptor.notifyRequestInterceptors() notify file not found interceptor.", (Object[])new Object[0]);
                    }
                    result = ((RequestInterceptor)fnfps.next()).handleRequest(req, resp);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"RegisterRequestInterceptor.notifyRequestInterceptors() no on-FNF interceptors.", (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"RegisterRequestInterceptor.notifyRequestInterceptors() invalid intercept point.", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("RegisterRequestInterceptor.notifyRequestInterceptors() : " + result));
        }
        return result;
    }
}

