/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.impl.DB2Helper;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;

public class DB2iToolboxHelper
extends DB2Helper {
    private static TraceComponent tc = Tr.register(DB2iToolboxHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private final AtomicReference<Class<?>> com_ibm_as400_access_AS400JDBCConnectionHandle_class = new AtomicReference();
    private final AtomicReference<Method> getServerJobIdentifier = new AtomicReference();
    boolean isolationLevelSwitchingSupport = false;

    DB2iToolboxHelper(WSManagedConnectionFactoryImpl mcf) throws Exception {
        super(mcf);
        this.localZOS = false;
        this.isRRSTransaction = false;
        this.threadIdentitySupport = 0;
        this.threadSecurity = false;
        Properties props = mcf.dsConfig.get().vendorProps;
        Object switchingSupported = props.get("isolationLevelSwitchingSupport");
        if (switchingSupported != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("isolationSwitchingSupported property = " + switchingSupported), (Object[])new Object[0]);
            }
            this.isolationLevelSwitchingSupport = switchingSupported instanceof Boolean ? (Boolean)switchingSupported : Boolean.valueOf((String)switchingSupported);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"isolationSwitchingSupported property not set for this datasource", (Object[])new Object[0]);
        }
        Collections.addAll(this.staleSQLStates, "HY017");
    }

    @Override
    public boolean doConnectionCleanup(Connection conn) throws SQLException {
        block8: {
            SQLWarning warn;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup", (Object[])new Object[0]);
            }
            if ((warn = conn.getWarnings()) == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup(): no warnings to cleanup", (Object[])new Object[0]);
                }
            } else {
                try {
                    conn.clearWarnings();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup(): cleanup of warnings done", (Object[])new Object[0]);
                    }
                }
                catch (SQLException se) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup(): cleanup of warnings failed", (Object[])new Object[]{se});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup");
        }
        return false;
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        stmt.setCursorName(null);
        stmt.setFetchDirection(1000);
        stmt.setMaxFieldSize(0);
        stmt.setMaxRows(0);
        Integer queryTimeout = this.mcf.dsConfig.get().queryTimeout;
        if (queryTimeout == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
    }

    @Override
    public String getCorrelator(final WSRdbManagedConnectionImpl mc) throws SQLException {
        block10: {
            try {
                Class c = this.com_ibm_as400_access_AS400JDBCConnectionHandle_class.get();
                if (c == null) {
                    if (System.getSecurityManager() == null) {
                        c = mc.mcf.jdbcDriverLoader.loadClass("com.ibm.as400.access.AS400JDBCConnectionHandle");
                        this.com_ibm_as400_access_AS400JDBCConnectionHandle_class.set(c);
                    } else {
                        c = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                            @Override
                            public Class<?> run() throws ClassNotFoundException {
                                return mc.mcf.jdbcDriverLoader.loadClass("com.ibm.as400.access.AS400JDBCConnectionHandle");
                            }
                        });
                        this.com_ibm_as400_access_AS400JDBCConnectionHandle_class.set(c);
                    }
                }
                if (c.isInstance(mc.sqlConn)) {
                    Method m = this.getServerJobIdentifier.get();
                    if (m == null) {
                        m = c.getMethod("getServerJobIdentifier", new Class[0]);
                        this.getServerJobIdentifier.set(m);
                    }
                    return (String)m.invoke((Object)mc.sqlConn, new Object[0]);
                }
            }
            catch (NullPointerException npx) {
                Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object[])new Object[]{"getServerJobIdentifier()", npx, "method not supported on DB2 driver being used"});
            }
            catch (NoSuchMethodError nsex) {
                Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object[])new Object[]{"getServerJobIdentifier()", nsex, "method not supported on DB2 driver being used"});
            }
            catch (IllegalAccessError illegalaccesserror) {
                Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object[])new Object[]{"getServerJobIdentifier()", illegalaccesserror, ": AS400JDBCConnectionHandle is not a public class in the version of the Toolbox driver being used."});
            }
            catch (Exception e) {
                Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object[])new Object[]{"getServerJobIdentifier()", e, "method may not be supported on DB2 driver being used"});
                if (!(e.getCause() instanceof SQLException)) break block10;
                AdapterUtil.mapSQLException((SQLException)e.getCause(), mc);
            }
        }
        return null;
    }

    @Override
    public boolean isIsolationLevelSwitchingSupport() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("isolationSwitchingSupported has a value of " + this.isolationLevelSwitchingSupport), (Object[])new Object[0]);
        }
        return this.isolationLevelSwitchingSupport;
    }
}

