/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.opentracing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.microprofile.opentracing.jaeger.JaegerTracerFactory;
import com.ibm.ws.opentracing.OpentracingContext;
import com.ibm.ws.opentracing.OpentracingUserFeatureAccessService;
import com.ibm.ws.opentracing.OpentracingUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.opentracing.Tracer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpentracingTracerManager {
    private static final TraceComponent tc = Tr.register(OpentracingTracerManager.class, (String)"OPENTRACING", (String)"com.ibm.ws.opentracing.resources.Opentracing");
    private static final Map<String, Tracer> applicationTracers = new ConcurrentHashMap<String, Tracer>();
    private static final ThreadLocal<OpentracingContext> OPEN_TRACING_CONTEXT_VAR = new OpentracingThreadLocal();
    static final long serialVersionUID = -7635173546494166862L;

    @Trivial
    @ManualTrace
    private static Tracer ensureTracer(String appName) {
        String methodName = "ensureTracer";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{appName});
        }
        Tracer tracer = applicationTracers.get(appName);
        boolean found = true;
        if (tracer == null) {
            found = false;
            tracer = applicationTracers.computeIfAbsent(appName, TracerCreator.INSTANCE);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String tracerCase = found ? "previously created" : "newly created or previously created if lost race condition";
            Tr.exit((TraceComponent)tc, (String)(methodName + " (" + tracerCase + ")"), (Object)OpentracingUtils.getTracerText(tracer));
        }
        return tracer;
    }

    private static Tracer createJaegerTracer(String appName) {
        return JaegerTracerFactory.createJaegerTracer((String)appName);
    }

    @Trivial
    private static Tracer createTracer(String appName) {
        return OpentracingUserFeatureAccessService.getTracerInstance(appName);
    }

    @Trivial
    @ManualTrace
    public static Tracer getTracer() {
        String tracerCase;
        String methodName = "getTracer";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        OpentracingContext tracerContext = OpentracingTracerManager.getOpentracingContext();
        String appName = tracerContext.getAppName();
        Tracer tracer = tracerContext.getTracer();
        if (tracer != null) {
            tracerCase = "previously stored for " + appName;
        } else {
            appName = OpentracingUtils.lookupAppName();
            tracer = OpentracingTracerManager.ensureTracer(appName);
            tracerContext.setTracer(appName, tracer);
            tracerCase = "newly stored for " + appName;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Thread currentThread = Thread.currentThread();
            String threadName = currentThread.getName();
            long threadId = currentThread.getId();
            Tr.exit((TraceComponent)tc, (String)(methodName + " (" + tracerCase + ") in (" + threadName + ":" + Long.toString(threadId) + ")"), (Object)OpentracingUtils.getTracerText(tracer));
        }
        return tracer;
    }

    @Trivial
    private static OpentracingContext getOpentracingContext() {
        return OPEN_TRACING_CONTEXT_VAR.get();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class OpentracingThreadLocal
    extends InheritableThreadLocal<OpentracingContext> {
        static final long serialVersionUID = -7741692698163985022L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private OpentracingThreadLocal() {
        }

        @Override
        protected OpentracingContext initialValue() {
            return new OpentracingContext();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.opentracing.OpentracingTracerManager$OpentracingThreadLocal", OpentracingThreadLocal.class, (String)"OPENTRACING", (String)"com.ibm.ws.opentracing.resources.Opentracing");
        }
    }

    @Trivial
    private static class TracerCreator
    implements Function<String, Tracer> {
        static TracerCreator INSTANCE = new TracerCreator();

        private TracerCreator() {
        }

        @Override
        public Tracer apply(String appName) {
            Tracer tracer = OpentracingTracerManager.createJaegerTracer(appName);
            if (tracer == null) {
                tracer = OpentracingTracerManager.createTracer(appName);
            }
            return tracer;
        }
    }
}

