/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.message;

import com.ibm.ws.jain.protocol.ip.sip.message.MessageImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.StatusLine;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.ProxyAuthenticateHeader;
import jain.protocol.ip.sip.header.ServerHeader;
import jain.protocol.ip.sip.message.Response;
import java.util.List;

public class ResponseImpl
extends MessageImpl
implements Response {
    private static final long serialVersionUID = 7369918283364553763L;
    StatusLine m_statusLine = new StatusLine();

    @Override
    public void removeViaHeader() {
        this.removeHeader("Via", true);
    }

    @Override
    public HeaderIterator getAllowHeaders() {
        return this.getHeaders("Allow");
    }

    @Override
    public boolean hasAllowHeaders() {
        return this.hasHeaders("Allow");
    }

    @Override
    public void setAllowHeaders(List allowHeaders) throws IllegalArgumentException {
        this.setHeaders("Allow", allowHeaders);
    }

    @Override
    public void removeAllowHeaders() {
        this.removeHeaders("Allow");
    }

    @Override
    public ProxyAuthenticateHeader getProxyAuthenticateHeader() {
        try {
            return (ProxyAuthenticateHeader)this.getHeader("Proxy-Authenticate", true);
        }
        catch (HeaderParseException e2) {
            return null;
        }
    }

    @Override
    public boolean hasProxyAuthenticateHeader() {
        return this.hasHeaders("Proxy-Authenticate");
    }

    @Override
    public void removeProxyAuthenticateHeader() {
        this.removeHeaders("Proxy-Authenticate");
    }

    @Override
    public void setProxyAuthenticateHeader(ProxyAuthenticateHeader proxyAuthenticateHeader) throws IllegalArgumentException {
        this.setHeader(proxyAuthenticateHeader, true);
    }

    @Override
    public HeaderIterator getWWWAuthenticateHeaders() {
        return this.getHeaders("WWW-Authenticate");
    }

    @Override
    public boolean hasWWWAuthenticateHeaders() {
        return this.hasHeaders("WWW-Authenticate");
    }

    @Override
    public void removeWWWAuthenticateHeaders() {
        this.removeHeaders("WWW-Authenticate");
    }

    @Override
    public void setWWWAuthenticateHeaders(List wwwAuthenticateHeaders) throws IllegalArgumentException {
        this.setHeaders("WWW-Authenticate", wwwAuthenticateHeaders);
    }

    @Override
    public ServerHeader getServerHeader() throws HeaderParseException {
        return (ServerHeader)this.getHeader("Server", true);
    }

    @Override
    public boolean hasServerHeader() {
        return this.hasHeaders("Server");
    }

    @Override
    public void removeServerHeader() {
        this.removeHeaders("Server");
    }

    @Override
    public void setServerHeader(ServerHeader serverHeader) throws IllegalArgumentException {
        this.setHeader(serverHeader, true);
    }

    @Override
    public HeaderIterator getUnsupportedHeaders() {
        return this.getHeaders("Unsupported");
    }

    @Override
    public boolean hasUnsupportedHeaders() {
        return this.hasHeaders("Unsupported");
    }

    @Override
    public void removeUnsupportedHeaders() {
        this.removeHeaders("Unsupported");
    }

    @Override
    public void setUnsupportedHeaders(List unsupportedHeaders) throws IllegalArgumentException {
        this.setHeaders("Unsupported", unsupportedHeaders);
    }

    @Override
    public HeaderIterator getWarningHeaders() {
        return this.getHeaders("Warning");
    }

    @Override
    public boolean hasWarningHeaders() {
        return this.hasHeaders("Warning");
    }

    @Override
    public void removeWarningHeaders() {
        this.removeHeaders("Warning");
    }

    @Override
    public void setWarningHeaders(List warningHeaders) throws IllegalArgumentException {
        this.setHeaders("Warning", warningHeaders);
    }

    @Override
    public int getStatusCode() throws SipParseException {
        return this.m_statusLine.getStatusCode();
    }

    @Override
    public void setStatusCode(int statusCode) throws SipParseException {
        if (statusCode < 100 || statusCode > 999) {
            throw new SipParseException("Response: Status code out of range", "");
        }
        this.m_statusLine.setStatusCode(statusCode);
    }

    @Override
    public String getReasonPhrase() throws SipParseException {
        return this.m_statusLine.getReasonPhrase();
    }

    @Override
    public void setReasonPhrase(String reasonPhrase) throws IllegalArgumentException, SipParseException {
        if (reasonPhrase == null) {
            throw new IllegalArgumentException("Response: null Reason phrase");
        }
        if (reasonPhrase.length() == 0) {
            throw new IllegalArgumentException("Response: Empty Reason phrase");
        }
        this.m_statusLine.setReasonPhrase(reasonPhrase);
    }

    @Override
    public void setVersion(int versionMajor, int versionMinor) throws SipParseException {
        super.setVersion(versionMajor, versionMinor);
        this.m_statusLine.setSipVersion(this.getVersion());
    }

    @Override
    public boolean isRequest() {
        return false;
    }

    @Override
    public String getStartLine() {
        return this.m_statusLine.toString();
    }

    @Override
    public void writeStartLineToBuffer(CharsBuffer buffer, boolean network) {
        this.m_statusLine.writeToCharBuffer(buffer);
    }

    public void setStatusLine(StatusLine statusLine) {
        this.m_statusLine = statusLine;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

