/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.container.DumpActivator;
import com.ibm.wsspi.logging.Introspector;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={Introspector.class}, configurationPid={"com.ibm.ws.sip.introspector"})
public class SipContainerIntrospector
implements Introspector {
    private static final TraceComponent tc = Tr.register(SipContainerIntrospector.class);
    private final String SUCCINCT_DUMP_METHOD = "SUCCINCT";
    private final String VERBOSE_DUMP_METHOD = "VERBOSE";
    private String _dumpMethodType;

    @Activate
    public void activate(ComponentContext ctx, Map<String, Object> properties) {
        Object value = properties.get("method");
        if (value != null) {
            this._dumpMethodType = value.toString();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("activate SIP introspect for " + value), (Object[])new Object[0]);
        }
    }

    public void introspect(PrintWriter out) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"IntrospectableService invoked in sip container", (Object[])new Object[0]);
        }
        if (this._dumpMethodType == null || this._dumpMethodType.isEmpty()) {
            out.println("There is no configuration for dumping. Please define a dumping mode in the server.xml");
            return;
        }
        out.println(this._dumpMethodType);
        DumpActivator dumpActivator = new DumpActivator();
        StringBuilder strToPrint = new StringBuilder();
        if (this._dumpMethodType.equals("SUCCINCT")) {
            dumpActivator.startDumpingListOfSessions(DumpActivator.DUMP_SAS_IDs, strToPrint);
            dumpActivator.startDumpingListOfSessions(DumpActivator.DUMP_TU_IDs, strToPrint);
        } else if (this._dumpMethodType.equals("VERBOSE")) {
            dumpActivator.startDumpingListOfSessions(DumpActivator.DUMP_SAS_DETAILs, strToPrint);
            dumpActivator.startDumpingListOfSessions(DumpActivator.DUMP_TU_DETAILs, strToPrint);
        }
        out.println(strToPrint);
        out.println("--- End of Dump ---");
    }

    public String getIntrospectorName() {
        return "SipContainerIntrospector";
    }

    public String getIntrospectorDescription() {
        return "SIP state details";
    }
}

