/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.asynch;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.sip.AsynchronousWork;
import com.ibm.websphere.sip.AsynchronousWorkListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jain.protocol.ip.sip.message.SipResponseCodes;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.appqueue.MessageDispatcher;
import com.ibm.ws.sip.container.appqueue.NativeMessageDispatchingHandler;
import com.ibm.ws.sip.container.asynch.AsynchronousWorkListenerWrapper;
import com.ibm.ws.sip.container.asynch.AsynchronousWorkTaskListener;
import com.ibm.ws.sip.container.asynch.AsynchronousWorkTasksManager;
import com.ibm.ws.sip.container.events.ContextEstablisher;
import com.ibm.ws.sip.container.failover.repository.SessionRepository;
import com.ibm.ws.sip.container.osgi.AsynchronousWorkDispatcher;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.router.tasks.RoutedTask;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletsFactoryImpl;
import com.ibm.ws.sip.container.was.ThreadLocalStorage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.NoSuchElementException;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;

public class AsynchronousWorkTask
extends RoutedTask
implements AsynchronousWorkDispatcher {
    private AsynchronousWork _appAsynchWorkObject;
    private AsynchronousWorkListener _appAsynchWorkListener;
    public static final String ENCODED_APP_SESSION_ID = "ibmappid";
    public static final String SIP_METHOD = "ASYNWORK";
    public static final String CONTENT_TYPE = "asynchwork/type";
    private static final LogMgr c_logger = Log.get(AsynchronousWorkTask.class);
    private String _appSessionID;
    private AsynchronousWorkListenerWrapper _listenerWrapper = null;
    private Object _lockObj = new Object();
    private boolean _isResponseRecived = false;
    private boolean _isWaitForResponse = false;
    private Object _result = null;
    private ClassLoader _cl;

    public AsynchronousWorkTask(String appSessionId) {
        this._appSessionID = appSessionId;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "AsynchronousWorkTask", "Creating async work task for sip application id: " + this._appSessionID);
        }
        try {
            this._index = SipApplicationSessionImpl.extractAppSessionCounter(this._appSessionID);
        }
        catch (NoSuchElementException e2) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "AsynchronousWorkTask", "AppSessionId is not valid, appSessionId: " + this._appSessionID);
            }
            throw new IllegalArgumentException("AppSessionId is not valid, appSessionId: " + this._appSessionID);
        }
        this._cl = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public int getQueueIndex() {
        if (this._index < 0) {
            throw new RuntimeException("Dispatching error, transaction-user not found!");
        }
        return this._index;
    }

    @Override
    public int priority() {
        return 50;
    }

    public String toString() {
        return "AsynchronousWorkTask user task for application ID: " + this._appSessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object waitForResponse(long time) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "waitForResponse", (Object)time);
        }
        Object object = this._lockObj;
        synchronized (object) {
            if (!this._isResponseRecived) {
                block10: {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "waitForResponse", "going to wait for respone, applicationid=" + this._appSessionID);
                    }
                    this._isWaitForResponse = true;
                    try {
                        this._lockObj.wait(time);
                    }
                    catch (InterruptedException e2) {
                        if (!c_logger.isTraceDebugEnabled()) break block10;
                        c_logger.traceDebug(this, "waitForResponse", "Async work was interrupted, applicationid=" + this._appSessionID);
                    }
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "waitForResponse", "respone was received thread is notified, applicationid=" + this._appSessionID);
                }
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "waitForResponse");
        }
        return this._result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitThread() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "notifyWaitThread");
        }
        Object object = this._lockObj;
        synchronized (object) {
            this._isResponseRecived = true;
            if (this._isWaitForResponse) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "notifyWaitThread", "respone was received going to notify waiting thread, applicationid=" + this._appSessionID);
                }
                this._isWaitForResponse = false;
                this._lockObj.notify();
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "notifyWaitThread");
        }
    }

    @Override
    public void dispatch(AsynchronousWork obj, AsynchronousWorkListener listener) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "dispatch", obj, listener);
        }
        this._appAsynchWorkObject = obj;
        this._appAsynchWorkListener = listener;
        Integer currentQueueId = ThreadLocalStorage.getQueueId();
        SipApplicationSessionImpl sipAppSession = SipApplicationSessionImpl.getAppSession(this._appSessionID);
        if (sipAppSession == null) {
            int reason;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("dispatch: sipAppSession is null, sending Async work remotely");
            }
            if (currentQueueId != null && !(this._appAsynchWorkListener instanceof AsynchronousWorkTaskListener)) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "dispatch", "This is a custom async listener, Wrapping the async listener for dispaching");
                }
                this._listenerWrapper = new AsynchronousWorkListenerWrapper(this._appAsynchWorkListener, currentQueueId);
            }
            if ((reason = this.sendAsynchronousWorkRequest()) != 200) {
                this.sendFailedResponse(reason);
            }
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "dispatch", "Async work will be dispached to local server, SAS was found localy, applicationid=" + this._appSessionID);
            }
            if (currentQueueId != null) {
                int asyncQueueId;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "dispatch", "Current thread is running from Sip container queue, queueid=" + currentQueueId);
                }
                if ((asyncQueueId = this.getQueueIndex() % NativeMessageDispatchingHandler.s_dispatchers) == currentQueueId) {
                    this.setForDispatching(false);
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "dispatch", "Async work will run on current thread, asyncQueueId=" + asyncQueueId);
                    }
                } else {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "dispatch", "Async work will be dispached to a different SIP queue than the current thread queue, asyncQueueId=" + asyncQueueId);
                    }
                    if (!(this._appAsynchWorkListener instanceof AsynchronousWorkTaskListener)) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "dispatch", "This is a custom async listener, Wrapping the async listener for dispaching");
                        }
                        this._listenerWrapper = new AsynchronousWorkListenerWrapper(this._appAsynchWorkListener, currentQueueId);
                    }
                }
            }
            MessageDispatcher.dispatchRoutedTask(this);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "dispatch");
        }
    }

    public void sendCompletedResponse(Serializable result) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "sendCompletedResponse", (Object)result);
        }
        this._result = result;
        this.notifyWaitThread();
        if (this._appAsynchWorkListener != null) {
            if (this._listenerWrapper != null) {
                this._listenerWrapper.setResult(result);
                this._listenerWrapper.setMode(1);
                MessageDispatcher.dispatchRoutedTask(this._listenerWrapper);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "dispatch", "Async Listener was dispached to the correct queue=" + this._listenerWrapper.getQueueIndex());
                }
            } else {
                this._appAsynchWorkListener.onCompleted(result);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "sendCompletedResponse");
        }
    }

    public void sendFailedResponse(int reason) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "sendFailedResponse", (Object)reason);
        }
        this._result = reason;
        this.notifyWaitThread();
        if (this._appAsynchWorkListener != null) {
            if (this._listenerWrapper != null) {
                this._listenerWrapper.setReason(reason);
                this._listenerWrapper.setMode(2);
                MessageDispatcher.dispatchRoutedTask(this._listenerWrapper);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "dispatch", "Async Listener was dispached to the correct queue=" + this._listenerWrapper.getQueueIndex());
                }
            } else {
                this._appAsynchWorkListener.onFailed(reason, SipResponseCodes.getResponseCodeText(reason));
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "sendFailedResponse");
        }
    }

    @Override
    public SipApplicationSession getSipApplicationSession() {
        return SessionRepository.getInstance().getAppSession(this._appSessionID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTask() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "doTask", new Object[0]);
        }
        try {
            SipApplicationSession appsession = this.getSipApplicationSession();
            ContextEstablisher contextEstablisher = null;
            ClassLoader currentThreadClassLoader = null;
            Serializable result = null;
            try {
                if (appsession != null) {
                    SipAppDesc sipAD;
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("doTask switching context for async task before invoking. appsession=" + appsession);
                    }
                    if ((contextEstablisher = (sipAD = SipContainer.getInstance().getRouter().getSipApp(appsession.getApplicationName())).getContextEstablisher()) != null) {
                        currentThreadClassLoader = contextEstablisher.getThreadCurrentClassLoader();
                        contextEstablisher.establishContext();
                    } else if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("doTask couldn't switch context for async task before invoking. contextEstablisher is null. appsession=" + appsession);
                    }
                    result = this._appAsynchWorkObject.doAsyncTask();
                } else {
                    this.sendFailedResponse(481);
                }
            }
            finally {
                if (contextEstablisher != null) {
                    contextEstablisher.removeContext(currentThreadClassLoader);
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("doTask switching context back. appsession=" + appsession);
                }
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("doAsyncTask: returned: " + result);
            }
            if (result == null) {
                this.sendCompletedResponse((Serializable)((Object)""));
            } else {
                this.sendCompletedResponse(result);
            }
        }
        catch (Throwable e2) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("Application async task threw exception: " + e2.getMessage() + " ,applicationId: " + this._appSessionID);
            }
            FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sip.container.asynch.AsynchronousWorkTask", (String)"1", (Object)this);
            this.sendFailedResponse(400);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "doTask");
        }
    }

    @Override
    public String getMethod() {
        return "Asynch Work Task method";
    }

    private int sendAsynchronousWorkRequest() {
        String host = null;
        int port = -1;
        if (host == null) {
            if (c_logger.isErrorEnabled()) {
                c_logger.error("error.asynchwork.host.unknown", "Connect.INUSE", null);
            }
            return 500;
        }
        AsynchronousWorkTasksManager manager = AsynchronousWorkTasksManager.instance();
        SipApplicationSessionImpl appSession = manager.getAsynchSipApp();
        try {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("sendAsynchronousWorkRequest: Sending Async work to remote server");
            }
            SipServletRequestImpl request = (SipServletRequestImpl)SipServletsFactoryImpl.getInstance().createRequest((SipApplicationSession)appSession, SIP_METHOD, "sip:server1@ibm.com", "sip:server2@ibm.com");
            request.setContent(this.dataToByteArray(this._appAsynchWorkObject), CONTENT_TYPE);
            SipURI requestURI = SipServletsFactoryImpl.getInstance().createSipURI("task", host);
            requestURI.setPort(port);
            requestURI.setTransportParam("udp");
            this.encodeURI(requestURI, this._appSessionID);
            request.setRequestURI(requestURI);
            manager.putAsynchronousWorkTask(request.getCallId(), this);
            request.send();
        }
        catch (ServletParseException e2) {
            if (c_logger.isErrorEnabled()) {
                c_logger.error("error.exception.spe", "Request", null, (Throwable)((Object)e2));
            }
            return 500;
        }
        catch (UnsupportedEncodingException e3) {
            if (c_logger.isErrorEnabled()) {
                c_logger.error("error.exception.uee", "Request", null, (Throwable)e3);
            }
            return 500;
        }
        catch (IllegalArgumentException e4) {
            if (c_logger.isErrorEnabled()) {
                c_logger.error("error.exception.iae", "Request", null, (Throwable)e4);
            }
            return 500;
        }
        catch (IOException e5) {
            if (c_logger.isErrorEnabled()) {
                c_logger.error("error.exception.io", "Request", null, (Throwable)e5);
            }
            return 500;
        }
        return 200;
    }

    private void encodeURI(URI uri, String sessionId) {
        if (!uri.isSipURI()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "encodeURI", "Can not encode URI, Not a SIP URI " + uri);
            }
            throw new IllegalArgumentException("Not a SIP a URI, Can not encode session information");
        }
        ((SipURI)uri).setParameter(ENCODED_APP_SESSION_ID, sessionId);
    }

    private byte[] dataToByteArray(Object obj) throws IOException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "dataToByteArray", new Object[]{obj});
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(obj);
        byte[] bits = bout.toByteArray();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "dataToByteArray", (Object)bits);
        }
        return bits;
    }

    public ClassLoader getCl() {
        return this._cl;
    }

    @Override
    public Object getServiceSynchronizer() {
        SipApplicationSessionImpl sipAppSession = (SipApplicationSessionImpl)this.getSipApplicationSession();
        return sipAppSession.getServiceSynchronizer();
    }

    @Override
    public SipApplicationSession getApplicationSession() {
        return this.getSipApplicationSession();
    }
}

