/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.container.proxy.SipProxyInfo;
import com.ibm.ws.sip.container.proxy.StatefullProxy;
import com.ibm.ws.sip.container.router.SipRouter;
import com.ibm.ws.sip.container.servlets.AddressImpl;
import com.ibm.ws.sip.container.servlets.IncomingSipServletRequest;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.servlets.SipSessionImplementation;
import com.ibm.ws.sip.container.transaction.ServerTransaction;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.util.SipUtil;
import jain.protocol.ip.sip.SipException;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.TransactionDoesNotExistException;
import jain.protocol.ip.sip.address.NameAddress;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.header.ContactHeader;
import jain.protocol.ip.sip.header.Header;
import jain.protocol.ip.sip.message.Message;
import jain.protocol.ip.sip.message.Response;
import java.io.IOException;
import javax.servlet.sip.Address;
import javax.servlet.sip.Rel100Exception;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.UAMode;

public class OutgoingSipServletResponse
extends SipServletResponseImpl {
    private static final long serialVersionUID = -5804127531338290805L;
    private static final LogMgr c_logger = Log.get(OutgoingSipServletResponse.class);
    private transient boolean m_sendingReliably = false;
    private boolean m_isProxyResponse = false;
    private boolean m_isOfVirtualProxyBranch = false;

    public OutgoingSipServletResponse() {
    }

    public OutgoingSipServletResponse(Response response, SipServletRequestImpl request) {
        super(response, request.getTransactionId(), request.getSipProvider());
        this.setRequest(request);
        this.setTransaction(request.getTransaction());
        this.setIsCommited(false);
    }

    @Override
    Address getLocalParty() {
        return this.getFrom();
    }

    @Override
    Address getRemoteParty() {
        return this.getTo();
    }

    @Override
    public synchronized void send() throws IOException {
        if (!this.isLiveMessage("send")) {
            return;
        }
        if (this.isCommitted()) {
            if (this.isJSR289Application()) {
                throw new IllegalStateException("Can not modify committed message");
            }
            String err = "Can not Send, Operation not allowed on a committed Response";
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "send", err);
            }
            throw new IOException(err);
        }
        if (!this.m_isProxyResponse && this.getStatus() > 100 && this.getStatus() < 200 && this.shouldBeSentReliably()) {
            throw new IllegalStateException("This response should be sent reliably" + this);
        }
        this.continueToSend();
    }

    private void sendOnOriginalRatherOnDerivedTCK_SIP_SERVLET_1_1() {
        TransactionUserWrapper transactionUser = this.getTransactionUser();
        if (transactionUser != null && transactionUser.isDerived()) {
            SipServletRequestImpl req = (SipServletRequestImpl)this.getRequest();
            SipSessionImplementation session = (SipSessionImplementation)this.getRequest().getSession(false);
            if (req.getLinkedRequest() == null && session != null && session.getLinkedSession() == null && transactionUser.isB2B()) {
                TransactionUserWrapper derivedTransactionUser = transactionUser;
                transactionUser = transactionUser.getOrigTUWrapper();
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "continueToSend1", "override transactionUser");
                }
                this.setTransactionUser(transactionUser);
                session = (SipSessionImplementation)this.getRequest().getSession();
                session.setTransactionUser(transactionUser);
                transactionUser.overridePendingMessagesByDerived(derivedTransactionUser);
            }
        }
    }

    private synchronized void continueToSend() throws IOException {
        this.resetContentLength();
        Response response = this.getResponse();
        boolean continueSending = true;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "continueToSend1", this.getCallId() + " ,status = " + this.getStatus());
        }
        this.sendOnOriginalRatherOnDerivedTCK_SIP_SERVLET_1_1();
        TransactionUserWrapper transactionUser = this.getTransactionUser();
        if (transactionUser != null && !transactionUser.isProxying() && !this.m_isProxyResponse) {
            transactionUser.setUASMode();
            this.updateToTag(response);
        }
        try {
            SipServletRequest request = this.getRequest();
            boolean addContact = false;
            addContact = SipUtil.shouldAddContact(this.getStatus());
            if (addContact && SipUtil.isDialogInitialRequest(this.getMethod()) && transactionUser != null && !transactionUser.isProxying()) {
                if (this.getContactHeader() == null) {
                    boolean created = this.createAndSetMultihomeContactHeader();
                    if (!created) {
                        this.createAndSetContactHeader(this.getMessage(), null, true);
                    }
                } else if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "addContactHeader", "Can't addContactHeader, contact exist");
                }
            }
        }
        catch (IllegalArgumentException e2) {
            e2.printStackTrace();
        }
        catch (SipParseException e3) {
            e3.printStackTrace();
        }
        if (this.isSendingReliably()) {
            transactionUser.onSendingReliableProvisionalResponse(this);
        } else if (transactionUser.wasAnsweredReliable() && this.getStatus() >= 200 && "INVITE".equals(this.getMethod())) {
            transactionUser.onSendingFinalResponseAfterProvisional(this);
        }
        boolean isProxy = transactionUser.isProxying();
        StatefullProxy proxy = (StatefullProxy)this.getProxy();
        if (proxy != null) {
            transactionUser.setIsProxying(isProxy);
        }
        if (!this.m_isProxyResponse && null != proxy && null != transactionUser && isProxy && !this.isOfVirtualProxyBranch()) {
            TransactionUserWrapper tu;
            block27: {
                this.markAsOfVirtualProxyBranch();
                tu = transactionUser.createDerivedTU(this.getResponse(), " OutgoingSipServletResponse - VirutalBranch causes to Derived Session");
                this.setTransactionUser(tu);
                try {
                    this.createAndSetContactHeader(response, null, true);
                }
                catch (SipParseException e4) {
                    if (!c_logger.isTraceDebugEnabled()) break block27;
                    c_logger.traceDebug(this, "continueToSend", "Exception while adding contact header: " + e4.getLocalizedMessage());
                }
            }
            this.updateToTag(this.getResponse());
            tu.setIsVirtualBranch(response);
            tu.setIsRRProxying(proxy.getRecordRoute());
            continueSending = proxy.processApplicationRespone(this);
            if (continueSending && this.getTransaction().isTerminated()) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "continueToSend", "The original server transaction is closed, This response will be sent directly over the SipStack.");
                }
                this.setShouldBeSentWithoutST(true);
            }
        }
        if (continueSending) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "continueToSend2", this.getCallId() + " ,status = " + this.getStatus());
            }
            if (this.shouldBeSentWithoutST()) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "continueToSend", "This response will be sent directly over the SipStack.");
                }
                this.getTransactionUser().onSendingResponse(this);
                PerformanceMgr perfMgr = PerformanceMgr.getInstance();
                if (perfMgr != null) {
                    perfMgr.responseSent(((SipServletRequestImpl)this.getRequest()).getArrivedTime());
                }
                SipRouter.sendResponseDirectlyToTransport(this.getSipProvider(), this.getResponse(), false);
            } else {
                TransactionUserWrapper listener;
                ServerTransaction serverTransaction = (ServerTransaction)this.getTransaction();
                if (isProxy && (listener = (TransactionUserWrapper)serverTransaction.getServerTransactionLisener()) != null && listener != this.getTransactionUser()) {
                    serverTransaction.setTransactionListener(this.getTransactionUser());
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "continueToSend", "The response server transaction listener is changed to: " + this.getTransactionUser());
                    }
                }
                serverTransaction.sendResponse(this);
            }
            this.setIsCommited(true);
        }
    }

    private boolean createAndSetMultihomeContactHeader() throws IllegalArgumentException, SipParseException {
        boolean created = false;
        SipServletRequest request = this.getRequest();
        String transport = request.getTransport();
        if (SipProxyInfo.getInstance().getNumberOfInterfaces(transport) > 1) {
            SipURI receivedOnInterfaceURI;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "addContactHeader", "Multi-home response detected. Pulling contact header from received on interface");
            }
            if ((receivedOnInterfaceURI = SipProxyInfo.getInstance().extractReceivedOnInterface(request)) != null) {
                String host = receivedOnInterfaceURI.getHost();
                int port = receivedOnInterfaceURI.getPort();
                SipURL sipUrl = this.getAddressFactory().createSipURL(host);
                sipUrl.setPort(port);
                sipUrl.setTransport(transport);
                this.setContactScheme(sipUrl);
                NameAddress address = this.getAddressFactory().createNameAddress(sipUrl);
                ContactHeader contactHeader = this.getHeadersFactory().createContactHeader(address);
                Message res = this.getMessage();
                res.setHeader(contactHeader, true);
                created = true;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "addContactHeader", "Response contact: " + contactHeader.toString());
                }
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "addContactHeader", "Failed to find receivedOnInterfaceURI");
            }
        }
        return created;
    }

    @Override
    protected void setContactScheme(SipURL sipUrl) throws IllegalArgumentException, SipParseException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        if (sipUrl.getScheme().equalsIgnoreCase("sip")) {
            boolean secure;
            block8: {
                secure = false;
                SipServletRequest request = this.getRequest();
                if (request.getRequestURI() != null && request.getRequestURI().getScheme().equalsIgnoreCase("sips")) {
                    secure = true;
                } else {
                    try {
                        String scheme;
                        Address topRoute = request.getAddressHeader("Route");
                        if (topRoute != null && (scheme = topRoute.getURI().getScheme()).equalsIgnoreCase("sips")) {
                            secure = true;
                        }
                    }
                    catch (ServletParseException e2) {
                        if (!c_logger.isErrorEnabled()) break block8;
                        c_logger.error("error.send.response", "Request", this, (Throwable)((Object)e2));
                    }
                }
            }
            if (secure) {
                sipUrl.setScheme("sips");
            }
        }
    }

    private boolean shouldBeSentReliably() {
        IncomingSipServletRequest req = (IncomingSipServletRequest)this.getRequest();
        return req.getShouldBeAnsweredReliable();
    }

    private void updateToTag(Response response) throws IOException {
        if (!this.isLiveMessage("updateToTag")) {
            return;
        }
        String toTag = response.getToHeader().getTag();
        if (null == toTag || toTag.length() == 0) {
            TransactionUserWrapper transactionUser = this.getTransactionUser();
            AddressImpl toAddr = (AddressImpl)transactionUser.getLocalParty();
            if (null != toAddr) {
                toTag = toAddr.getTag();
            }
            if (null == toTag || toTag.length() == 0) {
                toTag = transactionUser.generateLocalTag();
            }
            try {
                response.getToHeader().setTag(toTag);
            }
            catch (IllegalArgumentException e2) {
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{this};
                    c_logger.error("error.send.response", "Request", args, (Throwable)e2);
                }
                throw new IOException(e2.getMessage());
            }
            catch (SipParseException e3) {
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{this};
                    c_logger.error("error.send.response", "Request", args, (Throwable)e3);
                }
                throw new IOException(e3.getMessage());
            }
        }
    }

    public void sendImpl() throws IOException {
        if (!this.isLiveMessage("sendImpl")) {
            return;
        }
        try {
            PerformanceMgr perfMgr = PerformanceMgr.getInstance();
            if (perfMgr != null) {
                perfMgr.responseSent(((SipServletRequestImpl)this.getRequest()).getArrivedTime());
            }
            this.getSipProvider().sendResponse(this.getTransactionId(), this.getResponse());
        }
        catch (TransactionDoesNotExistException e2) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("error sending response. no transaction for ID [" + this.getTransactionId() + "] top via [" + this.getTopVia() + "] code [" + this.getStatus() + ']');
            }
            this.logExceptionToSessionLog(0x100005, e2);
        }
        catch (SipException e3) {
            if (c_logger.isErrorEnabled()) {
                Object[] args = new Object[]{this};
                c_logger.error("error.send.response", "Request", args, (Throwable)e3);
            }
            this.logExceptionToSessionLog(0x100005, e3);
            throw new IOException(e3.getMessage());
        }
    }

    @Override
    public void sendReliably() throws Rel100Exception {
        if (!this.isLiveMessage("sendReliably")) {
            return;
        }
        if (this.isCommitted()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        if (this.getStatus() <= 100 || this.getStatus() >= 200) {
            String err = "Can not Send, Operation not allowed on not provisional Response";
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "send", err);
            }
            throw new Rel100Exception(0);
        }
        if (!this.canBeSentReliably()) {
            throw new Rel100Exception(2);
        }
        this.markAsSentReliably();
        TransactionUserWrapper transactionUser = this.getTransactionUser();
        long rSeq = transactionUser.getNextRSegNumber();
        try {
            Header header = this.getHeadersFactory().createHeader("RSeq", Long.toString(rSeq));
            this.getResponse().setHeader(header, false);
            header = this.getHeadersFactory().createHeader("Require", "100rel");
            this.getResponse().addHeader(header, false);
            this.continueToSend();
        }
        catch (IllegalArgumentException e2) {
            e2.printStackTrace();
            throw new IllegalStateException(e2.getMessage() + this);
        }
        catch (SipParseException e3) {
            throw new IllegalStateException(e3.getMessage() + this);
        }
        catch (IOException e4) {
            throw new IllegalStateException(e4.getMessage() + this);
        }
    }

    @Override
    public SipServletRequest createAck() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "createAck", "Create Ack Operation not allowed on an outgoing response");
        }
        throw new IllegalStateException("Can not create ACK for a locally generated request");
    }

    @Override
    public SipServletRequest createPrack() throws Rel100Exception {
        String method = this.getMethod();
        if (method == null || !method.equals("INVITE")) {
            throw new Rel100Exception(1);
        }
        if (!this.isReliableResponse()) {
            throw new Rel100Exception(4);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "createPrack", "Create Prack Operation not allowed on an outgoing response");
        }
        throw new IllegalStateException("Can not create PRACK for a locally generated response");
    }

    public boolean isNon2xxResponse() {
        Response response = this.getResponse();
        boolean rc = false;
        int status = 0;
        try {
            status = response.getStatusCode();
        }
        catch (SipParseException e2) {
            this.logException(e2);
        }
        if (status < 200 || status >= 300) {
            rc = true;
        }
        return rc;
    }

    public void markAsProxyResponse() {
        if (!this.isLiveMessage("MarkAsPeoxyResponse")) {
            return;
        }
        this.m_isProxyResponse = true;
    }

    public void markAsSentReliably() {
        this.m_sendingReliably = true;
    }

    public boolean isSendingReliably() {
        return this.m_sendingReliably;
    }

    public void markAsOfVirtualProxyBranch() {
        this.m_isOfVirtualProxyBranch = true;
    }

    public boolean isOfVirtualProxyBranch() {
        return this.m_isOfVirtualProxyBranch;
    }

    @Override
    public SipSession getProxySession(boolean create) {
        return this.getTransactionUser().getSipSession(create);
    }

    @Override
    protected void updateUnCommittedMessagesList(boolean isCommited) {
        if (this.m_isProxyResponse) {
            return;
        }
        TransactionUserWrapper transactionUser = this.getTransactionUser();
        if (isCommited) {
            transactionUser.removeB2BPendingMsg(this, UAMode.UAS);
        } else {
            transactionUser.addB2BPendingMsg(this, UAMode.UAS);
        }
    }

    @Override
    protected boolean shouldCreateContactIfNotExist() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "shouldCreateContactIfNotExist", "m_isProxyResponse=" + this.m_isProxyResponse + ", m_isOfVirtualProxyBranch=" + this.m_isOfVirtualProxyBranch);
        }
        if (this.m_isOfVirtualProxyBranch) {
            return true;
        }
        return !this.m_isProxyResponse;
    }
}

