/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.failover.repository.SessionRepository;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipServletsFactoryImpl;
import com.ibm.ws.sip.container.servlets.SipSessionImplementation;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipSessionsUtil;

public class SipSessionsUtilImpl
implements SipSessionsUtil {
    private static final LogMgr c_logger = Log.get(SipSessionsUtilImpl.class);
    private String m_appName = null;

    public SipSessionsUtilImpl() {
    }

    public SipSessionsUtilImpl(String appName) {
        this.m_appName = appName;
        SipAppDesc m_sipApp = null;
        if (appName != null) {
            m_sipApp = SipContainer.getInstance().getSipApp(appName);
        } else {
            this.m_appName = "Unknown application";
        }
        if (m_sipApp == null && c_logger.isErrorEnabled()) {
            c_logger.error("Error retirieving application descriptor for application name: " + appName);
        }
    }

    @Override
    public SipApplicationSession getApplicationSessionById(String applicationSessionId) {
        return SipApplicationSessionImpl.getAppSession(applicationSessionId);
    }

    @Override
    public SipApplicationSession getApplicationSessionByKey(String applicationSessionKey, boolean create) throws NullPointerException {
        return ((SipServletsFactoryImpl)SipServletsFactoryImpl.getInstance(this.m_appName)).createApplicationSessionByKey(applicationSessionKey, create);
    }

    @Override
    public SipSession getCorrespondingSipSession(SipSession session, String headerName) {
        if (session == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getCorrespondingSipSession", "session is null");
            }
            return null;
        }
        TransactionUserWrapper tuWrapper = ((SipSessionImplementation)session).getTransactionUser();
        String correspondingSessionHeader = tuWrapper.getRelatedSipSessionHeader();
        String correspondingSessionId = tuWrapper.getRelatedSipSessionId();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getCorrespondingSipSession", "correspondingSessionId=" + correspondingSessionId + " correspondingSessionHeader=" + correspondingSessionHeader);
        }
        if (correspondingSessionHeader != null && correspondingSessionHeader.equals(headerName)) {
            return SessionRepository.getInstance().getSipSession(correspondingSessionId);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getCorrespondingSipSession", "headerName=" + headerName + ", The related session was not set using this header");
        }
        return null;
    }
}

