/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.parser.util;

import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class DateParser {
    private static Calendar m_calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));

    public static synchronized Date parse(String iso8601Date) throws UnsupportedEncodingException {
        Calendar calendar = DateParser.getCalendar(iso8601Date);
        return calendar.getTime();
    }

    public static synchronized String getIsoDate(Date date) {
        m_calendar.setTime(date);
        StringBuffer buffer = new StringBuffer(16);
        buffer.append(m_calendar.get(1));
        buffer.append("-");
        buffer.append(DateParser.twoDigit(m_calendar.get(2) + 1));
        buffer.append("-");
        buffer.append(DateParser.twoDigit(m_calendar.get(5)));
        buffer.append("T");
        buffer.append(DateParser.twoDigit(m_calendar.get(11)));
        buffer.append(":");
        buffer.append(DateParser.twoDigit(m_calendar.get(12)));
        buffer.append(":");
        buffer.append(DateParser.twoDigit(m_calendar.get(13)));
        buffer.append(".");
        buffer.append(DateParser.twoDigit(m_calendar.get(14) / 10));
        buffer.append("Z");
        return buffer.toString();
    }

    private static Calendar getCalendar(String isoDate) throws UnsupportedEncodingException {
        StringTokenizer st = new StringTokenizer(isoDate, "-T:.+Z", true);
        m_calendar.clear();
        try {
            if (!st.hasMoreTokens()) {
                return m_calendar;
            }
            int year = Integer.parseInt(st.nextToken());
            m_calendar.set(1, year);
            if (!DateParser.check(st, "-") || !st.hasMoreTokens()) {
                return m_calendar;
            }
            int month = Integer.parseInt(st.nextToken()) - 1;
            m_calendar.set(2, month);
            if (!DateParser.check(st, "-") || !st.hasMoreTokens()) {
                return m_calendar;
            }
            int day = Integer.parseInt(st.nextToken());
            m_calendar.set(5, day);
            if (!DateParser.check(st, "T") || !st.hasMoreTokens()) {
                m_calendar.set(11, 0);
                m_calendar.set(12, 0);
                m_calendar.set(13, 0);
                m_calendar.set(14, 0);
                return m_calendar;
            }
            int hour = Integer.parseInt(st.nextToken());
            m_calendar.set(11, hour);
            if (!DateParser.check(st, ":") || !st.hasMoreTokens()) {
                m_calendar.set(12, 0);
                m_calendar.set(13, 0);
                m_calendar.set(14, 0);
                return m_calendar;
            }
            int minutes = Integer.parseInt(st.nextToken());
            m_calendar.set(12, minutes);
            if (!st.hasMoreTokens()) {
                return m_calendar;
            }
            String tok = st.nextToken();
            if (tok.equals(":")) {
                if (!st.hasMoreTokens()) {
                    throw new UnsupportedEncodingException("No seconds specified");
                }
                int seconds = Integer.parseInt(st.nextToken());
                m_calendar.set(13, seconds);
                if (!st.hasMoreTokens()) {
                    return m_calendar;
                }
                tok = st.nextToken();
                if (tok.equals(".")) {
                    String nt = st.nextToken();
                    while (nt.length() < 3) {
                        nt = nt + "0";
                    }
                    nt = nt.substring(0, 3);
                    int millisec = Integer.parseInt(nt);
                    m_calendar.set(14, millisec);
                    if (!st.hasMoreTokens()) {
                        return m_calendar;
                    }
                    tok = st.nextToken();
                } else {
                    m_calendar.set(14, 0);
                }
            } else {
                m_calendar.set(13, 0);
                m_calendar.set(14, 0);
            }
            if (!tok.equals("Z")) {
                if (!tok.equals("+") && !tok.equals("-")) {
                    throw new UnsupportedEncodingException("only Z, + or - allowed");
                }
                boolean plus = tok.equals("+");
                if (!st.hasMoreTokens()) {
                    throw new UnsupportedEncodingException("Missing hour field");
                }
                int tzhour = Integer.parseInt(st.nextToken());
                int tzmin = 0;
                if (!DateParser.check(st, ":") || !st.hasMoreTokens()) {
                    throw new UnsupportedEncodingException("Missing minute field");
                }
                tzmin = Integer.parseInt(st.nextToken());
                if (plus) {
                    m_calendar.add(10, tzhour);
                    m_calendar.add(12, tzmin);
                } else {
                    m_calendar.add(10, -tzhour);
                    m_calendar.add(12, -tzmin);
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new UnsupportedEncodingException("[" + ex.getMessage() + "] is not an integer");
        }
        return m_calendar;
    }

    private static boolean check(StringTokenizer st, String token) throws UnsupportedEncodingException {
        try {
            if (st.nextToken().equals(token)) {
                return true;
            }
            throw new UnsupportedEncodingException("Missing [" + token + "]");
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }

    private static String twoDigit(int i) {
        if (i >= 0 && i < 10) {
            return "0" + String.valueOf(i);
        }
        return String.valueOf(i);
    }
}

