/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.util.NoSuchElementException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class CDIUtils {
    private static boolean cdiAvailable;
    static final long serialVersionUID = 4487248316261760256L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private CDIUtils() {
    }

    @FFDCIgnore(value={Throwable.class})
    static <T> T getInstanceFromCDI(Class<T> clazz) {
        Object bean;
        if (cdiAvailable) {
            try {
                bean = CDIUtils.findBean(clazz);
            }
            catch (Throwable t) {
                if (!(t instanceof NoSuchElementException)) {
                    cdiAvailable = false;
                }
                bean = null;
            }
        } else {
            bean = null;
        }
        return bean;
    }

    private static <T> T findBean(Class<T> clazz) {
        BeanManager beanManager = CDI.current().getBeanManager();
        Bean bean = (Bean)beanManager.getBeans(clazz, new Annotation[0]).iterator().next();
        CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
        Object instance = beanManager.getReference(bean, clazz, ctx);
        return (T)instance;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.microprofile.client.cdi.CDIUtils", CDIUtils.class, null, null);
        cdiAvailable = true;
    }
}

