/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.asset.UninstallAsset;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class FeatureDependencyChecker {
    public boolean toBeUninstalled(String name, List<UninstallAsset> list) {
        for (UninstallAsset asset : list) {
            String featureName = InstallUtils.getShortName(asset.getProvisioningFeatureDefinition());
            if (!asset.getName().equals(name) && (featureName == null || !featureName.equals(name))) continue;
            InstallLogUtils.getInstallLogger().log(Level.FINEST, "The dependent feature is specified to be uninstalled : " + featureName);
            return true;
        }
        return false;
    }

    public boolean toBeUninstalled(Collection<ProvisioningFeatureDefinition> features, List<UninstallAsset> list) {
        for (ProvisioningFeatureDefinition feature : features) {
            if (this.toBeUninstalled(feature.getSymbolicName(), list)) continue;
            return false;
        }
        return true;
    }

    public Collection<ProvisioningFeatureDefinition> getNotToBeUninstall(Collection<ProvisioningFeatureDefinition> features, List<UninstallAsset> list) {
        ArrayList<ProvisioningFeatureDefinition> notToBeUninstalled = new ArrayList<ProvisioningFeatureDefinition>();
        for (ProvisioningFeatureDefinition p : features) {
            if (this.toBeUninstalled(p.getSymbolicName(), list)) continue;
            notToBeUninstalled.add(p);
        }
        return notToBeUninstalled;
    }

    public Collection<ProvisioningFeatureDefinition> isUninstallable(UninstallAsset uninstallAsset, Collection<ProvisioningFeatureDefinition> installedFeatureDefinitions, Collection<String> uninstallInstallFeatures, boolean isChecking) {
        Collection<ProvisioningFeatureDefinition> requiredByTheseFeatures = FeatureDependencyChecker.requiresThisFeature(uninstallAsset.getProvisioningFeatureDefinition().getSymbolicName(), installedFeatureDefinitions, uninstallInstallFeatures, isChecking);
        ArrayList<ProvisioningFeatureDefinition> temp = new ArrayList<ProvisioningFeatureDefinition>();
        while (requiredByTheseFeatures.size() > temp.size()) {
            temp.addAll(requiredByTheseFeatures);
            for (ProvisioningFeatureDefinition p : temp) {
                InstallLogUtils.getInstallLogger().log(Level.FINEST, "The uninstalling feature : " + uninstallAsset.getProvisioningFeatureDefinition().getSymbolicName() + " is required by " + p.getSymbolicName());
                InstallLogUtils.getInstallLogger().log(Level.FINEST, "Determine additional dependency for feature : " + p.getSymbolicName());
                Collection<ProvisioningFeatureDefinition> required = FeatureDependencyChecker.requiresThisFeature(p.getSymbolicName(), installedFeatureDefinitions, uninstallInstallFeatures, isChecking);
                if (required.isEmpty()) continue;
                for (ProvisioningFeatureDefinition pp : required) {
                    if (requiredByTheseFeatures.contains(pp)) continue;
                    InstallLogUtils.getInstallLogger().log(Level.FINEST, "Found additional dependent feature : " + pp.getSymbolicName());
                    requiredByTheseFeatures.add(pp);
                }
            }
        }
        return requiredByTheseFeatures;
    }

    public List<UninstallAsset> determineOrder(List<UninstallAsset> list) {
        HashMap<String, Integer> visited = new HashMap<String, Integer>();
        HashMap<String, UninstallAsset> assetsMap = new HashMap<String, UninstallAsset>();
        for (UninstallAsset ua : list) {
            assetsMap.put(ua.getProvisioningFeatureDefinition().getSymbolicName(), ua);
        }
        AtomicInteger order = new AtomicInteger(list.size());
        for (UninstallAsset ua : list) {
            if (visited.containsKey(ua.getProvisioningFeatureDefinition().getSymbolicName())) continue;
            this.DFS(ua, visited, assetsMap, order);
        }
        Collections.sort(list, new FeatureDependencyComparator(visited));
        return list;
    }

    private void DFS(UninstallAsset asset, Map<String, Integer> visited, Map<String, UninstallAsset> assetsMap, AtomicInteger order) {
        visited.put(asset.getProvisioningFeatureDefinition().getSymbolicName(), -1);
        for (FeatureResource fr : asset.getProvisioningFeatureDefinition().getConstituents(null)) {
            UninstallAsset ua = assetsMap.get(fr.getSymbolicName());
            if (ua == null || visited.containsKey(ua.getProvisioningFeatureDefinition().getSymbolicName())) continue;
            this.DFS(ua, visited, assetsMap, order);
        }
        visited.put(asset.getProvisioningFeatureDefinition().getSymbolicName(), order.get());
        order.decrementAndGet();
    }

    private static Collection<ProvisioningFeatureDefinition> requiresThisFeature(String symbolicName, Collection<ProvisioningFeatureDefinition> installedFeatureDefinitions, Collection<String> uninstallingInstallFeatures, boolean isChecking) {
        Collection<ProvisioningFeatureDefinition> requiredByThese = FeatureDependencyChecker.requiresThisFeatureByVisibility(symbolicName, installedFeatureDefinitions, null);
        ArrayList<ProvisioningFeatureDefinition> includePublicOnly = new ArrayList<ProvisioningFeatureDefinition>();
        for (ProvisioningFeatureDefinition requiredByThis : requiredByThese) {
            if (requiredByThis.getVisibility() == null || !requiredByThis.getVisibility().equals((Object)Visibility.PUBLIC) && !requiredByThis.getVisibility().equals((Object)Visibility.INSTALL)) {
                Collection<ProvisioningFeatureDefinition> requiredByThesePublic = FeatureDependencyChecker.requiresThisFeatureByVisibility(requiredByThis.getSymbolicName(), installedFeatureDefinitions, Visibility.PUBLIC);
                if (requiredByThesePublic.isEmpty()) {
                    InstallLogUtils.getInstallLogger().log(Level.FINEST, "Cannot locate the public feature which requires this feature : " + requiredByThis.getSymbolicName());
                    continue;
                }
                includePublicOnly.addAll(requiredByThesePublic);
                continue;
            }
            if (isChecking && requiredByThis.getVisibility() != null && requiredByThis.getVisibility().equals((Object)Visibility.INSTALL)) {
                InstallLogUtils.getInstallLogger().log(Level.FINEST, "Ignore feature with install visibility during prereq checking : " + requiredByThis.getSymbolicName());
                continue;
            }
            if (!isChecking && requiredByThis.getVisibility() != null && requiredByThis.getVisibility().equals((Object)Visibility.INSTALL) && uninstallingInstallFeatures != null && (uninstallingInstallFeatures.isEmpty() || uninstallingInstallFeatures.contains(requiredByThis.getSymbolicName()))) {
                InstallLogUtils.getInstallLogger().log(Level.FINEST, "Ignore feature with install visibility : " + requiredByThis.getSymbolicName());
                continue;
            }
            includePublicOnly.add(requiredByThis);
        }
        return includePublicOnly;
    }

    private static Collection<ProvisioningFeatureDefinition> requiresThisFeatureByVisibility(String symbolicName, Collection<ProvisioningFeatureDefinition> installedFeatureDefinitions, Visibility visibility) {
        ArrayList<ProvisioningFeatureDefinition> requiredByThese = new ArrayList<ProvisioningFeatureDefinition>();
        for (ProvisioningFeatureDefinition fd : installedFeatureDefinitions) {
            if (visibility != null && (fd.getVisibility() == null || !fd.getVisibility().equals((Object)visibility)) && (fd.getVisibility() == null || !fd.getVisibility().equals((Object)Visibility.INSTALL)) || fd.getSymbolicName() == symbolicName) continue;
            for (FeatureResource fr : fd.getConstituents(null)) {
                SubsystemContentType type = fr.getType();
                if (SubsystemContentType.FEATURE_TYPE != type || !symbolicName.equals(fr.getSymbolicName())) continue;
                requiredByThese.add(fd);
            }
        }
        return requiredByThese;
    }

    static class FeatureDependencyComparator
    implements Comparator<UninstallAsset>,
    Serializable {
        private Map<String, Integer> orderMap;

        public FeatureDependencyComparator() {
        }

        public FeatureDependencyComparator(Map<String, Integer> orderMap) {
            this.orderMap = orderMap;
        }

        @Override
        public int compare(UninstallAsset feature1, UninstallAsset feature2) {
            int feature2Order;
            int feature1Order = this.orderMap.get(feature1.getProvisioningFeatureDefinition().getSymbolicName());
            if (feature1Order < (feature2Order = this.orderMap.get(feature2.getProvisioningFeatureDefinition().getSymbolicName()).intValue())) {
                return -1;
            }
            if (feature1Order == feature2Order) {
                return 0;
            }
            return 1;
        }
    }
}

