/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.artifact.proxy.SkipProcessListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.SkipReadListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.SkipWriteListenerProxy;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.execution.impl.RuntimeStepExecution;
import com.ibm.jbatch.container.impl.ExceptionMatcher;
import com.ibm.jbatch.jsl.model.Chunk;
import com.ibm.jbatch.jsl.model.ExceptionClassFilter;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class SkipHandler {
    private static final String className = SkipHandler.class.getName();
    private static Logger logger = Logger.getLogger(SkipHandler.class.getPackage().getName());
    public static final String SKIP_COUNT = "skip-limit";
    public static final String SKIP_INCLUDE_EX = "include class";
    public static final String SKIP_EXCLUDE_EX = "exclude class";
    private List<SkipProcessListenerProxy> _skipProcessListener;
    private List<SkipReadListenerProxy> _skipReadListener;
    private List<SkipWriteListenerProxy> _skipWriteListener;
    private ExceptionMatcher excMatcher;
    private String _stepId;
    private Set<String> _skipIncludeExceptions;
    private Set<String> _skipExcludeExceptions;
    private int _skipLimit;
    private long _skipCount;
    static final long serialVersionUID = -7874479561945523910L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SkipHandler(Chunk chunk, RuntimeStepExecution runtimeStepExecution) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.SkipHandler", "<init>", new Object[]{chunk, runtimeStepExecution});
        }
        this._skipProcessListener = null;
        this._skipReadListener = null;
        this._skipWriteListener = null;
        this.excMatcher = null;
        this._stepId = null;
        this._skipIncludeExceptions = null;
        this._skipExcludeExceptions = null;
        this._skipLimit = Integer.MIN_VALUE;
        this._skipCount = 0L;
        this._stepId = runtimeStepExecution.getStepName();
        this.initialize(chunk);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.SkipHandler", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addSkipReadListener(List<SkipReadListenerProxy> skipReadListener) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.SkipHandler", "addSkipReadListener", new Object[]{skipReadListener});
        }
        this._skipReadListener = skipReadListener;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.SkipHandler", "addSkipReadListener");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addSkipWriteListener(List<SkipWriteListenerProxy> skipWriteListener) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.SkipHandler", "addSkipWriteListener", new Object[]{skipWriteListener});
        }
        this._skipWriteListener = skipWriteListener;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.SkipHandler", "addSkipWriteListener");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addSkipProcessListener(List<SkipProcessListenerProxy> skipProcessListener) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.SkipHandler", "addSkipProcessListener", new Object[]{skipProcessListener});
        }
        this._skipProcessListener = skipProcessListener;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.SkipHandler", "addSkipProcessListener");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void initialize(Chunk chunk) {
        String mName = "initialize";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "initialize");
        }
        try {
            if (chunk.getSkipLimit() != null) {
                this._skipLimit = Integer.parseInt(chunk.getSkipLimit());
                if (this._skipLimit < 0) {
                    throw new IllegalArgumentException("The skip-limit attribute on a chunk cannot be a negative value");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            void nfe;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.jbatch.container.impl.SkipHandler", (String)"117", (Object)this, (Object[])new Object[]{chunk});
            throw new RuntimeException("NumberFormatException reading skip-limit", (Throwable)nfe);
        }
        this._skipIncludeExceptions = new HashSet<String>();
        this._skipExcludeExceptions = new HashSet<String>();
        if (chunk.getSkippableExceptionClasses() != null && chunk.getSkippableExceptionClasses().getIncludeList() != null) {
            List<ExceptionClassFilter.Include> includes = chunk.getSkippableExceptionClasses().getIncludeList();
            for (ExceptionClassFilter.Include include : includes) {
                this._skipIncludeExceptions.add(include.getClazz().trim());
                logger.finer("SKIPHANDLE: include: " + include.getClazz().trim());
            }
            if (this._skipIncludeExceptions.size() == 0) {
                logger.finer("SKIPHANDLE: include element not present");
            }
        }
        if (chunk.getSkippableExceptionClasses() != null && chunk.getSkippableExceptionClasses().getExcludeList() != null) {
            List<ExceptionClassFilter.Exclude> excludes = chunk.getSkippableExceptionClasses().getExcludeList();
            for (ExceptionClassFilter.Exclude exclude : excludes) {
                this._skipExcludeExceptions.add(exclude.getClazz().trim());
                logger.finer("SKIPHANDLE: exclude: " + exclude.getClazz().trim());
            }
            if (this._skipExcludeExceptions.size() == 0) {
                logger.finer("SKIPHANDLE: exclude element not present");
            }
        }
        this.excMatcher = new ExceptionMatcher(this._skipIncludeExceptions, this._skipExcludeExceptions);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, className, "initialize", "added include exception " + this._skipIncludeExceptions + "; added exclude exception " + this._skipExcludeExceptions);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "initialize", this.toString());
        }
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleExceptionRead(Exception e) {
        String mName = "handleException";
        logger.finer("SKIPHANDLE: in skiphandler handle exception on a read");
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINE, className, "handleException", e.getClass().getName() + "; " + this.toString());
        }
        if (!this.isSkipLimitReached() && this.excMatcher.isSkippableOrRetryable(e)) {
            ++this._skipCount;
            this.logSkip(e);
            if (this._skipReadListener != null) {
                for (SkipReadListenerProxy skipReadListenerProxy : this._skipReadListener) {
                    skipReadListenerProxy.onSkipReadItem(e);
                }
            }
        } else {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINE, className, "handleException", "No skip.  Rethrow", e);
            }
            throw new BatchContainerRuntimeException(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "handleException", e);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleExceptionWithRecordProcess(Exception e, Object w) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.SkipHandler", "handleExceptionWithRecordProcess", new Object[]{e, w});
        }
        String mName = "handleExceptionWithRecordProcess";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINE, className, "handleExceptionWithRecordProcess", e.getClass().getName() + "; " + this.toString());
        }
        if (!this.isSkipLimitReached() && this.excMatcher.isSkippableOrRetryable(e)) {
            ++this._skipCount;
            this.logSkip(e);
            if (this._skipProcessListener != null) {
                for (SkipProcessListenerProxy skipProcessListenerProxy : this._skipProcessListener) {
                    skipProcessListenerProxy.onSkipProcessItem(w, e);
                }
            }
        } else {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINE, className, "handleExceptionWithRecordProcess", "No skip.  Rethrow ", e);
            }
            throw new BatchContainerRuntimeException(e);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.SkipHandler", "handleExceptionWithRecordProcess");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleExceptionWithRecordListWrite(Exception e, List<?> items) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.SkipHandler", "handleExceptionWithRecordListWrite", new Object[]{e, items});
        }
        String mName = "handleExceptionWithRecordListWrite(Exception, List<?>)";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINE, className, "handleExceptionWithRecordListWrite(Exception, List<?>)", e.getClass().getName() + "; " + this.toString());
        }
        if (!this.isSkipLimitReached() && this.excMatcher.isSkippableOrRetryable(e)) {
            ++this._skipCount;
            this.logSkip(e);
            if (this._skipWriteListener != null) {
                for (SkipWriteListenerProxy skipWriteListenerProxy : this._skipWriteListener) {
                    skipWriteListenerProxy.onSkipWriteItem(items, e);
                }
            }
        } else {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINE, className, "handleExceptionWithRecordListWrite(Exception, List<?>)", "No skip.  Rethrow ", e);
            }
            throw new BatchContainerRuntimeException(e);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.SkipHandler", "handleExceptionWithRecordListWrite");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isSkipLimitReached() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.SkipHandler", "isSkipLimitReached", new Object[0]);
        }
        if (this._skipLimit == Integer.MIN_VALUE) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.jbatch.container.impl.SkipHandler", "isSkipLimitReached", bl);
            }
            return bl;
        }
        boolean bl = this._skipCount >= (long)this._skipLimit;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.impl.SkipHandler", "isSkipLimitReached", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void logSkip(Exception e) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.SkipHandler", "logSkip", new Object[]{e});
        }
        Object[] details = new Object[]{this._stepId, e.getClass().getName() + ": " + e.getMessage()};
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, className, "logSkip", "Logging details: ", details);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.SkipHandler", "logSkip");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getSkipCount() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.SkipHandler", "getSkipCount", new Object[0]);
        }
        long l = this._skipCount;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.jbatch.container.impl.SkipHandler", "getSkipCount", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setSkipCount(long skipCount) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.SkipHandler", "setSkipCount", new Object[]{skipCount});
        }
        String mName = "setSkipCount";
        this._skipCount = skipCount;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, className, "setSkipCount", "setSkipCount: " + this._skipCount);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.SkipHandler", "setSkipCount");
        }
    }

    public String toString() {
        return "SkipHandler{" + super.toString() + "}count:limit=" + this._skipCount + ":" + this._skipLimit;
    }
}

