/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Type;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.CookieParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.ProxyHelper;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.ClientLifeCycleManager;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.UpfrontConduitSelector;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxrs.AbstractJAXRSFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.client.ClientProxyImpl;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.FrontendClientAdapter;
import org.apache.cxf.jaxrs.client.InvocationHandlerAware;
import org.apache.cxf.jaxrs.client.ThreadLocalClientState;
import org.apache.cxf.jaxrs.client.UrlEncodingParamConverter;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.FactoryBeanListener;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class JAXRSClientFactoryBean
extends AbstractJAXRSFactoryBean {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSClientFactoryBean.class);
    private String username;
    private String password;
    private boolean inheritHeaders;
    private MultivaluedMap<String, String> headers;
    private ClientState initialState;
    private boolean threadSafe;
    private long timeToKeepState;
    private Class<?> serviceClass;
    private ClassLoader proxyLoader;
    static final long serialVersionUID = 6957014964196115781L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXRSClientFactoryBean() {
        this(new JAXRSServiceFactoryBean());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXRSClientFactoryBean(JAXRSServiceFactoryBean serviceFactory) {
        super(serviceFactory);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "<init>", new Object[]{serviceFactory});
        }
        serviceFactory.setEnableStaticResolution(true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setClassLoader(ClassLoader loader) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setClassLoader", new Object[]{loader});
        }
        this.proxyLoader = loader;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setClassLoader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setThreadSafe(boolean threadSafe) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setThreadSafe", new Object[]{threadSafe});
        }
        this.threadSafe = threadSafe;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setThreadSafe");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setSecondsToKeepState(long time) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setSecondsToKeepState", new Object[]{time});
        }
        this.timeToKeepState = time;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setSecondsToKeepState");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getUsername() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "getUsername", new Object[0]);
        }
        String string = this.username;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "getUsername", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setUsername(String username) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setUsername", new Object[]{username});
        }
        this.username = username;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setUsername");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPassword() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "getPassword", new Object[0]);
        }
        String string = this.password;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "getPassword", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setPassword(String password) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setPassword", new Object[]{password});
        }
        this.password = password;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setPassword");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setInheritHeaders(boolean ih) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setInheritHeaders", new Object[]{ih});
        }
        this.inheritHeaders = ih;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setInheritHeaders");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setResourceClass(Class<?> cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setResourceClass", new Object[]{cls});
        }
        this.setServiceClass(cls);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setResourceClass");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setServiceClass(Class<?> cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setServiceClass", new Object[]{cls});
        }
        this.serviceClass = cls;
        this.serviceFactory.setResourceClass(cls);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setServiceClass");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Class<?> getServiceClass() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "getServiceClass", new Object[0]);
        }
        Class<?> clazz = this.serviceClass;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "getServiceClass", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setHeaders(Map<String, String> map) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setHeaders", new Object[]{map});
        }
        this.headers = new MetadataMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String[] values;
            for (String v : values = entry.getValue().split(",")) {
                if (v.length() == 0) continue;
                this.headers.add((Object)entry.getKey(), (Object)v);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setHeaders");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, List<String>> getHeaders() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "getHeaders", new Object[0]);
        }
        MultivaluedMap<String, String> multivaluedMap = this.headers;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            multivaluedMap = multivaluedMap;
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "getHeaders", multivaluedMap);
        }
        return multivaluedMap;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WebClient createWebClient() {
        WebClient webClient;
        block4: {
            int queryIndex;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "createWebClient", new Object[0]);
            }
            String serviceAddress = this.getAddress();
            int n = queryIndex = serviceAddress != null ? serviceAddress.lastIndexOf(63) : -1;
            if (queryIndex != -1) {
                serviceAddress = serviceAddress.substring(0, queryIndex);
            }
            JAXRSServiceImpl service = new JAXRSServiceImpl(serviceAddress, this.getServiceName());
            this.getServiceFactory().setService((Service)service);
            try {
                Endpoint ep = this.createEndpoint();
                this.getServiceFactory().sendEvent(FactoryBeanListener.Event.PRE_CLIENT_CREATE, new Object[]{ep});
                ClientState actualState = this.getActualState();
                WebClient client = actualState == null ? new WebClient(this.getAddress()) : new WebClient(actualState);
                this.initClient(client, ep, actualState == null);
                this.notifyLifecycleManager(client);
                this.getServiceFactory().sendEvent(FactoryBeanListener.Event.CLIENT_CREATED, new Object[]{client, ep});
                webClient = client;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block4;
            }
            catch (Exception ep) {
                void ex;
                FFDCFilter.processException((Throwable)ep, (String)"org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", (String)"233", (Object)((Object)this), (Object[])new Object[0]);
                LOG.severe(ex.getClass().getName() + " : " + ex.getLocalizedMessage());
                throw new RuntimeException((Throwable)ex);
            }
            webClient = webClient;
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "createWebClient", webClient);
        }
        return webClient;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void notifyLifecycleManager(Object client) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "notifyLifecycleManager", new Object[]{client});
        }
        ClientLifeCycleManager mgr = (ClientLifeCycleManager)this.bus.getExtension(ClientLifeCycleManager.class);
        if (null != mgr) {
            mgr.clientCreated((org.apache.cxf.endpoint.Client)new FrontendClientAdapter(WebClient.getConfig(client)));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "notifyLifecycleManager");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ClientState getActualState() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "getActualState", new Object[0]);
        }
        if (this.threadSafe) {
            this.initialState = new ThreadLocalClientState(this.getAddress(), this.timeToKeepState);
        }
        if (this.initialState != null) {
            ClientState clientState = this.headers != null ? this.initialState.newState(URI.create(this.getAddress()), this.headers, null) : this.initialState;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clientState = clientState;
                LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "getActualState", clientState);
            }
            return clientState;
        }
        ClientState clientState = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clientState = clientState;
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "getActualState", clientState);
        }
        return clientState;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> T create(Class<T> cls, Object ... varValues) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "create", new Object[]{cls, varValues});
        }
        T t = cls.cast(this.createWithValues(varValues));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            t = t;
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "create", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Client create() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "create", new Object[0]);
        }
        if (this.serviceClass == WebClient.class) {
            WebClient webClient = this.createWebClient();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                webClient = webClient;
                LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "create", webClient);
            }
            return webClient;
        }
        Client client = this.createWithValues(new Object[0]);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            client = client;
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "create", client);
        }
        return client;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Client createWithValues(Object ... varValues) {
        Client client;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "createWithValues", new Object[]{varValues});
        }
        this.serviceFactory.setBus(this.getBus());
        this.checkResources(false);
        ClassResourceInfo cri = null;
        try {
            Endpoint ep = this.createEndpoint();
            if (this.getServiceClass() != null) {
                for (ClassResourceInfo info : this.serviceFactory.getClassResourceInfo()) {
                    if (!info.getServiceClass().isAssignableFrom(this.getServiceClass()) && !this.getServiceClass().isAssignableFrom(info.getServiceClass())) continue;
                    cri = info;
                    break;
                }
                if (cri == null) {
                    throw new RuntimeException("Service class " + this.getServiceClass().getName() + " is not recognized");
                }
            } else {
                cri = (ClassResourceInfo)this.serviceFactory.getClassResourceInfo().get(0);
            }
            boolean isRoot = cri.getURITemplate() != null;
            ClientProxyImpl proxyImpl = null;
            ClientState actualState = this.getActualState();
            proxyImpl = this.createClientProxy(cri, isRoot, actualState, varValues);
            this.initClient(proxyImpl, ep, actualState == null);
            final Class serviceClass = cri.getServiceClass();
            ClassLoader theLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
                static final long serialVersionUID = -9064573621345227861L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ClassLoader run() {
                    return JAXRSClientFactoryBean.this.proxyLoader == null ? serviceClass.getClassLoader() : JAXRSClientFactoryBean.this.proxyLoader;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean$1", 1.class, null, null);
                }
            });
            Class[] ifaces = new Class[]{Client.class, InvocationHandlerAware.class, Closeable.class, cri.getServiceClass()};
            Client actualClient = (Client)ProxyHelper.getProxy((ClassLoader)theLoader, (Class[])ifaces, (InvocationHandler)proxyImpl);
            proxyImpl.setProxyClient(actualClient);
            this.notifyLifecycleManager(actualClient);
            this.getServiceFactory().sendEvent(FactoryBeanListener.Event.CLIENT_CREATED, new Object[]{actualClient, ep});
            client = actualClient;
        }
        catch (IllegalArgumentException ep) {
            String expected;
            void ex;
            FFDCFilter.processException((Throwable)ep, (String)"org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", (String)"330", (Object)((Object)this), (Object[])new Object[]{varValues});
            String message = ex.getLocalizedMessage();
            if (cri != null && ((expected = cri.getServiceClass().getSimpleName()) + " is not an interface").equals(message)) {
                message = message + "; make sure CGLIB is on the classpath";
            }
            LOG.severe(ex.getClass().getName() + " : " + message);
            throw ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", (String)"340", (Object)((Object)this), (Object[])new Object[]{varValues});
            LOG.severe(ex.getClass().getName() + " : " + ex.getLocalizedMessage());
            throw new RuntimeException(ex);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            client = client;
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "createWithValues", client);
        }
        return client;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ClientProxyImpl createClientProxy(ClassResourceInfo cri, boolean isRoot, ClientState actualState, Object[] varValues) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "createClientProxy", new Object[]{cri, isRoot, actualState, varValues});
        }
        if (actualState == null) {
            ClientProxyImpl clientProxyImpl = new ClientProxyImpl(URI.create(this.getAddress()), this.proxyLoader, cri, isRoot, this.inheritHeaders, varValues);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clientProxyImpl = clientProxyImpl;
                LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "createClientProxy", clientProxyImpl);
            }
            return clientProxyImpl;
        }
        ClientProxyImpl clientProxyImpl = new ClientProxyImpl(actualState, this.proxyLoader, cri, isRoot, this.inheritHeaders, varValues);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clientProxyImpl = clientProxyImpl;
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "createClientProxy", clientProxyImpl);
        }
        return clientProxyImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ConduitSelector getConduitSelector(Endpoint ep) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "getConduitSelector", new Object[]{ep});
        }
        ConduitSelector cs = this.getConduitSelector();
        if (cs == null) {
            cs = new UpfrontConduitSelector();
        }
        cs.setEndpoint(ep);
        ConduitSelector conduitSelector = cs;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            conduitSelector = conduitSelector;
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "getConduitSelector", conduitSelector);
        }
        return conduitSelector;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void initClient(AbstractClient client, Endpoint ep, boolean addHeaders) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "initClient", new Object[]{client, ep, addHeaders});
        }
        if (this.username != null) {
            AuthorizationPolicy authPolicy = new AuthorizationPolicy();
            authPolicy.setUserName(this.username);
            authPolicy.setPassword(this.password);
            ep.getEndpointInfo().addExtensor((Object)authPolicy);
        }
        client.getConfiguration().setConduitSelector(this.getConduitSelector(ep));
        client.getConfiguration().setBus(this.getBus());
        client.getConfiguration().getOutInterceptors().addAll(this.getOutInterceptors());
        client.getConfiguration().getOutInterceptors().addAll(ep.getOutInterceptors());
        client.getConfiguration().getInInterceptors().addAll(this.getInInterceptors());
        client.getConfiguration().getInInterceptors().addAll(ep.getInInterceptors());
        client.getConfiguration().getInFaultInterceptors().addAll(this.getInFaultInterceptors());
        this.applyFeatures(client);
        if (this.headers != null && addHeaders) {
            client.headers(this.headers);
        }
        ClientProviderFactory factory = ClientProviderFactory.createInstance(this.getBus());
        this.setupFactory(factory, ep);
        Map theProperties = super.getProperties();
        boolean encodeClientParameters = PropertyUtils.isTrue((Map)theProperties, (String)"url.encode.client.parameters");
        if (encodeClientParameters) {
            final String encodeClientParametersList = theProperties == null ? null : (String)this.getProperties().get("url.encode.client.parameters.list");
            factory.registerUserProvider(new ParamConverterProvider(){
                static final long serialVersionUID = -1352788240687568630L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public <T> ParamConverter<T> getConverter(Class<T> cls, Type t, Annotation[] anns) {
                    if (cls == String.class && AnnotationUtils.getAnnotation((Annotation[])anns, HeaderParam.class) == null && AnnotationUtils.getAnnotation((Annotation[])anns, CookieParam.class) == null) {
                        return new UrlEncodingParamConverter(encodeClientParametersList);
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean$2", 2.class, null, null);
                }
            });
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "initClient");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void applyFeatures(AbstractClient client) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "applyFeatures", new Object[]{client});
        }
        if (this.getFeatures() != null) {
            for (Feature feature : this.getFeatures()) {
                feature.initialize((InterceptorProvider)client.getConfiguration(), this.getBus());
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "applyFeatures");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setInitialState(ClientState initialState) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setInitialState", new Object[]{initialState});
        }
        this.initialState = initialState;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean", "setInitialState");
        }
    }
}

