/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.common.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.openidconnect.token.IdToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PropagationHelperImpl {
    private static final TraceComponent tc = Tr.register(PropagationHelperImpl.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.common.internal.resources.OidcCommonMessages");
    static final String keyExpiresIn = "expires_in";
    static final long serialVersionUID = 8087227289324007476L;

    public static String getAccessTokenType() {
        return PropagationHelperImpl.getSubjectAttributeString("token_type", true);
    }

    public static long getAccessTokenExpirationTime() {
        long exp = 0L;
        Subject runAsSubject = PropagationHelperImpl.getRunAsSubject();
        Object objExpiresIn = PropagationHelperImpl.getSubjectAttributeObject(runAsSubject, keyExpiresIn, true);
        if (objExpiresIn == null) {
            return 0L;
        }
        Object objStoreMilliseconds = PropagationHelperImpl.getSubjectAttributeObject(runAsSubject, "com.ibm.wssi.security.oidc.client.credential.storing.utc.time.milliseconds", true);
        if (objStoreMilliseconds != null) {
            exp = PropagationHelperImpl.getLong(objStoreMilliseconds) / 1000L + PropagationHelperImpl.getLong(objExpiresIn);
        }
        return exp;
    }

    public static String getAccessToken() {
        return PropagationHelperImpl.getSubjectAttributeString("access_token", true);
    }

    public static String getScopes() {
        return PropagationHelperImpl.getSubjectAttributeString("scope", true);
    }

    public static IdToken getIdToken() {
        IdToken idToken;
        block4: {
            Set<IdToken> privateIdTokens;
            Iterator<IdToken> iterator;
            idToken = null;
            Subject runAsSubject = PropagationHelperImpl.getRunAsSubject();
            if (runAsSubject == null) break block4;
            Set<IdToken> idTokens = runAsSubject.getPublicCredentials(IdToken.class);
            Iterator<IdToken> iterator2 = idTokens.iterator();
            if (iterator2.hasNext()) {
                IdToken idTokenTmp;
                idToken = idTokenTmp = iterator2.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("public IdToken:" + idToken), (Object[])new Object[0]);
                }
            }
            if (idToken == null && (iterator = (privateIdTokens = runAsSubject.getPrivateCredentials(IdToken.class)).iterator()).hasNext()) {
                IdToken idTokenTmp;
                idToken = idTokenTmp = iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("private IdToken:" + idToken), (Object[])new Object[0]);
                }
            }
        }
        return idToken;
    }

    /*
     * WARNING - void declaration
     */
    static Subject getRunAsSubject() {
        try {
            return WSSubject.getRunAsSubject();
        }
        catch (WSSecurityException wSSecurityException) {
            void e;
            FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.openidconnect.common.impl.PropagationHelperImpl", (String)"104", null, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception while getting runAsSubject:", (Object[])new Object[]{e.getCause()});
            }
            Tr.warning((TraceComponent)tc, (String)"OIDC_FAILED_RUN_AS_SUBJCET", (Object[])new Object[]{e.getLocalizedMessage()});
            return null;
        }
    }

    static String getSubjectAttributeString(String attribKey, boolean bindWithAccessToken) {
        Object obj;
        Subject runAsSubject = PropagationHelperImpl.getRunAsSubject();
        if (runAsSubject != null && (obj = PropagationHelperImpl.getSubjectAttributeObject(runAsSubject, attribKey, bindWithAccessToken)) != null) {
            return obj.toString();
        }
        return null;
    }

    static Object getSubjectAttributeObject(Subject subject, String attribKey, boolean bindWithAccessToken) {
        Set<Object> publicCredentials = subject.getPublicCredentials();
        int iCnt = 0;
        for (Object credentialObj : publicCredentials) {
            Object value;
            Object accessToken;
            ++iCnt;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("publicCredential(" + iCnt + ") class:" + credentialObj.getClass().getName()), (Object[])new Object[0]);
            }
            if (!(credentialObj instanceof Map) || bindWithAccessToken && (accessToken = ((Map)credentialObj).get("access_token")) == null || (value = ((Map)credentialObj).get(attribKey)) == null) continue;
            return value;
        }
        Set<Object> privCredentials = subject.getPrivateCredentials();
        for (Object credentialObj : privCredentials) {
            Object value;
            Object accessToken;
            ++iCnt;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("privateCredential(" + iCnt + ") class:" + credentialObj.getClass().getName()), (Object[])new Object[0]);
            }
            if (!(credentialObj instanceof Map) || bindWithAccessToken && (accessToken = ((Map)credentialObj).get("access_token")) == null || (value = ((Map)credentialObj).get(attribKey)) == null) continue;
            return value;
        }
        return null;
    }

    static long getSubjectAttributeLong(Subject runAsSubject, String attribKey, boolean bindWithAccessToken) {
        Object obj;
        if (runAsSubject != null && (obj = PropagationHelperImpl.getSubjectAttributeObject(runAsSubject, attribKey, bindWithAccessToken)) != null) {
            return PropagationHelperImpl.getLong(obj);
        }
        return 0L;
    }

    public static String getUserInfo() {
        Subject runAsSubject = PropagationHelperImpl.getRunAsSubject();
        return runAsSubject == null ? null : (String)PropagationHelperImpl.getSubjectAttributeObject(runAsSubject, "userinfo_string", false);
    }

    static long getLong(Object value) {
        block4: {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof String) {
                try {
                    Long lRet = Long.valueOf((String)value);
                    return lRet;
                }
                catch (NumberFormatException lRet) {
                    FFDCFilter.processException((Throwable)lRet, (String)"com.ibm.ws.security.openidconnect.common.impl.PropagationHelperImpl", (String)"206", null, (Object[])new Object[]{value});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)("NumberFormatException on:" + value), (Object[])new Object[0]);
                }
            }
        }
        return 0L;
    }
}

