/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collector.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.collector.internal.Task;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.logging.synch.ThreadLocalHandler;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayDeque;
import java.util.concurrent.Future;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TaskImpl
extends Task
implements Runnable {
    private static final TraceComponent tc = Tr.register(TaskImpl.class, (String)"Collector", (String)"com.ibm.ws.collector.internal.resources.LoggingMessages");
    private volatile Future<?> future = null;
    static final long serialVersionUID = 3039669736372825088L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FFDCIgnore(value={InterruptedException.class, IllegalArgumentException.class, NullPointerException.class})
    public void run() {
        ThreadLocalHandler.set((Boolean)Boolean.TRUE);
        String originalThreadName = Thread.currentThread().getName();
        TaskImpl.setThreadName(originalThreadName + "-collector-" + this.config.getSourceName() + "-" + this.handlerName);
        try {
            boolean done = false;
            int windowDuration = 1000;
            int maxEvents = 0;
            Throttler throttle = new Throttler(maxEvents, windowDuration);
            while (!done) {
                maxEvents = this.config.getMaxEvents();
                try {
                    Object event = this.bufferMgr.getNextEvent(this.handlerName);
                    if (maxEvents > 0) {
                        throttle.setMaxEvents(maxEvents);
                        throttle.go();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Received event ", (Object[])new Object[]{this, this.config.getSourceName(), event});
                    }
                    this.processEvent(event);
                }
                catch (IllegalArgumentException exit) {
                    done = true;
                }
                catch (InterruptedException exit) {
                    done = true;
                }
                catch (NullPointerException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)"Unexpected NullPointerException caught. Task will continue.", (Object[])new Object[]{e});
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collector.internal.TaskImpl", (String)"76", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)"Exception caught while running task.  Task will continue.", (Object[])new Object[]{e});
                }
            }
        }
        finally {
            this.executorSrvc = null;
            this.formatter = null;
            this.bufferMgr = null;
            TaskImpl.setThreadName(originalThreadName);
            ThreadLocalHandler.remove();
            this.setConfig(null);
        }
    }

    @Override
    public void stop() {
        if (this.future != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Stopping task", (Object[])new Object[]{this, this.config.getSourceName()});
            }
            this.future.cancel(true);
            this.future = null;
        }
    }

    @Override
    public void start() {
        if (this.future == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Starting task", (Object[])new Object[]{this, this.config.getSourceName()});
            }
            this.future = this.executorSrvc.submit(this);
        }
    }

    private void processEvent(Object event) {
        long startTime = System.nanoTime();
        Object formattedEvent = this.formatter.formatEvent(this.config.getSourceName(), this.config.getLocation(), event, this.config.getTags(), this.config.getMaxFieldLength());
        if (formattedEvent != null) {
            this.eventsBuffer.add(formattedEvent);
        }
        TaskImpl.traceTime(tc, startTime, "FormatAndQueue");
    }

    private static void traceTime(TraceComponent tc, long startTime, String label) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            long endTime = System.nanoTime();
            String s = String.format(label + ": %10.3f ms", Float.valueOf((float)(endTime - startTime) / 1000000.0f));
            Tr.event((TraceComponent)tc, (String)s, (Object[])new Object[0]);
        }
    }

    private static void setThreadName(final String name) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = -6485533519169395854L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Void run() {
                Thread.currentThread().setName(name);
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.collector.internal.TaskImpl$1", 1.class, null, null);
            }
        });
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class Throttler {
        private int maxEvents;
        private final long windowDuration;
        private final ArrayDeque ringBuffer = new ArrayDeque();
        private boolean throttling = false;
        static final long serialVersionUID = -5461305233440915623L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Throttler(int maxEvents, long windowDuration) {
            if (maxEvents < 0 || windowDuration < 1L) {
                throw new IllegalArgumentException("maxEvents cannot be less than 0 or windowDuration cannot be less than 1");
            }
            this.maxEvents = maxEvents;
            this.windowDuration = windowDuration;
        }

        long go() {
            long currentTime = System.currentTimeMillis();
            long oldestTime = 0L;
            oldestTime = this.ringBuffer.size() < this.maxEvents ? 0L : (Long)this.ringBuffer.removeFirst();
            long holdTime = this.windowDuration - (currentTime - oldestTime);
            if (holdTime > 0L) {
                try {
                    Thread.sleep(holdTime);
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.collector.internal.TaskImpl$Throttler", (String)"194", (Object)this, (Object[])new Object[0]);
                }
                currentTime = System.currentTimeMillis();
                this.ringBuffer.add(currentTime);
                if (!this.throttling) {
                    Tr.info((TraceComponent)tc, (String)"MAXEVENTS_EXCEEDS_MAXRATE", (Object[])new Object[]{Thread.currentThread().getName(), this.maxEvents});
                    this.throttling = true;
                }
                if (TraceComponent.isAnyTracingEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Thread" + Thread.currentThread().getName() + " slept for " + holdTime + " ms due to throttling. Throttle rate set to " + this.maxEvents + " per " + this.windowDuration + " milliseconds."), (Object[])new Object[0]);
                }
            } else {
                if (this.throttling && currentTime - (Long)this.ringBuffer.getLast() >= this.windowDuration) {
                    Tr.info((TraceComponent)tc, (String)"MAXEVENTS_NOTEXCEED_RATE", (Object[])new Object[0]);
                    this.throttling = false;
                }
                this.ringBuffer.add(currentTime);
                holdTime = 0L;
            }
            return holdTime;
        }

        public void setMaxEvents(int maxEvents) {
            if (maxEvents < 0) {
                throw new IllegalArgumentException("maxEvents cannot be less than 0");
            }
            while (this.ringBuffer.size() > maxEvents) {
                this.ringBuffer.removeFirst();
            }
            this.maxEvents = maxEvents;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collector.internal.TaskImpl$Throttler", Throttler.class, null, null);
        }
    }
}

