/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.iiop;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jndi.iiop.OrbContext;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.transport.iiop.spi.ClientORBRef;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.ObjectFactory;
import org.osgi.service.component.annotations.Reference;

public abstract class UrlContextFactory
implements ObjectFactory,
ApplicationRecycleComponent {
    static final TraceComponent tc = Tr.register(UrlContextFactory.class);
    private ClientORBRef orbRef;
    private final Set<String> appsToRecycle = Collections.newSetFromMap(new ConcurrentHashMap());

    @Reference
    protected void setIIOPClient(ClientORBRef orbRef) {
        this.orbRef = orbRef;
    }

    protected void unsetIIOPClient(ClientORBRef orbRef) {
        if (this.orbRef == orbRef) {
            orbRef = null;
        }
    }

    @Override
    public Object getObjectInstance(Object o, Name n, Context c, Hashtable<?, ?> env) throws Exception {
        String methodName = "getObjectInstance(): ";
        if (n != null || c != null) {
            return null;
        }
        if (o == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getObjectInstance(): object was null - returning new OrbContext.", (Object[])new Object[0]);
            }
            this.registerCaller();
            return new OrbContext(this.orbRef.getORB(), env);
        }
        if (o instanceof String) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getObjectInstance(): object was a string - performing a lookup on new OrbContext", (Object[])new Object[0]);
            }
            this.registerCaller();
            return new OrbContext(this.orbRef.getORB(), env).lookup((String)o);
        }
        if (o instanceof String[] && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getObjectInstance(): object was a string[] - ignoring", (Object[])new Object[0]);
        }
        throw new OperationNotSupportedException();
    }

    private void registerCaller() {
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cData != null) {
            this.appsToRecycle.add(cData.getJ2EEName().getApplication());
        }
    }

    public ApplicationRecycleContext getContext() {
        return null;
    }

    public Set<String> getDependentApplications() {
        HashSet<String> members = new HashSet<String>(this.appsToRecycle);
        this.appsToRecycle.removeAll(members);
        return members;
    }
}

