/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.list;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.list.LinkState;
import com.ibm.ws.sib.msgstore.list.LinkedList;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

public class Link {
    private static TraceComponent tc = SibTr.register(Link.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private LinkState _state = LinkState.PHYSICALLY_UNLINKED;
    private Link _previousLink;
    private Link _nextLink;
    private long _position = -1L;
    private LinkedList _parent;
    private int _cursorCount = 0;

    final Link _getNextLink() {
        return this._nextLink;
    }

    final Link _getPreviousLink() {
        return this._previousLink;
    }

    final void _link(Link prev, Link next, long position, LinkedList list) {
        if (LinkState.PHYSICALLY_UNLINKED != this._state) {
            throw new RuntimeException(this._state.toString());
        }
        this._nextLink = next;
        this._previousLink = prev;
        this._position = position;
        this._parent = list;
        this._state = LinkState.LINKED;
    }

    private final String _positionString() {
        Link link;
        StringBuffer buf = new StringBuffer();
        this._shortDebugString(buf);
        buf.append(" Forward:");
        int limit = 10;
        for (link = this._getNextLink(); null != link && 0 < limit--; link = link._getNextLink()) {
            buf.append(" ");
            link._shortDebugString(buf);
        }
        buf.append("; Backward:");
        limit = 10;
        for (link = this._getPreviousLink(); null != link && 0 < limit--; link = link._getPreviousLink()) {
            buf.append(" ");
            link._shortDebugString(buf);
        }
        return buf.toString();
    }

    final void _setAsHead(LinkedList parent, Link tail) {
        this._nextLink = tail;
        this._parent = parent;
        this._state = LinkState.HEAD;
    }

    final void _setAsTail(LinkedList parent, Link head) {
        this._previousLink = head;
        this._parent = parent;
        this._state = LinkState.TAIL;
    }

    final void _setNextLink(Link link) {
        this._nextLink = link;
    }

    final void _setPreviousLink(Link link) {
        this._previousLink = link;
    }

    final void _shortDebugString(StringBuffer buf) {
        if (-1L != this._position) {
            buf.append(this._position);
        }
        buf.append("(");
        buf.append(this._state);
        buf.append(")");
    }

    private final void _tryUnlink() {
        if (0 >= this._cursorCount && this._state == LinkState.LOGICALLY_UNLINKED) {
            this._previousLink._nextLink = this._nextLink;
            this._nextLink._previousLink = this._previousLink;
            this._previousLink = null;
            this._nextLink = null;
            this._parent = null;
            this._state = LinkState.PHYSICALLY_UNLINKED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cursorRemoved() {
        LinkedList parent;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cursorRemoved");
        }
        if (null != (parent = this._parent)) {
            LinkedList linkedList = parent;
            synchronized (linkedList) {
                if (LinkState.LINKED == this._state || LinkState.LOGICALLY_UNLINKED == this._state) {
                    --this._cursorCount;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("cursorCount decrement to " + this._cursorCount));
                    }
                    this._tryUnlink();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cursorRemoved");
        }
    }

    final void decrementCursorCount() {
        --this._cursorCount;
        this._tryUnlink();
    }

    final Link getNextLogicalLink() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getNextLogicalLink", (Object)this._positionString());
        }
        Link nextLink = null;
        LinkedList parent = this._parent;
        if (null != parent) {
            nextLink = this._parent.getNextLink(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getNextLogicalLink", (Object)nextLink);
        }
        return nextLink;
    }

    public final Link getNextPhysicalLink() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getNextPhysicalLink", (Object)this._positionString());
        }
        Link nextLink = this._nextLink;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getNextPhysicalLink", (Object)nextLink);
        }
        return nextLink;
    }

    public long getPosition() {
        return this._position;
    }

    public long getSequence() {
        return -1L;
    }

    final void incrementCursorCount() {
        ++this._cursorCount;
    }

    public final boolean isLinked() {
        return LinkState.LINKED == this._state;
    }

    public final boolean isLogicallyUnlinked() {
        return LinkState.LOGICALLY_UNLINKED == this._state;
    }

    public final boolean isPhysicallyUnlinked() {
        return LinkState.PHYSICALLY_UNLINKED == this._state;
    }

    public final boolean isTail() {
        return LinkState.TAIL == this._state;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        Link link = this._previousLink;
        if (null != link) {
            link._shortDebugString(buf);
            buf.append("?<-");
        }
        this._shortDebugString(buf);
        link = this._nextLink;
        if (null != link) {
            buf.append("?->");
            link._shortDebugString(buf);
        }
        buf.append("]");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean unlink() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlink", (Object)this._positionString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("cursor count = " + this._cursorCount));
        }
        boolean unlinked = false;
        LinkedList parent = this._parent;
        if (null != parent) {
            LinkedList linkedList = parent;
            synchronized (linkedList) {
                if (LinkState.LINKED == this._state) {
                    this._state = LinkState.LOGICALLY_UNLINKED;
                    this._tryUnlink();
                    unlinked = true;
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("unlink while " + this._state));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlink", (Object)new Object[]{unlinked, this._positionString()});
        }
        return unlinked;
    }

    protected void xmlWriteAttributesOn(FormattedWriter writer) throws IOException {
        writer.write(" position=\"");
        writer.write(Long.toString(this._position));
        writer.write("\" linkState=\"");
        writer.write(this._state.toString());
        writer.write("\" cursorCount=\"");
        writer.write(Integer.toString(this._cursorCount));
        writer.write("\" sihc=\"");
        writer.write(Integer.toHexString(System.identityHashCode(this)));
        writer.write("\" ");
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        String name = "link";
        writer.write("<");
        writer.write(name);
        this.xmlWriteAttributesOn(writer);
        writer.write(" />");
    }
}

