/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ssl.JSSEProviderFactory;
import java.util.Map;
import java.util.Properties;

public class KeyManagerData {
    private static final TraceComponent tc = Tr.register(KeyManagerData.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    private String kmName = null;
    private String kmProvider = null;
    private String kmAlgorithm = null;
    private String kmCustomClass = null;
    private Properties kmCustomProps = null;

    public KeyManagerData(String _name, Map<String, String> properties) {
        this.kmName = _name;
        for (Map.Entry<String, String> current : properties.entrySet()) {
            String key = current.getKey();
            String value = current.getValue();
            if (key.equalsIgnoreCase("algorithm")) {
                this.kmAlgorithm = value;
                continue;
            }
            if (key.equalsIgnoreCase("provider")) {
                this.kmProvider = value;
                continue;
            }
            if (key.equalsIgnoreCase("keyManagerClass")) {
                this.kmCustomClass = value;
                continue;
            }
            if (null == this.kmCustomProps) {
                this.kmCustomProps = new Properties();
            }
            this.kmCustomProps.setProperty(key, value);
        }
    }

    public KeyManagerData(String name, String provider, String algorithm, String customClass, Properties customAttributes) {
        this.kmName = name;
        this.kmProvider = provider;
        this.kmAlgorithm = algorithm;
        this.kmCustomClass = customClass;
        this.kmCustomProps = customAttributes;
    }

    public String getName() {
        return this.kmName;
    }

    public void setName(String s) {
        this.kmName = s;
    }

    public String getProvider() {
        return this.kmProvider;
    }

    public void setProvider(String s) {
        this.kmProvider = s;
    }

    public String getAlgorithm() {
        return this.kmAlgorithm;
    }

    public void setAlgorithm(String s) {
        this.kmAlgorithm = s;
    }

    public String getKeyManagerClass() {
        return this.kmCustomClass;
    }

    public void setKeyManagerClass(String s) {
        this.kmCustomClass = s;
    }

    public Properties getAdditionalKeyManagerAttrs() {
        return this.kmCustomProps;
    }

    public void setAdditionalKeyManagerAttrs(Map<String, String> attributes) {
        if (null == this.kmCustomProps) {
            this.kmCustomProps = new Properties();
        }
        for (Map.Entry<String, String> attr : attributes.entrySet()) {
            this.kmCustomProps.setProperty(attr.getKey(), attr.getValue());
        }
    }

    public String getKeyManagerString() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKeyManagerString", (Object[])new Object[0]);
        }
        String rc = null;
        rc = this.kmCustomClass != null ? this.kmCustomClass : (this.kmAlgorithm != null && this.kmProvider != null ? this.kmAlgorithm + "|" + this.kmProvider : (this.kmAlgorithm != null ? this.kmAlgorithm : JSSEProviderFactory.getKeyManagerFactoryAlgorithm()));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKeyManagerString -> " + rc));
        }
        return rc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("KeyManagerData: name=").append(this.kmName);
        sb.append(", algorithm=").append(this.kmAlgorithm);
        sb.append(", provider=").append(this.kmProvider);
        sb.append(", customClass=").append(this.kmCustomClass);
        return sb.toString();
    }
}

