/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import org.apache.cxf.common.logging.LogUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class W3CNamespaceContext
implements NamespaceContext {
    private static final Logger LOG = LogUtils.getL7dLogger(W3CNamespaceContext.class);
    private Element currentNode;
    private NamespaceContext outNamespaceContext;
    static final long serialVersionUID = 4600439799775041034L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public W3CNamespaceContext() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CNamespaceContext", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.W3CNamespaceContext", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public W3CNamespaceContext(Element el) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CNamespaceContext", "<init>", new Object[]{el});
        }
        this.currentNode = el;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.W3CNamespaceContext", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setOutNamespaceContext(NamespaceContext context) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CNamespaceContext", "setOutNamespaceContext", new Object[]{context});
        }
        this.outNamespaceContext = context;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.W3CNamespaceContext", "setOutNamespaceContext");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public NamespaceContext getOutNamespaceContext() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CNamespaceContext", "getOutNamespaceContext", new Object[0]);
        }
        NamespaceContext namespaceContext = this.outNamespaceContext;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            namespaceContext = namespaceContext;
            LOG.exiting("org.apache.cxf.staxutils.W3CNamespaceContext", "getOutNamespaceContext", namespaceContext);
        }
        return namespaceContext;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getNamespaceURI(String prefix) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CNamespaceContext", "getNamespaceURI", new Object[]{prefix});
        }
        String name = prefix;
        name = name.length() == 0 ? "xmlns" : "xmlns:" + prefix;
        String string = this.getNamespaceURI(this.currentNode, name);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CNamespaceContext", "getNamespaceURI", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getNamespaceURI(Element e, String name) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CNamespaceContext", "getNamespaceURI", new Object[]{e, name});
        }
        if (e == null) {
            String string = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.staxutils.W3CNamespaceContext", "getNamespaceURI", string);
            }
            return string;
        }
        Attr attr = e.getAttributeNode(name);
        if (attr == null) {
            Node n = e.getParentNode();
            if (n instanceof Element && n != e) {
                String string = this.getNamespaceURI((Element)n, name);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    string = string;
                    LOG.exiting("org.apache.cxf.staxutils.W3CNamespaceContext", "getNamespaceURI", string);
                }
                return string;
            }
        } else {
            String string = attr.getValue();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.staxutils.W3CNamespaceContext", "getNamespaceURI", string);
            }
            return string;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CNamespaceContext", "getNamespaceURI", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPrefix(String uri) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CNamespaceContext", "getPrefix", new Object[]{uri});
        }
        String string = this.getPrefix(this.currentNode, uri);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CNamespaceContext", "getPrefix", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getPrefix(Element e, String uri) {
        Node n;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CNamespaceContext", "getPrefix", new Object[]{e, uri});
        }
        if (e == null) {
            String string = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.staxutils.W3CNamespaceContext", "getPrefix", string);
            }
            return string;
        }
        NamedNodeMap attributes = e.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr a = (Attr)attributes.item(i);
                String val = a.getValue();
                if (val == null || !val.equals(uri)) continue;
                String name = a.getNodeName();
                if ("xmlns".equals(name)) {
                    String string = "";
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        string = string;
                        LOG.exiting("org.apache.cxf.staxutils.W3CNamespaceContext", "getPrefix", string);
                    }
                    return string;
                }
                String string = name.substring(6);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    string = string;
                    LOG.exiting("org.apache.cxf.staxutils.W3CNamespaceContext", "getPrefix", string);
                }
                return string;
            }
        }
        if ((n = e.getParentNode()) instanceof Element && n != e) {
            String string = this.getPrefix((Element)n, uri);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.staxutils.W3CNamespaceContext", "getPrefix", string);
            }
            return string;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.W3CNamespaceContext", "getPrefix", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Iterator<String> getPrefixes(String uri) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CNamespaceContext", "getPrefixes", new Object[]{uri});
        }
        ArrayList<String> prefixes = new ArrayList<String>();
        String prefix = this.getPrefix(uri);
        if (prefix != null) {
            prefixes.add(prefix);
        }
        Iterator<String> iterator = prefixes.iterator();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            iterator = iterator;
            LOG.exiting("org.apache.cxf.staxutils.W3CNamespaceContext", "getPrefixes", iterator);
        }
        return iterator;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Element getElement() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.W3CNamespaceContext", "getElement", new Object[0]);
        }
        Element element = this.currentNode;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            element = element;
            LOG.exiting("org.apache.cxf.staxutils.W3CNamespaceContext", "getElement", element);
        }
        return element;
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setElement(Element node) {
        LOG.entering("W3CNamespaceContext", "setElement");
        this.currentNode = node;
        LOG.exiting("W3CNamespaceContext", "setElement");
    }
}

