/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.math.BigDecimal;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.DecimalMin;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DecimalMinValidatorForString
implements ConstraintValidator<DecimalMin, String> {
    private BigDecimal minValue;
    private int comparator = -1;
    static final long serialVersionUID = 4924729930604326940L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void initialize(DecimalMin annotation) {
        try {
            this.minValue = new BigDecimal(annotation.value());
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"org.apache.bval.constraints.DecimalMinValidatorForString", (String)"39", (Object)this, (Object[])new Object[]{annotation});
            throw new IllegalArgumentException(annotation.value() + " does not represent a valid BigDecimal format");
        }
        if (!annotation.inclusive()) {
            this.comparator = 0;
        }
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        try {
            return new BigDecimal(value).compareTo(this.minValue) > this.comparator;
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"org.apache.bval.constraints.DecimalMinValidatorForString", (String)"54", (Object)this, (Object[])new Object[]{value, context});
            return false;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.bval.constraints.DecimalMinValidatorForString", DecimalMinValidatorForString.class, null, null);
    }
}

