/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.internal.config;

import com.ibm.ws.request.timing.config.Timing;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestTimingConfig {
    private final int sampleRate;
    private final int contextInfoRequirement;
    private final long requestThresholdMin;
    private final long requestThresholdMax;
    private final Map<String, List<Timing>> requestTiming;
    private final Timing defaultRequestTiming;

    public RequestTimingConfig(int sampleRate, int contextInfoRequirement, Map<String, List<Timing>> requestTiming) {
        this.sampleRate = sampleRate;
        this.contextInfoRequirement = contextInfoRequirement;
        this.requestTiming = requestTiming;
        this.requestThresholdMin = this.getReqThresholdMin();
        this.requestThresholdMax = this.getReqThresholdMax();
        if (this.requestTiming.containsKey("all")) {
            Timing defaultRequestTiming = null;
            List<Timing> defaultTimingMap = this.requestTiming.get("all");
            for (Timing t : defaultTimingMap) {
                if (!t.isDefaultTiming()) continue;
                defaultRequestTiming = t;
                break;
            }
            this.defaultRequestTiming = defaultRequestTiming;
        } else {
            this.defaultRequestTiming = null;
        }
    }

    public RequestTimingConfig() {
        this(1, 2, new HashMap<String, List<Timing>>());
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getContextInfoRequirement() {
        return this.contextInfoRequirement;
    }

    public Map<String, List<Timing>> getRequestTiming() {
        return this.requestTiming;
    }

    public long getRequestThresholdMin() {
        return this.requestThresholdMin;
    }

    public long getRequestThresholdMax() {
        return this.requestThresholdMax;
    }

    public long getRequestThreshold(String type, String[] contextInfo) {
        return this.getTiming(type, contextInfo).getRequestThreshold();
    }

    public boolean getInterruptRequest(String type, String[] contextInfo) {
        return false;
    }

    protected Timing getTiming(String type, String[] contextInfo) {
        if (type == null) {
            throw new IllegalArgumentException("Parameter 'type' can not be null");
        }
        if (this.requestTiming.containsKey(type)) {
            int bestMatchScore = Integer.MIN_VALUE;
            Timing bestMatch = null;
            List<Timing> timingMapForType = this.requestTiming.get(type);
            for (Timing t : timingMapForType) {
                int score;
                if (t == null || (score = t.getContextInfoMatchScore(contextInfo)) <= bestMatchScore) continue;
                bestMatchScore = score;
                bestMatch = t;
            }
            if (bestMatch != null) {
                return bestMatch;
            }
        }
        return this.defaultRequestTiming;
    }

    private long getReqThresholdMin() {
        long requestThreasholdMin = Long.MAX_VALUE;
        for (List<Timing> typeMap : this.requestTiming.values()) {
            for (Timing t : typeMap) {
                long curThreshold = t.getRequestThreshold();
                if (curThreshold <= 0L) continue;
                requestThreasholdMin = Math.min(requestThreasholdMin, curThreshold);
            }
        }
        if (requestThreasholdMin == Long.MAX_VALUE) {
            requestThreasholdMin = 0L;
        }
        return requestThreasholdMin;
    }

    private long getReqThresholdMax() {
        long requestThreasholdMax = Long.MIN_VALUE;
        for (List<Timing> typeMap : this.requestTiming.values()) {
            for (Timing t : typeMap) {
                requestThreasholdMax = Math.max(requestThreasholdMax, t.getRequestThreshold());
            }
        }
        return requestThreasholdMax;
    }
}

