/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.CORBA;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.Util;
import org.apache.yoko.orb.CORBA.Any;
import org.apache.yoko.orb.CORBA.Context;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.CORBA.TypeCode;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.CodeConverterBase;
import org.apache.yoko.orb.OB.CodeConverters;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.ObjectFactory;
import org.apache.yoko.orb.OB.TypeCodeCache;
import org.apache.yoko.orb.OB.TypeCodeFactory;
import org.apache.yoko.orb.OB.ValueReader;
import org.apache.yoko.orb.OCI.AlignmentBoundary;
import org.apache.yoko.orb.OCI.Buffer;
import org.apache.yoko.orb.OCI.GiopVersion;
import org.apache.yoko.orb.OCI.ReadBuffer;
import org.apache.yoko.rmi.impl.InputStreamWithOffsets;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA_2_3.portable.ObjectImpl;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.SendingContext.CodeBase;

public final class InputStream
extends InputStreamWithOffsets {
    private static final Logger logger = Logger.getLogger(InputStream.class.getName());
    private ORBInstance orbInstance_;
    private final ReadBuffer readBuffer;
    boolean swap_;
    private GiopVersion giopVersion_ = GiopVersion.GIOP1_0;
    private final int origPos_;
    private final boolean origSwap_;
    private ValueReader valueReader_;
    private TypeCodeCache cache_;
    private CodeConverters codeConverters_;
    private boolean charReaderRequired_;
    private boolean charConversionRequired_;
    private boolean wCharReaderRequired_;
    private boolean wCharConversionRequired_;
    private CodeBase sendingContextRuntime_;
    private String codebase_;

    private TypeCode checkCache(String id, int startPos, int length) {
        TypeCode tc = null;
        if (id.length() > 0 && (tc = this.cache_.get(id)) != null) {
            this._OB_skip(length + startPos - this.readBuffer.getPosition());
        }
        return tc;
    }

    private org.omg.CORBA.TypeCode readTypeCodeImpl(Hashtable<Integer, TypeCode> history, boolean isTopLevel) {
        int kind = this.read_ulong();
        int oldPos = this.readBuffer.getPosition() - 4;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(String.format("Reading a TypeCode of kind %d from position 0x%x", kind, oldPos));
        }
        TypeCode tc = null;
        if (kind == -1) {
            TypeCode p;
            int offs = this.read_long();
            int indirectionPos = this.readBuffer.getPosition() - 4 + offs;
            if ((p = history.get(indirectionPos += indirectionPos & 3)) == null) {
                throw InputStream.newMarshalError(1095974950);
            }
            history.put(oldPos, p);
            tc = p;
        } else {
            switch (kind) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    tc = (TypeCode)TypeCodeFactory.createPrimitiveTC(org.omg.CORBA_2_4.TCKind.from_int((int)kind));
                    history.put(oldPos, tc);
                    break;
                }
                case 28: {
                    short digits = this.read_ushort();
                    short scale = this.read_short();
                    tc = (TypeCode)TypeCodeFactory.createFixedTC(digits, scale);
                    history.put(oldPos, tc);
                    break;
                }
                case 14: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.readBuffer.getPosition();
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        tc = (TypeCode)TypeCodeFactory.createInterfaceTC(id, this.read_string());
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    history.put(oldPos, tc);
                    this.swap_ = swap;
                    break;
                }
                case 15: 
                case 22: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.readBuffer.getPosition();
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        TypeCode p = new TypeCode();
                        history.put(oldPos, p);
                        p.kind_ = org.omg.CORBA_2_4.TCKind.from_int((int)kind);
                        p.id_ = id;
                        p.name_ = this.read_string();
                        int num = this.read_ulong();
                        p.memberNames_ = new String[num];
                        p.memberTypes_ = new TypeCode[num];
                        for (int i = 0; i < num; ++i) {
                            p.memberNames_[i] = this.read_string();
                            p.memberTypes_[i] = (TypeCode)this.readTypeCodeImpl(history, false);
                        }
                        tc = p;
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    this.swap_ = swap;
                    break;
                }
                case 16: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.readBuffer.getPosition();
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        TypeCode p = new TypeCode();
                        history.put(oldPos, p);
                        p.kind_ = TCKind.tk_union;
                        p.id_ = id;
                        p.name_ = this.read_string();
                        p.discriminatorType_ = (TypeCode)this.readTypeCodeImpl(history, false);
                        int defaultIndex = this.read_long();
                        int num = this.read_ulong();
                        p.labels_ = new Any[num];
                        p.memberNames_ = new String[num];
                        p.memberTypes_ = new TypeCode[num];
                        TypeCode origTC = p.discriminatorType_._OB_getOrigType();
                        switch (origTC.kind().value()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 8: 
                            case 9: 
                            case 17: 
                            case 23: 
                            case 24: {
                                break;
                            }
                            default: {
                                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
                            }
                        }
                        for (int i = 0; i < num; ++i) {
                            p.labels_[i] = new Any();
                            if (i == defaultIndex) {
                                Any dummy = new Any();
                                dummy.read_value((org.omg.CORBA.portable.InputStream)this, p.discriminatorType_);
                                p.labels_[i].insert_octet((byte)0);
                            } else {
                                p.labels_[i].read_value((org.omg.CORBA.portable.InputStream)this, p.discriminatorType_);
                            }
                            p.memberNames_[i] = this.read_string();
                            p.memberTypes_[i] = (TypeCode)this.readTypeCodeImpl(history, false);
                        }
                        tc = p;
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    this.swap_ = swap;
                    break;
                }
                case 17: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.readBuffer.getPosition();
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        String name = this.read_string();
                        int num = this.read_ulong();
                        String[] members = new String[num];
                        for (int i = 0; i < num; ++i) {
                            members[i] = this.read_string();
                        }
                        tc = (TypeCode)TypeCodeFactory.createEnumTC(id, name, members);
                        history.put(oldPos, tc);
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    this.swap_ = swap;
                    break;
                }
                case 18: {
                    tc = (TypeCode)TypeCodeFactory.createStringTC(this.read_ulong());
                    history.put(oldPos, tc);
                    break;
                }
                case 27: {
                    tc = (TypeCode)TypeCodeFactory.createWStringTC(this.read_ulong());
                    history.put(oldPos, tc);
                    break;
                }
                case 19: 
                case 20: {
                    this.read_ulong();
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    TypeCode p = new TypeCode();
                    history.put(oldPos, p);
                    p.kind_ = org.omg.CORBA_2_4.TCKind.from_int((int)kind);
                    p.contentType_ = (TypeCode)this.readTypeCodeImpl(history, false);
                    p.length_ = this.read_ulong();
                    tc = p;
                    this.swap_ = swap;
                    break;
                }
                case 21: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.readBuffer.getPosition();
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        tc = (TypeCode)TypeCodeFactory.createAliasTC(id, this.read_string(), this.readTypeCodeImpl(history, false));
                        history.put(oldPos, tc);
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    this.swap_ = swap;
                    break;
                }
                case 29: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.readBuffer.getPosition();
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        TypeCode p = new TypeCode();
                        history.put(oldPos, p);
                        p.kind_ = org.omg.CORBA_2_4.TCKind.from_int((int)kind);
                        p.id_ = id;
                        p.name_ = this.read_string();
                        p.typeModifier_ = this.read_short();
                        p.concreteBaseType_ = (TypeCode)this.readTypeCodeImpl(history, false);
                        if (p.concreteBaseType_.kind().value() == 0) {
                            p.concreteBaseType_ = null;
                        }
                        int num = this.read_ulong();
                        p.memberNames_ = new String[num];
                        p.memberTypes_ = new TypeCode[num];
                        p.memberVisibility_ = new short[num];
                        for (int i = 0; i < num; ++i) {
                            p.memberNames_[i] = this.read_string();
                            p.memberTypes_[i] = (TypeCode)this.readTypeCodeImpl(history, false);
                            p.memberVisibility_[i] = this.read_short();
                        }
                        tc = p;
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    this.swap_ = swap;
                    break;
                }
                case 30: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.readBuffer.getPosition();
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        tc = (TypeCode)TypeCodeFactory.createValueBoxTC(id, this.read_string(), this.readTypeCodeImpl(history, false));
                        history.put(oldPos, tc);
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    this.swap_ = swap;
                    break;
                }
                case 32: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.readBuffer.getPosition();
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(String.format("Abstract interface typecode encapsulaton length=0x%x id=%s", length, id));
                    }
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        tc = (TypeCode)TypeCodeFactory.createAbstractInterfaceTC(id, this.read_string());
                        history.put(oldPos, tc);
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    this.swap_ = swap;
                    break;
                }
                case 31: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.readBuffer.getPosition();
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        tc = (TypeCode)TypeCodeFactory.createNativeTC(id, this.read_string());
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    history.put(oldPos, tc);
                    this.swap_ = swap;
                    break;
                }
                case 33: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.readBuffer.getPosition();
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        tc = (TypeCode)TypeCodeFactory.createLocalInterfaceTC(id, this.read_string());
                        history.put(oldPos, tc);
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    this.swap_ = swap;
                    break;
                }
                default: {
                    throw new BAD_TYPECODE("Unknown TypeCode kind: " + kind);
                }
            }
        }
        return tc;
    }

    private ValueReader valueReader() {
        if (this.valueReader_ == null) {
            this.valueReader_ = new ValueReader(this);
        }
        return this.valueReader_;
    }

    public int available() {
        int available = this.readBuffer.available();
        Assert.ensure(available >= 0);
        return available;
    }

    public int read() {
        this.checkChunk();
        if (this.readBuffer.available() < 1) {
            return -1;
        }
        return 0xFF & this.readBuffer.readByte();
    }

    public ORB orb() {
        if (this.orbInstance_ != null) {
            return this.orbInstance_.getORB();
        }
        return null;
    }

    public boolean read_boolean() {
        this.checkChunk();
        if (this.readBuffer.available() < 1) {
            throw InputStream.newMarshalError(1095974914);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(String.format("Boolean value is %b from position 0x%x", this.readBuffer.peekByte(), this.readBuffer.getPosition()));
        }
        return this.readBuffer.readByte() != 0;
    }

    public char read_char() {
        this.checkChunk();
        if (this.readBuffer.available() < 1) {
            throw InputStream.newMarshalError(1095974915);
        }
        if (this.charReaderRequired_ || this.charConversionRequired_) {
            CodeConverterBase converter = this.codeConverters_.inputCharConverter;
            if (this.charReaderRequired_ && this.charConversionRequired_) {
                return converter.convert(converter.read_char(this.readBuffer));
            }
            if (this.charReaderRequired_) {
                return converter.read_char(this.readBuffer);
            }
            return converter.convert((char)(this.readBuffer.readByte() & 0xFF));
        }
        return (char)(this.readBuffer.readByte() & 0xFF);
    }

    public char read_wchar() {
        return this.read_wchar(false);
    }

    private char read_wchar(boolean partOfString) {
        char value;
        this.checkChunk();
        CodeConverterBase converter = this.codeConverters_.inputWcharConverter;
        if (this.wCharReaderRequired_) {
            if (!partOfString) {
                converter.set_reader_flags(2);
            }
            int wcLen = 2;
            switch (this.giopVersion_) {
                case GIOP1_0: {
                    throw Assert.fail();
                }
                case GIOP1_1: {
                    this.readBuffer.align(AlignmentBoundary.TWO_BYTE_BOUNDARY);
                    break;
                }
                default: {
                    wcLen = this.readBuffer.readByte() & 0xFF;
                }
            }
            if (this.readBuffer.available() < wcLen) {
                throw InputStream.newMarshalError(1095974916);
            }
            value = converter.read_wchar(this.readBuffer, wcLen);
        } else {
            switch (this.giopVersion_) {
                case GIOP1_0: {
                    Assert.ensure(!this.wCharConversionRequired_);
                    this.readBuffer.align(AlignmentBoundary.TWO_BYTE_BOUNDARY);
                    if (this.readBuffer.available() < 2) {
                        throw new MARSHAL(1095974916, CompletionStatus.COMPLETED_NO);
                    }
                    return this.readBuffer.readChar();
                }
                case GIOP1_1: {
                    if (converter.getSourceCodeSet().max_bytes <= 2) {
                        value = (char)this.read_ushort();
                        break;
                    }
                    value = (char)this.read_ulong();
                    break;
                }
                default: {
                    int wcLen = this.readBuffer.readByte() & 0xFF;
                    if (this.readBuffer.available() < wcLen) {
                        throw new MARSHAL(1095974916, CompletionStatus.COMPLETED_NO);
                    }
                    value = this.swap_ ? this.readBuffer.readChar_LE() : this.readBuffer.readChar();
                    break;
                }
            }
        }
        if (this.wCharConversionRequired_) {
            value = converter.convert(value);
        }
        return value;
    }

    public byte read_octet() {
        this.checkChunk();
        if (this.readBuffer.available() < 1) {
            throw InputStream.newMarshalError(1095974917);
        }
        return this.readBuffer.readByte();
    }

    public short read_short() {
        this.checkChunk();
        this.readBuffer.align(AlignmentBoundary.TWO_BYTE_BOUNDARY);
        if (this.readBuffer.available() < 2) {
            throw InputStream.newMarshalError(1095974918);
        }
        if (this.swap_) {
            return (short)(this.readBuffer.readByte() & 0xFF | this.readBuffer.readByte() << 8);
        }
        return (short)(this.readBuffer.readByte() << 8 | this.readBuffer.readByte() & 0xFF);
    }

    public short read_ushort() {
        return this.read_short();
    }

    public int read_long() {
        this.checkChunk();
        return this._OB_readLongUnchecked();
    }

    public final long position() {
        return this.readBuffer.getPosition();
    }

    public int read_ulong() {
        return this.read_long();
    }

    public long read_longlong() {
        this.checkChunk();
        this.readBuffer.align(AlignmentBoundary.EIGHT_BYTE_BOUNDARY);
        if (this.readBuffer.available() < 8) {
            throw InputStream.newMarshalError(1095974922);
        }
        if (this.swap_) {
            return (long)this.readBuffer.readByte() & 0xFFL | (long)this.readBuffer.readByte() << 8 & 0xFF00L | (long)this.readBuffer.readByte() << 16 & 0xFF0000L | (long)this.readBuffer.readByte() << 24 & 0xFF000000L | (long)this.readBuffer.readByte() << 32 & 0xFF00000000L | (long)this.readBuffer.readByte() << 40 & 0xFF0000000000L | (long)this.readBuffer.readByte() << 48 & 0xFF000000000000L | (long)this.readBuffer.readByte() << 56;
        }
        return (long)this.readBuffer.readByte() << 56 | (long)this.readBuffer.readByte() << 48 & 0xFF000000000000L | (long)this.readBuffer.readByte() << 40 & 0xFF0000000000L | (long)this.readBuffer.readByte() << 32 & 0xFF00000000L | (long)this.readBuffer.readByte() << 24 & 0xFF000000L | (long)this.readBuffer.readByte() << 16 & 0xFF0000L | (long)this.readBuffer.readByte() << 8 & 0xFF00L | (long)this.readBuffer.readByte() & 0xFFL;
    }

    public long read_ulonglong() {
        return this.read_longlong();
    }

    public float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    public String read_string() {
        this.checkChunk();
        int byteCount = this.read_ulong();
        if (byteCount == 0) {
            throw InputStream.newMarshalError(1095974928);
        }
        if (byteCount < 0) {
            throw InputStream.newMarshalError(1095974927);
        }
        if (this.readBuffer.available() < byteCount) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("String length=0x%x %n%s", byteCount, this.readBuffer.dumpAllDataWithPosition()));
            }
            throw InputStream.newMarshalError(1095974927);
        }
        StringBuilder sb = new StringBuilder(byteCount - 1);
        CodeConverterBase converter = this.codeConverters_.inputCharConverter;
        int expectedRemainder = this.readBuffer.available() - (byteCount - 1);
        while (this.readBuffer.available() > expectedRemainder) {
            char value;
            char c = value = this.charReaderRequired_ ? converter.read_char(this.readBuffer) : this.readBuffer.readByteAsChar();
            if (value == '\u0000') {
                throw InputStream.newMarshalError(1095974929);
            }
            sb.append(this.charConversionRequired_ ? converter.convert(value) : value);
        }
        if (this.readBuffer.available() < expectedRemainder) {
            throw InputStream.newMarshalError(1095974927);
        }
        if (this.readBuffer.readByte() != 0) {
            throw InputStream.newMarshalError(1095974930);
        }
        return sb.toString();
    }

    public String read_wstring() {
        String s;
        this.checkChunk();
        CodeConverterBase converter = this.codeConverters_.inputWcharConverter;
        int len = this.read_ulong();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Reading wstring of length 0x%x", len));
        }
        switch (this.giopVersion_) {
            case GIOP1_0: 
            case GIOP1_1: {
                if (len == 0) {
                    throw InputStream.newMarshalError(1095974932);
                }
                char[] tmp = new char[len];
                if (this.wCharReaderRequired_) {
                    converter.set_reader_flags(2);
                }
                for (int i = 0; i < len; ++i) {
                    tmp[i] = this.read_wchar(true);
                }
                if (tmp[len - 1] != '\u0000') {
                    throw InputStream.newMarshalError(1095974934);
                }
                s = new String(tmp, 0, len - 1);
                break;
            }
            default: {
                StringBuilder stringBuffer = new StringBuilder(len);
                if (this.wCharReaderRequired_) {
                    converter.set_reader_flags(2);
                    while (len > 0) {
                        if (this.readBuffer.available() < 2) {
                            throw InputStream.newMarshalError(1095974931);
                        }
                        int wcLen = converter.read_count_wchar(this.readBuffer.peekChar());
                        len -= wcLen;
                        if (this.readBuffer.available() < wcLen) {
                            throw InputStream.newMarshalError(1095974931);
                        }
                        char c = converter.read_wchar(this.readBuffer, wcLen);
                        if (this.wCharConversionRequired_) {
                            c = converter.convert(c);
                        }
                        stringBuffer.append(c);
                    }
                } else {
                    int wcLen = 2;
                    while (len > 0) {
                        char c;
                        len -= 2;
                        if (this.readBuffer.available() < 2) {
                            throw InputStream.newMarshalError(1095974931);
                        }
                        char c2 = c = this.swap_ ? this.readBuffer.readChar_LE() : this.readBuffer.readChar();
                        if (this.wCharConversionRequired_) {
                            c = converter.convert(c);
                        }
                        stringBuffer.append(c);
                    }
                }
                s = stringBuffer.toString();
                break;
            }
        }
        return s;
    }

    public void read_boolean_array(boolean[] value, int offset, int length) {
        if (length <= 0) {
            return;
        }
        this.checkChunk();
        if (this.readBuffer.available() < length) {
            throw InputStream.newMarshalError(1095974937);
        }
        for (int i = offset; i < offset + length; ++i) {
            value[i] = this.readBuffer.readByte() != 0;
        }
    }

    public void read_char_array(char[] value, int offset, int length) {
        if (length <= 0) {
            return;
        }
        this.checkChunk();
        if (this.readBuffer.available() < length) {
            throw InputStream.newMarshalError(1095974938);
        }
        if (!this.charReaderRequired_ && !this.charConversionRequired_) {
            for (int i = offset; i < offset + length; ++i) {
                value[i] = (char)(this.readBuffer.readByte() & 0xFF);
            }
        } else {
            CodeConverterBase converter = this.codeConverters_.inputCharConverter;
            boolean bothRequired = this.charReaderRequired_ && this.charConversionRequired_;
            for (int i = offset; i < offset + length; ++i) {
                if (bothRequired) {
                    value[i] = converter.convert(converter.read_char(this.readBuffer));
                    continue;
                }
                if (this.charReaderRequired_) {
                    value[i] = converter.read_char(this.readBuffer);
                    continue;
                }
                char c = (char)(this.readBuffer.readByte() & 0xFF);
                value[i] = converter.convert(c);
            }
        }
    }

    public void read_wchar_array(char[] value, int offset, int length) {
        if (length <= 0) {
            return;
        }
        if (this.readBuffer.available() < length) {
            throw InputStream.newMarshalError(1095974938);
        }
        for (int i = offset; i < offset + length; ++i) {
            value[i] = this.read_wchar(false);
        }
    }

    public void read_octet_array(byte[] value, int offset, int length) {
        if (length <= 0) {
            return;
        }
        this.checkChunk();
        try {
            this.readBuffer.readBytes(value, offset, length);
        }
        catch (IndexOutOfBoundsException e) {
            throw InputStream.newMarshalError(1095974940);
        }
    }

    public void read_short_array(short[] value, int offset, int length) {
        if (length <= 0) {
            return;
        }
        this.checkChunk();
        this.readBuffer.align(AlignmentBoundary.TWO_BYTE_BOUNDARY);
        if (this.readBuffer.available() < length * 2) {
            throw InputStream.newMarshalError(1095974941);
        }
        if (this.swap_) {
            for (int i = offset; i < offset + length; ++i) {
                value[i] = (short)((short)this.readBuffer.readByte() & 0xFF | (short)this.readBuffer.readByte() << 8);
            }
        } else {
            for (int i = offset; i < offset + length; ++i) {
                value[i] = (short)((short)this.readBuffer.readByte() << 8 | (short)this.readBuffer.readByte() & 0xFF);
            }
        }
    }

    public void read_ushort_array(short[] value, int offset, int length) {
        this.read_short_array(value, offset, length);
    }

    public void read_long_array(int[] value, int offset, int length) {
        if (length <= 0) {
            return;
        }
        this.checkChunk();
        this.readBuffer.align(AlignmentBoundary.FOUR_BYTE_BOUNDARY);
        if (this.readBuffer.available() < length * 4) {
            throw InputStream.newMarshalError(1095974943);
        }
        if (this.swap_) {
            for (int i = offset; i < offset + length; ++i) {
                value[i] = this.readBuffer.readByte() & 0xFF | this.readBuffer.readByte() << 8 & 0xFF00 | this.readBuffer.readByte() << 16 & 0xFF0000 | this.readBuffer.readByte() << 24;
            }
        } else {
            for (int i = offset; i < offset + length; ++i) {
                value[i] = this.readBuffer.readByte() << 24 | this.readBuffer.readByte() << 16 & 0xFF0000 | this.readBuffer.readByte() << 8 & 0xFF00 | this.readBuffer.readByte() & 0xFF;
            }
        }
    }

    private static MARSHAL newMarshalError(int minor) {
        return new MARSHAL(MinorCodes.describeMarshal(minor), minor, CompletionStatus.COMPLETED_NO);
    }

    public void read_ulong_array(int[] value, int offset, int length) {
        this.read_long_array(value, offset, length);
    }

    public void read_longlong_array(long[] value, int offset, int length) {
        if (length <= 0) {
            return;
        }
        this.checkChunk();
        this.readBuffer.align(AlignmentBoundary.EIGHT_BYTE_BOUNDARY);
        if (this.readBuffer.available() < length * 8) {
            throw InputStream.newMarshalError(1095974945);
        }
        if (this.swap_) {
            for (int i = offset; i < offset + length; ++i) {
                value[i] = (long)this.readBuffer.readByte() & 0xFFL | (long)this.readBuffer.readByte() << 8 & 0xFF00L | (long)this.readBuffer.readByte() << 16 & 0xFF0000L | (long)this.readBuffer.readByte() << 24 & 0xFF000000L | (long)this.readBuffer.readByte() << 32 & 0xFF00000000L | (long)this.readBuffer.readByte() << 40 & 0xFF0000000000L | (long)this.readBuffer.readByte() << 48 & 0xFF000000000000L | (long)this.readBuffer.readByte() << 56;
            }
        } else {
            for (int i = offset; i < offset + length; ++i) {
                value[i] = (long)this.readBuffer.readByte() << 56 | (long)this.readBuffer.readByte() << 48 & 0xFF000000000000L | (long)this.readBuffer.readByte() << 40 & 0xFF0000000000L | (long)this.readBuffer.readByte() << 32 & 0xFF00000000L | (long)this.readBuffer.readByte() << 24 & 0xFF000000L | (long)this.readBuffer.readByte() << 16 & 0xFF0000L | (long)this.readBuffer.readByte() << 8 & 0xFF00L | (long)this.readBuffer.readByte() & 0xFFL;
            }
        }
    }

    public void read_ulonglong_array(long[] value, int offset, int length) {
        this.read_longlong_array(value, offset, length);
    }

    public void read_float_array(float[] value, int offset, int length) {
        if (length <= 0) {
            return;
        }
        this.checkChunk();
        this.readBuffer.align(AlignmentBoundary.FOUR_BYTE_BOUNDARY);
        if (this.readBuffer.available() < length * 4) {
            throw InputStream.newMarshalError(1095974947);
        }
        if (this.swap_) {
            for (int i = offset; i < offset + length; ++i) {
                int v = this.readBuffer.readByte() & 0xFF | this.readBuffer.readByte() << 8 & 0xFF00 | this.readBuffer.readByte() << 16 & 0xFF0000 | this.readBuffer.readByte() << 24;
                value[i] = Float.intBitsToFloat(v);
            }
        } else {
            for (int i = offset; i < offset + length; ++i) {
                int v = this.readBuffer.readByte() << 24 | this.readBuffer.readByte() << 16 & 0xFF0000 | this.readBuffer.readByte() << 8 & 0xFF00 | this.readBuffer.readByte() & 0xFF;
                value[i] = Float.intBitsToFloat(v);
            }
        }
    }

    public void read_double_array(double[] value, int offset, int length) {
        if (length <= 0) {
            return;
        }
        this.checkChunk();
        this.readBuffer.align(AlignmentBoundary.EIGHT_BYTE_BOUNDARY);
        if (this.readBuffer.available() < length * 8) {
            throw InputStream.newMarshalError(1095974948);
        }
        if (this.swap_) {
            for (int i = offset; i < offset + length; ++i) {
                long v = (long)this.readBuffer.readByte() & 0xFFL | (long)this.readBuffer.readByte() << 8 & 0xFF00L | (long)this.readBuffer.readByte() << 16 & 0xFF0000L | (long)this.readBuffer.readByte() << 24 & 0xFF000000L | (long)this.readBuffer.readByte() << 32 & 0xFF00000000L | (long)this.readBuffer.readByte() << 40 & 0xFF0000000000L | (long)this.readBuffer.readByte() << 48 & 0xFF000000000000L | (long)this.readBuffer.readByte() << 56;
                value[i] = Double.longBitsToDouble(v);
            }
        } else {
            for (int i = offset; i < offset + length; ++i) {
                long v = (long)this.readBuffer.readByte() << 56 | (long)this.readBuffer.readByte() << 48 & 0xFF000000000000L | (long)this.readBuffer.readByte() << 40 & 0xFF0000000000L | (long)this.readBuffer.readByte() << 32 & 0xFF00000000L | (long)this.readBuffer.readByte() << 24 & 0xFF000000L | (long)this.readBuffer.readByte() << 16 & 0xFF0000L | (long)this.readBuffer.readByte() << 8 & 0xFF00L | (long)this.readBuffer.readByte() & 0xFFL;
                value[i] = Double.longBitsToDouble(v);
            }
        }
    }

    public Object read_Object() {
        this.checkChunk();
        IOR ior = IORHelper.read((org.omg.CORBA.portable.InputStream)this);
        if (ior.type_id.length() == 0 && ior.profiles.length == 0) {
            return null;
        }
        if (this.orbInstance_ == null) {
            throw new INITIALIZE("InputStream must be created by a full ORB");
        }
        ObjectFactory objectFactory = this.orbInstance_.getObjectFactory();
        return objectFactory.createObject(ior);
    }

    public Object read_Object(Class expectedType) {
        Object obj = this.read_Object();
        if (obj == null) {
            return null;
        }
        org.omg.CORBA.portable.ObjectImpl impl = (org.omg.CORBA.portable.ObjectImpl)obj;
        if (org.omg.CORBA.portable.ObjectImpl.class.isAssignableFrom(expectedType)) {
            return this.createStub(expectedType, impl._get_delegate());
        }
        String codebase = ((ObjectImpl)impl)._get_codebase();
        try {
            if (IDLEntity.class.isAssignableFrom(expectedType)) {
                final Class helperClass = Util.loadClass((String)(expectedType.getName() + "Helper"), (String)codebase, (ClassLoader)expectedType.getClassLoader());
                Method helperNarrow = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                    @Override
                    public Method run() throws NoSuchMethodException {
                        return helperClass.getMethod("narrow", Object.class);
                    }
                });
                return (Object)helperNarrow.invoke(null, impl);
            }
            return this.createStub(this.getRMIStubClass(codebase, expectedType), impl._get_delegate());
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InvocationTargetException | PrivilegedActionException ex) {
            logger.log(Level.FINE, "Exception creating object stub", ex);
            MARSHAL m = new MARSHAL("Unable to create stub for class " + expectedType.getName(), 1095974958, CompletionStatus.COMPLETED_NO);
            m.initCause((Throwable)ex);
            throw m;
        }
    }

    private Object createStub(Class<?> stubClass, Delegate delegate) {
        Assert.ensure(org.omg.CORBA.portable.ObjectImpl.class.isAssignableFrom(stubClass), "stub class " + stubClass.getName() + " must extend ObjectImpl");
        Class<?> clz = stubClass;
        try {
            org.omg.CORBA.portable.ObjectImpl stub = (org.omg.CORBA.portable.ObjectImpl)clz.newInstance();
            stub._set_delegate(delegate);
            return stub;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            logger.log(Level.FINE, "Exception creating object stub", ex);
            MARSHAL m = new MARSHAL("Unable to create stub for class " + clz.getName(), 1095974958, CompletionStatus.COMPLETED_NO);
            m.initCause((Throwable)ex);
            throw m;
        }
    }

    private String getRMIStubClassName(Class<?> c) {
        String cname = c.getName();
        int idx = cname.lastIndexOf(46);
        return cname.substring(0, idx + 1) + "_" + cname.substring(idx + 1) + "_Stub";
    }

    private Class<? extends org.omg.CORBA.portable.ObjectImpl> getRMIStubClass(String codebase, Class<?> type) throws ClassNotFoundException {
        String name = this.getRMIStubClassName(type);
        ClassLoader cl = type.getClassLoader();
        try {
            return Util.loadClass((String)name, (String)codebase, (ClassLoader)cl);
        }
        catch (ClassNotFoundException e1) {
            try {
                return Util.loadClass((String)("org.omg.stub." + name), (String)codebase, (ClassLoader)cl);
            }
            catch (ClassNotFoundException e2) {
                e2.addSuppressed(e1);
                throw e2;
            }
        }
    }

    public org.omg.CORBA.TypeCode read_TypeCode() {
        this.checkChunk();
        return this.readTypeCodeImpl(new Hashtable<Integer, TypeCode>(), true);
    }

    public org.omg.CORBA.Any read_any() {
        Any any = new Any(this.orbInstance_);
        any.read_value((org.omg.CORBA.portable.InputStream)this, this.read_TypeCode());
        return any;
    }

    public org.omg.CORBA.Context read_Context() {
        int len = this.read_ulong();
        String[] values = new String[len];
        for (int i = 0; i < len; ++i) {
            values[i] = this.read_string();
        }
        return new Context(this.orbInstance_.getORB(), "", values);
    }

    public Principal read_Principal() {
        throw new NO_IMPLEMENT();
    }

    public BigDecimal read_fixed() {
        StringBuilder vBuffer = new StringBuilder("0");
        StringBuilder sBuffer = new StringBuilder();
        boolean first = true;
        while (true) {
            int lo;
            byte b;
            int hi;
            if ((hi = (b = this.read_octet()) >>> 4 & 0xF) > 9) {
                throw InputStream.newMarshalError(1095974936);
            }
            if (!first || hi > 0) {
                vBuffer.append((char)(hi + 48));
            }
            if ((lo = b & 0xF) >= 10) {
                if (lo == 12 || lo == 13) {
                    if (lo != 13) break;
                    sBuffer.append("-");
                    break;
                }
                throw InputStream.newMarshalError(1095974936);
            }
            vBuffer.append((char)(lo + 48));
            first = false;
        }
        sBuffer.append((CharSequence)vBuffer);
        try {
            return new BigDecimal(sBuffer.toString());
        }
        catch (NumberFormatException ex) {
            throw InputStream.newMarshalError(1095974936);
        }
    }

    public Serializable read_value() {
        return this.valueReader().readValue();
    }

    public Serializable read_value(String id) {
        return this.valueReader().readValue(id);
    }

    public Serializable read_value(Class clz) {
        return this.valueReader().readValue(clz);
    }

    public Serializable read_value(BoxedValueHelper helper) {
        return this.valueReader().readValueBox(helper);
    }

    public Serializable read_value(Serializable value) {
        this.valueReader().initializeValue(value);
        return value;
    }

    public java.lang.Object read_abstract_interface() {
        return this.valueReader().readAbstractInterface();
    }

    public java.lang.Object read_abstract_interface(Class clz) {
        return this.valueReader().readAbstractInterface(clz);
    }

    public void read_value(org.omg.CORBA.Any any, org.omg.CORBA.TypeCode tc) {
        this.valueReader().readValueAny(any, tc);
    }

    private InputStream(ReadBuffer readBuffer, int offs, boolean swap, CodeConverters codeConverters, GiopVersion giopVersion) {
        this.readBuffer = (ReadBuffer)readBuffer.setPosition(offs);
        this.swap_ = swap;
        this.origPos_ = offs;
        this.origSwap_ = swap;
        this._OB_codeConverters(codeConverters, giopVersion);
    }

    public InputStream(InputStream that) {
        this((ReadBuffer)that.readBuffer.clone(), that.origPos_, that.origSwap_, that.codeConverters_, that.giopVersion_);
        this.orbInstance_ = that.orbInstance_;
    }

    public InputStream(ReadBuffer readBuffer, boolean swap, CodeConverters codeConverters, GiopVersion giopVersion) {
        this(readBuffer, 0, swap, codeConverters, giopVersion);
    }

    public InputStream(byte[] data, boolean swap, CodeConverters codeConverters, GiopVersion giopVersion) {
        this(Buffer.createReadBuffer(data), swap, codeConverters, giopVersion);
    }

    public InputStream(ReadBuffer readBuffer, int offs, boolean swap) {
        this(readBuffer, offs, swap, null, null);
    }

    public InputStream(ReadBuffer readBuffer, boolean swap) {
        this(readBuffer, swap, null, null);
    }

    public InputStream(ReadBuffer readBuffer) {
        this(readBuffer, false, null, null);
    }

    public InputStream(byte[] data) {
        this(Buffer.createReadBuffer(data));
    }

    public void _OB_codeConverters(CodeConverters converters, GiopVersion giopVersion) {
        if (giopVersion != null) {
            this.giopVersion_ = giopVersion;
        }
        this.charReaderRequired_ = false;
        this.charConversionRequired_ = false;
        this.wCharReaderRequired_ = false;
        this.wCharConversionRequired_ = false;
        this.codeConverters_ = CodeConverters.createCopy(converters);
        if (converters != null) {
            if (this.codeConverters_.inputCharConverter != null) {
                this.charReaderRequired_ = this.codeConverters_.inputCharConverter.readerRequired();
                this.charConversionRequired_ = this.codeConverters_.inputCharConverter.conversionRequired();
            }
            if (this.codeConverters_.inputWcharConverter != null) {
                this.wCharReaderRequired_ = this.codeConverters_.inputWcharConverter.readerRequired();
                this.wCharConversionRequired_ = this.codeConverters_.inputWcharConverter.conversionRequired();
            }
        }
    }

    public CodeConverters _OB_codeConverters() {
        return this.codeConverters_;
    }

    public ReadBuffer getBuffer() {
        return this.readBuffer;
    }

    public int getPosition() {
        return this.readBuffer.getPosition();
    }

    public void setPosition(int pos) {
        this.readBuffer.setPosition(pos);
    }

    public void _OB_swap(boolean swap) {
        this.swap_ = swap;
    }

    public void _OB_reset() {
        this.swap_ = this.origSwap_;
        this.readBuffer.setPosition(this.origPos_);
    }

    public void _OB_skip(int n) {
        try {
            this.readBuffer.skipBytes(n);
        }
        catch (IndexOutOfBoundsException e) {
            throw InputStream.newMarshalError(1095974913);
        }
    }

    public void skipAlign(AlignmentBoundary boundary) {
        this.readBuffer.align(boundary);
    }

    public void _OB_readEndian() {
        this.swap_ = this.read_boolean();
    }

    public void _OB_ORBInstance(ORBInstance orbInstance) {
        this.orbInstance_ = orbInstance;
        if (this.orbInstance_ != null && this.orbInstance_.useTypeCodeCache()) {
            this.cache_ = TypeCodeCache.instance();
        }
    }

    public ORBInstance _OB_ORBInstance() {
        return this.orbInstance_;
    }

    public int _OB_readLongUnchecked() {
        this.readBuffer.align(AlignmentBoundary.FOUR_BYTE_BOUNDARY);
        if (this.readBuffer.available() < 4) {
            throw InputStream.newMarshalError(1095974920);
        }
        if (this.swap_) {
            return this.readBuffer.readByte() & 0xFF | this.readBuffer.readByte() << 8 & 0xFF00 | this.readBuffer.readByte() << 16 & 0xFF0000 | this.readBuffer.readByte() << 24;
        }
        return this.readBuffer.readByte() << 24 | this.readBuffer.readByte() << 16 & 0xFF0000 | this.readBuffer.readByte() << 8 & 0xFF00 | this.readBuffer.readByte() & 0xFF;
    }

    public void _OB_beginValue() {
        this.valueReader().beginValue();
    }

    public void _OB_endValue() {
        this.valueReader().endValue();
    }

    public void _OB_remarshalValue(org.omg.CORBA.TypeCode tc, OutputStream out) {
        this.valueReader().remarshalValue(tc, out);
    }

    public void __setSendingContextRuntime(CodeBase runtime) {
        this.sendingContextRuntime_ = runtime;
    }

    public CodeBase __getSendingContextRuntime() {
        return this.sendingContextRuntime_;
    }

    public void __setCodeBase(String codebase) {
        this.codebase_ = codebase;
    }

    public String __getCodeBase() {
        return this.codebase_;
    }

    public String dumpPosition() {
        return this.readBuffer.dumpPosition();
    }

    public String dumpRemainingData() {
        return this.readBuffer.dumpRemainingData();
    }

    public String dumpAllData() {
        return this.readBuffer.dumpAllData();
    }

    public String dumpAllDataWithPosition() {
        return this.readBuffer.dumpAllDataWithPosition();
    }

    private void checkChunk() {
        if (this.valueReader_ != null) {
            this.valueReader_.checkChunk();
        }
    }

    public void end_value() {
        this.valueReader().endValue();
    }

    public void start_value() {
        this.valueReader().beginValue();
    }
}

