/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OBPortableServer;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.yoko.orb.IMR.ActiveState;
import org.apache.yoko.orb.IMR.Domain;
import org.apache.yoko.orb.IMR.DomainHelper;
import org.apache.yoko.orb.IMR.NoSuchOAD;
import org.apache.yoko.orb.IMR.NoSuchServer;
import org.apache.yoko.orb.IMR.OADNotRunning;
import org.apache.yoko.orb.IMR.ServerStatus;
import org.apache.yoko.orb.OAD.AlreadyLinked;
import org.apache.yoko.orb.OAD.ProcessEndpoint;
import org.apache.yoko.orb.OAD.ProcessEndpointManagerHolder;
import org.apache.yoko.orb.OAD.ProcessEndpoint_impl;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.InitialServiceManager;
import org.apache.yoko.orb.OB.LocationForward;
import org.apache.yoko.orb.OB.Logger;
import org.apache.yoko.orb.OB.ORBControl;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.PIManager;
import org.apache.yoko.orb.OB.ParseParams;
import org.apache.yoko.orb.OB.RefCountPolicyList;
import org.apache.yoko.orb.OBPortableServer.AcceptorConfig;
import org.apache.yoko.orb.OBPortableServer.CommunicationsConcurrencyPolicy;
import org.apache.yoko.orb.OBPortableServer.CommunicationsConcurrencyPolicy_impl;
import org.apache.yoko.orb.OBPortableServer.DirectServant;
import org.apache.yoko.orb.OBPortableServer.EndpointConfigurationPolicy;
import org.apache.yoko.orb.OBPortableServer.EndpointConfigurationPolicyHelper;
import org.apache.yoko.orb.OBPortableServer.EndpointConfigurationPolicyOperations;
import org.apache.yoko.orb.OBPortableServer.EndpointConfigurationPolicy_impl;
import org.apache.yoko.orb.OBPortableServer.GIOPVersionPolicy;
import org.apache.yoko.orb.OBPortableServer.GIOPVersionPolicy_impl;
import org.apache.yoko.orb.OBPortableServer.POALocator;
import org.apache.yoko.orb.OBPortableServer.POAManager;
import org.apache.yoko.orb.OBPortableServer.POAManagerFactory;
import org.apache.yoko.orb.OBPortableServer.POAManager_impl;
import org.apache.yoko.orb.OBPortableServer.POA_impl;
import org.apache.yoko.orb.OCI.AccFactory;
import org.apache.yoko.orb.OCI.AccFactoryRegistry;
import org.apache.yoko.orb.OCI.Acceptor;
import org.apache.yoko.orb.OCI.InvalidParam;
import org.apache.yoko.orb.OCI.NoSuchFactory;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.PortableInterceptor.IMRIORInterceptor_impl;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.SystemException;
import org.omg.IOP.IOR;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;
import org.omg.PortableServer.POAManagerFactoryPackage.ManagerAlreadyExists;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;

public final class POAManagerFactory_impl
extends LocalObject
implements POAManagerFactory {
    private ORBInstance orbInstance_;
    private Map<String, POAManager_impl> managers_;
    private AtomicInteger count_ = new AtomicInteger();
    private ActiveState activeState_;
    private POALocator poaLocator_;
    private ProcessEndpoint_impl processEndpoint_;
    private Object endpointManager_;

    private String getUniqueName() {
        String name = String.format("POAManager-%d-%d", System.currentTimeMillis(), this.count_.getAndIncrement());
        Assert.ensure(!this.managers_.containsKey(name));
        return name;
    }

    private void validateName(String name) throws ManagerAlreadyExists {
        POAManager manager = this.managers_.get(name);
        if (manager != null) {
            if (manager.get_state() == State.INACTIVE) {
                this.managers_.remove(name);
            } else {
                throw new ManagerAlreadyExists();
            }
        }
    }

    private AcceptorConfig[] parseEndpointString(String endpoint) {
        Logger logger = this.orbInstance_.getLogger();
        ArrayList<AcceptorConfig> acceptorConfigs = new ArrayList<AcceptorConfig>();
        AccFactoryRegistry registry = this.orbInstance_.getAccFactoryRegistry();
        AccFactory[] factories = registry.get_factories();
        int pos = 0;
        block0: while (pos != -1) {
            ArrayList<String> params = new ArrayList<String>();
            pos = ParseParams.parse(endpoint, pos, params);
            if (params.isEmpty()) continue;
            String protocol = (String)params.remove(0);
            for (AccFactory factory : factories) {
                if (!protocol.equals(factory.id())) continue;
                AcceptorConfig config = new AcceptorConfig(protocol, params.toArray(new String[0]));
                acceptorConfigs.add(config);
                continue block0;
            }
            logger.error("unknown endpoint protocol `" + protocol + "'");
            throw new INITIALIZE("unknown endpoint protocol `" + protocol + "'");
        }
        if (acceptorConfigs.isEmpty()) {
            logger.error("no endpoints defined");
            throw new INITIALIZE("no endpoints defined");
        }
        return acceptorConfigs.toArray(new AcceptorConfig[0]);
    }

    public POAManagerFactory_impl() {
        this.managers_ = new Hashtable<String, POAManager_impl>(7);
        this.poaLocator_ = new POALocator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POAManager_impl create_POAManager(String id, Policy[] policies) throws ManagerAlreadyExists, PolicyError {
        Map<String, POAManager_impl> map = this.managers_;
        synchronized (map) {
            AcceptorConfig[] config;
            if (id.isEmpty()) {
                id = this.getUniqueName();
            } else {
                this.validateName(id);
                this.count_.incrementAndGet();
            }
            Properties props = this.orbInstance_.getProperties();
            Logger logger = this.orbInstance_.getLogger();
            EndpointConfigurationPolicyOperations endpointPolicy = null;
            ArrayList<Policy> policyList = new ArrayList<Policy>();
            int nTmpPolicies = 0;
            int nPolicies = policies.length;
            if (nPolicies != 0) {
                for (Policy policy : policies) {
                    int policyType = policy.policy_type();
                    if (policyType == 1330577669) {
                        endpointPolicy = EndpointConfigurationPolicyHelper.narrow((Object)policy);
                        continue;
                    }
                    ++nTmpPolicies;
                    policyList.add(policy);
                }
            }
            Policy[] tmpPolicies = policyList.toArray(new Policy[0]);
            if (endpointPolicy == null) {
                String defaultProtocol = "iiop";
                if (id.equals("RootPOAManager")) {
                    defaultProtocol = props.getProperty("yoko.orb.oa.endpoint", defaultProtocol);
                }
                String paramStr = props.getProperty("yoko.orb.poamanager." + id + ".endpoint", defaultProtocol);
                config = this.parseEndpointString(paramStr);
            } else {
                config = endpointPolicy.value();
            }
            AccFactoryRegistry registry = this.orbInstance_.getAccFactoryRegistry();
            ArrayList<Acceptor> acceptors = new ArrayList<Acceptor>();
            for (AcceptorConfig acceptorConfig : config) {
                try {
                    AccFactory factory = registry.get_factory(acceptorConfig.id);
                    acceptors.add(factory.create_acceptor(acceptorConfig.params));
                }
                catch (NoSuchFactory ex) {
                    String err = "cannot find factory: " + (java.lang.Object)((java.lang.Object)ex);
                    logger.error(err, (Throwable)((java.lang.Object)ex));
                    throw (INITIALIZE)new INITIALIZE(err).initCause((Throwable)((java.lang.Object)ex));
                }
                catch (InvalidParam ex) {
                    String err = "unable to create acceptor: " + ex.reason;
                    logger.error(err, (Throwable)((java.lang.Object)ex));
                    throw (INITIALIZE)new INITIALIZE(err).initCause((Throwable)((java.lang.Object)ex));
                }
            }
            Acceptor[] arr = acceptors.toArray(new Acceptor[0]);
            POAManager_impl manager = new POAManager_impl(this.orbInstance_, this.poaLocator_, id, this.count_.toString(), arr, tmpPolicies);
            this.managers_.put(id, manager);
            return manager;
        }
    }

    public org.omg.PortableServer.POAManager[] list() {
        ArrayList<POAManager_impl> list = new ArrayList<POAManager_impl>(this.managers_.values());
        while (list.remove(null)) {
        }
        return list.toArray(new org.omg.PortableServer.POAManager[0]);
    }

    public POAManager_impl find(String id) {
        return this.managers_.get(id);
    }

    @Override
    public void destroy() {
        this.orbInstance_ = null;
        if (!this.managers_.isEmpty()) {
            this._OB_deactivate();
        }
    }

    @Override
    public EndpointConfigurationPolicy create_endpoint_configuration_policy(String value) throws PolicyError {
        AcceptorConfig[] configArray = this.parseEndpointString(value);
        return new EndpointConfigurationPolicy_impl(configArray);
    }

    @Override
    public CommunicationsConcurrencyPolicy create_communications_concurrency_policy(short value) throws PolicyError {
        return new CommunicationsConcurrencyPolicy_impl(value);
    }

    @Override
    public GIOPVersionPolicy create_giop_version_policy(short value) throws PolicyError {
        return new GIOPVersionPolicy_impl(value);
    }

    public void _OB_deactivate() {
        for (POAManager pOAManager : this.managers_.values()) {
            if (pOAManager == null) continue;
            try {
                pOAManager.deactivate(true, true);
            }
            catch (AdapterInactive adapterInactive) {}
        }
        this.managers_.clear();
        if (this.activeState_ == null) {
            return;
        }
        Logger logger = this.orbInstance_.getLogger();
        String string = this.orbInstance_.getServerInstance();
        try {
            this.activeState_.set_status(string, ServerStatus.STOPPING);
        }
        catch (SystemException ex) {
            logger.warning(this.orbInstance_.getServerId() + ": Cannot contact IMR on shutdown", ex);
        }
        this.activeState_ = null;
    }

    public DirectServant _OB_getDirectServant(IOR ior, RefCountPolicyList policies) throws LocationForward {
        for (POAManager_impl manager : this.managers_.values()) {
            if (manager == null) continue;
            try {
                for (Acceptor acceptor : manager.get_acceptors()) {
                    ProfileInfo[] profileInfos = acceptor.get_local_profiles(ior);
                    if (profileInfos.length == 0) continue;
                    return manager._OB_getDirectServant(profileInfos[0].key, policies);
                }
            }
            catch (OBJECT_NOT_EXIST | AdapterInactive throwable) {
            }
        }
        return null;
    }

    public void _OB_setORBInstance(ORBInstance instance) {
        this.orbInstance_ = instance;
    }

    public void _OB_initializeIMR(POA_impl root, ORBControl orbControl) {
        String serverId = this.orbInstance_.getServerId();
        String serverInstance = this.orbInstance_.getServerInstance();
        Properties properties = this.orbInstance_.getProperties();
        String noIMR = properties.getProperty("yoko.orb.noIMR");
        if (serverId.isEmpty() || noIMR != null) {
            return;
        }
        this.processEndpoint_ = new ProcessEndpoint_impl(serverId, serverInstance, root, orbControl);
        Domain imrDomain = null;
        try {
            InitialServiceManager initServiceManager = this.orbInstance_.getInitialServiceManager();
            Object imrObj = initServiceManager.resolveInitialReferences("IMR");
            imrDomain = DomainHelper.narrow(imrObj);
        }
        catch (BAD_PARAM | InvalidName initServiceManager) {
            // empty catch block
        }
        Logger logger = this.orbInstance_.getLogger();
        if (imrDomain == null) {
            logger.error(serverId + ": IMRDomain not reachable");
            throw new INITIALIZE(serverId + ": IMRDomain not reachable");
        }
        String exec = properties.getProperty("yoko.orb.imr.register");
        if (exec != null) {
            logger.error(serverId + ": Self registration not implemented for java servers");
            throw new INITIALIZE(serverId + ": Self registration not implemented for java servers");
        }
        try {
            ProcessEndpointManagerHolder endpoint = new ProcessEndpointManagerHolder();
            ObjectReferenceTemplate primary = root.adapter_template();
            this.activeState_ = imrDomain.startup(serverId, serverInstance, primary, endpoint);
            ProcessEndpoint ref = this.processEndpoint_._this(this.orbInstance_.getORB());
            endpoint.value.establish_link(serverId, serverInstance, -1, ref);
            this.endpointManager_ = endpoint.value;
            IMRIORInterceptor_impl i = new IMRIORInterceptor_impl(logger, this.activeState_, serverInstance);
            PIManager piManager = this.orbInstance_.getPIManager();
            try {
                piManager.addIORInterceptor((IORInterceptor)i, true);
            }
            catch (DuplicateName ex) {
                throw Assert.fail(ex);
            }
        }
        catch (BAD_PARAM ex) {
            logger.error(serverId + ": (IMR) Server already running", ex);
            throw (INITIALIZE)new INITIALIZE(serverId + ": (IMR) Server already running").initCause((Throwable)ex);
        }
        catch (NoSuchServer ex) {
            logger.error(serverId + ": (IMR) Not registered with IMR", (Throwable)((java.lang.Object)ex));
            throw (INITIALIZE)new INITIALIZE(serverId + ": (IMR) Not registered with IMR").initCause((Throwable)((java.lang.Object)ex));
        }
        catch (NoSuchOAD ex) {
            logger.error(serverId + ": (IMR) No OAD for host", (Throwable)((java.lang.Object)ex));
            throw (INITIALIZE)new INITIALIZE(serverId + ": (IMR) No OAD for host").initCause((Throwable)((java.lang.Object)ex));
        }
        catch (OADNotRunning ex) {
            logger.error(serverId + ": (IMR) OAD not running", (Throwable)((java.lang.Object)ex));
            throw (INITIALIZE)new INITIALIZE(serverId + ": (IMR) OAD not running").initCause((Throwable)((java.lang.Object)ex));
        }
        catch (AlreadyLinked ex) {
            logger.error(serverId + ": (IMR) Process registered with OAD", (Throwable)((java.lang.Object)ex));
            throw (INITIALIZE)new INITIALIZE(serverId + ": (IMR) Process registered with OAD").initCause((Throwable)((java.lang.Object)ex));
        }
    }
}

