/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.message;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.StringMapImpl;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.https.CertConstraints;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MessageImpl
extends StringMapImpl
implements Message {
    private static final long serialVersionUID = -3020763696429459865L;
    private Exchange exchange;
    private String id;
    private InterceptorChain interceptorChain;
    private Object[] contents = new Object[20];
    private int index;
    private static int contentType;
    private static int protoHeaders;
    private static int queryString;
    private static int httpRequest;
    private static int httpResponse;
    private static int pathToMatchSlash;
    private static int httpRequestMethod;
    private static int interceptorProviders;
    private static int templateParameters;
    private static int accept;
    private static int continuationProvider;
    private static int destination;
    private static int opStack;
    private static int wsdlDescription;
    private static int wsdlInterface;
    private static int wsdlOperation;
    private static int wsdlPort;
    private static int wsdlService;
    private static int requestUrl;
    private static int requestUri;
    private static int pathInfo;
    private static int basePath;
    private static int fixedParamOrder;
    private static int inInterceptors;
    private static int outInterceptors;
    private static int responseCode;
    private static int attachments;
    private static int encoding;
    private static int httpContext;
    private static int httpConfig;
    private static int httpContextMatchStrategy;
    private static int httpBasePath;
    private static int asyncPostDispatch;
    private static int securityContext;
    private static int authorizationPolicy;
    private static int certConstraints;
    private static int serviceRedirection;
    private static int httpServletResponse;
    private static int resourceMethod;
    private static int oneWayRequest;
    private static int asyncResponse;
    private static int threadContextSwitched;
    private static int cacheInputProperty;
    private static int previousMessage;
    private static int responseHeadersCopied;
    private static int sseEventSink;
    private static int requestorRole;
    private static int partialResponse;
    private static int emptyPartialResponse;
    private static int endpointAddress;
    private static int inboundMessage;
    private static int TOTAL;
    private Object[] propertyValues = new Object[TOTAL];
    private static final String REQUEST_PATH_TO_MATCH_SLASH = "path_to_match_slash";
    private static final String TEMPLATE_PARAMETERS = "jaxrs.template.parameters";
    private static final String CONTINUATION_PROVIDER;
    private static final String DESTINATION;
    private static final String OP_RES_INFO_STACK = "org.apache.cxf.jaxrs.model.OperationResourceInfoStack";
    private static final String HTTP_BASE_PATH = "http.base.path";
    private static final String SECURITY_CONTEXT;
    private static final String AUTHORIZATION_POLICY;
    private static final String CERT_CONSTRAINTS;
    private static final String HTTP_SERVLET_RESPONSE;
    private static final String RESOURCE_METHOD = "org.apache.cxf.resource.method";
    private static final String ASYNC_RESPONSE = "javax.ws.rs.container.AsyncResponse";
    private static final String SSE_EVENT_SINK = "javax.ws.rs.sse.SseEventSink";
    private static final Map<String, Integer> KEYMAP;
    private static final String[] propertyNames;
    private static final Object NOT_FOUND;
    private static final Integer KEY_NOT_FOUND;
    private Collection<Object> values = null;
    private Set<String> keySet = null;
    private Set<Map.Entry<String, Object>> entrySet = null;
    private static final Object[] NOT_SET_ARRAY;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public MessageImpl(int isize, float factor) {
        super(isize, factor);
        System.arraycopy(NOT_SET_ARRAY, 0, this.propertyValues, 0, TOTAL);
    }

    public MessageImpl() {
        System.arraycopy(NOT_SET_ARRAY, 0, this.propertyValues, 0, TOTAL);
    }

    public MessageImpl(Message m) {
        super(m);
        if (!(m instanceof MessageImpl)) {
            throw new RuntimeException("Not a MessageImpl! " + m.getClass());
        }
        MessageImpl impl = (MessageImpl)m;
        this.exchange = impl.getExchange();
        this.id = impl.id;
        this.interceptorChain = impl.interceptorChain;
        this.contents = impl.contents;
        this.index = impl.index;
        System.arraycopy(NOT_SET_ARRAY, 0, this.propertyValues, 0, TOTAL);
    }

    @Override
    public Collection<Attachment> getAttachments() {
        return (Collection)this.getFromPropertyArray(attachments);
    }

    @Override
    public void setAttachments(Collection<Attachment> a) {
        this.propertyValues[MessageImpl.attachments] = a;
    }

    public String getAttachmentMimeType() {
        return null;
    }

    @Override
    public Destination getDestination() {
        return (Destination)this.getFromPropertyArray(destination);
    }

    @Override
    public Exchange getExchange() {
        return this.exchange;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public InterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    @Override
    public <T> T getContent(Class<T> format) {
        for (int x = 0; x < this.index; x += 2) {
            if (this.contents[x] != format) continue;
            return (T)this.contents[x + 1];
        }
        return null;
    }

    @Override
    public <T> void setContent(Class<T> format, Object content) {
        for (int x = 0; x < this.index; x += 2) {
            if (this.contents[x] != format) continue;
            this.contents[x + 1] = content;
            return;
        }
        if (this.index >= this.contents.length) {
            Object[] tmp = new Object[this.contents.length + 10];
            System.arraycopy(this.contents, 0, tmp, 0, this.contents.length);
            this.contents = tmp;
        }
        this.contents[this.index] = format;
        this.contents[this.index + 1] = content;
        this.index += 2;
    }

    @Override
    public <T> void removeContent(Class<T> format) {
        for (int x = 0; x < this.index; x += 2) {
            if (this.contents[x] != format) continue;
            this.index -= 2;
            if (x != this.index) {
                this.contents[x] = this.contents[this.index];
                this.contents[x + 1] = this.contents[this.index + 1];
            }
            this.contents[this.index] = null;
            this.contents[this.index + 1] = null;
            return;
        }
    }

    @Override
    public Set<Class<?>> getContentFormats() {
        HashSet c = new HashSet();
        for (int x = 0; x < this.index; x += 2) {
            c.add((Class)this.contents[x]);
        }
        return c;
    }

    public void setDestination(Destination d) {
        this.propertyValues[MessageImpl.destination] = d;
    }

    @Override
    public void setExchange(Exchange e) {
        this.exchange = e;
    }

    @Override
    public void setId(String i) {
        this.id = i;
    }

    @Override
    public void setInterceptorChain(InterceptorChain ic) {
        this.interceptorChain = ic;
    }

    @Override
    public Object getContextualProperty(String key) {
        Object o = this.getOrDefault(key, NOT_FOUND);
        if (o != NOT_FOUND) {
            return o;
        }
        return this.getFromExchange(key);
    }

    private Object getFromExchange(String key) {
        Exchange ex = this.getExchange();
        if (ex != null) {
            Service sv;
            Map<String, Object> p;
            Object o = ex.getOrDefault(key, NOT_FOUND);
            if (o != NOT_FOUND) {
                return o;
            }
            Endpoint ep = ex.getEndpoint();
            if (ep != null) {
                o = ep.getOrDefault(key, NOT_FOUND);
                if (o != NOT_FOUND) {
                    return o;
                }
                EndpointInfo ei = ep.getEndpointInfo();
                if (ei != null) {
                    p = ei.getProperties();
                    if (p != null && (o = p.getOrDefault(key, NOT_FOUND)) != NOT_FOUND) {
                        return o;
                    }
                    p = ei.getBinding().getProperties();
                    if (p != null && (o = p.getOrDefault(key, NOT_FOUND)) != NOT_FOUND) {
                        return o;
                    }
                }
            }
            if ((sv = ex.getService()) != null && (o = sv.getOrDefault(key, NOT_FOUND)) != NOT_FOUND) {
                return o;
            }
            Bus b = ex.getBus();
            if (b != null && (p = b.getProperties()) != null && (o = p.getOrDefault(key, NOT_FOUND)) != NOT_FOUND) {
                return o;
            }
        }
        return null;
    }

    private Set<String> getExchangeKeySet() {
        HashSet<String> keys = new HashSet<String>();
        Exchange ex = this.getExchange();
        if (ex != null) {
            Endpoint ep;
            Service sv;
            Map<String, Object> p;
            Bus b = ex.getBus();
            if (b != null && (p = b.getProperties()) != null && !p.isEmpty()) {
                keys.addAll(p.keySet());
            }
            if ((sv = ex.getService()) != null && !sv.isEmpty()) {
                keys.addAll(sv.keySet());
            }
            if ((ep = ex.getEndpoint()) != null) {
                EndpointInfo ei = ep.getEndpointInfo();
                if (ei != null) {
                    p = ei.getBinding().getProperties();
                    if (p != null && !p.isEmpty()) {
                        keys.addAll(p.keySet());
                    }
                    if ((p = ei.getProperties()) != null && !p.isEmpty()) {
                        keys.addAll(p.keySet());
                    }
                }
                if (!ep.isEmpty()) {
                    keys.addAll(ep.keySet());
                }
            }
            if (!ex.isEmpty()) {
                keys.addAll(ex.keySet());
            }
        }
        return keys;
    }

    @Override
    public Set<String> getContextualPropertyKeys() {
        Set<String> s = this.getExchangeKeySet();
        s.addAll(this.keySet());
        return s;
    }

    public static void copyContent(Message m1, Message m2) {
        for (Class<?> c : m1.getContentFormats()) {
            m2.setContent(c, m1.getContent(c));
        }
    }

    @Override
    public void resetContextCache() {
    }

    void setContextualProperty(String key, Object v) {
        this.putIfAbsent(key, v);
    }

    public Map getProtocolHeaders() {
        return (Map)this.getFromPropertyArray(protoHeaders);
    }

    public void setProtocolHeaders(Map p) {
        this.propertyValues[MessageImpl.protoHeaders] = p;
    }

    @Override
    public Object remove(Object key) {
        return this.remove((String)key);
    }

    public Object remove(String key) {
        Integer index = KEYMAP.getOrDefault(key, KEY_NOT_FOUND);
        if (index != KEY_NOT_FOUND) {
            Object ret = this.getFromPropertyArray(index);
            this.propertyValues[index.intValue()] = NOT_FOUND;
            return ret;
        }
        return super.remove(key);
    }

    @Override
    public Object get(Object key) {
        return this.get((String)key);
    }

    public Object get(String key) {
        Integer index = KEYMAP.getOrDefault(key, KEY_NOT_FOUND);
        if (index != KEY_NOT_FOUND) {
            return this.getFromPropertyArray(index);
        }
        return super.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        Integer index = KEYMAP.getOrDefault(key, KEY_NOT_FOUND);
        if (index != KEY_NOT_FOUND) {
            Object ret = this.getFromPropertyArray(index);
            this.propertyValues[index.intValue()] = value;
            return ret;
        }
        return super.put(key, value);
    }

    @Override
    @Trivial
    public Set<String> keySet() {
        return this.keySet != null ? this.keySet : (this.keySet = new KeySet());
    }

    @Override
    public boolean containsKey(Object key) {
        Integer index = KEYMAP.getOrDefault(key, KEY_NOT_FOUND);
        if (index != KEY_NOT_FOUND) {
            return this.propertyValues[index] != NOT_FOUND;
        }
        return super.containsKey(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @Trivial
    public Collection<Object> values() {
        return this.values != null ? this.values : (this.values = new Values());
    }

    @Override
    @Trivial
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = new EntrySet());
    }

    public Object getAuthorizationPolicy() {
        return this.getFromPropertyArray(authorizationPolicy);
    }

    public void setAuthorizationPolicy(Object a) {
        this.propertyValues[MessageImpl.authorizationPolicy] = a;
    }

    public Object getCertConstraints() {
        return this.getFromPropertyArray(certConstraints);
    }

    public void setCertConstraints(Object c) {
        this.propertyValues[MessageImpl.certConstraints] = c;
    }

    public Object getServiceRedirection() {
        return this.getFromPropertyArray(serviceRedirection);
    }

    public void setServiceRedirection(Object s) {
        this.propertyValues[MessageImpl.serviceRedirection] = s;
    }

    public Object getHttpServletResponse() {
        return this.getFromPropertyArray(httpServletResponse);
    }

    public void setHttpServletResponse(Object h) {
        this.propertyValues[MessageImpl.httpServletResponse] = h;
    }

    public Object getResourceMethod() {
        return this.getFromPropertyArray(resourceMethod);
    }

    public void setResourceMethod(Object r) {
        this.propertyValues[MessageImpl.resourceMethod] = r;
    }

    public Object getOneWayRequest() {
        return this.getFromPropertyArray(oneWayRequest);
    }

    public void setOneWayRequest(Object o) {
        this.propertyValues[MessageImpl.oneWayRequest] = o;
    }

    public Object getAsyncResponse() {
        return this.getFromPropertyArray(asyncResponse);
    }

    public void setAsyncResponse(Object a) {
        this.propertyValues[MessageImpl.asyncResponse] = a;
    }

    public Object getThreadContextSwitched() {
        return this.getFromPropertyArray(threadContextSwitched);
    }

    public void setThreadContextSwitched(Object t) {
        this.propertyValues[MessageImpl.threadContextSwitched] = t;
    }

    public Object getPreviousMessage() {
        return this.getFromPropertyArray(previousMessage);
    }

    public boolean containsPreviousMessage() {
        return this.propertyValues[previousMessage] != NOT_FOUND;
    }

    public void setPreviousMessage(Object p) {
        this.propertyValues[MessageImpl.previousMessage] = p;
    }

    public Object getCacheInputProperty() {
        return this.getFromPropertyArray(cacheInputProperty);
    }

    public void setCacheInputProperty(Object c) {
        this.propertyValues[MessageImpl.cacheInputProperty] = c;
    }

    public Object getSseEventSink() {
        return this.getFromPropertyArray(sseEventSink);
    }

    public void setSseEventSink(Object s) {
        this.propertyValues[MessageImpl.sseEventSink] = s;
    }

    public Object getResponseHeadersCopied() {
        return this.getFromPropertyArray(responseHeadersCopied);
    }

    public void setResponseHeadersCopied(Object r) {
        this.propertyValues[MessageImpl.responseHeadersCopied] = r;
    }

    public Object getRequestorRole() {
        return this.getFromPropertyArray(requestorRole);
    }

    public void setRequestorRole(Object r) {
        this.propertyValues[MessageImpl.requestorRole] = r;
    }

    public Object getEmptyPartialResponse() {
        return this.getFromPropertyArray(emptyPartialResponse);
    }

    public void setEmptyPartialResponse(Object e) {
        this.propertyValues[MessageImpl.emptyPartialResponse] = e;
    }

    public Object getPartialResponse() {
        return this.getFromPropertyArray(partialResponse);
    }

    public void setPartialResponse(Object p) {
        this.propertyValues[MessageImpl.partialResponse] = p;
    }

    public Object getEndpointAddress() {
        return this.getFromPropertyArray(endpointAddress);
    }

    public void setEndpointAddress(Object e) {
        this.propertyValues[MessageImpl.endpointAddress] = e;
    }

    public Object getInboundMessage() {
        return this.getFromPropertyArray(inboundMessage);
    }

    public void setInboundMessage(Object i) {
        this.propertyValues[MessageImpl.inboundMessage] = i;
    }

    public String getPathToMatchSlash() {
        return (String)this.getFromPropertyArray(pathToMatchSlash);
    }

    public void setPathToMatchSlash(String p) {
        this.propertyValues[MessageImpl.pathToMatchSlash] = p;
    }

    public String getHttpRequestMethod() {
        return (String)this.getFromPropertyArray(httpRequestMethod);
    }

    public void setHttpRequestMethod(String h) {
        this.propertyValues[MessageImpl.httpRequestMethod] = h;
    }

    public void removePathToMatchSlash() {
        this.propertyValues[MessageImpl.pathToMatchSlash] = NOT_FOUND;
    }

    public String getQueryString() {
        return (String)this.getFromPropertyArray(queryString);
    }

    public void setQueryString(String q) {
        this.propertyValues[MessageImpl.queryString] = q;
    }

    public Object getOperationResourceInfoStack() {
        return this.getFromPropertyArray(opStack);
    }

    public void setOperationResourceInfoStack(Object o) {
        this.propertyValues[MessageImpl.opStack] = o;
    }

    public String getContentType() {
        return (String)this.getFromPropertyArray(contentType);
    }

    public boolean containsContentType() {
        return this.propertyValues[contentType] != NOT_FOUND;
    }

    public void setContentType(String c) {
        this.propertyValues[MessageImpl.contentType] = c;
    }

    public Object getHttpRequest() {
        return this.getFromPropertyArray(httpRequest);
    }

    public boolean containsHttpRequest() {
        return this.propertyValues[httpRequest] != NOT_FOUND;
    }

    public void setHttpRequest(Object h) {
        this.propertyValues[MessageImpl.httpRequest] = h;
    }

    public Object getHttpResponse() {
        return this.getFromPropertyArray(httpResponse);
    }

    public void setHttpResponse(Object h) {
        this.propertyValues[MessageImpl.httpResponse] = h;
    }

    public Object getAccept() {
        return this.getFromPropertyArray(accept);
    }

    public void setAccept(Object a) {
        this.propertyValues[MessageImpl.accept] = a;
    }

    public Object getContinuationProvider() {
        return this.getFromPropertyArray(continuationProvider);
    }

    public void setContinuationProvider(Object c) {
        this.propertyValues[MessageImpl.continuationProvider] = c;
    }

    public Object getWsdlDescription() {
        return this.getFromPropertyArray(wsdlDescription);
    }

    public void setWsdlDescription(Object w) {
        this.propertyValues[MessageImpl.wsdlDescription] = w;
    }

    public Object getWsdlInterface() {
        return this.getFromPropertyArray(wsdlInterface);
    }

    public void setWsdlInterface(Object w) {
        this.propertyValues[MessageImpl.wsdlInterface] = w;
    }

    public Object getWsdlOperation() {
        return this.getFromPropertyArray(wsdlOperation);
    }

    public void setWsdlOperation(Object w) {
        this.propertyValues[MessageImpl.wsdlOperation] = w;
    }

    public Object getWsdlPort() {
        return this.getFromPropertyArray(wsdlPort);
    }

    public void setWsdlPort(Object w) {
        this.propertyValues[MessageImpl.wsdlPort] = w;
    }

    public Object getWsdlService() {
        return this.getFromPropertyArray(wsdlService);
    }

    public void setWsdlService(Object w) {
        this.propertyValues[MessageImpl.wsdlService] = w;
    }

    public Object getRequestUrl() {
        return this.getFromPropertyArray(requestUrl);
    }

    public void setRequestUrl(Object r) {
        this.propertyValues[MessageImpl.requestUrl] = r;
    }

    public Object getRequestUri() {
        return this.getFromPropertyArray(requestUri);
    }

    public void setRequestUri(Object r) {
        this.propertyValues[MessageImpl.requestUri] = r;
    }

    public Object getPathInfo() {
        return this.getFromPropertyArray(pathInfo);
    }

    public void setPathInfo(Object p) {
        this.propertyValues[MessageImpl.pathInfo] = p;
    }

    public Object getBasePath() {
        return this.getFromPropertyArray(basePath);
    }

    public boolean containsBasePath() {
        return this.propertyValues[basePath] != NOT_FOUND;
    }

    public void setBasePath(Object b) {
        this.propertyValues[MessageImpl.basePath] = b;
    }

    public Object getFixedParamOrder() {
        return this.getFromPropertyArray(fixedParamOrder);
    }

    public void setFixedParamOrder(Object f) {
        this.propertyValues[MessageImpl.fixedParamOrder] = f;
    }

    public Object getInInterceptors() {
        return this.getFromPropertyArray(inInterceptors);
    }

    public void setInInterceptors(Object i) {
        this.propertyValues[MessageImpl.inInterceptors] = i;
    }

    public Object getOutInterceptors() {
        return this.getFromPropertyArray(outInterceptors);
    }

    public void setOutInterceptors(Object o) {
        this.propertyValues[MessageImpl.outInterceptors] = o;
    }

    public Object getResponseCode() {
        return this.getFromPropertyArray(responseCode);
    }

    public void setResponseCode(Object r) {
        this.propertyValues[MessageImpl.responseCode] = r;
    }

    public Object getEncoding() {
        return this.getFromPropertyArray(encoding);
    }

    public void setEncoding(Object e) {
        this.propertyValues[MessageImpl.encoding] = e;
    }

    public Object getHttpContext() {
        return this.getFromPropertyArray(httpContext);
    }

    public void setHttpContext(Object h) {
        this.propertyValues[MessageImpl.httpContext] = h;
    }

    public Object getHttpConfig() {
        return this.getFromPropertyArray(httpConfig);
    }

    public void setHttpConfig(Object h) {
        this.propertyValues[MessageImpl.httpConfig] = h;
    }

    public Object getHttpContextMatchStrategy() {
        return this.getFromPropertyArray(httpContextMatchStrategy);
    }

    public void setHttpContextMatchStrategy(Object h) {
        this.propertyValues[MessageImpl.httpContextMatchStrategy] = h;
    }

    public Object getHttpBasePath() {
        return this.getFromPropertyArray(httpBasePath);
    }

    public void setHttpBasePath(Object h) {
        this.propertyValues[MessageImpl.httpBasePath] = h;
    }

    public Object getAsyncPostDispatch() {
        return this.getFromPropertyArray(asyncPostDispatch);
    }

    public void setAsyncPostDispatch(Object a) {
        this.propertyValues[MessageImpl.asyncPostDispatch] = a;
    }

    public Object getSecurityContext() {
        return this.getFromPropertyArray(securityContext);
    }

    public void setSecurityContext(Object s) {
        this.propertyValues[MessageImpl.securityContext] = s;
    }

    public Collection getInterceptorProviders() {
        return (Collection)this.getFromPropertyArray(interceptorProviders);
    }

    public void setInterceptorProviders(Collection i) {
        this.propertyValues[MessageImpl.interceptorProviders] = i;
    }

    public Object getTemplateParameters() {
        return this.getFromPropertyArray(templateParameters);
    }

    public void setTemplateParameters(Object t) {
        this.propertyValues[MessageImpl.templateParameters] = t;
    }

    public void removeContentType() {
        this.propertyValues[MessageImpl.contentType] = NOT_FOUND;
    }

    public void removeHttpResponse() {
        this.propertyValues[MessageImpl.httpResponse] = NOT_FOUND;
    }

    public void removeHttpRequest() {
        this.propertyValues[MessageImpl.httpRequest] = NOT_FOUND;
    }

    private Object getFromPropertyArray(int index) {
        Object value = this.propertyValues[index];
        return value == NOT_FOUND ? null : value;
    }

    @Override
    public int size() {
        int size = super.size();
        for (Object o : this.propertyValues) {
            if (o == NOT_FOUND) continue;
            ++size;
        }
        return size;
    }

    @Override
    public void clear() {
        super.clear();
        for (int i = 0; i < TOTAL; ++i) {
            this.propertyValues[i] = NOT_FOUND;
        }
    }

    @Override
    public boolean isEmpty() {
        if (!super.isEmpty()) {
            return false;
        }
        for (Object o : this.propertyValues) {
            if (o == NOT_FOUND) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsValue(Object value) {
        if (super.containsValue(value)) {
            return true;
        }
        if (value == null) {
            for (Object o : this.propertyValues) {
                if (o != null) continue;
                return true;
            }
        } else {
            for (Object o : this.propertyValues) {
                if (o == null || o == NOT_FOUND || !value.equals(o)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getOrDefault(Object key, Object d) {
        return this.getOrDefault((String)key, d);
    }

    public Object getOrDefault(String key, Object d) {
        Integer index = KEYMAP.getOrDefault(key, KEY_NOT_FOUND);
        if (index != KEY_NOT_FOUND) {
            return this.propertyValues[index] == NOT_FOUND ? d : this.propertyValues[index];
        }
        return super.getOrDefault(key, d);
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super Object> action) {
        super.forEach(action);
        for (int i = 0; i < TOTAL; ++i) {
            if (this.propertyValues[i] == NOT_FOUND) continue;
            action.accept(propertyNames[i], this.propertyValues[i]);
        }
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super Object, ? extends Object> function) {
        super.replaceAll(function);
        for (int i = 0; i < TOTAL; ++i) {
            if (this.propertyValues[i] == NOT_FOUND) continue;
            this.propertyValues[i] = function.apply(propertyNames[i], this.propertyValues[i]);
        }
    }

    @Override
    public Object replace(String key, Object value) {
        Integer index = KEYMAP.getOrDefault(key, KEY_NOT_FOUND);
        if (index != KEY_NOT_FOUND) {
            if (this.propertyValues[index] != NOT_FOUND) {
                Object ret = this.propertyValues[index];
                this.propertyValues[index.intValue()] = value;
                return ret;
            }
            return null;
        }
        return super.replace(key, value);
    }

    @Override
    public boolean replace(String key, Object oldValue, Object newValue) {
        Integer index = KEYMAP.getOrDefault(key, KEY_NOT_FOUND);
        if (index != KEY_NOT_FOUND) {
            if (this.propertyValues[index] != NOT_FOUND) {
                if (oldValue == null) {
                    if (this.propertyValues[index] == null) {
                        this.propertyValues[index.intValue()] = newValue;
                        return true;
                    }
                    return false;
                }
                if (this.propertyValues[index] == null) {
                    return false;
                }
                if (oldValue.equals(this.propertyValues[index])) {
                    this.propertyValues[index.intValue()] = newValue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return super.replace(key, oldValue, newValue);
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        Integer index = KEYMAP.getOrDefault(key, KEY_NOT_FOUND);
        if (index != KEY_NOT_FOUND) {
            if (this.propertyValues[index] == NOT_FOUND) {
                this.propertyValues[index.intValue()] = value;
                return null;
            }
            return this.propertyValues[index];
        }
        return super.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Integer index = KEYMAP.getOrDefault(key, KEY_NOT_FOUND);
        if (index != KEY_NOT_FOUND) {
            if (this.propertyValues[index] != NOT_FOUND) {
                if (value == null) {
                    if (this.propertyValues[index] == null) {
                        this.propertyValues[index.intValue()] = NOT_FOUND;
                        return true;
                    }
                    return false;
                }
                if (this.propertyValues[index] == null) {
                    return false;
                }
                if (value.equals(this.propertyValues[index])) {
                    this.propertyValues[index.intValue()] = NOT_FOUND;
                    return true;
                }
                return false;
            }
            return false;
        }
        return super.remove(key, value);
    }

    @Override
    public Object compute(String key, BiFunction<? super String, ? super Object, ? extends Object> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        Integer index = KEYMAP.getOrDefault(key, KEY_NOT_FOUND);
        if (index != KEY_NOT_FOUND) {
            Object newValue = remappingFunction.apply(key, this.propertyValues[index] == NOT_FOUND ? null : this.propertyValues[index]);
            this.propertyValues[index.intValue()] = newValue == null ? NOT_FOUND : newValue;
            return newValue;
        }
        return super.compute(key, remappingFunction);
    }

    @Override
    public Object computeIfAbsent(String key, Function<? super String, ? extends Object> mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        Integer index = KEYMAP.getOrDefault(key, KEY_NOT_FOUND);
        if (index != KEY_NOT_FOUND) {
            if (this.propertyValues[index] == NOT_FOUND) {
                Object newValue = mappingFunction.apply(key);
                if (newValue != null) {
                    this.propertyValues[index.intValue()] = newValue;
                }
                return newValue;
            }
            return this.getFromPropertyArray(index);
        }
        return super.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public Object computeIfPresent(String key, BiFunction<? super String, ? super Object, ? extends Object> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        Integer index = KEYMAP.getOrDefault(key, KEY_NOT_FOUND);
        if (index != KEY_NOT_FOUND) {
            if (this.propertyValues[index] != NOT_FOUND) {
                Object newValue = remappingFunction.apply(key, this.propertyValues[index]);
                this.propertyValues[index.intValue()] = newValue == null ? NOT_FOUND : newValue;
                return newValue;
            }
            return null;
        }
        return super.computeIfPresent(key, remappingFunction);
    }

    @Override
    public Object merge(String key, Object value, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        if (value == null || remappingFunction == null) {
            throw new NullPointerException();
        }
        Integer index = KEYMAP.getOrDefault(key, KEY_NOT_FOUND);
        if (index != KEY_NOT_FOUND) {
            if (this.propertyValues[index] != NOT_FOUND && this.propertyValues[index] != null) {
                Object newValue = remappingFunction.apply(this.propertyValues[index], value);
                this.propertyValues[index.intValue()] = newValue == null ? NOT_FOUND : newValue;
            } else {
                this.propertyValues[index.intValue()] = value;
            }
            return this.getFromPropertyArray(index);
        }
        return super.merge(key, value, remappingFunction);
    }

    public String[] getPropertyNames() {
        return propertyNames;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.message.MessageImpl", MessageImpl.class, null, null);
        contentType = 0;
        protoHeaders = 1;
        queryString = 2;
        httpRequest = 3;
        httpResponse = 4;
        pathToMatchSlash = 5;
        httpRequestMethod = 6;
        interceptorProviders = 7;
        templateParameters = 8;
        accept = 9;
        continuationProvider = 10;
        destination = 11;
        opStack = 12;
        wsdlDescription = 13;
        wsdlInterface = 14;
        wsdlOperation = 15;
        wsdlPort = 16;
        wsdlService = 17;
        requestUrl = 18;
        requestUri = 19;
        pathInfo = 20;
        basePath = 21;
        fixedParamOrder = 22;
        inInterceptors = 23;
        outInterceptors = 24;
        responseCode = 25;
        attachments = 26;
        encoding = 27;
        httpContext = 28;
        httpConfig = 29;
        httpContextMatchStrategy = 30;
        httpBasePath = 31;
        asyncPostDispatch = 32;
        securityContext = 33;
        authorizationPolicy = 34;
        certConstraints = 35;
        serviceRedirection = 36;
        httpServletResponse = 37;
        resourceMethod = 38;
        oneWayRequest = 39;
        asyncResponse = 40;
        threadContextSwitched = 41;
        cacheInputProperty = 42;
        previousMessage = 43;
        responseHeadersCopied = 44;
        sseEventSink = 45;
        requestorRole = 46;
        partialResponse = 47;
        emptyPartialResponse = 48;
        endpointAddress = 49;
        inboundMessage = 50;
        TOTAL = 51;
        CONTINUATION_PROVIDER = ContinuationProvider.class.getName();
        DESTINATION = Destination.class.getName();
        SECURITY_CONTEXT = SecurityContext.class.getName();
        AUTHORIZATION_POLICY = AuthorizationPolicy.class.getName();
        CERT_CONSTRAINTS = CertConstraints.class.getName();
        HTTP_SERVLET_RESPONSE = HttpServletResponse.class.getName();
        propertyNames = new String[]{"Content-Type", PROTOCOL_HEADERS, QUERY_STRING, "HTTP.REQUEST", "HTTP.RESPONSE", REQUEST_PATH_TO_MATCH_SLASH, "org.apache.cxf.request.method", INTERCEPTOR_PROVIDERS, TEMPLATE_PARAMETERS, "Accept", CONTINUATION_PROVIDER, DESTINATION, OP_RES_INFO_STACK, "javax.xml.ws.wsdl.description", "javax.xml.ws.wsdl.interface", "javax.xml.ws.wsdl.operation", "javax.xml.ws.wsdl.port", "javax.xml.ws.wsdl.service", "org.apache.cxf.request.url", "org.apache.cxf.request.uri", PATH_INFO, BASE_PATH, FIXED_PARAMETER_ORDER, IN_INTERCEPTORS, OUT_INTERCEPTORS, RESPONSE_CODE, ATTACHMENTS, ENCODING, "HTTP.CONTEXT", "HTTP.CONFIG", "HTTP_CONTEXT_MATCH_STRATEGY", HTTP_BASE_PATH, "org.apache.cxf.async.post.response.dispatch", SECURITY_CONTEXT, AUTHORIZATION_POLICY, CERT_CONSTRAINTS, "http.service.redirection", HTTP_SERVLET_RESPONSE, RESOURCE_METHOD, "OnewayRequest", ASYNC_RESPONSE, "thread.context.switched", "cxf.io.cacheinput", PhaseInterceptorChain.PREVIOUS_MESSAGE, "http.headers.copied", SSE_EVENT_SINK, "org.apache.cxf.client", "org.apache.cxf.partial.response", "org.apache.cxf.partial.response.empty", ENDPOINT_ADDRESS, "org.apache.cxf.message.inbound"};
        NOT_FOUND = new Object();
        KEY_NOT_FOUND = -1;
        NOT_SET_ARRAY = new Object[TOTAL];
        HashMap<String, Integer> keymap = new HashMap<String, Integer>(TOTAL);
        for (int i = 0; i < TOTAL; ++i) {
            keymap.put(propertyNames[i], i);
            MessageImpl.NOT_SET_ARRAY[i] = NOT_FOUND;
        }
        KEYMAP = Collections.unmodifiableMap(keymap);
    }

    @Trivial
    final class EntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        EntrySet() {
        }

        @Override
        public final int size() {
            return MessageImpl.this.size();
        }

        @Override
        public final void clear() {
            MessageImpl.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<String, Object>> iterator() {
            return new EntryIterator();
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            String key = (String)e.getKey();
            Object val = MessageImpl.this.getOrDefault(key, NOT_FOUND);
            if (val != NOT_FOUND) {
                AbstractMap.SimpleEntry<String, Object> entry = new AbstractMap.SimpleEntry<String, Object>(key, val);
                return e.equals(entry);
            }
            return false;
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object val = e.getValue();
                return MessageImpl.this.remove(key, val);
            }
            return false;
        }

        @Override
        public final Spliterator<Map.Entry<String, Object>> spliterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void forEach(Consumer<? super Map.Entry<String, Object>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            for (int i = 0; i < TOTAL; ++i) {
                if (MessageImpl.this.propertyValues[i] == NOT_FOUND) continue;
                action.accept(new AbstractMap.SimpleEntry<String, Object>(propertyNames[i], MessageImpl.this.propertyValues[i]));
            }
            for (Map.Entry e : MessageImpl.super.entrySet()) {
                action.accept(e);
            }
        }
    }

    @Trivial
    final class Values
    extends AbstractCollection<Object> {
        Values() {
        }

        @Override
        public final int size() {
            return MessageImpl.this.size();
        }

        @Override
        public final void clear() {
            MessageImpl.this.clear();
        }

        @Override
        public final Iterator<Object> iterator() {
            return new ValuesIterator();
        }

        @Override
        public final boolean contains(Object o) {
            return MessageImpl.this.containsValue(o);
        }

        @Override
        public final Spliterator<Object> spliterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void forEach(Consumer<? super Object> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            for (int i = 0; i < TOTAL; ++i) {
                if (MessageImpl.this.propertyValues[i] == NOT_FOUND) continue;
                action.accept(MessageImpl.this.propertyValues[i]);
            }
            for (Object v : MessageImpl.super.values()) {
                action.accept(v);
            }
        }
    }

    @Trivial
    final class KeySet
    extends AbstractSet<String> {
        KeySet() {
        }

        @Override
        public final int size() {
            return MessageImpl.this.size();
        }

        @Override
        public final void clear() {
            MessageImpl.this.clear();
        }

        @Override
        public final Iterator<String> iterator() {
            return new KeyIterator();
        }

        @Override
        public final boolean contains(Object o) {
            return MessageImpl.this.containsKey(o);
        }

        @Override
        public final boolean remove(Object key) {
            if (MessageImpl.this.containsKey(key)) {
                MessageImpl.this.remove(key);
                return true;
            }
            return false;
        }

        @Override
        public final Spliterator<String> spliterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void forEach(Consumer<? super String> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            for (int i = 0; i < TOTAL; ++i) {
                if (MessageImpl.this.propertyValues[i] == NOT_FOUND) continue;
                action.accept(propertyNames[i]);
            }
            for (String k : MessageImpl.super.keySet()) {
                action.accept(k);
            }
        }
    }

    @Trivial
    final class ValuesIterator
    extends MessageIterator<Object> {
        ValuesIterator() {
            super(MessageImpl.super.values().iterator());
        }

        @Override
        Object getNextFromProperties(int index) {
            return MessageImpl.this.propertyValues[index];
        }
    }

    @Trivial
    final class EntryIterator
    extends MessageIterator<Map.Entry<String, Object>> {
        EntryIterator() {
            super(MessageImpl.super.entrySet().iterator());
        }

        @Override
        Map.Entry<String, Object> getNextFromProperties(int index) {
            return new AbstractMap.SimpleEntry<String, Object>(propertyNames[index], MessageImpl.this.propertyValues[index]);
        }
    }

    @Trivial
    final class KeyIterator
    extends MessageIterator<String> {
        KeyIterator() {
            super(MessageImpl.super.keySet().iterator());
        }

        @Override
        String getNextFromProperties(int index) {
            return propertyNames[index];
        }
    }

    @Trivial
    abstract class MessageIterator<T>
    implements Iterator<T> {
        Iterator<T> backedIterator;
        int current = -1;
        int next = -1;
        boolean removeAllowed = false;

        MessageIterator(Iterator<T> it) {
            this.backedIterator = it;
        }

        @Override
        public final boolean hasNext() {
            if (this.backedIterator.hasNext()) {
                return true;
            }
            if (this.next == TOTAL) {
                return false;
            }
            if (this.next > this.current) {
                return true;
            }
            this.next = this.current + 1;
            while (this.next < TOTAL) {
                if (MessageImpl.this.propertyValues[this.next] != NOT_FOUND) {
                    return true;
                }
                ++this.next;
            }
            return false;
        }

        @Override
        public final T next() {
            if (this.hasNext()) {
                if (this.next == -1) {
                    this.removeAllowed = true;
                    return this.backedIterator.next();
                }
                this.current = this.next;
                this.removeAllowed = true;
                return this.getNextFromProperties(this.next);
            }
            this.removeAllowed = false;
            throw new NoSuchElementException();
        }

        @Override
        public final void remove() {
            if (!this.removeAllowed) {
                throw new IllegalStateException();
            }
            if (this.current == -1) {
                this.backedIterator.remove();
            } else {
                ((MessageImpl)MessageImpl.this).propertyValues[this.current] = NOT_FOUND;
            }
            this.removeAllowed = false;
        }

        abstract T getNextFromProperties(int var1);
    }
}

