/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.WebServicePermission;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.http.HTTPBinding;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.BindingConfiguration;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.common.util.ModCountCopyOnWriteArrayList;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.WSDLGetUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxws.EndpointReferenceBuilder;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class EndpointImpl
extends javax.xml.ws.Endpoint
implements InterceptorProvider,
Configurable {
    public static final String CHECK_PUBLISH_ENDPOINT_PERMISSON_PROPERTY = "org.apache.cxf.jaxws.checkPublishEndpointPermission";
    public static final String CHECK_PUBLISH_ENDPOINT_PERMISSON_PROPERTY_WITH_SECURITY_MANAGER = "org.apache.cxf.jaxws.checkPublishEndpointPermissionWithSecurityManager";
    private static final WebServicePermission PUBLISH_PERMISSION = new WebServicePermission("publishEndpoint");
    private static final Logger LOG = LogUtils.getL7dLogger(EndpointImpl.class);
    private Bus bus;
    private Object implementor;
    private Server server;
    private JaxWsServerFactoryBean serverFactory;
    private JaxWsServiceFactoryBean serviceFactory;
    private Service service;
    private Map<String, Object> properties;
    private List<Source> metadata;
    private Invoker invoker;
    private Executor executor;
    private String bindingUri;
    private String wsdlLocation;
    private String address;
    private String publishedEndpointUrl;
    private QName endpointName;
    private QName serviceName;
    private Class<?> implementorClass;
    private List<String> schemaLocations;
    private List<AbstractFeature> features;
    private List<Interceptor<? extends Message>> in;
    private List<Interceptor<? extends Message>> out;
    private List<Interceptor<? extends Message>> outFault;
    private List<Interceptor<? extends Message>> inFault;
    private List<Handler> handlers;
    private boolean publishable;
    static final long serialVersionUID = 1519532561500399788L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EndpointImpl(Object implementor) {
        this(BusFactory.getThreadDefaultBus(), implementor);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "<init>", new Object[]{implementor});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EndpointImpl(Bus b, Object implementor, JaxWsServerFactoryBean sf) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "<init>", new Object[]{b, implementor, sf});
        }
        this.in = new ModCountCopyOnWriteArrayList();
        this.out = new ModCountCopyOnWriteArrayList();
        this.outFault = new ModCountCopyOnWriteArrayList();
        this.inFault = new ModCountCopyOnWriteArrayList();
        this.handlers = new ModCountCopyOnWriteArrayList();
        this.publishable = true;
        this.bus = b;
        this.serverFactory = sf;
        this.implementor = implementor;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EndpointImpl(Bus b, Object i, String bindingUri, String wsdl) {
        this(b, i, bindingUri, wsdl, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "<init>", new Object[]{b, i, bindingUri, wsdl});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EndpointImpl(Bus b, Object i, String bindingUri, String wsdl, WebServiceFeature[] f) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "<init>", new Object[]{b, i, bindingUri, wsdl, f});
        }
        this.in = new ModCountCopyOnWriteArrayList();
        this.out = new ModCountCopyOnWriteArrayList();
        this.outFault = new ModCountCopyOnWriteArrayList();
        this.inFault = new ModCountCopyOnWriteArrayList();
        this.handlers = new ModCountCopyOnWriteArrayList();
        this.publishable = true;
        this.bus = b;
        this.implementor = i;
        this.bindingUri = bindingUri;
        this.wsdlLocation = wsdl == null ? null : new String(wsdl);
        this.serverFactory = new JaxWsServerFactoryBean();
        if (f != null) {
            ((JaxWsServiceFactoryBean)this.serverFactory.getServiceFactory()).setWsFeatures(Arrays.asList(f));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EndpointImpl(Bus b, Object i, String bindingUri) {
        this(b, i, bindingUri, (String)null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "<init>", new Object[]{b, i, bindingUri});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EndpointImpl(Bus b, Object i, String bindingUri, WebServiceFeature[] features) {
        this(b, i, bindingUri, null, features);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "<init>", new Object[]{b, i, bindingUri, features});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EndpointImpl(Bus bus, Object implementor) {
        this(bus, implementor, (String)null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "<init>", new Object[]{bus, implementor});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setBus(Bus b) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setBus", new Object[]{b});
        }
        this.bus = b;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setBus");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Bus getBus() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getBus", new Object[0]);
        }
        Bus bus = this.bus;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bus = bus;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getBus", bus);
        }
        return bus;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Binding getBinding() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getBinding", new Object[0]);
        }
        Binding binding = ((JaxWsEndpointImpl)this.getEndpoint()).getJaxwsBinding();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            binding = binding;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getBinding", binding);
        }
        return binding;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setExecutor(Executor executor) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setExecutor", new Object[]{executor});
        }
        this.executor = executor;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setExecutor");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Executor getExecutor() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getExecutor", new Object[0]);
        }
        Executor executor = this.executor;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            executor = executor;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getExecutor", executor);
        }
        return executor;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Service getService() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getService", new Object[0]);
        }
        Service service = this.service;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            service = service;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getService", service);
        }
        return service;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JaxWsServiceFactoryBean getServiceFactory() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getServiceFactory", new Object[0]);
        }
        JaxWsServiceFactoryBean jaxWsServiceFactoryBean = this.serviceFactory;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            jaxWsServiceFactoryBean = jaxWsServiceFactoryBean;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getServiceFactory", (Object)jaxWsServiceFactoryBean);
        }
        return jaxWsServiceFactoryBean;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object getImplementor() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getImplementor", new Object[0]);
        }
        Object object = this.implementor;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getImplementor", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Class<?> getImplementorClass() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getImplementorClass", new Object[0]);
        }
        Class clazz = this.implementorClass != null ? this.implementorClass : ClassHelper.getRealClass((Object)this.implementor);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getImplementorClass", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Source> getMetadata() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getMetadata", new Object[0]);
        }
        List<Source> list = this.metadata;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getMetadata", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Object> getProperties() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getProperties", new Object[0]);
        }
        if (this.server != null) {
            Endpoint endpoint = this.server.getEndpoint();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                endpoint = endpoint;
                LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getProperties", endpoint);
            }
            return endpoint;
        }
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        Map<String, Object> map = this.properties;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getProperties", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isPublished() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "isPublished", new Object[0]);
        }
        boolean bl = this.server != null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "isPublished", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void publish(Object arg0) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "publish", new Object[]{arg0});
        }
        this.checkPublishPermission();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "publish");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void publish(String addr) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "publish", new Object[]{addr});
        }
        this.doPublish(addr);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "publish");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setServiceFactory(JaxWsServiceFactoryBean sf) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setServiceFactory", new Object[]{sf});
        }
        this.serviceFactory = sf;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setServiceFactory");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setMetadata(List<Source> metadata) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setMetadata", new Object[]{metadata});
        }
        this.checkPublishable();
        this.metadata = metadata;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setMetadata");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setProperties(Map<String, Object> properties) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setProperties", new Object[]{properties});
        }
        this.properties = properties;
        if (this.server != null) {
            this.server.getEndpoint().putAll(properties);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setProperties");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void stop() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "stop", new Object[0]);
        }
        if (null != this.server) {
            this.server.destroy();
            this.server = null;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "stop");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getBeanName() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getBeanName", new Object[0]);
        }
        String string = this.endpointName.toString() + ".jaxws-endpoint";
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getBeanName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JaxWsServerFactoryBean getServerFactory() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getServerFactory", new Object[0]);
        }
        JaxWsServerFactoryBean jaxWsServerFactoryBean = this.serverFactory;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            jaxWsServerFactoryBean = jaxWsServerFactoryBean;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getServerFactory", (Object)jaxWsServerFactoryBean);
        }
        return jaxWsServerFactoryBean;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setServerFactory(JaxWsServerFactoryBean bean) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setServerFactory", new Object[]{bean});
        }
        this.serverFactory = bean;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setServerFactory");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void checkProperties() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "checkProperties", new Object[0]);
        }
        if (this.properties != null) {
            if (this.properties.containsKey("javax.xml.ws.wsdl.description")) {
                this.wsdlLocation = this.properties.get("javax.xml.ws.wsdl.description").toString();
            }
            if (this.properties.containsKey("javax.xml.ws.wsdl.port")) {
                this.endpointName = (QName)this.properties.get("javax.xml.ws.wsdl.port");
            }
            if (this.properties.containsKey("javax.xml.ws.wsdl.service")) {
                this.serviceName = (QName)this.properties.get("javax.xml.ws.wsdl.service");
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "checkProperties");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void doPublish(String addr) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "doPublish", new Object[]{addr});
        }
        this.checkPublishPermission();
        this.checkPublishable();
        ServerImpl serv = null;
        ClassLoaderUtils.ClassLoaderHolder loader = null;
        try {
            ClassLoader newLoader;
            if (this.bus != null && (newLoader = (ClassLoader)this.bus.getExtension(ClassLoader.class)) != null) {
                loader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)newLoader);
            }
            serv = this.getServer(addr);
            if (addr != null) {
                EndpointInfo endpointInfo = serv.getEndpoint().getEndpointInfo();
                if (!endpointInfo.getAddress().contains(addr)) {
                    endpointInfo.setAddress(addr);
                }
                if (this.publishedEndpointUrl != null) {
                    endpointInfo.setProperty("publishedEndpointUrl", (Object)this.publishedEndpointUrl);
                    Definition def = (Definition)endpointInfo.getService().getProperty(WSDLServiceBuilder.WSDL_DEFINITION, Definition.class);
                    if (def == null) {
                        def = ((WSDLManager)this.bus.getExtension(WSDLManager.class)).getDefinition(this.wsdlLocation);
                    }
                    new WSDLGetUtils().updateWSDLPublishedEndpointAddress(def, endpointInfo);
                }
                if (null != this.properties) {
                    for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                        endpointInfo.setProperty(entry.getKey(), entry.getValue());
                    }
                }
                this.address = endpointInfo.getAddress();
            }
            serv.start();
            this.publishable = false;
        }
        catch (Exception ex) {
            try {
                this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new WebServiceException((Throwable)ex);
        }
        finally {
            if (loader != null) {
                loader.reset();
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "doPublish");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ServerImpl getServer() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getServer", new Object[0]);
        }
        ServerImpl serverImpl = this.getServer(null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            serverImpl = serverImpl;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getServer", serverImpl);
        }
        return serverImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized ServerImpl getServer(String addr) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getServer", new Object[]{addr});
        }
        if (this.server == null) {
            this.checkProperties();
            ClassLoaderUtils.ClassLoaderHolder loader = null;
            try {
                ClassLoader newLoader;
                if (this.bus != null && (newLoader = (ClassLoader)this.bus.getExtension(ClassLoader.class)) != null) {
                    loader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)newLoader);
                }
                QName origEpn = this.endpointName;
                if (this.endpointName == null) {
                    JaxWsImplementorInfo implInfo = new JaxWsImplementorInfo(this.getImplementorClass());
                    this.endpointName = implInfo.getEndpointName();
                }
                if (this.serviceFactory != null) {
                    this.serverFactory.setServiceFactory(this.serviceFactory);
                }
                this.configureObject((Object)this);
                this.endpointName = origEpn;
                this.serverFactory.setAddress(addr);
                this.serverFactory.setStart(false);
                this.serverFactory.setEndpointName(this.endpointName);
                this.serverFactory.setServiceBean(this.implementor);
                this.serverFactory.setBus(this.bus);
                this.serverFactory.setFeatures(this.getFeatures());
                this.serverFactory.setInvoker(this.invoker);
                this.serverFactory.setSchemaLocations(this.schemaLocations);
                if (this.serverFactory.getProperties() != null) {
                    this.serverFactory.getProperties().putAll(this.properties);
                } else {
                    this.serverFactory.setProperties(this.properties);
                }
                if (this.getWsdlLocation() != null) {
                    this.serverFactory.setWsdlURL(this.getWsdlLocation());
                }
                if (this.bindingUri != null) {
                    this.serverFactory.setBindingId(this.bindingUri);
                }
                if (this.serviceName != null) {
                    this.serverFactory.getServiceFactory().setServiceName(this.serviceName);
                }
                if (this.implementorClass != null) {
                    this.serverFactory.setServiceClass(this.implementorClass);
                }
                if (this.executor != null) {
                    this.serverFactory.getServiceFactory().setExecutor(this.executor);
                }
                if (this.handlers.size() > 0) {
                    this.serverFactory.addHandlers(this.handlers);
                }
                this.configureObject((Object)this.serverFactory);
                this.server = this.serverFactory.create();
                Endpoint endpoint = this.getEndpoint();
                if (this.in != null) {
                    endpoint.getInInterceptors().addAll(this.in);
                }
                if (this.out != null) {
                    endpoint.getOutInterceptors().addAll(this.out);
                }
                if (this.inFault != null) {
                    endpoint.getInFaultInterceptors().addAll(this.inFault);
                }
                if (this.outFault != null) {
                    endpoint.getOutFaultInterceptors().addAll(this.outFault);
                }
                if (this.properties != null) {
                    endpoint.putAll(this.properties);
                }
                this.configureObject(endpoint.getService());
                this.configureObject(endpoint);
                this.service = endpoint.getService();
                if (this.getWsdlLocation() == null) {
                    this.setWsdlLocation(this.serverFactory.getWsdlURL());
                }
                if (this.serviceName == null) {
                    this.setServiceName(this.serverFactory.getServiceFactory().getServiceQName());
                }
                if (this.endpointName == null) {
                    this.endpointName = endpoint.getEndpointInfo().getName();
                }
            }
            finally {
                if (loader != null) {
                    loader.reset();
                }
            }
        }
        ServerImpl serverImpl = (ServerImpl)this.server;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            serverImpl = serverImpl;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getServer", serverImpl);
        }
        return serverImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    Endpoint getEndpoint() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getEndpoint", new Object[0]);
        }
        Endpoint endpoint = this.getServer(null).getEndpoint();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            endpoint = endpoint;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getEndpoint", endpoint);
        }
        return endpoint;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void configureObject(Object instance) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "configureObject", new Object[]{instance});
        }
        Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(instance);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "configureObject");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void checkPublishPermission() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "checkPublishPermission", new Object[0]);
        }
        SecurityManager sm = System.getSecurityManager();
        boolean checkPublishEndpointPermissionWithSecurityManager = Boolean.valueOf(SystemPropertyAction.getProperty((String)CHECK_PUBLISH_ENDPOINT_PERMISSON_PROPERTY_WITH_SECURITY_MANAGER, (String)"true"));
        if (checkPublishEndpointPermissionWithSecurityManager && sm != null) {
            sm.checkPermission((Permission)PUBLISH_PERMISSION);
        } else if (Boolean.getBoolean(CHECK_PUBLISH_ENDPOINT_PERMISSON_PROPERTY)) {
            AccessController.checkPermission((Permission)PUBLISH_PERMISSION);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "checkPublishPermission");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void checkPublishable() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "checkPublishable", new Object[0]);
        }
        if (!this.publishable) {
            throw new IllegalStateException("Cannot invoke method after endpoint has been published.");
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "checkPublishable");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void publish() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "publish", new Object[0]);
        }
        this.publish(this.getAddress());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "publish");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getAddress() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getAddress", new Object[0]);
        }
        String string = this.address;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getAddress", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setAddress(String address) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setAddress", new Object[]{address});
        }
        this.address = address;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setAddress");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPublishedEndpointUrl() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getPublishedEndpointUrl", new Object[0]);
        }
        String string = this.publishedEndpointUrl;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getPublishedEndpointUrl", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setPublishedEndpointUrl(String publishedEndpointUrl) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setPublishedEndpointUrl", new Object[]{publishedEndpointUrl});
        }
        this.publishedEndpointUrl = publishedEndpointUrl;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setPublishedEndpointUrl");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getEndpointName() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getEndpointName", new Object[0]);
        }
        QName qName = this.endpointName;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getEndpointName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setEndpointName(QName endpointName) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setEndpointName", new Object[]{endpointName});
        }
        this.endpointName = endpointName;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setEndpointName");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getServiceName() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getServiceName", new Object[0]);
        }
        QName qName = this.serviceName;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getServiceName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setServiceName(QName serviceName) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setServiceName", new Object[]{serviceName});
        }
        this.serviceName = serviceName;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setServiceName");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getWsdlLocation() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getWsdlLocation", new Object[0]);
        }
        String string = this.wsdlLocation;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getWsdlLocation", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setWsdlLocation(String wsdlLocation) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setWsdlLocation", new Object[]{wsdlLocation});
        }
        this.wsdlLocation = wsdlLocation != null ? new String(wsdlLocation) : null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setWsdlLocation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setBindingUri(String binding) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setBindingUri", new Object[]{binding});
        }
        this.bindingUri = binding;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setBindingUri");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getBindingUri() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getBindingUri", new Object[0]);
        }
        String string = this.bindingUri;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getBindingUri", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setDataBinding(DataBinding dataBinding) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setDataBinding", new Object[]{dataBinding});
        }
        this.serverFactory.setDataBinding(dataBinding);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setDataBinding");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DataBinding getDataBinding() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getDataBinding", new Object[0]);
        }
        DataBinding dataBinding = this.serverFactory.getDataBinding();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            dataBinding = dataBinding;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getDataBinding", dataBinding);
        }
        return dataBinding;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Interceptor<? extends Message>> getOutFaultInterceptors() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getOutFaultInterceptors", new Object[0]);
        }
        if (this.server == null) {
            List<Interceptor<? extends Message>> list = this.outFault;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                list = list;
                LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getOutFaultInterceptors", list);
            }
            return list;
        }
        DoubleAddInterceptorList doubleAddInterceptorList = new DoubleAddInterceptorList(this.outFault, this.server.getEndpoint().getOutFaultInterceptors());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            doubleAddInterceptorList = doubleAddInterceptorList;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getOutFaultInterceptors", doubleAddInterceptorList);
        }
        return doubleAddInterceptorList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Interceptor<? extends Message>> getInFaultInterceptors() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getInFaultInterceptors", new Object[0]);
        }
        if (this.server == null) {
            List<Interceptor<? extends Message>> list = this.inFault;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                list = list;
                LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getInFaultInterceptors", list);
            }
            return list;
        }
        DoubleAddInterceptorList doubleAddInterceptorList = new DoubleAddInterceptorList(this.inFault, this.server.getEndpoint().getInFaultInterceptors());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            doubleAddInterceptorList = doubleAddInterceptorList;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getInFaultInterceptors", doubleAddInterceptorList);
        }
        return doubleAddInterceptorList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Interceptor<? extends Message>> getInInterceptors() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getInInterceptors", new Object[0]);
        }
        if (this.server == null) {
            List<Interceptor<? extends Message>> list = this.in;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                list = list;
                LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getInInterceptors", list);
            }
            return list;
        }
        DoubleAddInterceptorList doubleAddInterceptorList = new DoubleAddInterceptorList(this.in, this.server.getEndpoint().getInInterceptors());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            doubleAddInterceptorList = doubleAddInterceptorList;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getInInterceptors", doubleAddInterceptorList);
        }
        return doubleAddInterceptorList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Interceptor<? extends Message>> getOutInterceptors() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getOutInterceptors", new Object[0]);
        }
        if (this.server == null) {
            List<Interceptor<? extends Message>> list = this.out;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                list = list;
                LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getOutInterceptors", list);
            }
            return list;
        }
        DoubleAddInterceptorList doubleAddInterceptorList = new DoubleAddInterceptorList(this.out, this.server.getEndpoint().getOutInterceptors());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            doubleAddInterceptorList = doubleAddInterceptorList;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getOutInterceptors", doubleAddInterceptorList);
        }
        return doubleAddInterceptorList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setInInterceptors(List<Interceptor<? extends Message>> interceptors) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setInInterceptors", new Object[]{interceptors});
        }
        this.in = interceptors;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setInInterceptors");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setInFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setInFaultInterceptors", new Object[]{interceptors});
        }
        this.inFault = interceptors;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setInFaultInterceptors");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setOutInterceptors(List<Interceptor<? extends Message>> interceptors) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setOutInterceptors", new Object[]{interceptors});
        }
        this.out = interceptors;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setOutInterceptors");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setOutFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setOutFaultInterceptors", new Object[]{interceptors});
        }
        this.outFault = interceptors;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setOutFaultInterceptors");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setHandlers(List<Handler> h) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setHandlers", new Object[]{h});
        }
        this.handlers.clear();
        this.handlers.addAll(h);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setHandlers");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Handler> getHandlers() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getHandlers", new Object[0]);
        }
        List<Handler> list = this.handlers;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getHandlers", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<AbstractFeature> getFeatures() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getFeatures", new Object[0]);
        }
        if (this.features == null) {
            this.features = new ArrayList<AbstractFeature>();
        }
        List<AbstractFeature> list = this.features;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getFeatures", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setFeatures(List<AbstractFeature> features) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setFeatures", new Object[]{features});
        }
        this.features = features;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setFeatures");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Invoker getInvoker() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getInvoker", new Object[0]);
        }
        Invoker invoker = this.invoker;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            invoker = invoker;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getInvoker", invoker);
        }
        return invoker;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setInvoker(Invoker invoker) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setInvoker", new Object[]{invoker});
        }
        this.invoker = invoker;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setInvoker");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setImplementorClass(Class<?> implementorClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setImplementorClass", new Object[]{implementorClass});
        }
        this.implementorClass = implementorClass;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setImplementorClass");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setTransportId(String transportId) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setTransportId", new Object[]{transportId});
        }
        this.serverFactory.setTransportId(transportId);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setTransportId");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getTransportId() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getTransportId", new Object[0]);
        }
        String string = this.serverFactory.getTransportId();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getTransportId", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setBindingConfig(BindingConfiguration config) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setBindingConfig", new Object[]{config});
        }
        this.serverFactory.setBindingConfig(config);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setBindingConfig");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BindingConfiguration getBindingConfig() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getBindingConfig", new Object[0]);
        }
        BindingConfiguration bindingConfiguration = this.serverFactory.getBindingConfig();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bindingConfiguration = bindingConfiguration;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getBindingConfig", bindingConfiguration);
        }
        return bindingConfiguration;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<String> getSchemaLocations() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getSchemaLocations", new Object[0]);
        }
        List<String> list = this.schemaLocations;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getSchemaLocations", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setSchemaLocations(List<String> schemaLocations) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "setSchemaLocations", new Object[]{schemaLocations});
        }
        this.schemaLocations = schemaLocations;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "setSchemaLocations");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EndpointReference getEndpointReference(Element ... referenceParameters) {
        W3CEndpointReference w3CEndpointReference;
        ClassLoader cl;
        block8: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getEndpointReference", new Object[]{referenceParameters});
            }
            if (!this.isPublished()) {
                throw new WebServiceException(new org.apache.cxf.common.i18n.Message("ENDPOINT_NOT_PUBLISHED", LOG, new Object[0]).toString());
            }
            if (this.getBinding() instanceof HTTPBinding) {
                throw new UnsupportedOperationException(new org.apache.cxf.common.i18n.Message("GET_ENDPOINTREFERENCE_UNSUPPORTED_BINDING", LOG, new Object[0]).toString());
            }
            W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
            builder.address(this.address);
            builder.serviceName(this.serviceName);
            builder.endpointName(this.endpointName);
            if (referenceParameters != null) {
                for (Element referenceParameter : referenceParameters) {
                    builder.referenceParameter(referenceParameter);
                }
            }
            builder.wsdlDocumentLocation(this.wsdlLocation);
            cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(EndpointReferenceBuilder.class.getClassLoader());
            W3CEndpointReference w3CEndpointReference2 = builder.build();
            w3CEndpointReference = w3CEndpointReference2;
            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block8;
            w3CEndpointReference = w3CEndpointReference;
            LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getEndpointReference", w3CEndpointReference);
        }
        return w3CEndpointReference;
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointImpl", "getEndpointReference", new Object[]{clazz, referenceParameters});
        }
        if (W3CEndpointReference.class.isAssignableFrom(clazz)) {
            EndpointReference endpointReference = (EndpointReference)clazz.cast(this.getEndpointReference(referenceParameters));
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                endpointReference = endpointReference;
                LOG.exiting("org.apache.cxf.jaxws.EndpointImpl", "getEndpointReference", endpointReference);
            }
            return (T)endpointReference;
        }
        throw new WebServiceException(new org.apache.cxf.common.i18n.Message("ENDPOINTREFERENCE_TYPE_NOT_SUPPORTED", LOG, new Object[]{clazz.getName()}).toString());
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    class DoubleAddInterceptorList
    implements List<Interceptor<? extends Message>> {
        List<Interceptor<? extends Message>> orig;
        List<Interceptor<? extends Message>> other;
        static final long serialVersionUID = -2696284766685809264L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public DoubleAddInterceptorList(List<Interceptor<? extends Message>> a1, List<Interceptor<? extends Message>> a2) {
            this.orig = a1;
            this.other = a2;
        }

        @Override
        public boolean add(Interceptor<? extends Message> e) {
            this.other.add(e);
            return this.orig.add(e);
        }

        @Override
        public void add(int index, Interceptor<? extends Message> element) {
            this.other.add(element);
            this.orig.add(index, element);
        }

        @Override
        public boolean addAll(Collection<? extends Interceptor<? extends Message>> c) {
            this.other.addAll(c);
            return this.orig.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Interceptor<? extends Message>> c) {
            this.other.addAll(c);
            return this.orig.addAll(index, c);
        }

        @Override
        public void clear() {
            this.orig.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.orig.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.orig.containsAll(c);
        }

        @Override
        public Interceptor<? extends Message> get(int index) {
            return this.orig.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.orig.indexOf(o);
        }

        @Override
        public boolean isEmpty() {
            return this.orig.isEmpty();
        }

        @Override
        public Iterator<Interceptor<? extends Message>> iterator() {
            return this.orig.iterator();
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.orig.lastIndexOf(o);
        }

        @Override
        public ListIterator<Interceptor<? extends Message>> listIterator() {
            return this.orig.listIterator();
        }

        @Override
        public ListIterator<Interceptor<? extends Message>> listIterator(int index) {
            return this.orig.listIterator(index);
        }

        @Override
        public boolean remove(Object o) {
            this.other.remove(o);
            return this.orig.remove(o);
        }

        @Override
        public Interceptor<? extends Message> remove(int index) {
            Interceptor<? extends Message> o = this.orig.remove(index);
            if (o == null) {
                this.other.remove(o);
            }
            return o;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            this.other.removeAll(c);
            return this.orig.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Interceptor<? extends Message> set(int index, Interceptor<? extends Message> element) {
            Interceptor<? extends Message> o = this.orig.set(index, element);
            if (o != null) {
                int idx = this.other.indexOf(o);
                this.other.set(idx, element);
            }
            return o;
        }

        @Override
        public int size() {
            return this.orig.size();
        }

        @Override
        public List<Interceptor<? extends Message>> subList(int fromIndex, int toIndex) {
            return this.orig.subList(fromIndex, toIndex);
        }

        @Override
        public Object[] toArray() {
            return this.orig.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.orig.toArray(a);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxws.EndpointImpl$DoubleAddInterceptorList", DoubleAddInterceptorList.class, null, null);
        }
    }
}

