/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.Provider;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.invoker.Factory;
import org.apache.cxf.service.invoker.SingletonFactory;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class JAXWSMethodInvoker
extends AbstractJAXWSMethodInvoker {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXWSMethodInvoker.class);
    static final long serialVersionUID = 6667039270844511703L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXWSMethodInvoker(Object bean) {
        super((Factory)new SingletonFactory(bean));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JAXWSMethodInvoker", "<init>", new Object[]{bean});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.JAXWSMethodInvoker", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXWSMethodInvoker(Factory factory) {
        super(factory);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JAXWSMethodInvoker", "<init>", new Object[]{factory});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.JAXWSMethodInvoker", "<init>", (Object)this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Object invoke(Exchange exchange, Object serviceObject, Method m, List<Object> params) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JAXWSMethodInvoker", "invoke", new Object[]{exchange, serviceObject, m, params});
        }
        WrappedMessageContext ctx = new WrappedMessageContext(exchange.getInMessage(), MessageContext.Scope.APPLICATION);
        Map<String, Object> handlerScopedStuff = this.removeHandlerProperties(ctx);
        WebServiceContextImpl.setMessageContext(ctx);
        List res = null;
        try {
            if ((params == null || params.isEmpty()) && m.getDeclaringClass().equals(Provider.class)) {
                params = Collections.singletonList(null);
            }
            res = CastUtils.cast((List)((List)super.invoke(exchange, serviceObject, m, params)));
            if (serviceObject instanceof Provider && MessageUtils.getContextualBoolean((Message)exchange.getInMessage(), (String)"jaxws.provider.interpretNullAsOneway", (boolean)true) && res != null && !res.isEmpty() && res.get(0) == null && exchange.getInMessage().getInterceptorChain().getState() == InterceptorChain.State.EXECUTING) {
                res = null;
                this.changeToOneway(exchange);
            }
            this.updateWebServiceContext(exchange, ctx);
        }
        catch (Fault f) {
            this.updateHeader(exchange, ctx);
            throw f;
        }
        finally {
            if (serviceObject instanceof Provider) {
                LOG.log(Level.FINE, "Checking for cxf.add.attachments property in MessageContext...");
                boolean addAttachments = MessageUtils.isTrue((Object)ctx.get("cxf.add.attachments"));
                if (addAttachments) {
                    LOG.log(Level.FINE, "Setting cxf.add.attachments property in Message: " + addAttachments);
                    Message m1 = exchange.getOutMessage();
                    if (m1 != null) {
                        m1.put((Object)"cxf.add.attachments", (Object)Boolean.TRUE);
                    }
                }
            }
            LOG.log(Level.FINE, "Checking for org.apache.cxf.stax.force-start-document in MessageContext...");
            boolean forceXmlDecl = MessageUtils.isTrue((Object)ctx.get("org.apache.cxf.stax.force-start-document"));
            if (forceXmlDecl) {
                LOG.log(Level.FINE, "Setting org.apache.cxf.stax.force-start-document property in Message: " + forceXmlDecl);
                Message m2 = exchange.getOutMessage();
                if (m2 != null) {
                    LOG.log(Level.FINE, "Setting force-start-document in Message: " + m2);
                    m2.put((Object)"org.apache.cxf.stax.force-start-document", (Object)Boolean.TRUE);
                }
            }
            WebServiceContextImpl.clear();
            this.addHandlerProperties(ctx, handlerScopedStuff);
        }
        List list = res;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxws.JAXWSMethodInvoker", "invoke", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void changeToOneway(Exchange exchange) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JAXWSMethodInvoker", "changeToOneway", new Object[]{exchange});
        }
        exchange.setOneWay(true);
        HttpServletResponse httpresp = (HttpServletResponse)exchange.getInMessage().get((Object)"HTTP.RESPONSE");
        if (httpresp != null) {
            httpresp.setStatus(202);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.JAXWSMethodInvoker", "changeToOneway");
        }
    }
}

