/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.error.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.oauth.core.api.OAuthResult;
import com.ibm.oauth.core.api.error.OAuthConfigurationException;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidGrantTypeException;
import com.ibm.oauth.core.util.JSONUtil;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.error.OAuthExceptionHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
public class OAuth20TokenRequestExceptionHandler
implements OAuthExceptionHandler {
    private static final TraceComponent tc = Tr.register(OAuth20TokenRequestExceptionHandler.class, (String)"OAuth20Provider", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    public static final String EXAMPLE_WWW_AUTHENTICATE_BASIC_VALUE = "Basic: realm=\"test\"";
    static final long serialVersionUID = 7362352658677389043L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public OAuth20TokenRequestExceptionHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void handleResultException(HttpServletRequest req, HttpServletResponse rsp, OAuthResult result) {
        String methodName;
        block27: {
            String encoding;
            methodName = "handleResultException";
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)methodName, (Object)result);
            }
            boolean handled = false;
            String string = encoding = req.getCharacterEncoding() != null ? req.getCharacterEncoding() : "utf-8";
            if (result.getStatus() != 0) {
                OAuthException e = result.getCause();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"com.ibm.ws.security.oauth20.web.OAuth20EndpointServlet.TokenRequest result is bad", (Object)new Object[]{e});
                }
                if (e != null) {
                    block26: {
                        OAuthException e2;
                        if (!(e instanceof OAuth20InvalidGrantTypeException)) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.error.impl.OAuth20TokenRequestExceptionHandler", (String)"80", (Object)this);
                        }
                        if (e instanceof OAuth20Exception) {
                            e2 = (OAuth20Exception)e;
                            String error = ((OAuth20Exception)e2).getError();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("processing exception with OAuthResult: " + error + " and error message = " + e2.getMessage() + ", localized message = " + e2.getLocalizedMessage()));
                            }
                            if ("invalid_client".equals(error)) {
                                rsp.setStatus(401);
                            } else if ("invalid_grant".equals(error) || "invalid_token".equals(error)) {
                                if ("invalid_grant".equals(error) && (e2.getMessage().contains("CWOAU0080E") || e2.getMessage().contains("CWOAU0081E"))) {
                                    rsp.setStatus(400);
                                } else {
                                    rsp.setStatus(401);
                                }
                            } else if ("invalid_scope".equals(error)) {
                                rsp.setStatus(302);
                            } else {
                                rsp.setStatus(400);
                            }
                            rsp.setHeader("Cache-Control", "no-store");
                            rsp.setHeader("Pragma", "no-cache");
                            rsp.setHeader("Content-Type", "application/json;charset=UTF-8");
                            String errorDescription = ((OAuth20Exception)e2).formatSelf(req.getLocale(), encoding);
                            HashMap<String, Object> attributes = new HashMap<String, Object>();
                            attributes.put("error", error);
                            attributes.put("error_description", errorDescription);
                            try {
                                PrintWriter pw = rsp.getWriter();
                                pw.print(JSONUtil.getJSON(attributes));
                                handled = true;
                            }
                            catch (IOException pw) {
                                FFDCFilter.processException((Throwable)pw, (String)"com.ibm.ws.security.oauth20.error.impl.OAuth20TokenRequestExceptionHandler", (String)"185", (Object)this, (Object[])new Object[]{req, rsp, result});
                                if (tc.isDebugEnabled()) {
                                    void ioe;
                                    Tr.debug((TraceComponent)tc, (String)"Internal error writing JSON response", (Object)new Object[]{ioe});
                                }
                                break block26;
                            }
                        }
                        if (e instanceof OAuthConfigurationException) {
                            e2 = (OAuthConfigurationException)e;
                            String error = ((OAuthConfigurationException)e2).getError();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("processing exception with OAuthResult: " + error));
                            }
                            rsp.setStatus(500);
                            rsp.setHeader("Cache-Control", "no-store");
                            rsp.setHeader("Pragma", "no-cache");
                            rsp.setHeader("Content-Type", "application/json;charset=UTF-8");
                            String errorDescription = ((OAuthConfigurationException)e2).formatSelf(req.getLocale(), encoding);
                            HashMap<String, Object> attributes = new HashMap<String, Object>();
                            attributes.put("error", error);
                            attributes.put("error_description", errorDescription);
                            try {
                                PrintWriter pw = rsp.getWriter();
                                pw.print(JSONUtil.getJSON(attributes));
                                handled = true;
                            }
                            catch (IOException pw) {
                                void ioe;
                                FFDCFilter.processException((Throwable)pw, (String)"com.ibm.ws.security.oauth20.error.impl.OAuth20TokenRequestExceptionHandler", (String)"235", (Object)this, (Object[])new Object[]{req, rsp, result});
                                if (!tc.isDebugEnabled()) break block26;
                                Tr.debug((TraceComponent)tc, (String)"Internal error writing JSON response", (Object)new Object[]{ioe});
                            }
                        }
                    }
                    if (!handled) {
                        try {
                            PrintWriter pw = rsp.getWriter();
                            pw.print(e.formatSelf(req.getLocale(), encoding));
                            handled = true;
                        }
                        catch (IOException pw) {
                            void ioe;
                            FFDCFilter.processException((Throwable)pw, (String)"com.ibm.ws.security.oauth20.error.impl.OAuth20TokenRequestExceptionHandler", (String)"250", (Object)this, (Object[])new Object[]{req, rsp, result});
                            if (!tc.isDebugEnabled()) break block27;
                            Tr.debug((TraceComponent)tc, (String)"Internal error", (Object)new Object[]{ioe});
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)result);
        }
    }
}

