/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.oauth.core.api.OAuthResult;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20AccessDeniedException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20DuplicateParameterException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.OAuth20Constants;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.oauth.core.internal.oauth20.OAuthResultImpl;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.common.claims.UserClaims;
import com.ibm.ws.security.oauth20.ProvidersService;
import com.ibm.ws.security.oauth20.api.OAuth20EnhancedTokenCache;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.error.impl.OAuth20TokenRequestExceptionHandler;
import com.ibm.ws.security.oauth20.exception.OAuth20BadParameterException;
import com.ibm.ws.security.oauth20.plugins.OAuth20TokenImpl;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.util.ConfigUtils;
import com.ibm.ws.security.oauth20.util.HashUtils;
import com.ibm.ws.security.oauth20.util.Nonce;
import com.ibm.ws.security.oauth20.util.OAuth20ProviderUtils;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import com.ibm.ws.security.oauth20.web.ClientAuthentication;
import com.ibm.ws.security.oauth20.web.ClientAuthnData;
import com.ibm.ws.security.oauth20.web.ClientAuthorization;
import com.ibm.ws.security.oauth20.web.Consent;
import com.ibm.ws.security.oauth20.web.CoverageMapEndpointServices;
import com.ibm.ws.security.oauth20.web.EndpointUtils;
import com.ibm.ws.security.oauth20.web.LogoutPages;
import com.ibm.ws.security.oauth20.web.OAuth20ClientMetatypeService;
import com.ibm.ws.security.oauth20.web.OAuth20Request;
import com.ibm.ws.security.oauth20.web.OAuthClientTracker;
import com.ibm.ws.security.oauth20.web.Prompt;
import com.ibm.ws.security.oauth20.web.RegistrationEndpointServices;
import com.ibm.ws.security.oauth20.web.TokenExchange;
import com.ibm.ws.security.oauth20.web.TokenIntrospect;
import com.ibm.ws.security.oauth20.web.UIAccessTokenBuilder;
import com.ibm.ws.security.oauth20.web.UserAuthentication;
import com.ibm.ws.security.oauth20.web.WebUtils;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.oauth20.JwtAccessTokenMediator;
import com.ibm.wsspi.security.oauth20.TokenIntrospectProvider;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={OAuth20EndpointServices.class}, name="com.ibm.ws.security.oauth20.web.OAuth20EndpointServices", immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class OAuth20EndpointServices {
    private static TraceComponent tc = Tr.register(OAuth20EndpointServices.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static TraceComponent tc2 = Tr.register(OAuth20EndpointServices.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    protected static final String MESSAGE_BUNDLE = "com.ibm.ws.security.oauth20.internal.resources.OAuthMessages";
    protected static final String MSG_RESOURCE_BUNDLE = "com.ibm.ws.security.oauth20.resources.ProviderMsgs";
    public static final String KEY_SERVICE_PID = "service.pid";
    public static final String KEY_SECURITY_SERVICE = "securityService";
    protected final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    public static final String KEY_TOKEN_INTROSPECT_PROVIDER = "tokenIntrospectProvider";
    private final ConcurrentServiceReferenceMap<String, TokenIntrospectProvider> tokenIntrospectProviderRef = new ConcurrentServiceReferenceMap("tokenIntrospectProvider");
    public static final String KEY_JWT_MEDIATOR = "jwtAccessTokenMediator";
    private final ConcurrentServiceReferenceMap<String, JwtAccessTokenMediator> jwtAccessTokenMediatorRef = new ConcurrentServiceReferenceMap("jwtAccessTokenMediator");
    public static final String KEY_OAUTH_CLIENT_METATYPE_SERVICE = "oauth20ClientMetatypeService";
    private static final AtomicServiceReference<OAuth20ClientMetatypeService> oauth20ClientMetatypeServiceRef = new AtomicServiceReference("oauth20ClientMetatypeService");
    private static final String ATTR_NONCE = "consentNonce";
    public static final String AUTHENTICATED = "authenticated";
    protected volatile ClientAuthentication clientAuthentication = new ClientAuthentication();
    protected volatile ClientAuthorization clientAuthorization = new ClientAuthorization();
    protected volatile UserAuthentication userAuthentication = new UserAuthentication();
    protected volatile CoverageMapEndpointServices coverageMapServices = new CoverageMapEndpointServices();
    protected volatile RegistrationEndpointServices registrationEndpointServices = new RegistrationEndpointServices();
    protected volatile Consent consent = new Consent();
    protected volatile TokenExchange tokenExchange = new TokenExchange();
    static final long serialVersionUID = -5120536779361211840L;

    @Reference(service=SecurityService.class, name="securityService", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.setReference(reference);
    }

    protected void unsetSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.unsetReference(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=TokenIntrospectProvider.class, name="tokenIntrospectProvider", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    protected void setTokenIntrospectProvider(ServiceReference<TokenIntrospectProvider> ref) {
        ConcurrentServiceReferenceMap<String, TokenIntrospectProvider> concurrentServiceReferenceMap = this.tokenIntrospectProviderRef;
        synchronized (concurrentServiceReferenceMap) {
            this.tokenIntrospectProviderRef.putReference((Object)((String)ref.getProperty(KEY_SERVICE_PID)), ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetTokenIntrospectProvider(ServiceReference<TokenIntrospectProvider> ref) {
        ConcurrentServiceReferenceMap<String, TokenIntrospectProvider> concurrentServiceReferenceMap = this.tokenIntrospectProviderRef;
        synchronized (concurrentServiceReferenceMap) {
            this.tokenIntrospectProviderRef.removeReference((Object)((String)ref.getProperty(KEY_SERVICE_PID)), ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=JwtAccessTokenMediator.class, name="jwtAccessTokenMediator", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setJwtAccessTokenMediator(ServiceReference<JwtAccessTokenMediator> ref) {
        ConcurrentServiceReferenceMap<String, JwtAccessTokenMediator> concurrentServiceReferenceMap = this.jwtAccessTokenMediatorRef;
        synchronized (concurrentServiceReferenceMap) {
            this.jwtAccessTokenMediatorRef.putReference((Object)((String)ref.getProperty(KEY_SERVICE_PID)), ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetJwtAccessTokenMediator(ServiceReference<JwtAccessTokenMediator> ref) {
        ConcurrentServiceReferenceMap<String, JwtAccessTokenMediator> concurrentServiceReferenceMap = this.jwtAccessTokenMediatorRef;
        synchronized (concurrentServiceReferenceMap) {
            this.jwtAccessTokenMediatorRef.removeReference((Object)((String)ref.getProperty(KEY_SERVICE_PID)), ref);
        }
    }

    @Reference(service=OAuth20ClientMetatypeService.class, name="oauth20ClientMetatypeService", policy=ReferencePolicy.DYNAMIC)
    protected void setOAuth20ClientMetatypeService(ServiceReference<OAuth20ClientMetatypeService> ref) {
        oauth20ClientMetatypeServiceRef.setReference(ref);
    }

    protected void unsetOAuth20ClientMetatypeService(ServiceReference<OAuth20ClientMetatypeService> ref) {
        oauth20ClientMetatypeServiceRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.securityServiceRef.activate(cc);
        this.tokenIntrospectProviderRef.activate(cc);
        this.jwtAccessTokenMediatorRef.activate(cc);
        oauth20ClientMetatypeServiceRef.activate(cc);
        ConfigUtils.setJwtAccessTokenMediatorService(this.jwtAccessTokenMediatorRef);
        TokenIntrospect.setTokenIntrospect(this.tokenIntrospectProviderRef);
        String infoMsg = TraceNLS.getFormattedMessage(this.getClass(), (String)MESSAGE_BUNDLE, (String)"OAUTH_ENDPOINT_SERVICE_ACTIVATED", null, (String)"CWWKS1410I: The OAuth endpoint service is activated.");
        Tr.info((TraceComponent)tc, (String)infoMsg, (Object[])new Object[0]);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.securityServiceRef.deactivate(cc);
        this.tokenIntrospectProviderRef.deactivate(cc);
        this.jwtAccessTokenMediatorRef.deactivate(cc);
        oauth20ClientMetatypeServiceRef.deactivate(cc);
    }

    protected void handleOAuthRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws ServletException, IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Checking if OAuth20 Provider should process the request.", (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Inbound request " + com.ibm.ws.security.common.web.WebUtils.getRequestStringForTrace((HttpServletRequest)request, (String)"client_secret")), (Object[])new Object[0]);
        }
        OAuth20Request oauth20Request = this.getAuth20Request(request, response);
        OAuth20Provider oauth20Provider = null;
        if (oauth20Request != null) {
            OAuth20Request.EndpointType endpointType = oauth20Request.getType();
            oauth20Provider = this.getProvider(response, oauth20Request);
            if (oauth20Provider != null) {
                AttributeList optionalParams = new AttributeList();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"OAUTH20 _SSO OP PROCESS IS STARTING.", (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("OAUTH20 _SSO OP inbound URL " + com.ibm.ws.security.common.web.WebUtils.getRequestStringForTrace((HttpServletRequest)request, (String)"client_secret")), (Object[])new Object[0]);
                }
                this.handleEndpointRequest(request, response, servletContext, oauth20Provider, endpointType, optionalParams);
            }
        }
        if (tc.isDebugEnabled()) {
            if (oauth20Provider != null) {
                Tr.debug((TraceComponent)tc, (String)"OAUTH20 _SSO OP WILL NOT PROCESS THE REQUEST", (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)"OAUTH20 _SSO OP PROCESS HAS ENDED.", (Object[])new Object[0]);
            }
        }
    }

    @FFDCIgnore(value={OidcServerException.class})
    protected void handleEndpointRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, OAuth20Provider oauth20Provider, OAuth20Request.EndpointType endpointType, AttributeList oidcOptionalParams) throws ServletException, IOException {
        this.checkHttpsRequirement(request, response, oauth20Provider);
        if (response.isCommitted()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Response has already been committed, so likely did not pass HTTPS requirement", (Object[])new Object[0]);
            }
            return;
        }
        boolean isBrowserWithBasicAuth = false;
        UIAccessTokenBuilder uitb = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("endpointType[" + (Object)((Object)endpointType) + "]"), (Object[])new Object[0]);
        }
        try {
            switch (endpointType) {
                case authorize: {
                    OAuthResult result = this.processAuthorizationRequest(oauth20Provider, request, response, servletContext, oidcOptionalParams);
                    if (result == null || result.getStatus() == 2 || result.getStatus() == 0) break;
                    this.userAuthentication.renderErrorPage(oauth20Provider, request, response, result);
                    break;
                }
                case token: {
                    if (!this.clientAuthentication.verify(oauth20Provider, request, response, endpointType)) break;
                    this.processTokenRequest(oauth20Provider, request, response);
                    break;
                }
                case introspect: {
                    if (!this.clientAuthentication.verify(oauth20Provider, request, response, endpointType)) break;
                    this.introspect(oauth20Provider, request, response);
                    break;
                }
                case revoke: {
                    if (!this.clientAuthentication.verify(oauth20Provider, request, response, endpointType)) break;
                    this.revoke(oauth20Provider, request, response);
                    break;
                }
                case coverage_map: {
                    this.coverageMapServices.handleEndpointRequest(oauth20Provider, request, response);
                    break;
                }
                case registration: {
                    this.secureEndpointServices(oauth20Provider, request, response, servletContext, "clientManager", true);
                    this.registrationEndpointServices.handleEndpointRequest(oauth20Provider, request, response);
                    break;
                }
                case logout: {
                    this.logout(oauth20Provider, request, response);
                    break;
                }
                case app_password: {
                    if (this.isJava7(request.getRequestURI())) break;
                    this.tokenExchange.processAppPassword(oauth20Provider, request, response);
                    break;
                }
                case app_token: {
                    if (this.isJava7(request.getRequestURI())) break;
                    this.tokenExchange.processAppToken(oauth20Provider, request, response);
                    break;
                }
                case clientManagement: {
                    if (!this.authenticateUI(request, response, servletContext, oauth20Provider, oidcOptionalParams, "clientManager")) break;
                    RequestDispatcher rd = servletContext.getRequestDispatcher("WEB-CONTENT/clientAdmin/index.jsp");
                    rd.forward((ServletRequest)request, (ServletResponse)response);
                    break;
                }
                case personalTokenManagement: {
                    if (!this.authenticateUI(request, response, servletContext, oauth20Provider, oidcOptionalParams, null)) break;
                    this.checkUIConfig(oauth20Provider, request);
                    uitb = new UIAccessTokenBuilder(oauth20Provider, request);
                    uitb.createHeaderValuesForUI();
                    RequestDispatcher rd2 = servletContext.getRequestDispatcher("WEB-CONTENT/accountManager/index.jsp");
                    rd2.forward((ServletRequest)request, (ServletResponse)response);
                    break;
                }
                case usersTokenManagement: {
                    if (!this.authenticateUI(request, response, servletContext, oauth20Provider, oidcOptionalParams, "tokenManager")) break;
                    this.checkUIConfig(oauth20Provider, request);
                    uitb = new UIAccessTokenBuilder(oauth20Provider, request);
                    uitb.createHeaderValuesForUI();
                    RequestDispatcher rd3 = servletContext.getRequestDispatcher("WEB-CONTENT/tokenManager/index.jsp");
                    rd3.forward((ServletRequest)request, (ServletResponse)response);
                    break;
                }
                case clientMetatype: {
                    this.serveClientMetatypeRequest(request, response);
                    break;
                }
            }
        }
        catch (OidcServerException e) {
            if (!isBrowserWithBasicAuth && !e.getErrorDescription().contains("CWWKS1424E")) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.web.OAuth20EndpointServices", (String)"324", (Object)this);
            }
            boolean suppressBasicAuthChallenge = isBrowserWithBasicAuth;
            WebUtils.sendErrorJSON(response, e.getHttpStatus(), e.getErrorCode(), e.getErrorDescription(request.getLocales()), suppressBasicAuthChallenge);
        }
    }

    private boolean authenticateUI(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, OAuth20Provider provider, AttributeList options, String requiredRole) throws ServletException, IOException, OidcServerException {
        if (this.isJava7(request.getRequestURI())) {
            return false;
        }
        OAuthResult result = this.handleUIUserAuthentication(request, response, servletContext, provider, options);
        return this.isUIAuthenticationComplete(request, response, provider, result, requiredRole);
    }

    private boolean isJava7(String uri) {
        if (OAuth20Constants.JAVA_VERSION_7 || OAuth20Constants.JAVA_VERSION_6) {
            Tr.warning((TraceComponent)tc2, (String)"JAVA8_REQUIRED", (Object[])new Object[]{uri});
            return true;
        }
        return false;
    }

    private boolean isUIAuthenticationComplete(HttpServletRequest request, HttpServletResponse response, OAuth20Provider provider, OAuthResult result, String requiredRole) throws OidcServerException {
        if (result == null) {
            return false;
        }
        if (result.getStatus() == 2) {
            return false;
        }
        if (result.getStatus() != 0) {
            try {
                this.userAuthentication.renderErrorPage(provider, request, response, result);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.web.OAuth20EndpointServices", (String)"389", (Object)this, (Object[])new Object[]{request, response, provider, result, requiredRole});
            }
            return false;
        }
        if (requiredRole != null && !request.isUserInRole(requiredRole)) {
            throw new OidcServerException("403", "access_denied", 403);
        }
        return true;
    }

    void serveClientMetatypeRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        OAuth20ClientMetatypeService metatypeService = (OAuth20ClientMetatypeService)oauth20ClientMetatypeServiceRef.getService();
        if (metatypeService == null) {
            response.sendError(500);
            return;
        }
        metatypeService.sendClientMetatypeData(request, response);
    }

    private boolean checkUIConfig(OAuth20Provider provider, HttpServletRequest request) {
        String uri = request.getRequestURI();
        String id = provider.getInternalClientId();
        String secret = provider.getInternalClientSecret();
        OidcBaseClient client = null;
        boolean result = false;
        try {
            client = provider.getClientProvider().get(id);
        }
        catch (OidcServerException oidcServerException) {
            FFDCFilter.processException((Throwable)oidcServerException, (String)"com.ibm.ws.security.oauth20.web.OAuth20EndpointServices", (String)"418", (Object)this, (Object[])new Object[]{provider, request});
        }
        if (client != null) {
            boolean bl = result = secret != null && client.isEnabled() && (client.isAppPasswordAllowed() || client.isAppTokenAllowed());
        }
        if (!result) {
            Tr.warning((TraceComponent)tc2, (String)"OAUTH_UI_ENDPOINT_NOT_ENABLED", (Object[])new Object[]{uri});
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public void logout(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Processing logout", (Object[])new Object[0]);
        }
        try {
            request.logout();
        }
        catch (ServletException servletException) {
            void e;
            FFDCFilter.processException((Throwable)servletException, (String)"com.ibm.ws.security.oauth20.web.OAuth20EndpointServices", (String)"454", (Object)this, (Object[])new Object[]{provider, request, response});
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"logout", (Object[])new Object[0]);
            new LogoutPages().sendDefaultErrorPage(request, response);
            return;
        }
        String logoutRedirectURL = provider.getLogoutRedirectURL();
        try {
            if (logoutRedirectURL != null) {
                String encodedURL = this.URLEncodeParams(logoutRedirectURL);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("OAUTH20 _SSO OP redirecting to [" + logoutRedirectURL + "], url encoded to [" + encodedURL + "]"), (Object[])new Object[0]);
                }
                response.sendRedirect(encodedURL);
                return;
            }
            new LogoutPages().sendDefaultLogoutPage(request, response);
        }
        catch (IOException encodedURL) {
            void e;
            FFDCFilter.processException((Throwable)encodedURL, (String)"com.ibm.ws.security.oauth20.web.OAuth20EndpointServices", (String)"476", (Object)this, (Object[])new Object[]{provider, request, response});
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"logout", (Object[])new Object[0]);
            new LogoutPages().sendDefaultErrorPage(request, response);
        }
    }

    String URLEncodeParams(String UrlStr) {
        String sep = "?";
        String encodedURL = UrlStr;
        int index = UrlStr.indexOf(sep);
        boolean alreadyEncoded = UrlStr.contains("%");
        if (index > -1 && !alreadyEncoded) {
            String prefix = UrlStr.substring(0, ++index);
            String suffix = UrlStr.substring(index);
            try {
                encodedURL = prefix + URLEncoder.encode(suffix, StandardCharsets.UTF_8.toString());
                encodedURL = encodedURL.replace("%3D", "=");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.oauth20.web.OAuth20EndpointServices", (String)"498", (Object)this, (Object[])new Object[]{UrlStr});
            }
        }
        return encodedURL;
    }

    public OAuthResult processAuthorizationRequest(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, AttributeList options) throws ServletException, IOException, OidcServerException {
        OAuthResult oauthResult = this.checkForError(request);
        if (oauthResult != null) {
            return oauthResult;
        }
        boolean autoAuthz = this.clientAuthorization.isClientAutoAuthorized(provider, request);
        String reqConsentNonce = this.getReqConsentNonce(request);
        boolean afterLogin = this.isAfterLogin(request);
        if (reqConsentNonce == null && (oauthResult = this.clientAuthorization.validateAuthorization(provider, request, response)).getStatus() != 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Status is OK, returning result", (Object[])new Object[0]);
            }
            return oauthResult;
        }
        oauthResult = this.handleUserAuthentication(oauthResult, request, response, servletContext, provider, reqConsentNonce, options, autoAuthz, afterLogin);
        return oauthResult;
    }

    private void setTokenHintAttributes(AttributeList options, AttributeList attrList) {
        String value = options.getAttributeValueByName("id_token_hint_status");
        if (value != null) {
            attrList.setAttribute("id_token_hint_status", "urn:ibm:names:oauth:request", new String[]{value});
        }
        if ((value = options.getAttributeValueByName("id_token_hint_username")) != null) {
            attrList.setAttribute("id_token_hint_username", "urn:ibm:names:oauth:request", new String[]{value});
        }
        if ((value = options.getAttributeValueByName("id_token_hint_clientid")) != null) {
            attrList.setAttribute("id_token_hint_clientid", "urn:ibm:names:oauth:request", new String[]{value});
        }
    }

    /*
     * WARNING - void declaration
     */
    private OAuthResultImpl validateIdTokenHintIfPresent(AttributeList attrs, HttpServletRequest request) {
        if (attrs != null) {
            Principal user = request.getUserPrincipal();
            String username = null;
            if (user != null) {
                username = user.getName();
            }
            try {
                this.userAuthentication.validateIdTokenHint(username, attrs);
            }
            catch (OAuth20Exception oAuth20Exception) {
                void oe;
                FFDCFilter.processException((Throwable)oAuth20Exception, (String)"com.ibm.ws.security.oauth20.web.OAuth20EndpointServices", (String)"568", (Object)this, (Object[])new Object[]{attrs, request});
                return new OAuthResultImpl(1, attrs, (OAuthException)oe);
            }
        }
        return null;
    }

    private OAuthResult createTokenLimitResult(AttributeList attrs, HttpServletRequest request, String clientId) {
        if (attrs == null) {
            attrs = new AttributeList();
            String responseType = request.getParameter("response_type");
            attrs.setAttribute("response_type", "response_type", new String[]{responseType});
            attrs.setAttribute("client_id", "client_id", new String[]{clientId});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Attribute responseType:" + responseType + " client_id:" + clientId), (Object[])new Object[0]);
            }
        }
        OAuth20AccessDeniedException e = new OAuth20AccessDeniedException("security.oauth20.token.limit.external.error");
        e.setHttpStatusCode(400);
        OAuthResultImpl oauthResultWithExcep = new OAuthResultImpl(1, attrs, e);
        return oauthResultWithExcep;
    }

    private OAuthResult handleUIUserAuthentication(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, OAuth20Provider provider, AttributeList options) throws IOException, ServletException, OidcServerException {
        OAuthResult oauthResult = null;
        Prompt prompt = new Prompt();
        if (request.getUserPrincipal() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Authenticate user if not done yet", (Object[])new Object[0]);
            }
            oauthResult = this.userAuthentication.handleAuthenticationWithOAuthResult(provider, request, response, prompt, this.securityServiceRef, servletContext, AUTHENTICATED, oauthResult);
        }
        if (request.getUserPrincipal() == null) {
            return oauthResult;
        }
        if (CookieHelper.getCookieValue((Cookie[])request.getCookies(), (String)"WASReLoginURL") != null) {
            ReferrerURLCookieHandler handler = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig().createReferrerURLCookieHandler();
            handler.invalidateReferrerURLCookie(request, response, "WASReLoginURL");
        }
        if (!request.isUserInRole(AUTHENTICATED)) {
            Tr.audit((TraceComponent)tc, (String)"security.oauth20.error.authorization", (Object[])new Object[]{request.getUserPrincipal().getName()});
            response.sendError(403);
            return oauthResult;
        }
        return new OAuthResultImpl(0, new AttributeList());
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={OAuth20BadParameterException.class})
    private OAuthResult handleUserAuthentication(OAuthResult oauthResult, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, OAuth20Provider provider, String reqConsentNonce, AttributeList options, boolean autoauthz, boolean afterLogin) throws IOException, ServletException, OidcServerException {
        OAuthResultImpl result;
        String[] stateParams;
        Prompt prompt = null;
        String[] scopesAttr = null;
        AttributeList attrs = null;
        if (oauthResult != null) {
            String[] validResources;
            attrs = oauthResult.getAttributeList();
            scopesAttr = attrs.getAttributeValuesByName("scope");
            if (options != null) {
                this.setTokenHintAttributes(options, attrs);
            }
            if ((validResources = attrs.getAttributeValuesByName("resource")) != null) {
                options.setAttribute("resource", "urn:ibm:names:oauth:param", validResources);
            }
        }
        if ((stateParams = request.getParameterValues("state")) != null) {
            if (attrs == null) {
                attrs = new AttributeList();
            }
            attrs.setAttribute("state", "urn:ibm:names:query:param", stateParams);
        }
        boolean isOpenId = false;
        if (scopesAttr != null) {
            for (String scope : scopesAttr) {
                if (!"openid".equals(scope)) continue;
                isOpenId = true;
                break;
            }
        }
        if (isOpenId && (result = this.validateIdTokenHintIfPresent(attrs, request)) != null) {
            return result;
        }
        prompt = new Prompt(request);
        if (request.getUserPrincipal() == null || prompt.hasLogin() && !afterLogin) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Authenticate user if not done yet", (Object[])new Object[0]);
            }
            oauthResult = this.userAuthentication.handleAuthenticationWithOAuthResult(provider, request, response, prompt, this.securityServiceRef, servletContext, AUTHENTICATED, oauthResult);
        }
        if (request.getUserPrincipal() == null) {
            return oauthResult;
        }
        if (CookieHelper.getCookieValue((Cookie[])request.getCookies(), (String)"WASReLoginURL") != null) {
            ReferrerURLCookieHandler handler = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig().createReferrerURLCookieHandler();
            handler.invalidateReferrerURLCookie(request, response, "WASReLoginURL");
        }
        if (!request.isUserInRole(AUTHENTICATED) && !request.isUserInRole("tokenManager")) {
            Tr.audit((TraceComponent)tc, (String)"security.oauth20.error.authorization", (Object[])new Object[]{request.getUserPrincipal().getName()});
            response.sendError(403);
            return oauthResult;
        }
        if (reqConsentNonce != null && !this.consent.isNonceValid(request, reqConsentNonce)) {
            this.consent.handleNonceError(request, response);
            return oauthResult;
        }
        String clientId = this.getClientId(request);
        String[] reducedScopes = null;
        try {
            reducedScopes = this.clientAuthorization.getReducedScopes(provider, request, clientId, true);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.web.OAuth20EndpointServices", (String)"710", (Object)this, (Object[])new Object[]{oauthResult, request, response, servletContext, provider, reqConsentNonce, options, autoauthz, afterLogin});
            if (tc.isDebugEnabled()) {
                void e1;
                Tr.debug((TraceComponent)tc, (String)("Caught exception, so setting reduced scopes to null. Exception was: " + e1.getMessage()), (Object[])new Object[0]);
            }
            reducedScopes = null;
        }
        boolean preAuthzed = false;
        if (reqConsentNonce == null) {
            try {
                preAuthzed = this.clientAuthorization.isPreAuthorizedScope(provider, clientId, reducedScopes);
            }
            catch (Exception scope) {
                FFDCFilter.processException((Throwable)scope, (String)"com.ibm.ws.security.oauth20.web.OAuth20EndpointServices", (String)"721", (Object)this, (Object[])new Object[]{oauthResult, request, response, servletContext, provider, reqConsentNonce, options, autoauthz, afterLogin});
                preAuthzed = false;
            }
        }
        if (!(autoauthz || preAuthzed || reqConsentNonce != null || this.consent.isCachedAndValid(oauthResult, provider, request, response))) {
            if (prompt.hasNone()) {
                oauthResult = prompt.errorConsentRequired(attrs);
            } else {
                Nonce nonce = this.consent.setNonce(request);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"_SSO OP redirecting for consent", (Object[])new Object[0]);
                }
                this.consent.renderConsentForm(request, response, provider, clientId, nonce, oauthResult.getAttributeList(), servletContext);
            }
            return oauthResult;
        }
        if (this.reachedTokenLimit(provider, request)) {
            return this.createTokenLimitResult(attrs, request, clientId);
        }
        if (request.getAttribute("OidcRequest") != null && (oauthResult = this.clientAuthorization.checkForEmptyScopeSetAfterConsent(reducedScopes, oauthResult, request, provider, clientId)) != null && oauthResult.getStatus() != 0) {
            response.setStatus(302);
            return oauthResult;
        }
        try {
            OidcBaseClient client = OAuth20ProviderUtils.getOidcOAuth20Client(provider, clientId);
            OAuth20ProviderUtils.validateResource(request, options, client);
        }
        catch (OAuth20BadParameterException e) {
            WebUtils.throwOidcServerException(request, e);
        }
        catch (OAuth20Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.web.OAuth20EndpointServices", (String)"762", (Object)this, (Object[])new Object[]{oauthResult, request, response, servletContext, provider, reqConsentNonce, options, autoauthz, afterLogin});
            WebUtils.throwOidcServerException(request, e);
        }
        if (options != null) {
            options.setAttribute("scope", "urn:ibm:names:oauth:response:attribute", reducedScopes);
        }
        if (provider.isTrackOAuthClients()) {
            OAuthClientTracker clientTracker = new OAuthClientTracker(request, response, provider);
            clientTracker.trackOAuthClient(clientId);
        }
        this.consent.handleConsent(provider, request, prompt, clientId);
        this.getExternalClaimsFromWSSubject(request, options);
        oauthResult = provider.processAuthorization(request, response, options);
        return oauthResult;
    }

    @FFDCIgnore(value={OidcServerException.class})
    private void secureEndpointServices(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, String requiredRole, boolean fallbackToBasicAuth) throws OidcServerException {
        try {
            this.userAuthentication.handleBasicAuthenticationWithRequiredRole(provider, request, response, this.securityServiceRef, servletContext, requiredRole, fallbackToBasicAuth);
        }
        catch (OidcServerException e) {
            if (fallbackToBasicAuth && e.getHttpStatus() == 401) {
                response.setHeader("WWW-Authenticate", "Basic realm=\"clientManager\"");
            }
            throw e;
        }
    }

    @FFDCIgnore(value={OAuth20BadParameterException.class})
    public void processTokenRequest(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) throws ServletException, OidcServerException {
        String clientId = (String)request.getAttribute("authenticatedClient");
        try {
            OidcBaseClient client = OAuth20ProviderUtils.getOidcOAuth20Client(provider, clientId);
            if (client == null || !client.isEnabled()) {
                throw new OidcServerException("security.oauth20.error.invalid.client", "invalid_client_metadata", 400);
            }
            OAuth20ProviderUtils.validateResource(request, null, client);
        }
        catch (OAuth20BadParameterException e) {
            WebUtils.throwOidcServerException(request, e);
        }
        catch (OAuth20Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.web.OAuth20EndpointServices", (String)"819", (Object)this, (Object[])new Object[]{provider, request, response});
            WebUtils.throwOidcServerException(request, e);
        }
        OAuthResult result = this.clientAuthorization.validateAndHandle2LegsScope(provider, request, response, clientId);
        if (result.getStatus() == 0) {
            result = provider.processTokenRequest(clientId, request, response);
        }
        if (result.getStatus() != 0) {
            OAuth20TokenRequestExceptionHandler handler = new OAuth20TokenRequestExceptionHandler();
            handler.handleResultException(request, response, result);
        }
    }

    public void introspect(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) throws OidcServerException, IOException {
        TokenIntrospect tokenIntrospect = new TokenIntrospect();
        tokenIntrospect.introspect(provider, request, response);
    }

    /*
     * WARNING - void declaration
     */
    public void revoke(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) {
        block22: {
            try {
                ClientAuthnData clientAuthData;
                String tokenString = request.getParameter("token");
                if (tokenString == null) {
                    WebUtils.sendErrorJSON(response, 400, "invalid_request", null);
                    return;
                }
                String tokenLookupStr = tokenString;
                OAuth20Token token = null;
                boolean isAppPasswordOrToken = false;
                if (OidcOAuth20Util.isJwtToken(tokenString)) {
                    tokenLookupStr = HashUtils.digest(tokenString);
                } else if (tokenString.length() == provider.getAccessTokenLength() + 2) {
                    String encode = provider.getAccessTokenEncoding();
                    tokenLookupStr = "plain".equals(encode) ? EndpointUtils.computeTokenHash(tokenString) : EndpointUtils.computeTokenHash(tokenString, encode);
                    isAppPasswordOrToken = true;
                }
                token = isAppPasswordOrToken ? provider.getTokenCache().getByHash(tokenLookupStr) : provider.getTokenCache().get(tokenLookupStr);
                boolean isAppPassword = false;
                if (token != null && "app_password".equals(token.getGrantType())) {
                    isAppPassword = true;
                    Tr.error((TraceComponent)tc, (String)"security.oauth20.apppwtok.revoke.disallowed", (Object[])new Object[0]);
                }
                if (token == null) {
                    response.setStatus(200);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("token " + tokenString + " not in cache or wrong token type, return"), (Object[])new Object[0]);
                    }
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("token type: " + token.getType()), (Object[])new Object[0]);
                }
                if ((clientAuthData = new ClientAuthnData(request, response)).hasAuthnData() && clientAuthData.getUserName().equals(token.getClientId())) {
                    if (!isAppPassword && (token.getType().equals("authorization_grant") && token.getSubType().equals("refresh_token") || token.getType().equals("access_token"))) {
                        if (tc.isDebugEnabled()) {
                            OAuth20Token theToken = provider.getTokenCache().get(tokenLookupStr);
                            String buf = theToken != null ? "is in the cache" : "is not in the cache";
                            Tr.debug((TraceComponent)tc, (String)("token " + tokenLookupStr + " " + buf + ", calling remove"), (Object[])new Object[0]);
                        }
                        if (isAppPasswordOrToken) {
                            provider.getTokenCache().removeByHash(tokenLookupStr);
                        } else {
                            provider.getTokenCache().remove(tokenLookupStr);
                        }
                        if (token.getSubType().equals("refresh_token")) {
                            this.removeAssociatedAccessTokens(request, provider, token);
                        }
                        response.setStatus(200);
                    } else {
                        WebUtils.sendErrorJSON(response, 400, "unsupported_token_type", null);
                    }
                } else {
                    String defaultMsg = "CWWKS1406E: The revoke request had an invalid client credential. The request URI was {" + request.getRequestURI() + "}.";
                    String errorMsg = TraceNLS.getFormattedMessage(this.getClass(), (String)MESSAGE_BUNDLE, (String)"OAUTH_INVALID_CLIENT", (Object[])new Object[]{"revoke", request.getRequestURI()}, (String)defaultMsg);
                    WebUtils.sendErrorJSON(response, 400, "invalid_client", errorMsg);
                }
            }
            catch (OAuth20DuplicateParameterException tokenString) {
                void e;
                FFDCFilter.processException((Throwable)tokenString, (String)"com.ibm.ws.security.oauth20.web.OAuth20EndpointServices", (String)"952", (Object)this, (Object[])new Object[]{provider, request, response});
                WebUtils.sendErrorJSON(response, 400, "invalid_request", e.getMessage());
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.web.OAuth20EndpointServices", (String)"955", (Object)this, (Object[])new Object[]{provider, request, response});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Internal error processing token revoke request", (Object[])new Object[]{e});
                }
                try {
                    response.sendError(500);
                }
                catch (IOException tokenLookupStr) {
                    void ioe;
                    FFDCFilter.processException((Throwable)tokenLookupStr, (String)"com.ibm.ws.security.oauth20.web.OAuth20EndpointServices", (String)"961", (Object)this, (Object[])new Object[]{provider, request, response});
                    if (!tc.isDebugEnabled()) break block22;
                    Tr.debug((TraceComponent)tc, (String)"Internal error process token introspect revoke error", (Object[])new Object[]{ioe});
                }
            }
        }
    }

    private void removeAssociatedAccessTokens(HttpServletRequest request, OAuth20Provider provider, OAuth20Token refreshToken) throws Exception {
        String contextPath = request.getContextPath();
        if (contextPath != null && !contextPath.equals("/oidc")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"not oidc, returning", (Object[])new Object[0]);
            }
            return;
        }
        if (!provider.getRevokeAccessTokensWithRefreshTokens()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"provider prop revokeAccessTokensWithRefreshTokens is false, returning", (Object[])new Object[0]);
            }
            return;
        }
        String username = refreshToken.getUsername();
        String clientId = refreshToken.getClientId();
        String refreshTokenId = refreshToken.getId();
        OAuth20EnhancedTokenCache cache = provider.getTokenCache();
        Collection<OAuth20Token> ctokens = cache.getAllUserTokens(username);
        for (OAuth20Token ctoken : ctokens) {
            boolean nullGuard = cache != null && ctoken.getType() != null && clientId != null && ctoken.getClientId() != null && ctoken.getId() != null;
            if (!nullGuard || !"access_token".equals(ctoken.getType()) || !clientId.equals(ctoken.getClientId()) || !refreshTokenId.equals(((OAuth20TokenImpl)ctoken).getRefreshTokenKey())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("removing token: " + ctoken.getId()), (Object[])new Object[0]);
            }
            cache.remove(ctoken.getId());
        }
    }

    protected void checkHttpsRequirement(HttpServletRequest request, HttpServletResponse response, OAuth20Provider provider) throws IOException {
        String url = request.getRequestURL().toString();
        if (provider.isHttpsRequired()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Checking if URL starts with https: " + url), (Object[])new Object[0]);
            }
            if (url != null && !url.startsWith("https")) {
                Tr.error((TraceComponent)tc, (String)"security.oauth20.error.wrong.http.scheme", (Object[])new Object[]{url});
                response.sendError(404, Tr.formatMessage((TraceComponent)tc, (String)"security.oauth20.error.wrong.http.scheme", (Object[])new Object[]{url}));
            }
        }
    }

    protected boolean reachedTokenLimit(OAuth20Provider provider, HttpServletRequest request) {
        long numtokens;
        String userName = this.getUserName(request);
        String clientId = this.getClientId(request);
        long limit = provider.getClientTokenCacheSize();
        if (limit > 0L && (numtokens = (long)provider.getTokenCache().getNumTokens(userName, clientId)) >= limit) {
            Tr.error((TraceComponent)tc, (String)"security.oauth20.token.limit.error", (Object[])new Object[]{userName, clientId, limit});
            return true;
        }
        return false;
    }

    private OAuth20Request getAuth20Request(HttpServletRequest request, HttpServletResponse response) throws IOException {
        OAuth20Request oauth20Request = (OAuth20Request)request.getAttribute("OAuth20Request");
        if (oauth20Request == null) {
            String errorMsg = TraceNLS.getFormattedMessage(this.getClass(), (String)MESSAGE_BUNDLE, (String)"OAUTH_REQUEST_ATTRIBUTE_MISSING", (Object[])new Object[]{request.getRequestURI(), "OAuth20Request"}, (String)"CWWKS1412E: The request endpoint {0} does not have attribute {1}.");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            response.sendError(404);
        }
        return oauth20Request;
    }

    private OAuth20Provider getProvider(HttpServletResponse response, OAuth20Request oauth20Request) throws IOException {
        OAuth20Provider provider = ProvidersService.getOAuth20Provider(oauth20Request.getProviderName());
        if (provider == null) {
            String errorMsg = TraceNLS.getFormattedMessage(this.getClass(), (String)MESSAGE_BUNDLE, (String)"OAUTH_PROVIDER_OBJECT_NULL", (Object[])new Object[]{oauth20Request.getProviderName(), "OAuth20Request"}, (String)"CWWKS1413E: The OAuth20Provider object is null for OAuth provider {0}.");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            response.sendError(404);
        }
        return provider;
    }

    private String getReqConsentNonce(HttpServletRequest request) {
        return request.getParameter(ATTR_NONCE);
    }

    private String getUserName(HttpServletRequest request) {
        return request.getUserPrincipal().getName();
    }

    private String getClientId(HttpServletRequest request) {
        return request.getParameter("client_id");
    }

    protected boolean isAfterLogin(HttpServletRequest request) {
        boolean output = false;
        HttpSession session = request.getSession(false);
        if (session != null && session.getAttribute("afterLogin") != null) {
            session.removeAttribute("afterLogin");
            output = true;
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String[]> getExternalClaimsFromWSSubject(HttpServletRequest request, AttributeList options) {
        block10: {
            String methodName = "getExternalClaimsFromWSSubject";
            try {
                String externalClaimNames = options.getAttributeValueByName("externalClaimNames");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getExternalClaimsFromWSSubject externalClamiNames:" + externalClaimNames), (Object[])new Object[0]);
                }
                if (externalClaimNames != null) {
                    Map map2 = (Map)this.getFromWSSubject("com.ibm.wsspi.security.oidc.external.mediation");
                    if (map2 != null && map2.size() > 0) {
                        Set entries = map2.entrySet();
                        for (Map.Entry entry : entries) {
                            options.setAttribute((String)entry.getKey(), "com.ibm.wsspi.security.oidc.external.mediation", (String[])entry.getValue());
                        }
                    }
                    Map map = (Map)this.getFromWSSubject("com.ibm.wsspi.security.oidc.external.claims");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getExternalClaimsFromWSSubject externalClaims:" + map), (Object[])new Object[0]);
                    }
                    if (map == null) {
                        return null;
                    }
                    StringTokenizer strTokenizer = new StringTokenizer(externalClaimNames, ", ");
                    while (strTokenizer.hasMoreTokens()) {
                        String key = strTokenizer.nextToken();
                        String[] values = (String[])map.get(key);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("getExternalClaimsFromWSSubject key:" + key + " values:'" + OAuth20Util.arrayToSpaceString(values) + "'"), (Object[])new Object[0]);
                        }
                        if (values == null || values.length <= 0) continue;
                        options.setAttribute("com.ibm.wsspi.security.oidc.external.claims:" + key, "com.ibm.wsspi.security.oidc.external.claims", values);
                    }
                    return map;
                }
            }
            catch (WSSecurityException externalClaimNames) {
                void e;
                FFDCFilter.processException((Throwable)externalClaimNames, (String)"com.ibm.ws.security.oauth20.web.OAuth20EndpointServices", (String)"1143", (Object)this, (Object[])new Object[]{request, options});
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug((TraceComponent)tc, (String)("getExternalClaimsFromWSSubject failed. Nothing changed. WSSecurityException:" + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Object getFromWSSubject(String externalClaims) throws WSSecurityException {
        Object obj;
        block4: {
            Subject runAsSubject = WSSubject.getRunAsSubject();
            obj = null;
            try {
                Set<Object> publicCreds = runAsSubject.getPublicCredentials();
                if (publicCreds == null || publicCreds.size() <= 0) break block4;
                for (Object cred : publicCreds) {
                    Hashtable userCred;
                    if (cred == null || !(cred instanceof Hashtable) || (obj = (userCred = (Hashtable)cred).get(externalClaims)) == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getFromWSSubject found:" + obj), (Object[])new Object[0]);
                    }
                    break;
                }
            }
            catch (Exception publicCreds) {
                void e;
                FFDCFilter.processException((Throwable)publicCreds, (String)"com.ibm.ws.security.oauth20.web.OAuth20EndpointServices", (String)"1178", (Object)this, (Object[])new Object[]{externalClaims});
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Unable to match predefined cache key." + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return obj;
    }

    private OAuthResult checkForError(HttpServletRequest request) {
        OAuthResultImpl result = null;
        String error = request.getParameter("error");
        if (error != null && error.length() > 0 && "access_denied".equals(error)) {
            String errorMsg = TraceNLS.getFormattedMessage(this.getClass(), (String)MESSAGE_BUNDLE, (String)"security.oauth20.request.denied", (Object[])new Object[0], (String)"CWOAU0067E: The request has been denied by the user, or another error occurred that resulted in denial of the request.");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            OAuth20AccessDeniedException e = new OAuth20AccessDeniedException("security.oauth20.request.denied");
            e.setHttpStatusCode(403);
            AttributeList attrs = new AttributeList();
            String value = request.getParameter("response_type");
            if (value != null && value.length() > 0) {
                attrs.setAttribute("response_type", "response_type", new String[]{value});
            }
            if ((value = this.getClientId(request)) != null && value.length() > 0) {
                attrs.setAttribute("client_id", "client_id", new String[]{value});
            }
            result = new OAuthResultImpl(1, attrs, e);
        }
        return result;
    }

    protected Map<String, Object> getUserClaimsMap(UserClaims userClaims, boolean groupsOnly) throws IOException {
        return TokenIntrospect.getUserClaimsMap(userClaims, groupsOnly);
    }

    protected UserClaims getUserClaimsObj(OAuth20Provider provider, OAuth20Token accessToken) throws IOException {
        return TokenIntrospect.getUserClaimsObj(provider, accessToken);
    }
}

