/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.j2ee.mbeans;

import com.ibm.websphere.management.j2ee.J2EEManagementObjectNameFactory;
import com.ibm.websphere.management.j2ee.J2EEServerMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import com.ibm.ws.management.j2ee.mbeans.internal.MBeanServerHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class J2EEServerMBeanImpl
extends StandardMBean
implements J2EEServerMBean {
    private static final String serverVendor = "IBM";
    private final String serverName;
    private final ObjectName objectName;
    static final long serialVersionUID = 1779933111986191379L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public J2EEServerMBeanImpl(String serverName) {
        super(J2EEServerMBean.class, false);
        this.objectName = J2EEManagementObjectNameFactory.createJ2EEServerObjectName((String)serverName);
        this.serverName = serverName;
    }

    public String getobjectName() {
        return this.objectName.toString();
    }

    public boolean isstateManageable() {
        return false;
    }

    public boolean isstatisticsProvider() {
        return false;
    }

    public boolean iseventProvider() {
        return false;
    }

    public String[] getdeployedObjects() {
        ArrayList<String> deployedObjects = new ArrayList<String>();
        deployedObjects.addAll(MBeanServerHelper.queryObjectName(this.createPropertyPatternObjectName("J2EEApplication")));
        List<J2EEManagementObjectNameFactory.ModuleType> allModuleTypes = Arrays.asList(J2EEManagementObjectNameFactory.ModuleType.values());
        for (J2EEManagementObjectNameFactory.ModuleType moduleType : allModuleTypes) {
            deployedObjects.addAll(MBeanServerHelper.queryObjectName(this.createPropertyPatternObjectName(moduleType.name())));
        }
        return deployedObjects.toArray(new String[deployedObjects.size()]);
    }

    public String[] getresources() {
        ArrayList<String> resources = new ArrayList<String>();
        List<J2EEManagementObjectNameFactory.ResourceType> allResourceTypes = Arrays.asList(J2EEManagementObjectNameFactory.ResourceType.values());
        for (J2EEManagementObjectNameFactory.ResourceType resourceType : allResourceTypes) {
            resources.addAll(MBeanServerHelper.queryObjectName(this.createPropertyPatternObjectName(resourceType.name())));
        }
        return resources.toArray(new String[resources.size()]);
    }

    public String[] getjavaVMs() {
        ArrayList<String> javaVMs = new ArrayList<String>();
        javaVMs.addAll(MBeanServerHelper.queryObjectName(this.createPropertyPatternObjectName("JVM")));
        return javaVMs.toArray(new String[javaVMs.size()]);
    }

    public String getserverVendor() {
        return serverVendor;
    }

    public String getserverVersion() {
        return this.getProductVersion();
    }

    private String getProductVersion() {
        Map productIdToVersionPropertiesMap = null;
        try {
            productIdToVersionPropertiesMap = ProductInfo.getAllProductInfo();
            for (ProductInfo versionProperties : productIdToVersionPropertiesMap.values()) {
                if (versionProperties.getReplacedBy() != null) continue;
                return versionProperties.getVersion();
            }
        }
        catch (ProductInfoParseException productInfoParseException) {
            FFDCFilter.processException((Throwable)productInfoParseException, (String)"com.ibm.ws.management.j2ee.mbeans.J2EEServerMBeanImpl", (String)"139", (Object)this, (Object[])new Object[0]);
        }
        catch (DuplicateProductInfoException duplicateProductInfoException) {
            FFDCFilter.processException((Throwable)duplicateProductInfoException, (String)"com.ibm.ws.management.j2ee.mbeans.J2EEServerMBeanImpl", (String)"141", (Object)this, (Object[])new Object[0]);
        }
        catch (ProductInfoReplaceException productInfoReplaceException) {
            FFDCFilter.processException((Throwable)productInfoReplaceException, (String)"com.ibm.ws.management.j2ee.mbeans.J2EEServerMBeanImpl", (String)"143", (Object)this, (Object[])new Object[0]);
        }
        return null;
    }

    private ObjectName createPropertyPatternObjectName(String j2eeType) {
        StringBuilder nameBuilder = new StringBuilder("WebSphere").append(":");
        nameBuilder.append("j2eeType").append("=").append(j2eeType).append(",");
        nameBuilder.append("J2EEServer").append("=").append(this.serverName);
        nameBuilder.append(",*");
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(nameBuilder.toString());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.ws.management.j2ee.mbeans.J2EEServerMBeanImpl", (String)"159", (Object)this, (Object[])new Object[]{j2eeType});
        }
        return objectName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.management.j2ee.mbeans.J2EEServerMBeanImpl", J2EEServerMBeanImpl.class, null, null);
    }
}

