/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HashUtils {
    private static final TraceComponent tc = Tr.register(HashUtils.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    private static String DEFAULT_ALGORITHM = "SHA-256";
    private static String DEFAULT_CHARSET = "UTF-8";
    static final long serialVersionUID = -4960261805540745404L;

    @Sensitive
    @Trivial
    public static String digest(@Sensitive String input) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        return HashUtils.digest(input, DEFAULT_ALGORITHM, DEFAULT_CHARSET);
    }

    /*
     * WARNING - void declaration
     */
    @Sensitive
    @Trivial
    protected static String digest(@Sensitive String input, @Sensitive String algorithm, String charset) {
        String output = null;
        if (input != null && input.length() > 0) {
            try {
                MessageDigest md = MessageDigest.getInstance(algorithm);
                md.update(input.getBytes(charset));
                output = Base64Coder.toString(Base64Coder.base64Encode(md.digest()));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                void nsae;
                Object[] objectArray = new Object[3];
                objectArray[0] = "<sensitive java.lang.String>";
                objectArray[1] = "<sensitive java.lang.String>";
                objectArray[2] = charset;
                FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.security.openidconnect.clients.common.HashUtils", (String)"58", null, (Object[])objectArray);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception instanciating MessageDigest. The algorithm is " + algorithm + nsae), (Object[])new Object[0]);
                }
                throw new RuntimeException("Exception instanciating MessageDigest : " + nsae);
            }
            catch (UnsupportedEncodingException nsae) {
                void uee;
                Object[] objectArray = new Object[3];
                objectArray[0] = "<sensitive java.lang.String>";
                objectArray[1] = "<sensitive java.lang.String>";
                objectArray[2] = charset;
                FFDCFilter.processException((Throwable)nsae, (String)"com.ibm.ws.security.openidconnect.clients.common.HashUtils", (String)"63", null, (Object[])objectArray);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception converting String object : " + uee), (Object[])new Object[0]);
                }
                throw new RuntimeException("Exception converting String object : " + uee);
            }
        }
        return output;
    }

    @Sensitive
    @Trivial
    public static String getStrHashCode(String input) {
        if (input != null && !input.isEmpty()) {
            int hashCode = input.hashCode();
            if (hashCode < 0) {
                return "n" + (hashCode *= -1);
            }
            return "p" + hashCode;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"hash() gets a null or empty parameter", (Object[])new Object[0]);
        }
        return "";
    }

    @Sensitive
    @Trivial
    public static String getCookieName(String prefix, ConvergedClientConfig clientConfig, String state) {
        String newValue = state + clientConfig.getId();
        String newName = HashUtils.getStrHashCode(newValue);
        return prefix + newName;
    }

    @Sensitive
    @Trivial
    public static String createStateCookieValue(ConvergedClientConfig clientConfig, String state) {
        String timestamp = state.substring(0, 15);
        String newValue = state + clientConfig.getClientSecret();
        String value = HashUtils.digest(newValue);
        return timestamp + value;
    }
}

