/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.container.cdi;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.application.Application;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class CDIJSFInitializer {
    private static final Logger log = Logger.getLogger("com.ibm.ws.jsf.container.cdi");

    public static void initialize(Application application, String appname) {
        block7: {
            try {
                BeanManager beanManager = (BeanManager)InitialContext.doLookup("java:comp/BeanManager");
                if (beanManager != null) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.logp(Level.FINEST, CDIJSFInitializer.class.getName(), "initializeJSF", "Initializing application with CDI", appname);
                    }
                    try {
                        String className = "2.2".equals(System.getProperty("com.ibm.ws.jsfContainer.JSF_SPEC_LEVEL")) ? "org.jboss.weld.el.WeldELContextListener" : "org.jboss.weld.module.web.el.WeldELContextListener";
                        Constructor<?> constructor = Class.forName(className).getConstructor(new Class[0]);
                        application.addELContextListener((ELContextListener)constructor.newInstance(new Object[0]));
                    }
                    catch (ReflectiveOperationException e) {
                        e.printStackTrace();
                    }
                    ELResolver elResolver = beanManager.getELResolver();
                    application.addELResolver(elResolver);
                    break block7;
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.logp(Level.FINEST, CDIJSFInitializer.class.getName(), "initializeJSF", "No BeanManager found for application", appname);
                }
            }
            catch (NamingException e) {
                if (!log.isLoggable(Level.FINEST)) break block7;
                log.log(Level.FINEST, e.getMessage(), e);
            }
        }
    }
}

