/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.yoko.rmi.impl.ClosedObjectReader;
import org.apache.yoko.rmi.impl.DelegatingObjectReader;
import org.apache.yoko.rmi.impl.DelegatingObjectReaderWithBeforeReadHook;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;

public final class CustomMarshaledObjectReader
extends DelegatingObjectReader {
    private final ObjectReader objectReader;
    private State state = State.UNINITIALISED;

    public static ObjectReader wrap(final ObjectReader delegate) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ObjectReader>(){

                @Override
                public ObjectReader run() throws IOException {
                    return new CustomMarshaledObjectReader(delegate);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
    }

    private CustomMarshaledObjectReader(ObjectReader delegate) throws IOException {
        this.objectReader = delegate;
        this.setState(State.BEFORE_CUSTOM_DATA);
    }

    private State setState(State newState) throws IOException {
        this.state.checkStateTransition(newState);
        try {
            State state = this.state;
            return state;
        }
        finally {
            this.state = newState;
            switch (newState) {
                case UNINITIALISED: {
                    throw new IllegalStateException();
                }
                case BEFORE_CUSTOM_DATA: {
                    this.delegateTo(this.getDefaultWriteObjectReader(this.objectReader));
                    break;
                }
                case IN_CUSTOM_DATA: {
                    this.delegateTo(this.objectReader);
                    break;
                }
                case CLOSED: {
                    this.delegateTo(ClosedObjectReader.INSTANCE);
                }
            }
        }
    }

    private ObjectReader getDefaultWriteObjectReader(final ObjectReader delegate) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ObjectReader>(){

                @Override
                public ObjectReader run() throws IOException {
                    return new DefaultWriteObjectReader(delegate);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
    }

    private void readCustomRMIValue() throws IOException {
        this.setState(State.IN_CUSTOM_DATA);
        this.objectReader._startValue();
    }

    @Override
    public void close() throws IOException {
        switch (this.setState(State.CLOSED)) {
            case UNINITIALISED: {
                throw new IllegalStateException();
            }
            case BEFORE_CUSTOM_DATA: {
                this.objectReader.readValueObject();
                break;
            }
            case IN_CUSTOM_DATA: {
                this.objectReader._endValue();
                break;
            }
        }
    }

    @Override
    protected final Object readObjectOverride() throws ClassNotFoundException, IOException {
        return super.readObjectOverride0();
    }

    private final class DefaultWriteObjectReader
    extends DelegatingObjectReaderWithBeforeReadHook {
        private boolean allowDefaultRead;

        private DefaultWriteObjectReader(ObjectReader delegate) throws IOException {
            super(delegate);
            this.allowDefaultRead = true;
        }

        @Override
        public void defaultReadObject() throws IOException, ClassNotFoundException {
            if (!this.allowDefaultRead) {
                throw new IllegalStateException("defaultReadObject() or readFields() must not be called more than once");
            }
            this.allowDefaultRead = false;
            CustomMarshaledObjectReader.this.objectReader.defaultReadObject();
        }

        @Override
        public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
            if (this.allowDefaultRead) {
                this.allowDefaultRead = false;
                return CustomMarshaledObjectReader.this.objectReader.readFields();
            }
            throw new IllegalStateException("readFields() or defaultReadObject() must not be called more than once");
        }

        @Override
        void beforeRead() {
            try {
                CustomMarshaledObjectReader.this.readCustomRMIValue();
            }
            catch (IOException e) {
                throw (MARSHAL)new MARSHAL(e.toString()).initCause((Throwable)e);
            }
        }
    }

    private static enum State {
        UNINITIALISED,
        BEFORE_CUSTOM_DATA,
        IN_CUSTOM_DATA,
        CLOSED;

        private static final Map<State, Set<State>> TRANSITIONS;

        private static void allow(Map<State, Set<State>> map, State from, Set<State> to) {
            map.put(from, to);
        }

        private static State from(State state) {
            return state;
        }

        private static Set<State> to(State state, State ... states) {
            return Collections.unmodifiableSet(EnumSet.of(state, states));
        }

        void checkStateTransition(State newState) {
            if (TRANSITIONS.get((Object)this).contains((Object)newState)) {
                return;
            }
            throw new INTERNAL("Unexpected state transition from " + (Object)((Object)this) + " to " + (Object)((Object)newState));
        }

        static {
            EnumMap<State, Set<State>> transition = new EnumMap<State, Set<State>>(State.class);
            State.allow(transition, State.from(UNINITIALISED), State.to(BEFORE_CUSTOM_DATA, new State[0]));
            State.allow(transition, State.from(BEFORE_CUSTOM_DATA), State.to(IN_CUSTOM_DATA, CLOSED));
            State.allow(transition, State.from(IN_CUSTOM_DATA), State.to(CLOSED, new State[0]));
            State.allow(transition, State.from(CLOSED), State.to(CLOSED, new State[0]));
            TRANSITIONS = Collections.unmodifiableMap(transition);
        }
    }
}

