/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

import jakarta.servlet.jsp.PageContext;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.taglibs.standard.extra.commons.collections.map.LRUMap;
import org.apache.taglibs.standard.lang.jstl.Coercions;
import org.apache.taglibs.standard.lang.jstl.Constants;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.Expression;
import org.apache.taglibs.standard.lang.jstl.ExpressionString;
import org.apache.taglibs.standard.lang.jstl.Logger;
import org.apache.taglibs.standard.lang.jstl.VariableResolver;
import org.apache.taglibs.standard.lang.jstl.parser.ELParser;
import org.apache.taglibs.standard.lang.jstl.parser.ParseException;
import org.apache.taglibs.standard.lang.jstl.parser.Token;
import org.apache.taglibs.standard.lang.jstl.parser.TokenMgrError;

public class ELEvaluator {
    private static final String EXPR_CACHE_PARAM = "org.apache.taglibs.standard.lang.jstl.exprCacheSize";
    private static final int MAX_SIZE = 100;
    static Map sCachedExpressionStrings = null;
    static Map sCachedExpectedTypes = new HashMap();
    static Logger sLogger = new Logger(System.out);
    VariableResolver mResolver;
    boolean mBypassCache;
    PageContext pageContext;

    public ELEvaluator(VariableResolver pResolver) {
        this.mResolver = pResolver;
    }

    public ELEvaluator(VariableResolver pResolver, boolean pBypassCache) {
        this.mResolver = pResolver;
        this.mBypassCache = pBypassCache;
    }

    public void setBypassCache(boolean pBypassCache) {
        this.mBypassCache = pBypassCache;
    }

    public boolean getBypassCache() {
        return this.mBypassCache;
    }

    public Object evaluate(String pExpressionString, Object pContext, Class pExpectedType, Map functions, String defaultPrefix) throws ELException {
        return this.evaluate(pExpressionString, pContext, pExpectedType, functions, defaultPrefix, sLogger);
    }

    Object evaluate(String pExpressionString, Object pContext, Class pExpectedType, Map functions, String defaultPrefix, Logger pLogger) throws ELException {
        if (pExpressionString == null) {
            throw new ELException(Constants.NULL_EXPRESSION_STRING);
        }
        this.pageContext = (PageContext)pContext;
        Object parsedValue = this.parseExpressionString(pExpressionString);
        if (parsedValue instanceof String) {
            String strValue = (String)parsedValue;
            return this.convertStaticValueToExpectedType(strValue, pExpectedType, pLogger);
        }
        if (parsedValue instanceof Expression) {
            Object value = ((Expression)parsedValue).evaluate(pContext, this.mResolver, functions, defaultPrefix, pLogger);
            return this.convertToExpectedType(value, pExpectedType, pLogger);
        }
        if (parsedValue instanceof ExpressionString) {
            String strValue = ((ExpressionString)parsedValue).evaluate(pContext, this.mResolver, functions, defaultPrefix, pLogger);
            return this.convertToExpectedType(strValue, pExpectedType, pLogger);
        }
        return null;
    }

    public Object parseExpressionString(String pExpressionString) throws ELException {
        return this.parseExpressionString(pExpressionString, this.mBypassCache);
    }

    public Object parseExpressionString(String pExpressionString, boolean bypassCache) throws ELException {
        Object ret;
        if (pExpressionString.length() == 0) {
            return "";
        }
        if (!bypassCache && sCachedExpressionStrings == null) {
            this.createExpressionStringMap();
        }
        Object object = ret = bypassCache || sCachedExpressionStrings == null ? null : (Object)sCachedExpressionStrings.get(pExpressionString);
        if (ret == null) {
            StringReader r = new StringReader(pExpressionString);
            ELParser parser = new ELParser(r);
            try {
                ret = parser.ExpressionString();
                if (!bypassCache && sCachedExpressionStrings != null) {
                    sCachedExpressionStrings.put(pExpressionString, ret);
                }
            }
            catch (ParseException exc) {
                throw new ELException(ELEvaluator.formatParseException(pExpressionString, exc));
            }
            catch (TokenMgrError exc) {
                throw new ELException(exc.getMessage());
            }
        }
        return ret;
    }

    Object convertToExpectedType(Object pValue, Class pExpectedType, Logger pLogger) throws ELException {
        return Coercions.coerce(pValue, pExpectedType, pLogger);
    }

    Object convertStaticValueToExpectedType(String pValue, Class pExpectedType, Logger pLogger) throws ELException {
        if (pExpectedType == String.class || pExpectedType == Object.class) {
            return pValue;
        }
        Map valueByString = ELEvaluator.getOrCreateExpectedTypeMap(pExpectedType);
        if (!this.mBypassCache && valueByString.containsKey(pValue)) {
            return valueByString.get(pValue);
        }
        Object ret = Coercions.coerce(pValue, pExpectedType, pLogger);
        valueByString.put(pValue, ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map getOrCreateExpectedTypeMap(Class pExpectedType) {
        Map map = sCachedExpectedTypes;
        synchronized (map) {
            Map ret = (Map)sCachedExpectedTypes.get(pExpectedType);
            if (ret == null) {
                ret = Collections.synchronizedMap(new HashMap());
                sCachedExpectedTypes.put(pExpectedType, ret);
            }
            return ret;
        }
    }

    private void createExpressionStringMap() {
        if (sCachedExpressionStrings != null) {
            return;
        }
        if (this.pageContext == null) {
            return;
        }
        String value = this.pageContext.getServletContext().getInitParameter(EXPR_CACHE_PARAM);
        sCachedExpressionStrings = value != null ? Collections.synchronizedMap(new LRUMap(Integer.parseInt(value))) : Collections.synchronizedMap(new LRUMap(100));
    }

    static String formatParseException(String pExpressionString, ParseException pExc) {
        StringBuffer expectedBuf = new StringBuffer();
        int maxSize = 0;
        boolean printedOne = false;
        if (pExc.expectedTokenSequences == null) {
            return pExc.toString();
        }
        for (int i = 0; i < pExc.expectedTokenSequences.length; ++i) {
            if (maxSize < pExc.expectedTokenSequences[i].length) {
                maxSize = pExc.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < pExc.expectedTokenSequences[i].length; ++j) {
                if (printedOne) {
                    expectedBuf.append(", ");
                }
                expectedBuf.append(pExc.tokenImage[pExc.expectedTokenSequences[i][j]]);
                printedOne = true;
            }
        }
        String expected = expectedBuf.toString();
        StringBuffer encounteredBuf = new StringBuffer();
        Token tok = pExc.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                encounteredBuf.append(" ");
            }
            if (tok.kind == 0) {
                encounteredBuf.append(pExc.tokenImage[0]);
                break;
            }
            encounteredBuf.append(ELEvaluator.addEscapes(tok.image));
            tok = tok.next;
        }
        String encountered = encounteredBuf.toString();
        return MessageFormat.format(Constants.PARSE_EXCEPTION, expected, encountered);
    }

    static String addEscapes(String str) {
        StringBuffer retval = new StringBuffer();
        block8: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block8;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block8;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block8;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block8;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block8;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block8;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block8;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }

    public String parseAndRender(String pExpressionString) throws ELException {
        Object val = this.parseExpressionString(pExpressionString);
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof Expression) {
            return "${" + ((Expression)val).getExpressionString() + "}";
        }
        if (val instanceof ExpressionString) {
            return ((ExpressionString)val).getExpressionString();
        }
        return "";
    }
}

