/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl.test;

import jakarta.servlet.jsp.JspException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.taglibs.standard.lang.jstl.Evaluator;

public class ParserTest {
    public static void runTests(DataInput pIn, PrintStream pOut) throws IOException {
        String str;
        while ((str = pIn.readLine()) != null) {
            if (str.startsWith("#") || "".equals(str.trim())) {
                pOut.println(str);
                continue;
            }
            if ("@@non-ascii".equals(str)) {
                str = "\u1111";
            }
            pOut.println("Attribute value: " + str);
            try {
                String result = Evaluator.parseAndRender(str);
                pOut.println("Parses to: " + result);
            }
            catch (JspException exc) {
                pOut.println("Causes an error: " + exc.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runTests(File pInputFile, File pOutputFile) throws IOException {
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            fin = new FileInputStream(pInputFile);
            BufferedInputStream bin = new BufferedInputStream(fin);
            DataInputStream din = new DataInputStream(bin);
            try {
                fout = new FileOutputStream(pOutputFile);
                BufferedOutputStream bout = new BufferedOutputStream(fout);
                PrintStream pout = new PrintStream(bout);
                ParserTest.runTests(din, pout);
                pout.flush();
            }
            finally {
                if (fout != null) {
                    fout.close();
                }
            }
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
    }

    public static boolean isDifferentFiles(DataInput pIn1, DataInput pIn2) throws IOException {
        String str2;
        String str1;
        do {
            str1 = pIn1.readLine();
            str2 = pIn2.readLine();
            if (str1 == null && str2 == null) {
                return false;
            }
            if (str1 != null && str2 != null) continue;
            return true;
        } while (str1.equals(str2));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDifferentFiles(File pFile1, File pFile2) throws IOException {
        FileInputStream fin1 = null;
        try {
            boolean bl;
            block8: {
                fin1 = new FileInputStream(pFile1);
                BufferedInputStream bin1 = new BufferedInputStream(fin1);
                DataInputStream din1 = new DataInputStream(bin1);
                FileInputStream fin2 = null;
                try {
                    fin2 = new FileInputStream(pFile2);
                    BufferedInputStream bin2 = new BufferedInputStream(fin2);
                    DataInputStream din2 = new DataInputStream(bin2);
                    bl = ParserTest.isDifferentFiles(din1, din2);
                    if (fin2 == null) break block8;
                }
                catch (Throwable throwable) {
                    if (fin2 != null) {
                        fin2.close();
                    }
                    throw throwable;
                }
                fin2.close();
            }
            return bl;
        }
        finally {
            if (fin1 != null) {
                fin1.close();
            }
        }
    }

    public static void main(String[] pArgs) throws IOException {
        if (pArgs.length != 2 && pArgs.length != 3) {
            ParserTest.usage();
            System.exit(1);
        }
        File in = new File(pArgs[0]);
        File out = new File(pArgs[1]);
        ParserTest.runTests(in, out);
        if (pArgs.length > 2) {
            File compare = new File(pArgs[2]);
            if (ParserTest.isDifferentFiles(out, compare)) {
                System.out.println("Test failure - output file " + out + " differs from expected output file " + compare);
            } else {
                System.out.println("tests passed");
            }
        }
    }

    static void usage() {
        System.err.println("usage: java org.apache.taglibs.standard.lang.jstl.test.ParserTest {input file} {output file} [{compare file}]");
    }
}

