/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.fmt;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspTagException;
import jakarta.servlet.jsp.tagext.Tag;
import jakarta.servlet.jsp.tagext.TagSupport;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.tag.common.fmt.SetLocaleSupport;
import org.apache.taglibs.standard.tag.common.fmt.TimeZoneSupport;

public abstract class FormatDateSupport
extends TagSupport {
    private static final String DATE = "date";
    private static final String TIME = "time";
    private static final String DATETIME = "both";
    protected Date value;
    protected String type;
    protected String pattern;
    protected Object timeZone;
    protected String dateStyle;
    protected String timeStyle;
    private String var;
    private int scope;

    public FormatDateSupport() {
        this.init();
    }

    private void init() {
        this.timeStyle = null;
        this.dateStyle = null;
        this.type = null;
        this.var = null;
        this.pattern = null;
        this.value = null;
        this.timeZone = null;
        this.scope = 1;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = Util.getScope(scope);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doEndTag() throws JspException {
        String formatted = null;
        if (this.value == null) {
            if (this.var == null) return 6;
            this.pageContext.removeAttribute(this.var, this.scope);
            return 6;
        }
        Locale locale = SetLocaleSupport.getFormattingLocale(this.pageContext, (Tag)this, true, DateFormat.getAvailableLocales());
        if (locale != null) {
            DateFormat formatter = this.createFormatter(locale);
            if (this.pattern != null) {
                try {
                    ((SimpleDateFormat)formatter).applyPattern(this.pattern);
                }
                catch (ClassCastException cce) {
                    formatter = new SimpleDateFormat(this.pattern, locale);
                }
            }
            TimeZone tz = null;
            if (this.timeZone instanceof String && ((String)this.timeZone).equals("")) {
                this.timeZone = null;
            }
            if (this.timeZone != null) {
                if (this.timeZone instanceof String) {
                    tz = TimeZone.getTimeZone((String)this.timeZone);
                } else {
                    if (!(this.timeZone instanceof TimeZone)) throw new JspTagException(Resources.getMessage("FORMAT_DATE_BAD_TIMEZONE"));
                    tz = (TimeZone)this.timeZone;
                }
            } else {
                tz = TimeZoneSupport.getTimeZone(this.pageContext, (Tag)this);
            }
            if (tz != null) {
                formatter.setTimeZone(tz);
            }
            formatted = formatter.format(this.value);
        } else {
            formatted = this.value.toString();
        }
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, (Object)formatted, this.scope);
            return 6;
        }
        try {
            this.pageContext.getOut().print(formatted);
            return 6;
        }
        catch (IOException ioe) {
            throw new JspTagException(ioe.toString(), (Throwable)ioe);
        }
    }

    public void release() {
        this.init();
    }

    private DateFormat createFormatter(Locale loc) throws JspException {
        DateFormat formatter = null;
        if (this.type == null || DATE.equalsIgnoreCase(this.type)) {
            formatter = DateFormat.getDateInstance(Util.getStyle(this.dateStyle, "FORMAT_DATE_INVALID_DATE_STYLE"), loc);
        } else if (TIME.equalsIgnoreCase(this.type)) {
            formatter = DateFormat.getTimeInstance(Util.getStyle(this.timeStyle, "FORMAT_DATE_INVALID_TIME_STYLE"), loc);
        } else if (DATETIME.equalsIgnoreCase(this.type)) {
            formatter = DateFormat.getDateTimeInstance(Util.getStyle(this.dateStyle, "FORMAT_DATE_INVALID_DATE_STYLE"), Util.getStyle(this.timeStyle, "FORMAT_DATE_INVALID_TIME_STYLE"), loc);
        } else {
            throw new JspException(Resources.getMessage("FORMAT_DATE_INVALID_TYPE", this.type));
        }
        return formatter;
    }
}

