/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.injection.InjectionContextImpl;
import org.jboss.weld.injection.ResourceInjection;
import org.jboss.weld.injection.ResourceInjectionFactory;
import org.jboss.weld.injection.producer.DefaultInjector;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.collections.ImmutableList;

public class ResourceInjector<T>
extends DefaultInjector<T> {
    private List<Set<ResourceInjection<?>>> resourceInjectionsHierarchy;

    public static <T> ResourceInjector<T> of(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager) {
        return new ResourceInjector<T>(type, bean, beanManager);
    }

    protected ResourceInjector(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager) {
        super(type, bean, beanManager);
        ResourceInjectionFactory factory = beanManager.getServices().get(ResourceInjectionFactory.class);
        this.resourceInjectionsHierarchy = ImmutableList.copyOf(factory.getResourceInjections(bean, type, beanManager));
    }

    @Override
    public void inject(final T instance, final CreationalContext<T> ctx, final BeanManagerImpl manager, SlimAnnotatedType<T> type, InjectionTarget<T> injectionTarget) {
        new InjectionContextImpl<T>(manager, injectionTarget, type, instance){

            @Override
            public void proceed() {
                Beans.injectEEFields(ResourceInjector.this.resourceInjectionsHierarchy, instance, ctx);
                Beans.injectFieldsAndInitializers(instance, ctx, manager, ResourceInjector.this.getInjectableFields(), ResourceInjector.this.getInitializerMethods());
            }
        }.run();
    }
}

