/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.parser.processors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.impl.parser.ResolverCache;
import com.ibm.ws.microprofile.openapi.impl.parser.models.RefFormat;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.ExternalRefProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.util.RefUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.media.Schema;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SchemaProcessor {
    private final ResolverCache cache;
    private final ExternalRefProcessor externalRefProcessor;
    static final long serialVersionUID = -2080863610833679449L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SchemaProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.cache = cache;
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
    }

    public void processSchema(Schema schema) {
        if (schema != null) {
            if (schema.getRef() != null) {
                this.processReferenceSchema(schema);
            } else {
                this.processSchemaType(schema);
            }
        }
    }

    public static boolean isComposedSchema(Schema schema) {
        if (schema.getAllOf() != null) {
            return true;
        }
        if (schema.getAnyOf() != null) {
            return true;
        }
        return schema.getOneOf() != null;
    }

    public void processSchemaType(Schema schema) {
        if (schema.getType() == Schema.SchemaType.ARRAY) {
            this.processArraySchema(schema);
        } else if (SchemaProcessor.isComposedSchema(schema)) {
            this.processComposedSchema(schema);
        }
        if (schema.getProperties() != null) {
            this.processPropertySchema(schema);
        }
        if (schema.getNot() != null) {
            this.processNotSchema(schema);
        }
        if (schema.getAdditionalProperties() != null) {
            this.processAdditionalProperties(schema);
        }
    }

    private void processAdditionalProperties(Schema schema) {
        if (schema.getAdditionalProperties() != null && schema.getAdditionalProperties() instanceof Schema) {
            Schema addProps = (Schema)schema.getAdditionalProperties();
            if (addProps.getRef() != null) {
                this.processReferenceSchema(addProps);
            } else {
                this.processSchemaType(addProps);
            }
        }
    }

    private void processNotSchema(Schema schema) {
        if (schema.getNot() != null) {
            if (schema.getNot().getRef() != null) {
                this.processReferenceSchema(schema.getNot());
            } else {
                this.processSchemaType(schema.getNot());
            }
        }
    }

    public void processPropertySchema(Schema schema) {
        Map properties;
        if (schema.getRef() != null) {
            this.processReferenceSchema(schema);
        }
        if ((properties = schema.getProperties()) != null) {
            for (Map.Entry propertyEntry : properties.entrySet()) {
                Schema property = (Schema)propertyEntry.getValue();
                if (property.getType() == Schema.SchemaType.ARRAY) {
                    this.processArraySchema(property);
                }
                if (property.getRef() == null) continue;
                this.processReferenceSchema(property);
            }
        }
    }

    public void processComposedSchema(Schema composedSchema) {
        List schemas;
        if (composedSchema.getAllOf() != null && (schemas = composedSchema.getAllOf()) != null) {
            for (Schema schema : schemas) {
                if (schema.getRef() != null) {
                    this.processReferenceSchema(schema);
                    continue;
                }
                this.processSchemaType(schema);
            }
        }
        if (composedSchema.getOneOf() != null && (schemas = composedSchema.getOneOf()) != null) {
            for (Schema schema : schemas) {
                if (schema.getRef() != null) {
                    this.processReferenceSchema(schema);
                    continue;
                }
                this.processSchemaType(schema);
            }
        }
        if (composedSchema.getAnyOf() != null && (schemas = composedSchema.getAnyOf()) != null) {
            for (Schema schema : schemas) {
                if (schema.getRef() != null) {
                    this.processReferenceSchema(schema);
                    continue;
                }
                this.processSchemaType(schema);
            }
        }
    }

    public void processArraySchema(Schema arraySchema) {
        Schema items = arraySchema.getItems();
        if (items.getRef() != null) {
            this.processReferenceSchema(items);
        } else {
            this.processSchemaType(items);
        }
    }

    private void processReferenceSchema(Schema schema) {
        String newRef;
        RefFormat refFormat = RefUtils.computeRefFormat(schema.getRef());
        String $ref = schema.getRef();
        if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalSchema($ref, refFormat)) != null) {
            schema.setRef(newRef);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.openapi.impl.parser.processors.SchemaProcessor", SchemaProcessor.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    }
}

