/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.proxyhandler;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.SubscriptionMessage;
import com.ibm.ws.sib.mfp.control.SubscriptionMessageType;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.proxyhandler.MESubscription;
import com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler;
import com.ibm.ws.sib.processor.proxyhandler.Neighbour;
import com.ibm.ws.sib.processor.proxyhandler.SubscriptionMessageHandler;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Enumeration;
import java.util.Hashtable;

final class BusGroup {
    private static final TraceComponent tc = SibTr.register(BusGroup.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private Hashtable iLocalSubscriptions = new Hashtable();
    private Hashtable iRemoteSubscriptions = new Hashtable();
    private String iBusName;
    private Neighbour[] iNeighbours = new Neighbour[0];
    private MultiMEProxyHandler iProxyHandler;
    private Object subscriptionLock = new Object();
    private boolean isLocalBus;

    BusGroup(String name, MultiMEProxyHandler proxyHandler, boolean localBus) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"BusGroup", (Object)new Object[]{name, proxyHandler, new Boolean(localBus)});
        }
        this.iBusName = name;
        this.iProxyHandler = proxyHandler;
        this.isLocalBus = localBus;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"BusGroup", (Object)this);
        }
    }

    final String getName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)this.iBusName);
        }
        return this.iBusName;
    }

    Neighbour[] getMembers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMembers");
            SibTr.exit((TraceComponent)tc, (String)"getMembers");
        }
        return this.iNeighbours;
    }

    Hashtable getLocalSubscriptions() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalSubscriptions");
            SibTr.exit((TraceComponent)tc, (String)"getLocalSubscriptions", (Object)this.iLocalSubscriptions);
        }
        return (Hashtable)this.iLocalSubscriptions.clone();
    }

    Hashtable getRemoteSubscriptions() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteSubscriptions");
            SibTr.exit((TraceComponent)tc, (String)"getRemoteSubscriptions", (Object)this.iRemoteSubscriptions);
        }
        return (Hashtable)this.iRemoteSubscriptions.clone();
    }

    SubscriptionMessageHandler addLocalSubscription(ConsumerDispatcherState subState, SubscriptionMessageHandler messageHandler, Transaction transaction, boolean sendProxy) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addLocalSubscription", (Object)new Object[]{subState, messageHandler, transaction, new Boolean(sendProxy)});
        }
        if ((messageHandler = this.addSubscription(subState.getTopicSpaceName(), subState.getTopicSpaceUuid(), subState.getTopic(), messageHandler, this.iLocalSubscriptions, sendProxy)) != null && sendProxy) {
            this.sendToNeighbours(messageHandler.getSubscriptionMessage(), transaction, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addLocalSubscription", (Object)messageHandler);
        }
        return messageHandler;
    }

    SubscriptionMessageHandler addRemoteSubscription(SIBUuid12 topicSpace, String topic, SubscriptionMessageHandler messageHandler, boolean sendProxy) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addRemoteSubscription", (Object)new Object[]{topicSpace, topic, messageHandler});
        }
        messageHandler = this.addSubscription(null, topicSpace, topic, messageHandler, this.iRemoteSubscriptions, sendProxy);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addRemoteSubscription", (Object)messageHandler);
        }
        return messageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubscriptionMessageHandler addSubscription(String topicSpaceName, SIBUuid12 topicSpaceUuid, String topic, SubscriptionMessageHandler messageHandler, Hashtable subscriptionsTable, boolean sendProxy) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addSubscription", (Object)new Object[]{topicSpaceName, topicSpaceUuid, topic, messageHandler, subscriptionsTable, new Boolean(sendProxy)});
        }
        String key = BusGroup.subscriptionKey(topicSpaceUuid, topic);
        Object object = this.subscriptionLock;
        synchronized (object) {
            String foreignTSName;
            MESubscription subscription = (MESubscription)((Object)subscriptionsTable.get(key));
            String localTSName = null;
            try {
                DestinationHandler destHand = null;
                destHand = sendProxy || topicSpaceName == null ? this.iProxyHandler.getMessageProcessor().getDestinationManager().getDestination(topicSpaceUuid, false) : this.iProxyHandler.getMessageProcessor().getDestinationManager().getDestination(topicSpaceName, false);
                if (destHand != null) {
                    localTSName = destHand.getName();
                }
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.BusGroup.addSubscription", (String)"1:339:1.49", (Object)this);
                SIErrorException error = new SIErrorException((Throwable)e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"addSubscription", (Object)((Object)error));
                }
                throw error;
            }
            if (localTSName != null && (foreignTSName = this.iProxyHandler.getMessageProcessor().getDestinationManager().getTopicSpaceMapping(this.iBusName, topicSpaceUuid)) != null) {
                if (subscription == null) {
                    subscription = new MESubscription(topicSpaceUuid, localTSName, topic, foreignTSName);
                    subscriptionsTable.put(key, subscription);
                }
                messageHandler = this.doProxySubscribeOp(subscription.addRef(), subscription, messageHandler, subscriptionsTable, sendProxy);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addSubscription");
        }
        return messageHandler;
    }

    SubscriptionMessageHandler removeLocalSubscription(ConsumerDispatcherState subState, SubscriptionMessageHandler messageHandler, Transaction transaction, boolean sendProxy) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeLocalSubscription", (Object)new Object[]{subState, messageHandler, new Boolean(sendProxy), transaction});
        }
        if ((messageHandler = this.removeSubscription(subState.getTopicSpaceUuid(), subState.getTopic(), messageHandler, this.iLocalSubscriptions, sendProxy)) != null && sendProxy) {
            this.sendToNeighbours(messageHandler.getSubscriptionMessage(), transaction, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeLocalSubscription", (Object)messageHandler);
        }
        return messageHandler;
    }

    SubscriptionMessageHandler removeRemoteSubscription(SIBUuid12 topicSpace, String topic, SubscriptionMessageHandler messageHandler, boolean sendProxy) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeRemoteSubscription", (Object)new Object[]{topicSpace, topic, messageHandler});
        }
        messageHandler = this.removeSubscription(topicSpace, topic, messageHandler, this.iRemoteSubscriptions, sendProxy);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeRemoteSubscription", (Object)messageHandler);
        }
        return messageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubscriptionMessageHandler removeSubscription(SIBUuid12 topicSpace, String topic, SubscriptionMessageHandler messageHandler, Hashtable subscriptionsTable, boolean sendProxy) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeSubscription", (Object)new Object[]{topicSpace, topic, messageHandler, subscriptionsTable, new Boolean(sendProxy)});
        }
        String key = BusGroup.subscriptionKey(topicSpace, topic);
        Object object = this.subscriptionLock;
        synchronized (object) {
            MESubscription subscription = (MESubscription)((Object)subscriptionsTable.get(key));
            if (subscription == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeSubscription", (Object)("Non Existent Subscription " + topicSpace + ":" + topic));
                }
                return messageHandler;
            }
            messageHandler = this.doProxySubscribeOp(subscription.removeRef(), subscription, messageHandler, subscriptionsTable, sendProxy);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeSubscription", (Object)messageHandler);
        }
        return messageHandler;
    }

    protected void sendToNeighbours(SubscriptionMessage msg, Transaction transaction, boolean startup) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendToNeighbours", (Object)new Object[]{msg, transaction, new Boolean(startup)});
        }
        for (int i = 0; i < this.iNeighbours.length; ++i) {
            if (startup) {
                msg.setSubscriptionMessageType(SubscriptionMessageType.REQUEST);
                this.iNeighbours[i].setRequestedProxySubscriptions();
            }
            this.iNeighbours[i].sendToNeighbour((JsMessage)msg, transaction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendToNeighbours");
        }
    }

    void addNeighbour(Neighbour neighbour) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addNeighbour", (Object)((Object)neighbour));
        }
        Neighbour[] tmp = new Neighbour[this.iNeighbours.length + 1];
        System.arraycopy(this.iNeighbours, 0, tmp, 0, this.iNeighbours.length);
        tmp[this.iNeighbours.length] = neighbour;
        this.iNeighbours = tmp;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addNeighbour");
        }
    }

    void removeNeighbour(Neighbour neighbour) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeNeighbour", (Object)((Object)neighbour));
        }
        Neighbour[] tmp = this.iNeighbours;
        for (int i = 0; i < this.iNeighbours.length; ++i) {
            if (!this.iNeighbours[i].equals((Object)neighbour)) continue;
            tmp = new Neighbour[this.iNeighbours.length - 1];
            System.arraycopy(this.iNeighbours, 0, tmp, 0, i);
            System.arraycopy(this.iNeighbours, i + 1, tmp, i, this.iNeighbours.length - i - 1);
            this.iNeighbours = tmp;
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeNeighbour");
        }
    }

    private SubscriptionMessageHandler doProxySubscribeOp(int op, MESubscription subscription, SubscriptionMessageHandler messageHandler, Hashtable subscriptionsTable, boolean sendProxy) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"doProxySubscribeOp", (Object)new Object[]{new Integer(op), subscription, messageHandler, new Boolean(sendProxy)});
        }
        if (!sendProxy) {
            if (op == 2) {
                subscriptionsTable.remove(BusGroup.subscriptionKey(subscription.getTopicSpaceUuid(), subscription.getTopic()));
            }
            op = 0;
        }
        switch (op) {
            case 1: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Publishing new Subscription " + (Object)((Object)subscription) + "," + sendProxy));
                }
                if (messageHandler == null) {
                    messageHandler = this.iProxyHandler.getMessageHandler();
                    messageHandler.resetCreateSubscriptionMessage(subscription, this.isLocalBus);
                    break;
                }
                messageHandler.addSubscriptionToMessage(subscription, this.isLocalBus);
                break;
            }
            case 2: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Publishing Delete subscription " + (Object)((Object)subscription) + "," + sendProxy));
                }
                messageHandler = this.iProxyHandler.getMessageHandler();
                messageHandler.resetDeleteSubscriptionMessage(subscription, this.isLocalBus);
                subscriptionsTable.remove(BusGroup.subscriptionKey(subscription.getTopicSpaceUuid(), subscription.getTopic()));
                break;
            }
            default: {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)("Doing nothing for subscription " + (Object)((Object)subscription) + "," + sendProxy));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"doProxySubscribeOp", (Object)messageHandler);
        }
        return messageHandler;
    }

    public static final String subscriptionKey(SIBUuid12 topicSpace, String topic) {
        return topicSpace + "+" + topic;
    }

    public String toString() {
        return "Bus name " + this.iBusName;
    }

    public boolean equals(BusGroup group) {
        boolean equal = false;
        if (this.iBusName.equals(group.getName())) {
            equal = true;
        }
        return equal;
    }

    protected void reset() {
        this.iLocalSubscriptions = new Hashtable();
        this.iRemoteSubscriptions = new Hashtable();
    }

    protected SubscriptionMessage generateResetSubscriptionMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"generateResetSubscriptionMessage");
        }
        SubscriptionMessageHandler messageHandler = this.iProxyHandler.getMessageHandler();
        messageHandler.resetResetSubscriptionMessage();
        this.addToMessage(messageHandler, this.iLocalSubscriptions);
        this.addToMessage(messageHandler, this.iRemoteSubscriptions);
        SubscriptionMessage message = messageHandler.getSubscriptionMessage();
        this.iProxyHandler.addMessageHandler(messageHandler);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"generateResetSubscriptionMessage", (Object)message);
        }
        return message;
    }

    protected SubscriptionMessage generateReplySubscriptionMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"generateReplySubscriptionMessage");
        }
        SubscriptionMessageHandler messageHandler = this.iProxyHandler.getMessageHandler();
        messageHandler.resetReplySubscriptionMessage();
        if (this.iLocalSubscriptions.size() > 0) {
            this.addToMessage(messageHandler, this.iLocalSubscriptions);
        }
        if (this.iRemoteSubscriptions.size() > 0) {
            this.addToMessage(messageHandler, this.iRemoteSubscriptions);
        }
        SubscriptionMessage message = messageHandler.getSubscriptionMessage();
        this.iProxyHandler.addMessageHandler(messageHandler);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"generateReplySubscriptionMessage", (Object)message);
        }
        return message;
    }

    private final void addToMessage(SubscriptionMessageHandler messageHandler, Hashtable subscriptions) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addToMessage", (Object)new Object[]{messageHandler, subscriptions});
        }
        Enumeration enu = subscriptions.elements();
        while (enu.hasMoreElements()) {
            MESubscription subscription = (MESubscription)((Object)enu.nextElement());
            messageHandler.addSubscriptionToMessage(subscription, this.isLocalBus);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addToMessage");
        }
    }

    void resetListFailed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetListFailed");
        }
        for (int i = 0; i < this.iNeighbours.length; ++i) {
            this.iNeighbours[i].resetListFailed();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetListFailed");
        }
    }
}

