/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.web.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ObscuredConfigIdManager {
    public static final TraceComponent tc = Tr.register(ObscuredConfigIdManager.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    private final Map<String, String> obscuredIdMap = new HashMap<String, String>();
    private final Map<String, String> invertedObscuredIdMap = new HashMap<String, String>();
    static final long serialVersionUID = 6780969888805856269L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addId(String configId) {
        if (configId == null) {
            return;
        }
        String obscuredId = this.getObscuredId(configId);
        Map<String, String> map = this.obscuredIdMap;
        synchronized (map) {
            this.obscuredIdMap.put(configId, obscuredId);
        }
        map = this.invertedObscuredIdMap;
        synchronized (map) {
            this.invertedObscuredIdMap.put(obscuredId, configId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeId(String configId) {
        if (configId == null) {
            return;
        }
        String obscuredId = this.getObscuredId(configId);
        Map<String, String> map = this.obscuredIdMap;
        synchronized (map) {
            this.obscuredIdMap.remove(configId);
        }
        map = this.invertedObscuredIdMap;
        synchronized (map) {
            this.invertedObscuredIdMap.remove(obscuredId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getObscuredIdFromConfigId(String configId) {
        Map<String, String> map = this.obscuredIdMap;
        synchronized (map) {
            return this.obscuredIdMap.get(configId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConfigIdFromObscuredId(String obscuredConfigId) {
        Map<String, String> map = this.invertedObscuredIdMap;
        synchronized (map) {
            return this.invertedObscuredIdMap.get(obscuredConfigId);
        }
    }

    String getObscuredId(String configId) {
        return new Integer(configId.hashCode()).toString();
    }
}

